/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.reworked;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.FrozenDocument;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.MutableTerminalOutputModelImplKt;
import org.jetbrains.plugins.terminal.block.reworked.TerminalLineIndex;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelSnapshot;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u001bH\u0016J\u0018\u0010\"\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bH\u0016J\f\u0010)\u001a\u00020\u0012*\u00020\bH\u0002J\f\u0010)\u001a\u00020\u0012*\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\fR\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelSnapshotImpl;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelSnapshot;", "document", "Lcom/intellij/openapi/editor/impl/FrozenDocument;", "trimmedCharsCount", "", "trimmedLinesCount", "cursorOffset", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "<init>", "(Lcom/intellij/openapi/editor/impl/FrozenDocument;JJLorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;)V", "getCursorOffset", "()Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "immutableText", "", "getImmutableText", "()Ljava/lang/CharSequence;", "lineCount", "", "getLineCount", "()I", "modificationStamp", "getModificationStamp", "()J", "startOffset", "getStartOffset", "firstLine", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalLineIndex;", "getFirstLine", "()Lorg/jetbrains/plugins/terminal/block/reworked/TerminalLineIndex;", "getLineByOffset", "offset", "getStartOfLine", "line", "getEndOfLine", "includeEOL", "", "getText", "", "start", "end", "toRelative", "intellij.terminal"})
@ApiStatus.Internal
public final class TerminalOutputModelSnapshotImpl
implements TerminalOutputModelSnapshot {
    @NotNull
    private final FrozenDocument document;
    private final long trimmedCharsCount;
    private final long trimmedLinesCount;
    @NotNull
    private final TerminalOffset cursorOffset;

    public TerminalOutputModelSnapshotImpl(@NotNull FrozenDocument document, long trimmedCharsCount, long trimmedLinesCount, @NotNull TerminalOffset cursorOffset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)cursorOffset, (String)"cursorOffset");
        this.document = document;
        this.trimmedCharsCount = trimmedCharsCount;
        this.trimmedLinesCount = trimmedLinesCount;
        this.cursorOffset = cursorOffset;
    }

    @Override
    @NotNull
    public TerminalOffset getCursorOffset() {
        return this.cursorOffset;
    }

    @Override
    @NotNull
    public CharSequence getImmutableText() {
        return MutableTerminalOutputModelImplKt.access$immutableTextImpl((Document)this.document);
    }

    @Override
    public int getLineCount() {
        return MutableTerminalOutputModelImplKt.access$lineCountImpl((Document)this.document);
    }

    @Override
    public long getModificationStamp() {
        return MutableTerminalOutputModelImplKt.access$modificationStampImpl((Document)this.document);
    }

    @Override
    @NotNull
    public TerminalOffset getStartOffset() {
        return TerminalOffset.Companion.of(this.trimmedCharsCount);
    }

    @Override
    @NotNull
    public TerminalLineIndex getFirstLine() {
        return TerminalLineIndex.Companion.of(this.trimmedLinesCount);
    }

    @Override
    @NotNull
    public TerminalLineIndex getLineByOffset(@NotNull TerminalOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return MutableTerminalOutputModelImplKt.access$getLineByOffsetImpl(this.trimmedLinesCount, (Document)this.document, this.toRelative(offset));
    }

    @Override
    @NotNull
    public TerminalOffset getStartOfLine(@NotNull TerminalLineIndex line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return MutableTerminalOutputModelImplKt.access$getStartOfLineImpl(this.trimmedCharsCount, (Document)this.document, this.toRelative(line));
    }

    @Override
    @NotNull
    public TerminalOffset getEndOfLine(@NotNull TerminalLineIndex line, boolean includeEOL) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return MutableTerminalOutputModelImplKt.access$getEndOfLineImpl(this.trimmedCharsCount, (Document)this.document, this.toRelative(line), includeEOL);
    }

    @Override
    @NotNull
    public String getText(@NotNull TerminalOffset start2, @NotNull TerminalOffset end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return MutableTerminalOutputModelImplKt.access$getTextImpl((Document)this.document, this.toRelative(start2), this.toRelative(end));
    }

    private final int toRelative(TerminalOffset $this$toRelative) {
        return (int)$this$toRelative.minus(this.getStartOffset());
    }

    private final int toRelative(TerminalLineIndex $this$toRelative) {
        return (int)$this$toRelative.minus(this.getFirstLine());
    }
}

