/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.actions;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.actions.TfActionService;
import org.intellij.terraform.config.model.local.TfLocalSchemaService;
import org.intellij.terraform.hcl.HCLBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\r"}, d2={"createQuickFixNotInitialized", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "isInitRequired", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInitializedDir", "file", "Lcom/intellij/psi/PsiFile;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfInitAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfInitAction.kt\norg/intellij/terraform/config/actions/TfInitActionKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,53:1\n30#2,2:54\n*S KotlinDebug\n*F\n+ 1 TfInitAction.kt\norg/intellij/terraform/config/actions/TfInitActionKt\n*L\n45#1:54,2\n*E\n"})
public final class TfInitActionKt {
    @Nullable
    public static final LocalQuickFix createQuickFixNotInitialized(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!TfInitActionKt.isInitRequired(project, virtualFile2)) {
            return null;
        }
        return new LocalQuickFix(){

            public boolean startInWriteAction() {
                return false;
            }

            public String getFamilyName() {
                String string = HCLBundle.message("action.TfInitRequiredAction.text", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public void applyFix(Project project, ProblemDescriptor descriptor) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<TfActionService> serviceClass$iv = TfActionService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                TfActionService tfActionService = (TfActionService)object;
                VirtualFile virtualFile = descriptor.getPsiElement().getContainingFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                tfActionService.scheduleTerraformInit(virtualFile, false);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInitRequired(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<TfLocalSchemaService> serviceClass$iv = TfLocalSchemaService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        VirtualFile virtualFile2 = ((TfLocalSchemaService)object).findLockFile(virtualFile);
        if (virtualFile2 == null) {
            return true;
        }
        VirtualFile lock = virtualFile2;
        VirtualFile virtualFile3 = lock.getParent().findChild(".terraform");
        if (virtualFile3 == null) {
            return true;
        }
        VirtualFile terraformDirectory = virtualFile3;
        if (!terraformDirectory.isDirectory()) return true;
        VirtualFile[] virtualFileArray = terraformDirectory.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        if (((Object[])virtualFileArray).length != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInitializedDir(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (ApplicationManager.getApplication().isUnitTestMode()) return true;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        if (TfInitActionKt.isInitRequired(project, virtualFile)) return false;
        return true;
    }
}

