/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.codeinsight;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.actions.ImportProviderService;
import org.intellij.terraform.config.codeinsight.TfInsertHandlerService;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.HclTypeModelKt;
import org.intellij.terraform.config.model.ProviderTier;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.config.model.TfTypeModel;
import org.intellij.terraform.hcl.HCLTokenTypes;
import org.intellij.terraform.hcl.formatter.HclCodeStyleSettings;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/intellij/terraform/config/codeinsight/BlockSubNameInsertHandler;", "Lcom/intellij/codeInsight/completion/BasicInsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "type", "Lorg/intellij/terraform/config/model/BlockType;", "<init>", "(Lorg/intellij/terraform/config/model/BlockType;)V", "getType", "()Lorg/intellij/terraform/config/model/BlockType;", "tiersNotToInsert", "", "Lorg/intellij/terraform/config/model/ProviderTier;", "getTiersNotToInsert", "()Ljava/util/Set;", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.terraform"})
public final class BlockSubNameInsertHandler
extends BasicInsertHandler<LookupElement> {
    @NotNull
    private final BlockType type;
    @NotNull
    private final Set<ProviderTier> tiersNotToInsert;

    public BlockSubNameInsertHandler(@NotNull BlockType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
        ProviderTier[] providerTierArray = new ProviderTier[]{ProviderTier.TIER_LOCAL, ProviderTier.TIER_BUILTIN};
        this.tiersNotToInsert = SetsKt.setOf((Object[])providerTierArray);
    }

    @NotNull
    public final BlockType getType() {
        return this.type;
    }

    @NotNull
    public final Set<ProviderTier> getTiersNotToInsert() {
        return this.tiersNotToInsert;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        ProviderType provider;
        Object next;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (project2.isDisposed()) {
            return;
        }
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        PsiFile psiFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        PsiElement psiElement = file.findElementAt(context.getStartOffset());
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        PsiElement parent = null;
        if (element instanceof HCLIdentifier) {
            PsiElement psiElement2 = ((HCLIdentifier)element).getParent();
            if (psiElement2 == null) {
                return;
            }
            parent = psiElement2;
        } else if (element instanceof HCLStringLiteral) {
            PsiElement psiElement3 = ((HCLStringLiteral)element).getParent();
            if (psiElement3 == null) {
                return;
            }
            parent = psiElement3;
        } else {
            ASTNode aSTNode = element.getNode();
            if (!HCLTokenTypes.IDENTIFYING_LITERALS.contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null))) return;
            PsiElement psiElement4 = element.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getParent(...)");
            PsiElement p = element = psiElement4;
            if (p instanceof HCLElement) {
                PsiElement psiElement5;
                PsiElement psiElement6 = p;
                HCLObject hCLObject = psiElement6 instanceof HCLObject ? (HCLObject)psiElement6 : null;
                if (hCLObject != null) {
                    psiElement5 = hCLObject;
                } else {
                    psiElement5 = ((HCLElement)p).getParent();
                    if (psiElement5 == null) {
                        return;
                    }
                }
                parent = psiElement5;
            } else {
                parent = p;
            }
        }
        if (parent instanceof HCLProperty) {
            return;
        }
        Integer offset = null;
        int already = 0;
        int expected = this.type.getArgs();
        if (!(parent instanceof HCLBlock)) return;
        Document document = context.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        if (!TfInsertHandlerService.Companion.isNextNameOnTheSameLine$intellij_terraform(element, document)) return;
        Object[] objectArray = ((HCLBlock)parent).getNameElements();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getNameElements(...)");
        Object[] elements = objectArray;
        already = elements.length - 1;
        int i = ArraysKt.indexOf((Object[])elements, (Object)element);
        boolean bl2 = bl = i != -1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (i < ArraysKt.getLastIndex((Object[])elements) && i + 1 != ArraysKt.getLastIndex((Object[])elements) && (next = elements[i + 1]).textContains('\"') && next.getTextLength() < 3) {
            editor2.getCaretModel().moveToOffset(next.getTextRange().getEndOffset() - 1);
            TfInsertHandlerService.Companion.scheduleBasicCompletion$intellij_terraform(context);
        }
        if (already < expected) {
            offset = editor2.getCaretModel().getOffset() + 2;
            TfInsertHandlerService.Companion.addArguments$intellij_terraform(expected - already, editor2);
            if (expected - already != 1) {
                TfInsertHandlerService.Companion.scheduleBasicCompletion$intellij_terraform(context);
            }
        }
        CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getCustomSettings((PsiFile)file, HclCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        HclCodeStyleSettings settings = (HclCodeStyleSettings)customCodeStyleSettings;
        if (settings.IMPORT_PROVIDERS_AUTOMATICALLY && (provider = HclTypeModelKt.getProviderForBlockType(this.type)) != null && !this.tiersNotToInsert.contains((Object)provider.getTier()) && !TfTypeModel.Companion.collectProviderLocalNames((PsiElement)file).containsValue(provider.getFullName())) {
            ImportProviderService.Companion.getInstance(project2).addSelectedProvider(provider, (SmartPsiElementPointer<PsiFile>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)file)));
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor2.getDocument());
        if (offset != null) {
            editor2.getCaretModel().moveToOffset(offset.intValue());
        }
        if (this.type.getProperties().isEmpty()) return;
        boolean bl3 = true;
        if (!bl3) return;
        TfInsertHandlerService.Companion.getInstance$intellij_terraform(project2).addBlockRequiredProperties$intellij_terraform(file, editor2, project2);
    }
}

