/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.codeinsight;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Plow;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.codeinsight.BlockSubNameInsertHandler;
import org.intellij.terraform.config.codeinsight.QuoteInsertHandler;
import org.intellij.terraform.config.codeinsight.ResourcePropertyInsertHandler;
import org.intellij.terraform.config.codeinsight.TfCompletionUtil;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.codeinsight.TfPropertyObjectKeyCompletionProvider;
import org.intellij.terraform.config.documentation.psi.HclFakeElementPsiFactory;
import org.intellij.terraform.config.model.BackendType;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.DataSourceType;
import org.intellij.terraform.config.model.EphemeralType;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Hint;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.ProviderTier;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.config.model.ProvisionerType;
import org.intellij.terraform.config.model.ReferenceHint;
import org.intellij.terraform.config.model.ResourceOrDataSourceType;
import org.intellij.terraform.config.model.ResourceType;
import org.intellij.terraform.config.model.SimpleValueHint;
import org.intellij.terraform.config.model.TfTypeModel;
import org.intellij.terraform.config.model.TypeModelProvider;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.model.Variable;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLTokenTypes;
import org.intellij.terraform.hcl.codeinsight.HclBlockPropertiesCompletionProvider;
import org.intellij.terraform.hcl.codeinsight.HclKeywordsCompletionProvider;
import org.intellij.terraform.hcl.codeinsight.HclKeywordsCompletionProviderKt;
import org.intellij.terraform.hcl.codeinsight.HclRootBlockCompletionProvider;
import org.intellij.terraform.hcl.patterns.HCLPatterns;
import org.intellij.terraform.hcl.psi.HCLArray;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hil.codeinsight.HilCompletionContributor;
import org.intellij.terraform.hil.codeinsight.ReferenceCompletionHelper;
import org.intellij.terraform.opentofu.model.AbstractEncryptionMethod;
import org.intellij.terraform.opentofu.model.AbstractEncryptionProvider;
import org.intellij.terraform.opentofu.model.OpenTofuTypeModelKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \n2\u00020\u0001:\u0007\u0004\u0005\u0006\u0007\b\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000b"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor;", "Lorg/intellij/terraform/hil/codeinsight/HilCompletionContributor;", "<init>", "()V", "TfCompletionProvider", "RequiredProviderCompletion", "BlockTypeOrNameCompletionProvider", "PropertyValueCompletionProvider", "VariableNameTFVARSCompletionProvider", "MappedVariableTFVARSCompletionProvider", "Companion", "intellij.terraform"})
public final class TfConfigCompletionContributor
extends HilCompletionContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public TfConfigCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)HclKeywordsCompletionProviderKt.getAfterCommaOrBracketPattern(), HclKeywordsCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)HclRootBlockCompletionProvider.INSTANCE.createRootBlockPattern(TfPsiPatterns.INSTANCE.getTerraformConfigFile()), HclRootBlockCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)HclRootBlockCompletionProvider.INSTANCE.createBlockHeaderPattern(TfPsiPatterns.INSTANCE.getTerraformConfigFile()), HclRootBlockCompletionProvider.INSTANCE);
        TreeElementPattern treeElementPattern = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)TfPsiPatterns.INSTANCE.getTerraformConfigFile())).withParent(HCLPatterns.INSTANCE.getFileOrBlock());
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"withParent(...)");
        this.extend(CompletionType.BASIC, (ElementPattern)UtilKt.afterSiblingSkipping2((PsiElementPattern)treeElementPattern, (ElementPattern<? extends Object>)((ElementPattern)HCLPatterns.INSTANCE.getWhiteSpace()), HCLPatterns.INSTANCE.getIdentifierOrStringLiteralOrSimple()), BlockTypeOrNameCompletionProvider.INSTANCE);
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)TfPsiPatterns.INSTANCE.getTerraformConfigFile());
        ObjectPattern objectPattern = PlatformPatterns.psiElement().and(HCLPatterns.INSTANCE.getIdentifierOrStringLiteral());
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"and(...)");
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)capture.withParent((ElementPattern)UtilKt.afterSiblingSkipping2((PsiElementPattern)objectPattern, (ElementPattern<? extends Object>)((ElementPattern)HCLPatterns.INSTANCE.getWhiteSpace()), HCLPatterns.INSTANCE.getIdentifierOrStringLiteralOrSimple()))).withSuperParent(2, HCLPatterns.INSTANCE.getFileOrBlock()), BlockTypeOrNameCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)HclBlockPropertiesCompletionProvider.INSTANCE.createBlockPropertyKeyPattern(TfPsiPatterns.INSTANCE.getTerraformConfigFile()), HclBlockPropertiesCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)HclBlockPropertiesCompletionProvider.INSTANCE.createPropertyInBlockPattern(TfPsiPatterns.INSTANCE.getTerraformConfigFile()), HclBlockPropertiesCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)HclBlockPropertiesCompletionProvider.INSTANCE.createNestedBlockPropertyPattern(TfPsiPatterns.INSTANCE.getTerraformConfigFile()), HclBlockPropertiesCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)TfPsiPatterns.INSTANCE.getRequiredProviderIdentifier(), RequiredProviderCompletion.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)TfPsiPatterns.INSTANCE.getIdentifierOfRequiredProviderProperty(), RequiredProviderCompletion.INSTANCE);
        this.extend(null, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)TfPsiPatterns.INSTANCE.getTerraformConfigFile())).withParent(HCLPatterns.INSTANCE.getIdentifierOrStringLiteral())).withSuperParent(2, (ElementPattern)HCLPatterns.INSTANCE.getProperty())).withSuperParent(3, (ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(4, (ElementPattern)HCLPatterns.INSTANCE.getBlock()), PropertyValueCompletionProvider.INSTANCE);
        this.extend(null, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)TfPsiPatterns.INSTANCE.getTerraformConfigFile())).withParent(HCLPatterns.INSTANCE.getIdentifierOrStringLiteral())).withSuperParent(2, (ElementPattern)HCLPatterns.INSTANCE.getArray())).withSuperParent(3, (ElementPattern)HCLPatterns.INSTANCE.getProperty())).withSuperParent(4, (ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(5, (ElementPattern)HCLPatterns.INSTANCE.getBlock()), PropertyValueCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)TfPsiPatterns.INSTANCE.getTerraformConfigFile())).withParent((ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(2, HCLPatterns.INSTANCE.getPropertyOrBlock())).withSuperParent(3, (ElementPattern)HCLPatterns.INSTANCE.getObject()), TfPropertyObjectKeyCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)TfPsiPatterns.INSTANCE.getTerraformConfigFile())).withParent(HCLPatterns.INSTANCE.getIdentifierOrStringLiteral())).withSuperParent(2, (ElementPattern)HCLPatterns.INSTANCE.getProperty())).withSuperParent(3, (ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(4, HCLPatterns.INSTANCE.getPropertyOrBlock())).withSuperParent(5, (ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(6, (ElementPattern)HCLPatterns.INSTANCE.getBlock()), TfPropertyObjectKeyCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)TfPsiPatterns.INSTANCE.getTerraformConfigFile())).withParent((ElementPattern)PlatformPatterns.psiElement(PsiErrorElement.class))).withSuperParent(2, (ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(3, HCLPatterns.INSTANCE.getPropertyOrBlock())).withSuperParent(4, (ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(5, (ElementPattern)HCLPatterns.INSTANCE.getBlock()), TfPropertyObjectKeyCompletionProvider.INSTANCE);
        ElementPattern[] elementPatternArray = new ElementPattern[]{PlatformPatterns.psiElement().withParent((ElementPattern)HCLPatterns.INSTANCE.getFile()), ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(HCLPatterns.INSTANCE.getIdentifierOrStringLiteral())).withSuperParent(2, (ElementPattern)HCLPatterns.INSTANCE.getProperty())).withSuperParent(3, (ElementPattern)HCLPatterns.INSTANCE.getFile())};
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)TfPsiPatterns.INSTANCE.getTerraformVariablesFile())).andOr(elementPatternArray), VariableNameTFVARSCompletionProvider.INSTANCE);
        elementPatternArray = new ElementPattern[]{((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(1, HCLPatterns.INSTANCE.getIdentifierOrStringLiteral())).withSuperParent(2, (ElementPattern)HCLPatterns.INSTANCE.getProperty())).withSuperParent(3, (ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(4, (ElementPattern)HCLPatterns.INSTANCE.getProperty())).withSuperParent(5, (ElementPattern)HCLPatterns.INSTANCE.getFile()), ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(1, (ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(2, (ElementPattern)HCLPatterns.INSTANCE.getProperty())).withSuperParent(3, (ElementPattern)HCLPatterns.INSTANCE.getFile())};
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)TfPsiPatterns.INSTANCE.getTerraformVariablesFile())).andOr(elementPatternArray), MappedVariableTFVARSCompletionProvider.INSTANCE);
    }

    static {
        Logger logger = Logger.getInstance(TfConfigCompletionContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$BlockTypeOrNameCompletionProvider;", "Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$TfCompletionProvider;", "<init>", "()V", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "doCompletion", "", "position", "Lcom/intellij/psi/PsiElement;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "buildResourceOrDataLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "it", "Lorg/intellij/terraform/config/model/ResourceOrDataSourceType;", "buildLookupElement", "Lorg/intellij/terraform/config/model/BlockType;", "typeName", "", "typeText", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfConfigCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfConfigCompletionContributor.kt\norg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$BlockTypeOrNameCompletionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,433:1\n60#2,5:434\n60#2,5:439\n1222#3,2:444\n1252#3,4:446\n30#4,2:450\n30#4,2:452\n*S KotlinDebug\n*F\n+ 1 TfConfigCompletionContributor.kt\norg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$BlockTypeOrNameCompletionProvider\n*L\n233#1:434,5\n242#1:439,5\n296#1:444,2\n296#1:446,4\n307#1:450,2\n314#1:452,2\n*E\n"})
    public static final class BlockTypeOrNameCompletionProvider
    extends TfCompletionProvider {
        @NotNull
        public static final BlockTypeOrNameCompletionProvider INSTANCE = new BlockTypeOrNameCompletionProvider();

        private BlockTypeOrNameCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            PsiElement psiElement = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
            PsiElement position = psiElement;
            this.doCompletion(position, parameters, result2, (Processor<LookupElement>)((Processor)arg_0 -> BlockTypeOrNameCompletionProvider.addCompletions$lambda$0(result2, arg_0)));
        }

        private final boolean doCompletion(PsiElement position, CompletionParameters parameters, CompletionResultSet result2, Processor<LookupElement> consumer) {
            PsiElement psiElement;
            Logger logger;
            PsiElement parent = position.getParent();
            Logger $this$debug_u24default$iv = Companion.getLOG();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("TF.BlockTypeOrNameCompletionProvider{position=" + position + ", parent=" + parent + "}", e$iv);
            }
            if (parent instanceof HCLIdentifier) {
                psiElement = parent;
            } else if (parent instanceof HCLStringLiteral) {
                psiElement = parent;
            } else if (HCLTokenTypes.IDENTIFYING_LITERALS.contains(position.getNode().getElementType())) {
                psiElement = position;
            } else {
                return true;
            }
            PsiElement obj = psiElement;
            PsiElement leftNWS = HCLPsiUtil.getPrevSiblingNonWhiteSpace(obj);
            Logger $this$debug_u24default$iv2 = Companion.getLOG();
            Throwable e$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("TF.BlockTypeOrNameCompletionProvider{position=" + position + ", parent=" + parent + ", obj=" + obj + ", lnws=" + leftNWS + "}", e$iv2);
            }
            String string = TfCompletionUtil.INSTANCE.getClearTextValue(leftNWS);
            if (string == null) {
                return true;
            }
            String type = string;
            TfTypeModel typeModel = TypeModelProvider.Companion.getModel(position);
            Map<String, String> localProviders = TfTypeModel.Companion.collectProviderLocalNames(position);
            Set<ProviderTier> tiers = ProviderTier.Companion.getPreferedProviders();
            if (parameters.getInvocationCount() == 1) {
                Object[] objectArray = new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion")};
                String string2 = HCLBundle.message("popup.advertisement.press.to.show.partner.community.providers", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                String message = string2;
                result2.addLookupAdvertisement(message);
            }
            return switch (type) {
                case "resource" -> Plow.Companion.ofSequence(typeModel.allResources()).filter(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$2(parameters, tiers, localProviders, arg_0)).map(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$3(position, arg_0)).processWith(consumer);
                case "data" -> Plow.Companion.ofSequence(typeModel.allDataSources()).filter(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$4(parameters, tiers, localProviders, arg_0)).map(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$5(position, arg_0)).processWith(consumer);
                case "ephemeral" -> Plow.Companion.ofSequence(typeModel.allEphemeralResources()).filter(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$6(parameters, tiers, localProviders, arg_0)).map(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$7(position, arg_0)).processWith(consumer);
                case "provider" -> Plow.Companion.ofSequence(typeModel.allProviders()).filter(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$8(parameters, tiers, localProviders, arg_0)).map(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$9(position, arg_0)).processWith(consumer);
                case "provisioner" -> Plow.Companion.ofIterable((Iterable)typeModel.getProvisioners()).map(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$10(position, arg_0)).processWith(consumer);
                case "backend" -> Plow.Companion.ofIterable((Iterable)typeModel.getBackends()).map(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$11(position, arg_0)).processWith(consumer);
                case "key_provider" -> Plow.Companion.ofIterable((Iterable)OpenTofuTypeModelKt.getEncryptionKeyProviders().values()).map(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$12(position, arg_0)).processWith(consumer);
                case "method" -> Plow.Companion.ofIterable((Iterable)OpenTofuTypeModelKt.getEncryptionMethods().values()).map(arg_0 -> BlockTypeOrNameCompletionProvider.doCompletion$lambda$13(position, arg_0)).processWith(consumer);
                default -> true;
            };
        }

        /*
         * WARNING - void declaration
         */
        private final LookupElementBuilder buildResourceOrDataLookupElement(ResourceOrDataSourceType it, PsiElement position) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = TfTypeModel.Companion.collectProviderLocalNames(position).entrySet();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Map.Entry it2 = (Map.Entry)element$iv$iv;
                String string = (String)it2.getValue();
                boolean bl2 = false;
                String string2 = (String)it2.getKey();
                map.put(string, string2);
            }
            Map providerLocalNamesReversed = destination$iv$iv;
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)it, (String)it.getType()).withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(it, (Map<String, String>)providerLocalNamesReversed, position){
                final /* synthetic */ ResourceOrDataSourceType $it;
                final /* synthetic */ Map<String, String> $providerLocalNamesReversed;
                final /* synthetic */ PsiElement $position;
                {
                    this.$it = $it;
                    this.$providerLocalNamesReversed = $providerLocalNamesReversed;
                    this.$position = $position;
                }

                public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                    ResourceOrDataSourceType resourceOrDataSourceType = this.$it;
                    Intrinsics.checkNotNull((Object)resourceOrDataSourceType, (String)"null cannot be cast to non-null type org.intellij.terraform.config.model.BlockType");
                    presentation.setItemText(TfCompletionUtil.INSTANCE.buildResourceDisplayString$intellij_terraform((BlockType)((Object)resourceOrDataSourceType), this.$providerLocalNamesReversed));
                    presentation.setTypeText(TfCompletionUtil.INSTANCE.buildProviderTypeText$intellij_terraform(this.$it.getProvider()));
                    presentation.setTypeGrayed(true);
                    presentation.setIcon(TfCompletionUtil.INSTANCE.getLookupIcon(this.$position));
                }
            });
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.intellij.terraform.config.model.BlockType");
            LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder.withInsertHandler((InsertHandler)new BlockSubNameInsertHandler((BlockType)((Object)it)));
            Project project = position.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<HclFakeElementPsiFactory> serviceClass$iv = HclFakeElementPsiFactory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            LookupElementBuilder lookupElementBuilder3 = lookupElementBuilder2.withPsiElement((PsiElement)((HclFakeElementPsiFactory)object).createFakeHclBlock(it, position.getContainingFile().getOriginalFile()));
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder3, (String)"withPsiElement(...)");
            return lookupElementBuilder3;
        }

        private final LookupElementBuilder buildLookupElement(BlockType it, String typeName, String typeText, PsiElement position) {
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)typeName).withTypeText(typeText, true).withIcon(TfCompletionUtil.INSTANCE.getLookupIcon(position)).withInsertHandler((InsertHandler)new BlockSubNameInsertHandler(it));
            Project project = position.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<HclFakeElementPsiFactory> serviceClass$iv = HclFakeElementPsiFactory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder.withPsiElement((PsiElement)((HclFakeElementPsiFactory)object).createFakeHclBlock(it.getLiteral(), typeName, position.getContainingFile().getOriginalFile()));
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"withPsiElement(...)");
            return lookupElementBuilder2;
        }

        private static final boolean addCompletions$lambda$0(CompletionResultSet $result, LookupElement it) {
            $result.addElement(it);
            return !$result.isStopped();
        }

        private static final boolean doCompletion$lambda$2(CompletionParameters $parameters, Set $tiers, Map $localProviders, ResourceType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $parameters.getInvocationCount() > 1 || $tiers.contains((Object)it.getProvider().getTier()) || $localProviders.containsValue(it.getProvider().getFullName());
        }

        private static final LookupElementBuilder doCompletion$lambda$3(PsiElement $position, ResourceType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return INSTANCE.buildResourceOrDataLookupElement(it, $position);
        }

        private static final boolean doCompletion$lambda$4(CompletionParameters $parameters, Set $tiers, Map $localProviders, DataSourceType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $parameters.getInvocationCount() > 1 || $tiers.contains((Object)it.getProvider().getTier()) || $localProviders.containsValue(it.getProvider().getFullName());
        }

        private static final LookupElementBuilder doCompletion$lambda$5(PsiElement $position, DataSourceType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return INSTANCE.buildResourceOrDataLookupElement(it, $position);
        }

        private static final boolean doCompletion$lambda$6(CompletionParameters $parameters, Set $tiers, Map $localProviders, EphemeralType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $parameters.getInvocationCount() > 1 || $tiers.contains((Object)it.getProvider().getTier()) || $localProviders.containsValue(it.getProvider().getFullName());
        }

        private static final LookupElementBuilder doCompletion$lambda$7(PsiElement $position, EphemeralType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return INSTANCE.buildResourceOrDataLookupElement(it, $position);
        }

        private static final boolean doCompletion$lambda$8(CompletionParameters $parameters, Set $tiers, Map $localProviders, ProviderType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $parameters.getInvocationCount() > 1 || $tiers.contains((Object)it.getTier()) || $localProviders.containsValue(it.getFullName());
        }

        private static final LookupElement doCompletion$lambda$9(PsiElement $position, ProviderType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return TfCompletionUtil.INSTANCE.buildLookupForProviderBlock(it, $position);
        }

        private static final LookupElementBuilder doCompletion$lambda$10(PsiElement $position, ProvisionerType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return INSTANCE.buildLookupElement(it, it.getType(), it.getDescription(), $position);
        }

        private static final LookupElementBuilder doCompletion$lambda$11(PsiElement $position, BackendType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return INSTANCE.buildLookupElement(it, it.getType(), it.getDescription(), $position);
        }

        private static final LookupElementBuilder doCompletion$lambda$12(PsiElement $position, AbstractEncryptionProvider it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return INSTANCE.buildLookupElement(it, it.getType(), it.getDescription(), $position);
        }

        private static final LookupElementBuilder doCompletion$lambda$13(PsiElement $position, AbstractEncryptionMethod it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return INSTANCE.buildLookupElement(it, it.getType(), it.getDescription(), $position);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$MappedVariableTFVARSCompletionProvider;", "Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$TfCompletionProvider;", "<init>", "()V", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfConfigCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfConfigCompletionContributor.kt\norg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$MappedVariableTFVARSCompletionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,433:1\n60#2,5:434\n1617#3,9:439\n1869#3:448\n1870#3:450\n1626#3:451\n1374#3:452\n1460#3,2:453\n1563#3:455\n1634#3,3:456\n1462#3,3:459\n1#4:449\n*S KotlinDebug\n*F\n+ 1 TfConfigCompletionContributor.kt\norg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$MappedVariableTFVARSCompletionProvider\n*L\n402#1:434,5\n422#1:439,9\n422#1:448\n422#1:450\n422#1:451\n425#1:452\n425#1:453,2\n425#1:455\n425#1:456,3\n425#1:459,3\n422#1:449\n*E\n"})
    private static final class MappedVariableTFVARSCompletionProvider
    extends TfCompletionProvider {
        @NotNull
        public static final MappedVariableTFVARSCompletionProvider INSTANCE = new MappedVariableTFVARSCompletionProvider();

        private MappedVariableTFVARSCompletionProvider() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Object it;
            void $this$mapNotNullTo$iv$iv;
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            PsiElement psiElement = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
            PsiElement position = psiElement;
            PsiElement parent = position.getParent();
            Logger $this$debug_u24default$iv = Companion.getLOG();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("TF.MappedVariableTFVARSCompletionProvider{position=" + position + ", parent=" + parent + "}", e$iv);
            }
            HCLProperty varProperty = null;
            if (parent instanceof HCLObject) {
                PsiElement pp = ((HCLObject)parent).getParent();
                if (!(pp instanceof HCLProperty)) return;
                varProperty = (HCLProperty)pp;
            } else {
                HCLProperty pppp;
                if (!(parent instanceof HCLElement)) return;
                if (!HCLPsiUtil.INSTANCE.isPropertyKey(parent)) {
                    return;
                }
                PsiElement bl = ((HCLElement)parent).getParent().getParent();
                if (!(bl instanceof HCLObject)) return;
                HCLObject hCLObject = (HCLObject)bl;
                if (hCLObject == null) {
                    return;
                }
                HCLObject ppp = hCLObject;
                PsiElement psiElement2 = ppp.getParent();
                if (!(psiElement2 instanceof HCLProperty)) return;
                HCLProperty hCLProperty = (HCLProperty)psiElement2;
                if (hCLProperty == null) {
                    return;
                }
                varProperty = pppp = hCLProperty;
            }
            if (!(varProperty.getParent() instanceof HCLFile)) {
                return;
            }
            Module module = ExtensionsKt.getTerraformModule(varProperty);
            String string = varProperty.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            List<Variable> variables = module.findVariables(string);
            Iterable $this$mapNotNull$iv = variables;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                HCLObject it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                it = (Variable)element$iv$iv;
                boolean bl2 = false;
                HCLExpression hCLExpression = ((Variable)it).getDefault();
                if ((hCLExpression instanceof HCLObject ? (HCLObject)hCLExpression : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List defaults = (List)destination$iv$iv;
            $this$mapNotNull$iv = defaults;
            logger = result2;
            boolean $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                HCLObject hCLObject = (HCLObject)element$iv$iv;
                boolean bl = false;
                List<HCLProperty> list = hCLObject.getPropertyList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    HCLProperty hCLProperty = (HCLProperty)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(LookupElementBuilder.create((String)it2.getName()).withInsertHandler((InsertHandler)ResourcePropertyInsertHandler.INSTANCE));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            logger.addAllElements((Iterable)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$PropertyValueCompletionProvider;", "Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$TfCompletionProvider;", "<init>", "()V", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfConfigCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfConfigCompletionContributor.kt\norg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$PropertyValueCompletionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,433:1\n60#2,5:434\n1563#3:439\n1634#3,3:440\n1563#3:443\n1634#3,3:444\n1563#3:447\n1634#3,3:448\n1563#3:451\n1634#3,3:452\n1563#3:455\n1634#3,3:456\n1617#3,9:472\n1869#3:481\n1870#3:483\n1626#3:484\n1869#3,2:485\n11879#4,9:459\n13805#4:468\n13806#4:470\n11888#4:471\n1#5:469\n1#5:482\n*S KotlinDebug\n*F\n+ 1 TfConfigCompletionContributor.kt\norg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$PropertyValueCompletionProvider\n*L\n322#1:434,5\n330#1:439\n330#1:440,3\n335#1:443\n335#1:444,3\n337#1:447\n337#1:448,3\n339#1:451\n339#1:452,3\n341#1:455\n341#1:456,3\n363#1:472,9\n363#1:481\n363#1:483\n363#1:484\n369#1:485,2\n361#1:459,9\n361#1:468\n361#1:470\n361#1:471\n361#1:469\n363#1:482\n*E\n"})
    private static final class PropertyValueCompletionProvider
    extends TfCompletionProvider {
        @NotNull
        public static final PropertyValueCompletionProvider INSTANCE = new PropertyValueCompletionProvider();

        private PropertyValueCompletionProvider() {
        }

        /*
         * Unable to fully structure code
         */
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            block30: {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                v0 = parameters.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPosition(...)");
                position = v0;
                parent = position.getParent();
                inArray = parent.getParent() instanceof HCLArray;
                $this$debug_u24default$iv = TfConfigCompletionContributor.Companion.getLOG();
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var29_11 = $this$debug_u24default$iv;
                    $i$a$-debug$default-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$1 = false;
                    var29_11.debug("TF.PropertyValueCompletionProvider{position=" + position + ", parent=" + parent + "}", e$iv);
                }
                v1 = (HCLProperty)PsiTreeUtil.getParentOfType((PsiElement)position, HCLProperty.class);
                if (v1 == null) {
                    return;
                }
                property = v1;
                v2 = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)property, HCLBlock.class);
                if (v2 == null) {
                    return;
                }
                block = v2;
                type = UtilKt.getNameElementUnquoted(block, 0);
                if (Intrinsics.areEqual((Object)property.getName(), (Object)"provider") && (Intrinsics.areEqual((Object)type, (Object)"resource") || Intrinsics.areEqual((Object)type, (Object)"data"))) {
                    providers = ExtensionsKt.getTerraformModule(property).getDefinedProviders();
                    var11_16 = providers;
                    var29_11 = result;
                    $i$f$map = false;
                    var13_23 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var18_50 = (Pair)item$iv$iv;
                        var30_61 = destination$iv$iv;
                        $i$a$-map-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$2 = false;
                        var30_61.add(LookupElementBuilder.create((String)((String)it.getSecond())).withInsertHandler((InsertHandler)QuoteInsertHandler.INSTANCE));
                    }
                    var29_11.addAllElements((Iterable)((List)destination$iv$iv));
                    return;
                }
                if (!TfPsiPatterns.INSTANCE.getDependsOnPattern().accepts((Object)property) || !inArray) break block30;
                $this$map$iv = Module.getDefinedResources$default(ExtensionsKt.getTerraformModule(property), null, null, 3, null);
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (HCLBlock)item$iv$iv;
                    var29_11 = destination$iv$iv;
                    $i$a$-map-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$resources$1 = false;
                    var29_11.add(UtilKt.getNameElementUnquoted(it, 1) + "." + it.getName());
                }
                resources = (List)destination$iv$iv;
                $i$f$map = Module.getDefinedDataSources$default(ExtensionsKt.getTerraformModule(property), null, null, 3, null);
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    $i$a$-map-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$resources$1 = (HCLBlock)item$iv$iv;
                    var29_11 = destination$iv$iv;
                    $i$a$-map-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$datas$1 = false;
                    var29_11.add("data." + UtilKt.getNameElementUnquoted((HCLBlock)it, 1) + "." + it.getName());
                }
                datas = (List)destination$iv$iv;
                $i$f$map = Module.getDefinedModules$default(ExtensionsKt.getTerraformModule(property), null, 1, null);
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (E item$iv$iv : $this$mapTo$iv$iv) {
                    $i$a$-map-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$datas$1 = (HCLBlock)item$iv$iv;
                    var29_11 = destination$iv$iv;
                    $i$a$-map-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$modules$1 = false;
                    var29_11.add("module." + it.getName());
                }
                modules = (List)destination$iv$iv;
                $i$f$map = ExtensionsKt.getTerraformModule(property).getAllVariables();
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    $i$a$-map-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$modules$1 = (Variable)item$iv$iv;
                    var29_11 = destination$iv$iv;
                    $i$a$-map-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$variables$1 = false;
                    var29_11.add("var." + it.getName());
                }
                variables = (List)destination$iv$iv;
                $i$f$map = type;
                if ($i$f$map == null) ** GOTO lbl-1000
                tmp = -1;
                switch ($i$f$map.hashCode()) {
                    case 3076010: {
                        if ($i$f$map.equals("data")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -341064690: {
                        if ($i$f$map.equals("resource")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case -1068784020: {
                        if ($i$f$map.equals("module")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case -1249586564: {
                        if ($i$f$map.equals("variable")) {
                            tmp = 4;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v3 = "data." + UtilKt.getNameElementUnquoted(block, 1) + "." + block.getName();
                        break;
                    }
                    case 2: {
                        v3 = UtilKt.getNameElementUnquoted(block, 1) + "." + block.getName();
                        break;
                    }
                    case 3: {
                        v3 = "module." + block.getName();
                        break;
                    }
                    case 4: {
                        v3 = "var." + block.getName();
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v3 = "unsupported";
                    }
                }
                current = v3;
                result.addAllElements((Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.minus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)resources), (Iterable)datas), (Iterable)modules), (Iterable)variables), (Object)current), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, addCompletions$lambda$6(java.lang.String ), (Ljava/lang/String;)Lcom/intellij/codeInsight/lookup/LookupElementBuilder;)())));
                return;
            }
            datas = TfModelHelper.INSTANCE.getBlockProperties(block).get(property.getName());
            prop = datas instanceof PropertyType != false ? (PropertyType)datas : null;
            v4 = prop;
            if (v4 == null || (v4 = v4.getHint()) == null) {
                return;
            }
            hint = v4;
            if (hint instanceof ReferenceHint) {
                module = ExtensionsKt.getTerraformModule(property);
                variables = ((ReferenceHint)hint).getHint();
                $i$f$mapNotNull = false;
                $i$f$map = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                it = ((void)$this$forEach$iv$iv$iv).length;
                for (var20_65 = 0; var20_65 < it; ++var20_65) {
                    element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var20_65];
                    $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                    it = element$iv$iv;
                    $i$a$-mapNotNull-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$4 = false;
                    if (ReferenceCompletionHelper.INSTANCE.findByFQNRef((String)it, module) == null) continue;
                    $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var20_66 = $this$forEach$iv$iv$iv.iterator();
                while (var20_66.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var20_66.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = element$iv$iv;
                    $i$a$-mapNotNull-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$5 = false;
                    if ((it instanceof String ? "${" + it + "}" : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    $i$a$-forEach-TfConfigCompletionContributor$PropertyValueCompletionProvider$addCompletions$6 = false;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)it).withInsertHandler((InsertHandler)QuoteInsertHandler.INSTANCE));
                }
                return;
            }
        }

        private static final LookupElementBuilder addCompletions$lambda$6(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return LookupElementBuilder.create((String)it).withInsertHandler((InsertHandler)QuoteInsertHandler.INSTANCE);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$RequiredProviderCompletion;", "Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$TfCompletionProvider;", "<init>", "()V", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfConfigCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfConfigCompletionContributor.kt\norg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$RequiredProviderCompletion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,433:1\n66#2,2:434\n1563#3:436\n1634#3,3:437\n774#3:440\n865#3,2:441\n1563#3:443\n1634#3,3:444\n*S KotlinDebug\n*F\n+ 1 TfConfigCompletionContributor.kt\norg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$RequiredProviderCompletion\n*L\n211#1:434,2\n215#1:436\n215#1:437,3\n215#1:440\n215#1:441,2\n216#1:443\n216#1:444,3\n*E\n"})
    public static final class RequiredProviderCompletion
    extends TfCompletionProvider {
        @NotNull
        public static final RequiredProviderCompletion INSTANCE = new RequiredProviderCompletion();

        private RequiredProviderCompletion() {
        }

        /*
         * WARNING - void declaration
         */
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
            PsiElement superParent;
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Object[] objectArray = parameters.getOriginalPosition();
            if (objectArray == null) {
                return;
            }
            Object[] element = objectArray;
            PsiElement psiElement = element.getParent();
            Object object = superParent = psiElement != null ? psiElement.getParent() : null;
            if (TfPsiPatterns.INSTANCE.getRequiredProvidersBlock().accepts((Object)superParent)) {
                String string = result2.getPrefixMatcher().getPrefix();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
                String prefix = string;
                List providers = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(TypeModelProvider.Companion.getModel((PsiElement)element).allProviders(), arg_0 -> RequiredProviderCompletion.addCompletions$lambda$0(prefix, arg_0)), arg_0 -> RequiredProviderCompletion.addCompletions$lambda$1((PsiElement)element, arg_0)));
                CompletionSorter completionSorter = CompletionSorter.emptySorter().weigh(new LookupElementWeigher(){

                    public Integer weigh(LookupElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        Object object = element.getObject();
                        ProviderType providerType = object instanceof ProviderType ? (ProviderType)object : null;
                        ProviderType providerType2 = providerType;
                        return CollectionsKt.contains((Iterable)ProviderTier.Companion.getPreferedProviders(), (Object)((Object)(providerType2 != null ? providerType2.getTier() : null))) ? 0 : 1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)completionSorter, (String)"weigh(...)");
                CompletionSorter sorter2 = completionSorter;
                result2.withRelevanceSorter(sorter2).addAllElements((Iterable)providers);
            } else {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                PropertyType it;
                Collection collection;
                void $this$mapTo$iv$iv;
                Object[] $this$parentOfType_u24default$iv = element;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType22 = false;
                HCLObject hCLObject = (HCLObject)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, HCLObject.class, (boolean)true);
                if (hCLObject == null) {
                    return;
                }
                HCLObject parent = hCLObject;
                if (!TfPsiPatterns.INSTANCE.getRequiredProvidersProperty().accepts((Object)parent.getParent())) {
                    return;
                }
                $this$parentOfType_u24default$iv = new String[]{"source", "version"};
                Iterable $this$map$iv = CollectionsKt.listOf((Object[])$this$parentOfType_u24default$iv);
                boolean $i$f$map = false;
                Iterable $i$f$parentOfType22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new PropertyType((String)((Object)it), Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (PropertyType)element$iv$iv;
                    boolean bl = false;
                    if (!(parent.findProperty(it.getName()) == null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List properties = (List)destination$iv$iv;
                $this$filter$iv = properties;
                collection = result2;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (PropertyType)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(TfCompletionUtil.createPropertyOrBlockType$default(TfCompletionUtil.INSTANCE, it, null, null, 6, null));
                }
                collection.addAllElements((List)destination$iv$iv);
            }
        }

        private static final boolean addCompletions$lambda$0(String $prefix, ProviderType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return StringsKt.startsWith$default((String)it.getType(), (String)$prefix, (boolean)false, (int)2, null);
        }

        private static final LookupElement addCompletions$lambda$1(PsiElement $element, ProviderType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return TfCompletionUtil.INSTANCE.buildLookupForRequiredProvider(it, $element);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0004\u00a8\u0006\r"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$TfCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "needCompletionForBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "property", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "type", "", "intellij.terraform"})
    public static abstract class TfCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        protected final boolean needCompletionForBlock(@NotNull HCLBlock block, @NotNull HCLProperty property, @Nullable String type) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            boolean isRootBlock = TfPsiPatterns.INSTANCE.getRootBlock().accepts((Object)block);
            if (TfPsiPatterns.INSTANCE.getDependsOnPattern().accepts((Object)property)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)property.getName(), (Object)"provider") && (Intrinsics.areEqual((Object)type, (Object)"resource") || Intrinsics.areEqual((Object)type, (Object)"data")) && isRootBlock) {
                return true;
            }
            if (Intrinsics.areEqual((Object)property.getName(), (Object)"providers") && Intrinsics.areEqual((Object)type, (Object)"module") && isRootBlock) {
                return true;
            }
            PropertyOrBlockType propertyOrBlockType = TfModelHelper.INSTANCE.getBlockProperties(block).get(property.getName());
            PropertyType propertyType = propertyOrBlockType instanceof PropertyType ? (PropertyType)propertyOrBlockType : null;
            Hint hint = propertyType != null ? propertyType.getHint() : null;
            return hint instanceof SimpleValueHint || hint instanceof ReferenceHint;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$VariableNameTFVARSCompletionProvider;", "Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$TfCompletionProvider;", "<init>", "()V", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfConfigCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfConfigCompletionContributor.kt\norg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$VariableNameTFVARSCompletionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,433:1\n60#2,5:434\n1563#3:439\n1634#3,3:440\n*S KotlinDebug\n*F\n+ 1 TfConfigCompletionContributor.kt\norg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$VariableNameTFVARSCompletionProvider\n*L\n380#1:434,5\n394#1:439\n394#1:440,3\n*E\n"})
    private static final class VariableNameTFVARSCompletionProvider
    extends TfCompletionProvider {
        @NotNull
        public static final VariableNameTFVARSCompletionProvider INSTANCE = new VariableNameTFVARSCompletionProvider();

        private VariableNameTFVARSCompletionProvider() {
        }

        /*
         * WARNING - void declaration
         */
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            PsiElement psiElement;
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            PsiElement psiElement2 = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPosition(...)");
            PsiElement position = psiElement2;
            PsiElement parent = position.getParent();
            Logger $this$debug_u24default$iv = Companion.getLOG();
            PsiElement e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("TF.VariableNameTFVARSCompletionProvider{position=" + position + ", parent=" + parent + "}", (Throwable)e$iv);
            }
            Module module = null;
            e$iv = parent;
            if (e$iv instanceof HCLFile) {
                module = ExtensionsKt.getTerraformModule((HCLElement)parent);
            } else if (e$iv instanceof HCLElement) {
                psiElement = ((HCLElement)parent).getParent();
                HCLProperty hCLProperty = psiElement instanceof HCLProperty ? (HCLProperty)psiElement : null;
                if (hCLProperty == null) {
                    return;
                }
                HCLProperty pp = hCLProperty;
                if (parent != pp.getNameIdentifier()) {
                    return;
                }
                module = ExtensionsKt.getTerraformModule((HCLElement)parent);
            } else {
                return;
            }
            List<Variable> variables = module.getAllVariables();
            Iterable pp = variables;
            logger = result2;
            boolean $i$f$map = false;
            psiElement = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Variable variable = (Variable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LookupElementBuilder.create((String)it.getName()).withInsertHandler((InsertHandler)ResourcePropertyInsertHandler.INSTANCE));
            }
            logger.addAllElements((Iterable)((List)destination$iv$iv));
        }
    }
}

