/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.codeinsight;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.HclTypeModelKt;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.hcl.Icons;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfLookupElementRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElementRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "renderElement", "", "element", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "trimType", "", "type", "Lorg/intellij/terraform/config/model/HclType;", "getTypeIcon", "Ljavax/swing/Icon;", "intellij.terraform"})
public final class TfLookupElementRenderer
extends LookupElementRenderer<LookupElement> {
    public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setItemText(element.getLookupString());
        Object object = element.getObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
        Object obj = object;
        if (obj instanceof PropertyOrBlockType) {
            presentation.setItemTextBold(((PropertyOrBlockType)obj).getRequired());
            presentation.setStrikeout(((PropertyOrBlockType)obj).getDeprecated() != null);
            PropertyOrBlockType propertyOrBlockType = (PropertyOrBlockType)obj;
            if (propertyOrBlockType instanceof PropertyType) {
                presentation.setIcon(Icons.INSTANCE.getProperty());
                presentation.setTypeText(this.trimType(((PropertyType)obj).getType()), this.getTypeIcon(((PropertyType)obj).getType()));
            } else if (propertyOrBlockType instanceof BlockType) {
                presentation.setIcon(Icons.INSTANCE.getObject());
            }
        }
    }

    private final String trimType(HclType type) {
        String string = StringUtil.shortenTextWithEllipsis((String)type.toString(), (int)30, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        return string;
    }

    private final Icon getTypeIcon(HclType type) {
        if (HclTypeModelKt.isObjectType(type)) {
            Icons.INSTANCE.getObject();
        } else if (HclTypeModelKt.isListType(type)) {
            Icons.INSTANCE.getArray();
        }
        return null;
    }
}

