/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.CharsKt;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.config.psi.TfDocumentPsi;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hcl.psi.common.ProviderDefinedFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0001\u001a\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0001\u001a\u0017\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0016H\u0001\u001a\u0015\u0010\u0017\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00152\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u001a\u0019\u0010\u0018\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u0019\u0010\u0019\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0016H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"FETCH_TIMEOUT", "", "getFETCH_TIMEOUT", "()I", "NO_DOC", "", "getNO_DOC", "()Ljava/lang/String;", "ROOT_DOC_ANCHOR", "parentBlocksForDocs", "", "getParentBlocksForDocs", "()Ljava/util/Set;", "getBlockForHclIdentifier", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "element", "Lorg/intellij/terraform/hcl/psi/HCLIdentifier;", "getBlockForDocumentationLink", "Lorg/intellij/terraform/config/psi/TfDocumentPsi;", "blockTypeLiteral", "getHelpWindowHeader", "Lorg/jetbrains/annotations/Nls;", "Lcom/intellij/psi/PsiElement;", "calculateBlockDescription", "getTextIfProviderFunction", "getTextIfRequiredProvider", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLDocumentationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLDocumentationUtils.kt\norg/intellij/terraform/config/documentation/HCLDocumentationUtilsKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n80#2:118\n80#2:121\n67#2:125\n183#3,2:119\n183#3,2:122\n1#4:124\n*S KotlinDebug\n*F\n+ 1 HCLDocumentationUtils.kt\norg/intellij/terraform/config/documentation/HCLDocumentationUtilsKt\n*L\n34#1:118\n41#1:121\n51#1:125\n34#1:119,2\n41#1:122,2\n*E\n"})
public final class HCLDocumentationUtilsKt {
    private static final int FETCH_TIMEOUT = RegistryManager.Companion.getInstance().intValue("terraform.registry.connection.timeout", 1000);
    @NotNull
    private static final String NO_DOC;
    @NotNull
    public static final String ROOT_DOC_ANCHOR = "provider-docs-content";
    @NotNull
    private static final Set<String> parentBlocksForDocs;

    public static final int getFETCH_TIMEOUT() {
        return FETCH_TIMEOUT;
    }

    @NotNull
    public static final String getNO_DOC() {
        return NO_DOC;
    }

    @NotNull
    public static final Set<String> getParentBlocksForDocs() {
        return parentBlocksForDocs;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @Nullable
    public static final HCLBlock getBlockForHclIdentifier(@NotNull HCLIdentifier element) {
        Object v0;
        block1: {
            void $this$parentsOfType$iv;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = element;
            boolean withSelf$iv = true;
            boolean $i$f$parentsOfType = false;
            Sequence $this$firstOrNull$iv = PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, HCLBlock.class, (boolean)withSelf$iv);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HCLBlock block = (HCLBlock)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(block.getClass(), element.getClass()) && CollectionsKt.contains((Iterable)parentBlocksForDocs, (Object)UtilKt.getNameElementUnquoted(block, 0)))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresReadLock
    @Nullable
    public static final HCLBlock getBlockForDocumentationLink(@Nullable TfDocumentPsi element, @NotNull String blockTypeLiteral) {
        Object v3;
        block1: {
            void $this$parentsOfType$iv;
            Intrinsics.checkNotNullParameter((Object)blockTypeLiteral, (String)"blockTypeLiteral");
            TfDocumentPsi tfDocumentPsi = element;
            TfDocumentPsi tfDocumentPsi2 = tfDocumentPsi;
            if (tfDocumentPsi == null) return null;
            PsiElement psiElement = tfDocumentPsi2;
            boolean withSelf$iv = false;
            boolean $i$f$parentsOfType = false;
            Sequence sequence = PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, HCLBlock.class, (boolean)withSelf$iv);
            tfDocumentPsi2 = sequence;
            if (sequence == null) return null;
            TfDocumentPsi $this$firstOrNull$iv = tfDocumentPsi2;
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                HCLBlock block = (HCLBlock)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)UtilKt.getNameElementUnquoted(block, 1), (Object)blockTypeLiteral)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        HCLBlock hCLBlock = v3;
        return hCLBlock;
    }

    @RequiresReadLock
    @NotNull
    public static final String getHelpWindowHeader(@Nullable PsiElement element) {
        Object object;
        block10: {
            block13: {
                block14: {
                    String string;
                    block12: {
                        block11: {
                            Object parentBlockType;
                            block9: {
                                String $this$parentOfType$iv;
                                string = HCLDocumentationUtilsKt.getTextIfProviderFunction(element);
                                if (string != null) {
                                    String it = string;
                                    boolean bl = false;
                                    return it;
                                }
                                string = HCLDocumentationUtilsKt.getTextIfRequiredProvider(element);
                                if (string != null) {
                                    String it = string;
                                    boolean bl = false;
                                    return it;
                                }
                                string = element;
                                if (!(string instanceof HCLProperty)) break block9;
                                PsiElement it = element;
                                boolean withSelf$iv = true;
                                boolean $i$f$parentOfType = false;
                                HCLBlock block = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, HCLBlock.class, (boolean)false);
                                if (TfPsiPatterns.INSTANCE.getLocalsRootBlock().accepts((Object)block)) {
                                    Object[] objectArray = new Object[]{((HCLProperty)element).getName()};
                                    $this$parentOfType$iv = HCLBundle.message("terraform.doc.label.local.value.0", objectArray);
                                    Intrinsics.checkNotNull((Object)$this$parentOfType$iv);
                                    object = $this$parentOfType$iv;
                                } else {
                                    Object[] objectArray = new Object[]{((HCLProperty)element).getName()};
                                    $this$parentOfType$iv = HCLBundle.message("terraform.doc.property.0", objectArray);
                                    Intrinsics.checkNotNull((Object)$this$parentOfType$iv);
                                    object = $this$parentOfType$iv;
                                }
                                break block10;
                            }
                            if (!(string instanceof HCLIdentifier)) break block11;
                            HCLBlock parentBlock = HCLDocumentationUtilsKt.getBlockForHclIdentifier((HCLIdentifier)element);
                            Object object2 = parentBlock;
                            if (object2 == null || (object2 = UtilKt.getNameElementUnquoted((HCLBlock)object2, 1)) == null) {
                                HCLBlock hCLBlock = parentBlock;
                                object2 = hCLBlock != null ? UtilKt.getNameElementUnquoted(hCLBlock, 0) : null;
                            }
                            if ((parentBlockType = object2) != null) {
                                Object[] objectArray = new Object[]{parentBlockType, ((HCLIdentifier)element).getId()};
                                String string2 = HCLBundle.message("terraform.doc.argument.0.1", objectArray);
                                Intrinsics.checkNotNull((Object)string2);
                                object = string2;
                            } else {
                                object = NO_DOC;
                            }
                            break block10;
                        }
                        if (!(string instanceof HCLBlock)) break block12;
                        object = HCLDocumentationUtilsKt.calculateBlockDescription((HCLBlock)element);
                        break block10;
                    }
                    if (!(string instanceof TfDocumentPsi)) break block13;
                    PsiElement block = ((TfDocumentPsi)element).getParent();
                    object = block instanceof HCLBlock ? (HCLBlock)block : null;
                    if (object == null) break block14;
                    Object it = object;
                    boolean bl = false;
                    String string3 = HCLDocumentationUtilsKt.calculateBlockDescription((HCLBlock)it);
                    object = string3;
                    if (string3 != null) break block10;
                }
                Object[] objectArray = new Object[]{HCLBundle.message("terraform.doc.generic.block", new Object[0]), ((TfDocumentPsi)element).getName()};
                String string = HCLBundle.message("terraform.doc.block.type.0", objectArray);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                break block10;
            }
            object = NO_DOC;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String calculateBlockDescription(@NotNull HCLBlock element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String type = UtilKt.getNameElementUnquoted(element, 0);
        String string2 = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String name = string2;
        if (!TfPsiPatterns.INSTANCE.getRootBlock().accepts((Object)element)) {
            string = NO_DOC;
            return string;
        }
        if (Intrinsics.areEqual((Object)name, (Object)UtilKt.getNameElementUnquoted(element, 1))) {
            String string3;
            Object[] objectArray;
            String string4 = "terraform.doc.block.type.0";
            Object[] objectArray2 = objectArray = new Object[2];
            int n = 0;
            String string5 = type;
            if (string5 != null) {
                String string6 = string5;
                if (((CharSequence)string6).length() > 0) {
                    void it;
                    char c = string6.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    int n2 = n;
                    Object[] objectArray3 = objectArray2;
                    String string7 = string4;
                    boolean bl = false;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    CharSequence charSequence = CharsKt.uppercase((char)it, (Locale)locale);
                    string4 = string7;
                    objectArray2 = objectArray3;
                    n = n2;
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
                    String string8 = string6;
                    int n3 = 1;
                    String string9 = string8.substring(n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                    string3 = stringBuilder2.append(string9).toString();
                } else {
                    string3 = string6;
                }
            } else {
                string3 = null;
            }
            objectArray2[n] = string3;
            objectArray[1] = element.getName();
            String string10 = HCLBundle.message(string4, objectArray);
            Intrinsics.checkNotNull((Object)string10);
            string = string10;
            return string;
        }
        String string11 = type;
        if (string11 != null) {
            int n = -1;
            switch (string11.hashCode()) {
                case -1005512447: {
                    if (!string11.equals("output")) break;
                    n = 1;
                    break;
                }
                case 3076010: {
                    if (!string11.equals("data")) break;
                    n = 2;
                    break;
                }
                case -987494927: {
                    if (!string11.equals("provider")) break;
                    n = 3;
                    break;
                }
                case -341064690: {
                    if (!string11.equals("resource")) break;
                    n = 4;
                    break;
                }
                case -1068784020: {
                    if (!string11.equals("module")) break;
                    n = 5;
                    break;
                }
                case -1249586564: {
                    if (!string11.equals("variable")) break;
                    n = 6;
                    break;
                }
                case -2123444524: {
                    if (!string11.equals("terraform")) break;
                    n = 7;
                    break;
                }
                case -1097462168: {
                    if (!string11.equals("locals")) break;
                    n = 8;
                    break;
                }
            }
            switch (n) {
                case 5: {
                    Object[] objectArray = new Object[]{name};
                    String string12 = HCLBundle.message("terraform.doc.module.0", objectArray);
                    string = string12;
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"message(...)");
                    return string;
                }
                case 6: {
                    Object[] objectArray = new Object[]{name};
                    String string13 = HCLBundle.message("terraform.doc.input.variable.0", objectArray);
                    string = string13;
                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"message(...)");
                    return string;
                }
                case 1: {
                    Object[] objectArray = new Object[]{name};
                    String string14 = HCLBundle.message("terraform.doc.output.value.0", objectArray);
                    string = string14;
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"message(...)");
                    return string;
                }
                case 3: {
                    Object[] objectArray = new Object[]{name};
                    String string15 = HCLBundle.message("terraform.doc.provider.0", objectArray);
                    string = string15;
                    Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"message(...)");
                    return string;
                }
                case 4: {
                    Object[] objectArray = new Object[]{name, UtilKt.getNameElementUnquoted(element, 1)};
                    String string16 = HCLBundle.message("terraform.doc.resource.0.of.type.1", objectArray);
                    string = string16;
                    Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"message(...)");
                    return string;
                }
                case 2: {
                    Object[] objectArray = new Object[]{name, UtilKt.getNameElementUnquoted(element, 1)};
                    String string17 = HCLBundle.message("terraform.doc.data.source.0.of.type.1", objectArray);
                    string = string17;
                    Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"message(...)");
                    return string;
                }
                case 7: {
                    String string18 = HCLBundle.message("terraform.doc.terraform.configuration", new Object[0]);
                    string = string18;
                    Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"message(...)");
                    return string;
                }
                case 8: {
                    String string19 = HCLBundle.message("terraform.doc.local.values", new Object[0]);
                    string = string19;
                    Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"message(...)");
                    return string;
                }
            }
        }
        string = NO_DOC;
        return string;
    }

    private static final String getTextIfProviderFunction(PsiElement element) {
        Object object;
        ProviderDefinedFunction providerDefinedFunction = element instanceof ProviderDefinedFunction ? (ProviderDefinedFunction)element : null;
        if (providerDefinedFunction == null) {
            PsiElement psiElement = element;
            object = psiElement != null ? psiElement.getParent() : null;
            providerDefinedFunction = object instanceof ProviderDefinedFunction ? (ProviderDefinedFunction)object : null;
            if (providerDefinedFunction == null) {
                return null;
            }
        }
        ProviderDefinedFunction function = providerDefinedFunction;
        String providerName = UtilKt.getNameOrText((PsiNamedElement)function.getProvider());
        String functionName = UtilKt.getNameOrText((PsiNamedElement)function.getFunction());
        object = new Object[]{functionName, providerName};
        return HCLBundle.message("terraform.doc.provider.function", object);
    }

    private static final String getTextIfRequiredProvider(PsiElement element) {
        PsiElement psiElement = element;
        if (psiElement == null || (psiElement = HCLPsiUtil.INSTANCE.getRequiredProviderProperty(psiElement)) == null) {
            return null;
        }
        PsiElement providerProperty = psiElement;
        Object[] objectArray = new Object[]{providerProperty.getName()};
        return HCLBundle.message("terraform.doc.provider.0", objectArray);
    }

    static {
        String string = CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        NO_DOC = string;
        Object[] objectArray = new String[]{"resource", "data", "provider"};
        parentBlocksForDocs = SetsKt.setOf((Object[])objectArray);
    }
}

