/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.documentation;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.MarkdownParser;
import org.intellij.terraform.config.documentation.HCLDocumentationUtilsKt;
import org.intellij.terraform.config.documentation.RemoteTfDocumentationProvider;
import org.intellij.terraform.config.documentation.html.TfFlavourDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\nH\u0087@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0012\u0010\u0013\u001a\u00020\n2\b\b\u0001\u0010\u0014\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a \u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u0011\u0012\u000f\u0012\u0006\u0012\u0004\u0018\u00010\n0\f\u00a2\u0006\u0002\b\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/intellij/terraform/config/documentation/RemoteTfDocumentationProvider;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "embeddedHtmlType", "Lorg/intellij/markdown/IElementType;", "docCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lkotlinx/coroutines/Deferred;", "getDoc", "urlString", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchDocumentationText", "removeMdHeader", "input", "convertMarkdownToHtml", "markdownText", "intellij.terraform"})
public final class RemoteTfDocumentationProvider {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final IElementType embeddedHtmlType;
    @NotNull
    private final LoadingCache<String, Deferred<String>> docCache;

    public RemoteTfDocumentationProvider(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.embeddedHtmlType = new IElementType("ROOT");
        LoadingCache loadingCache = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).executor((Executor)AppExecutorUtil.getAppExecutorService()).build(new CacheLoader(this){
            final /* synthetic */ RemoteTfDocumentationProvider $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final Deferred<String> load(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RemoteTfDocumentationProvider.access$fetchDocumentationText(this.$tmp0, p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.docCache = loadingCache;
    }

    @NlsSafe
    @Nullable
    public final Object getDoc(@NotNull String urlString, @NotNull Continuation<? super String> $completion) {
        return ((Deferred)this.docCache.get((Object)urlString)).await($completion);
    }

    private final Deferred<String> fetchDocumentationText(String urlString) {
        return BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(urlString, this, null){
            int label;
            final /* synthetic */ String $urlString;
            final /* synthetic */ RemoteTfDocumentationProvider this$0;
            {
                this.$urlString = $urlString;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> fetchDocumentationText.1.invokeSuspend$lambda$0(this.$urlString, this.this$0, arg_0), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(String $urlString, RemoteTfDocumentationProvider this$0, ProgressIndicator it) {
                String string;
                try {
                    String string2 = HttpRequests.request((String)$urlString).connectTimeout(HCLDocumentationUtilsKt.getFETCH_TIMEOUT()).readTimeout(HCLDocumentationUtilsKt.getFETCH_TIMEOUT()).readString(ProgressManager.getGlobalProgressIndicator());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
                    String rawDocText = string2;
                    string = RemoteTfDocumentationProvider.access$convertMarkdownToHtml(this$0, RemoteTfDocumentationProvider.access$removeMdHeader(this$0, rawDocText));
                }
                catch (IOException ex) {
                    boolean $i$f$fileLogger = false;
                    boolean $i$f$currentClassLogger = false;
                    Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                    Logger logger = Logger.getInstance(clazz$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warnWithDebug("Cannot fetch documentation for url: " + $urlString + ", Exception: " + ex.getClass() + ": " + ex.getMessage() + ". Enable DEBUG log level to see stack trace", (Throwable)ex);
                    string = null;
                }
                return string;
            }
        }), (int)2, null);
    }

    private final String removeMdHeader(String input) {
        Ref.BooleanRef inFrontMatter = new Ref.BooleanRef();
        return ((Object)StringsKt.trim((CharSequence)SequencesKt.joinToString$default((Sequence)SequencesKt.dropWhile((Sequence)StringsKt.lineSequence((CharSequence)input), arg_0 -> RemoteTfDocumentationProvider.removeMdHeader$lambda$0(inFrontMatter, arg_0)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))).toString();
    }

    private final String convertMarkdownToHtml(@NlsSafe String markdownText) {
        TfFlavourDescriptor flavour = new TfFlavourDescriptor(this.embeddedHtmlType);
        ASTNode parsedTree = MarkdownParser.parse$default((MarkdownParser)new MarkdownParser((MarkdownFlavourDescriptor)flavour), (IElementType)this.embeddedHtmlType, (String)markdownText, (boolean)false, (int)4, null);
        return HtmlGenerator.generateHtml$default((HtmlGenerator)new HtmlGenerator(markdownText, parsedTree, (MarkdownFlavourDescriptor)flavour, false, 8, null), null, (int)1, null);
    }

    private static final boolean removeMdHeader$lambda$0(Ref.BooleanRef $inFrontMatter, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)line)).toString(), (Object)"---")) {
            $inFrontMatter.element = !$inFrontMatter.element;
        }
        return $inFrontMatter.element;
    }

    public static final /* synthetic */ String access$convertMarkdownToHtml(RemoteTfDocumentationProvider $this, String markdownText) {
        return $this.convertMarkdownToHtml(markdownText);
    }

    public static final /* synthetic */ String access$removeMdHeader(RemoteTfDocumentationProvider $this, String input) {
        return $this.removeMdHeader(input);
    }

    public static final /* synthetic */ Deferred access$fetchDocumentationText(RemoteTfDocumentationProvider $this, String urlString) {
        return $this.fetchDocumentationText(urlString);
    }
}

