/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.formatter;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.TerraformLanguage;
import org.intellij.terraform.hcl.formatter.HclLanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/terraform/config/formatter/TfConfigCodeStyleSettingsProvider;", "Lorg/intellij/terraform/hcl/formatter/HclLanguageCodeStyleSettingsProvider;", "<init>", "()V", "getCodeSample", "", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "getLanguage", "Lcom/intellij/lang/Language;", "intellij.terraform"})
public final class TfConfigCodeStyleSettingsProvider
extends HclLanguageCodeStyleSettingsProvider {
    @Override
    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        return "# Specify the provider and access details\nprovider \"aws\" {\n    region = \"${var.aws_region}\"\n}\n\nresource \"aws_elb\" \"web\" {\n  name = \"terraform-example-elb\"\n\n  # The same availability zone as our instances\n  availability_zones = [\"${aws_instance.web.*.availability_zone}\"]\n\n  listener {\n    instance_port = 80\n    instance_protocol = \"http\"\n    lb_port = 80\n    lb_protocol = \"http\"\n  }\n\n  # The instances are registered automatically\n  instances = [\"${aws_instance.web.*.id}\"]\n}\n\nresource \"aws_instance\" \"web\" {\n  instance_type = \"m1.small\"\n  ami = \"${lookup(var.aws_amis, var.aws_region)}\"\n\n  # This will create 4 instances\n  count = 4\n}";
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return TerraformLanguage.INSTANCE;
    }
}

