/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLNullLiteral;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J<\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/intellij/terraform/config/inspection/HCLBlockConflictingPropertiesInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getID", "", "getBatchSuppressActions", "", "Lcom/intellij/codeInspection/SuppressQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "doCheck", "", "name", "obj", "Lorg/intellij/terraform/hcl/psi/HCLObject;", "properties", "", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "MyEV", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLBlockConflictingPropertiesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLBlockConflictingPropertiesInspection.kt\norg/intellij/terraform/config/inspection/HCLBlockConflictingPropertiesInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n774#2:84\n865#2,2:85\n1634#2,3:87\n774#2:90\n865#2,2:91\n1634#2,3:93\n*S KotlinDebug\n*F\n+ 1 HCLBlockConflictingPropertiesInspection.kt\norg/intellij/terraform/config/inspection/HCLBlockConflictingPropertiesInspection\n*L\n65#1:84\n65#1:85,2\n65#1:87,3\n69#1:90\n69#1:91,2\n69#1:93,3\n*E\n"})
public final class HCLBlockConflictingPropertiesInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    @NotNull
    public String getID() {
        return "ConflictingProperties";
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressQuickFix[] suppressQuickFixArray = super.getBatchSuppressActions(PsiTreeUtil.getParentOfType((PsiElement)element, HCLBlock.class, (boolean)false));
        Intrinsics.checkNotNullExpressionValue((Object)suppressQuickFixArray, (String)"getBatchSuppressActions(...)");
        return suppressQuickFixArray;
    }

    /*
     * WARNING - void declaration
     */
    private final void doCheck(ProblemsHolder holder, PsiElement element, String name, HCLObject obj, Map<String, ? extends PropertyOrBlockType> properties) {
        HCLBlock it;
        Collection collection;
        void $this$mapTo$iv;
        HCLElement it2;
        Iterable $this$filterTo$iv$iv;
        ProgressIndicatorProvider.checkCanceled();
        PropertyOrBlockType propertyOrBlockType = properties.get(name);
        if (propertyOrBlockType == null) {
            return;
        }
        PropertyOrBlockType pobt = propertyOrBlockType;
        List<String> list = pobt.getConflictsWith();
        if (list == null) {
            return;
        }
        List conflictsWith = CollectionsKt.minus((Iterable)list, (Object)name);
        if (conflictsWith.isEmpty()) {
            return;
        }
        ProgressIndicatorProvider.checkCanceled();
        ArrayList conflicts = new ArrayList();
        List<HCLProperty> list2 = obj.getPropertyList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getPropertyList(...)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (HCLProperty)element$iv$iv;
            boolean bl = false;
            if (!conflictsWith.contains(it2.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (HCLProperty)element$iv$iv;
            boolean bl = false;
            if (!(!(it2.getValue() instanceof HCLNullLiteral))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection destination$iv = conflicts;
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            HCLProperty hCLProperty = (HCLProperty)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        ProgressIndicatorProvider.checkCanceled();
        List<HCLBlock> list3 = obj.getBlockList();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getBlockList(...)");
        $this$filter$iv = list3;
        $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (HCLBlock)element$iv$iv;
            boolean bl = false;
            if (!conflictsWith.contains(it2.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        destination$iv = conflicts;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (HCLBlock)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        if (conflicts.isEmpty()) {
            return;
        }
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)conflicts, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)};
        holder.registerProblem(element, HCLBundle.message("conflicting.resource.property.inspection.error.message", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/intellij/terraform/config/inspection/HCLBlockConflictingPropertiesInspection$MyEV;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/HCLBlockConflictingPropertiesInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitProperty", "", "property", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "visitBlock", "inner", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
    public final class MyEV
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitProperty(@NotNull HCLProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            ProgressIndicatorProvider.checkCanceled();
            PsiElement psiElement = property.getParent();
            HCLObject hCLObject = psiElement instanceof HCLObject ? (HCLObject)psiElement : null;
            if (hCLObject == null) {
                return;
            }
            HCLObject obj = hCLObject;
            PsiElement psiElement2 = obj.getParent();
            HCLBlock hCLBlock = psiElement2 instanceof HCLBlock ? (HCLBlock)psiElement2 : null;
            if (hCLBlock == null) {
                return;
            }
            HCLBlock block = hCLBlock;
            Map<String, PropertyOrBlockType> properties = TfModelHelper.INSTANCE.getBlockProperties(block);
            if (property.getValue() instanceof HCLNullLiteral) {
                return;
            }
            PsiElement psiElement3 = property;
            String string = property.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            HCLBlockConflictingPropertiesInspection.this.doCheck(this.holder, psiElement3, string, obj, properties);
        }

        @Override
        public void visitBlock(@NotNull HCLBlock inner) {
            Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
            ProgressIndicatorProvider.checkCanceled();
            PsiElement psiElement = inner.getParent();
            HCLObject hCLObject = psiElement instanceof HCLObject ? (HCLObject)psiElement : null;
            if (hCLObject == null) {
                return;
            }
            HCLObject obj = hCLObject;
            PsiElement psiElement2 = obj.getParent();
            HCLBlock hCLBlock = psiElement2 instanceof HCLBlock ? (HCLBlock)psiElement2 : null;
            if (hCLBlock == null) {
                return;
            }
            HCLBlock block = hCLBlock;
            Map<String, PropertyOrBlockType> properties = TfModelHelper.INSTANCE.getBlockProperties(block);
            PsiElement psiElement3 = inner;
            String string = inner.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            HCLBlockConflictingPropertiesInspection.this.doCheck(this.holder, psiElement3, string, obj, properties);
        }
    }
}

