/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.actions.TfInitActionKt;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/intellij/terraform/config/inspection/HCLDeprecatedElementInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "doCheck", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "properties", "", "", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "MyEV", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLDeprecatedElementInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLDeprecatedElementInspection.kt\norg/intellij/terraform/config/inspection/HCLDeprecatedElementInspection\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n504#2,7:85\n1761#3,3:92\n1761#3,3:95\n*S KotlinDebug\n*F\n+ 1 HCLDeprecatedElementInspection.kt\norg/intellij/terraform/config/inspection/HCLDeprecatedElementInspection\n*L\n48#1:85,7\n52#1:92,3\n68#1:95,3\n*E\n"})
public final class HCLDeprecatedElementInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    private final void doCheck(HCLBlock block, ProblemsHolder holder, Map<String, ? extends PropertyOrBlockType> properties) {
        boolean bl;
        String reason;
        Iterator name;
        Map candidates;
        HCLObject obj;
        block15: {
            Object[] it;
            Object element$iv;
            boolean bl2;
            boolean $i$f$any;
            Object $this$any$iv;
            block14: {
                if (properties.isEmpty()) {
                    return;
                }
                HCLObject hCLObject = block.getObject();
                if (hCLObject == null) {
                    return;
                }
                obj = hCLObject;
                ProgressIndicatorProvider.checkCanceled();
                Map<String, ? extends PropertyOrBlockType> $this$filterValues$iv = properties;
                boolean $i$f$filterValues = false;
                Object result$iv = new LinkedHashMap<String, PropertyOrBlockType>();
                for (Map.Entry<String, ? extends PropertyOrBlockType> entry$iv : $this$filterValues$iv.entrySet()) {
                    PropertyOrBlockType it2 = entry$iv.getValue();
                    boolean bl3 = false;
                    if (!(it2.getDeprecated() != null)) continue;
                    ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
                }
                candidates = (Map)result$iv;
                if (candidates.isEmpty()) {
                    return;
                }
                ProgressIndicatorProvider.checkCanceled();
                $this$any$iv = candidates.values();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    result$iv = $this$any$iv.iterator();
                    while (result$iv.hasNext()) {
                        element$iv = result$iv.next();
                        it = (Object[])element$iv;
                        boolean bl4 = false;
                        if (!(it instanceof PropertyType)) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                for (HCLProperty hclProperty : obj.getPropertyList()) {
                    Intrinsics.checkNotNullExpressionValue((Object)hclProperty.getName(), (String)"getName(...)");
                    PropertyOrBlockType propertyOrBlockType = (PropertyOrBlockType)candidates.get(name);
                    reason = propertyOrBlockType != null ? propertyOrBlockType.getDeprecated() : null;
                    if (reason == null) continue;
                    PsiElement psiElement = hclProperty;
                    it = new Object[]{name, reason, ((CharSequence)reason).length() > 0 ? 0 : 1};
                    String string = HCLBundle.message("deprecated.element.inspection.deprecated.property.error.message", it);
                    Collection collection = CollectionsKt.listOfNotNull((Object)TfInitActionKt.createQuickFixNotInitialized(block));
                    Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    it = (LocalQuickFix[])com.intellij.util.containers.UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
                    holder.registerProblem(psiElement, string, ProblemHighlightType.LIKE_DEPRECATED, (LocalQuickFix[])Arrays.copyOf(it, it.length));
                }
            }
            ProgressIndicatorProvider.checkCanceled();
            $this$any$iv = candidates.values();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                name = $this$any$iv.iterator();
                while (name.hasNext()) {
                    element$iv = name.next();
                    it = (PropertyOrBlockType)element$iv;
                    boolean bl5 = false;
                    if (!(it instanceof BlockType)) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            for (HCLBlock hclBlock : obj.getBlockList()) {
                Intrinsics.checkNotNullExpressionValue((Object)hclBlock.getName(), (String)"getName(...)");
                PropertyOrBlockType propertyOrBlockType = (PropertyOrBlockType)candidates.get(name);
                reason = propertyOrBlockType != null ? propertyOrBlockType.getDeprecated() : null;
                if (reason == null) continue;
                Object[] objectArray = new Object[]{name, reason, ((CharSequence)reason).length() > 0 ? 0 : 1};
                holder.registerProblem((PsiElement)hclBlock, HCLBundle.message("deprecated.element.inspection.deprecated.block.error.message", objectArray), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/inspection/HCLDeprecatedElementInspection$MyEV;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/HCLDeprecatedElementInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
    public final class MyEV
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitBlock(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            ProgressIndicatorProvider.checkCanceled();
            if (org.intellij.terraform.hcl.psi.UtilKt.getNameElementUnquoted(block, 0) == null) {
                return;
            }
            if (block.getObject() == null) {
                return;
            }
            Map<String, PropertyOrBlockType> properties = TfModelHelper.INSTANCE.getBlockProperties(block);
            HCLDeprecatedElementInspection.this.doCheck(block, this.holder, properties);
        }
    }
}

