/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.inspection.BlockSuppressQuickFix;
import org.intellij.terraform.config.inspection.PropertySuppressQuickFix;
import org.intellij.terraform.hcl.formatter.HclCodeStyleSettings;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J%\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/intellij/terraform/config/inspection/HCLInspectionSuppressor;", "Lcom/intellij/codeInspection/InspectionSuppressor;", "<init>", "()V", "isSuppressedFor", "", "element", "Lcom/intellij/psi/PsiElement;", "toolId", "", "getSuppressedInBlock", "getSuppressedProperty", "getInlineCommentPattern", "Ljava/util/regex/Pattern;", "getSuppressActions", "", "Lcom/intellij/codeInspection/SuppressQuickFix;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "intellij.terraform"})
public final class HCLInspectionSuppressor
implements InspectionSuppressor {
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        return this.getSuppressedInBlock(element, toolId) != null || this.getSuppressedProperty(element, toolId) != null;
    }

    private final PsiElement getSuppressedInBlock(PsiElement element, String toolId) {
        return SuppressionUtil.getStatementToolSuppressedIn((PsiElement)element, (String)toolId, HCLBlock.class, (Pattern)this.getInlineCommentPattern(element));
    }

    private final PsiElement getSuppressedProperty(PsiElement element, String toolId) {
        return SuppressionUtil.getStatementToolSuppressedIn((PsiElement)element, (String)toolId, HCLProperty.class, (Pattern)this.getInlineCommentPattern(element));
    }

    private final Pattern getInlineCommentPattern(PsiElement element) {
        CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getCustomSettings((PsiFile)element.getContainingFile(), HclCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        HclCodeStyleSettings settings = (HclCodeStyleSettings)customCodeStyleSettings;
        String commenterChar = settings.LINE_COMMENTER_CHARACTER.getPrefix();
        Pattern pattern = Pattern.compile(commenterChar + "\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*.*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        return pattern;
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        if (element == null) {
            Intrinsics.checkNotNullExpressionValue((Object)SuppressQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new BlockSuppressQuickFix(toolId), new PropertySuppressQuickFix(toolId)};
        return suppressQuickFixArray;
    }
}

