/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.inspection.TfDuplicatedInspectionBase;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002J1\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/intellij/terraform/config/inspection/TfDuplicatedProviderInspection;", "Lorg/intellij/terraform/config/inspection/TfDuplicatedInspectionBase;", "<init>", "()V", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "getDuplicates", "", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "block", "getFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "aliased", "", "duplicates", "(ZLorg/intellij/terraform/hcl/psi/HCLBlock;Ljava/util/List;)[Lcom/intellij/codeInspection/LocalQuickFix;", "MyEV", "AddAliasFix", "ChangeAliasFix", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfDuplicatedProviderInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfDuplicatedProviderInspection.kt\norg/intellij/terraform/config/inspection/TfDuplicatedProviderInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n774#2:97\n865#2,2:98\n1563#2:100\n1634#2,3:101\n295#2,2:104\n1#3:106\n37#4,2:107\n*S KotlinDebug\n*F\n+ 1 TfDuplicatedProviderInspection.kt\norg/intellij/terraform/config/inspection/TfDuplicatedProviderInspection\n*L\n45#1:97\n45#1:98,2\n52#1:100\n52#1:101,3\n58#1:104,2\n72#1:107,2\n*E\n"})
public final class TfDuplicatedProviderInspection
extends TfDuplicatedInspectionBase {
    @Override
    @NotNull
    public PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    /*
     * WARNING - void declaration
     */
    private final List<HCLBlock> getDuplicates(HCLBlock block) {
        void $this$mapTo$iv$iv;
        Pair it;
        Iterable $this$filterTo$iv$iv;
        if (!TfPsiPatterns.INSTANCE.getProviderRootBlock().accepts((Object)block)) {
            return null;
        }
        if (TfPsiPatterns.INSTANCE.getConfigOverrideFile().accepts((Object)block.getContainingFile())) {
            return null;
        }
        Module module = ExtensionsKt.getTerraformModule(block);
        String string = ExtensionsKt.getProviderFQName(block);
        if (string == null) {
            return null;
        }
        String fqn = string;
        Iterable $this$filter$iv = module.getDefinedProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getSecond(), (Object)fqn) && !TfPsiPatterns.INSTANCE.getConfigOverrideFile().accepts((Object)((HCLBlock)it.getFirst()).getContainingFile()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List same = (List)destination$iv$iv;
        if (same.isEmpty()) {
            return null;
        }
        if (same.size() == 1 && Intrinsics.areEqual((Object)((Pair)CollectionsKt.first((List)same)).getFirst(), (Object)block)) {
            return null;
        }
        Iterable $this$map$iv = same;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((HCLBlock)it.getFirst());
        }
        return (List)destination$iv$iv;
    }

    private final LocalQuickFix[] getFixes(boolean aliased, HCLBlock block, List<? extends HCLBlock> duplicates) {
        PsiFile psiFile;
        HCLBlock it;
        HCLBlock first;
        HCLBlock hCLBlock;
        Object v0;
        ArrayList<LocalQuickFix> fixes;
        block3: {
            fixes = new ArrayList<LocalQuickFix>();
            Iterable $this$firstOrNull$iv = duplicates;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HCLBlock it2 = (HCLBlock)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it2, (Object)block))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((hCLBlock = (first = (HCLBlock)v0)) != null && (hCLBlock = hCLBlock.getContainingFile()) != null && (hCLBlock = hCLBlock.getVirtualFile()) != null) {
            it = hCLBlock;
            boolean bl = false;
            LocalQuickFix it3 = this.createNavigateToDupeFix(first, duplicates.size() <= 2);
            boolean bl2 = false;
            fixes.add(it3);
        }
        if ((psiFile = block.getContainingFile()) != null && (psiFile = psiFile.getVirtualFile()) != null) {
            it = psiFile;
            boolean bl = false;
            LocalQuickFix it4 = this.createShowOtherDupesFix((PsiNamedElement)block, (NullableFunction<PsiElement, List<PsiElement>>)((NullableFunction)arg_0 -> TfDuplicatedProviderInspection.getFixes$lambda$2$0(this, arg_0)));
            boolean bl3 = false;
            fixes.add(it4);
        }
        Collection $this$toTypedArray$iv = fixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new LocalQuickFix[0]);
    }

    private static final List getFixes$lambda$2$0(TfDuplicatedProviderInspection this$0, PsiElement param) {
        Intrinsics.checkNotNull((Object)param, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLBlock");
        return this$0.getDuplicates((HCLBlock)param);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/inspection/TfDuplicatedProviderInspection$AddAliasFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.terraform"})
    private static final class AddAliasFix
    implements LocalQuickFix {
        @NotNull
        public static final AddAliasFix INSTANCE = new AddAliasFix();

        private AddAliasFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = HCLBundle.message("duplicated.provider.inspection.display.name.add.provider.alias.quick.fix.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            String string = "Implement";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/inspection/TfDuplicatedProviderInspection$ChangeAliasFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.terraform"})
    private static final class ChangeAliasFix
    implements LocalQuickFix {
        @NotNull
        public static final ChangeAliasFix INSTANCE = new ChangeAliasFix();

        private ChangeAliasFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = HCLBundle.message("duplicated.provider.inspection.display.name.change.provider.alias.quick.fix.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            String string = "Implement";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/inspection/TfDuplicatedProviderInspection$MyEV;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/TfDuplicatedProviderInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
    public final class MyEV
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitBlock(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            List list = TfDuplicatedProviderInspection.this.getDuplicates(block);
            if (list == null) {
                return;
            }
            List duplicates = list;
            String string = ExtensionsKt.getProviderFQName(block);
            if (string == null) {
                return;
            }
            String fqn = string;
            Object[] objectArray = new Object[]{fqn};
            String string2 = HCLBundle.message("duplicated.provider.inspection.display.name.multiple.declaration.error.message", objectArray);
            objectArray = TfDuplicatedProviderInspection.this.getFixes(!Intrinsics.areEqual((Object)fqn, (Object)UtilKt.getNameElementUnquoted(block, 1)), block, duplicates);
            this.holder.registerProblem((PsiElement)block, string2, ProblemHighlightType.GENERIC_ERROR, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        }
    }
}

