/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.actions.TfInitActionKt;
import org.intellij.terraform.config.inspection.RunTFToolGetFix;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.ModuleDetectionUtil;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.config.util.TfExecutorUtilKt;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.install.TfToolType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/intellij/terraform/config/inspection/TfMissingModuleInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getID", "", "getBatchSuppressActions", "", "Lcom/intellij/codeInspection/SuppressQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "doCheck", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "MyEV", "intellij.terraform"})
public final class TfMissingModuleInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    @NotNull
    public String getID() {
        return "MissingModule";
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressQuickFix[] suppressQuickFixArray = super.getBatchSuppressActions(PsiTreeUtil.getParentOfType((PsiElement)element, HCLBlock.class, (boolean)false));
        Intrinsics.checkNotNullExpressionValue((Object)suppressQuickFixArray, (String)"getBatchSuppressActions(...)");
        return suppressQuickFixArray;
    }

    private final void doCheck(ProblemsHolder holder, HCLBlock block) {
        PsiDirectory psiDirectory = block.getContainingFile().getContainingDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory directory = psiDirectory;
        ModuleDetectionUtil.Result<Module> pair = ModuleDetectionUtil.INSTANCE.getAsModuleBlockOrError(block);
        if (!(pair instanceof ModuleDetectionUtil.Result.Failure)) {
            return;
        }
        String err = ((ModuleDetectionUtil.Result.Failure)pair).getFailureString();
        ProgressIndicatorProvider.checkCanceled();
        VirtualFile virtualFile = directory.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        TfToolType applicableToolType = TfExecutorUtilKt.getApplicableToolType(virtualFile);
        PsiElement psiElement = block;
        Object[] objectArray = new Object[]{err};
        String string = HCLBundle.message("missing.module.inspection.missing.module.error.message", objectArray);
        Object[] objectArray2 = new LocalQuickFix[2];
        String string2 = directory.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        objectArray2[0] = new RunTFToolGetFix(string2, applicableToolType.getExecutableName());
        objectArray2[1] = TfInitActionKt.createQuickFixNotInitialized(block);
        Collection collection = CollectionsKt.listOfNotNull((Object[])objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        objectArray = (LocalQuickFix[])com.intellij.util.containers.UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
        holder.registerProblem(psiElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/inspection/TfMissingModuleInspection$MyEV;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/TfMissingModuleInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
    public final class MyEV
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitBlock(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            ProgressIndicatorProvider.checkCanceled();
            if (org.intellij.terraform.hcl.psi.UtilKt.getNameElementUnquoted(block, 0) == null) {
                return;
            }
            if (block.getObject() == null) {
                return;
            }
            if (!TfPsiPatterns.INSTANCE.getModuleRootBlock().accepts((Object)block)) {
                return;
            }
            if (TfPsiPatterns.INSTANCE.getModuleWithEmptySource().accepts((Object)block)) {
                return;
            }
            TfMissingModuleInspection.this.doCheck(this.holder, block);
        }
    }
}

