/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.actions.TfInitActionKt;
import org.intellij.terraform.config.codeinsight.TfCompletionUtil;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.inspection.AddClosingBraceFix;
import org.intellij.terraform.config.inspection.RemoveBlockQuickFix;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/intellij/terraform/config/inspection/TfUnknownBlockTypeInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "doCheck", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "type", "", "registerUnknownBlockProblem", "TfBlockVisitor", "intellij.terraform"})
public final class TfUnknownBlockTypeInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new TfBlockVisitor(holder);
    }

    private final void doCheck(HCLBlock block, ProblemsHolder holder, String type) {
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(HCLBlock.class), Reflection.getOrCreateKotlinClass(HCLFile.class)};
        PsiElement psiElement = PsiTreeUtilKt.parentOfTypes$default((PsiElement)block, (KClass[])kClassArray, (boolean)false, (int)2, null);
        if (psiElement == null) {
            return;
        }
        PsiElement parent = psiElement;
        PsiElement psiElement2 = parent;
        if (psiElement2 instanceof HCLFile) {
            if (TfCompletionUtil.INSTANCE.getRootBlockKeywords().contains(type)) {
                return;
            }
            this.registerUnknownBlockProblem(block, holder, type);
        } else if (psiElement2 instanceof HCLBlock) {
            if (org.intellij.terraform.hcl.psi.UtilKt.getNameElementUnquoted((HCLBlock)parent, 0) == null) {
                return;
            }
            if (((HCLBlock)parent).getObject() == null) {
                return;
            }
            if (TfPsiPatterns.INSTANCE.getDynamicBlock().accepts((Object)block) || TfPsiPatterns.INSTANCE.getDynamicBlockContent().accepts((Object)block)) {
                return;
            }
            Map<String, PropertyOrBlockType> properties = TfModelHelper.INSTANCE.getBlockProperties((HCLBlock)parent);
            if (properties.get(type) instanceof BlockType) {
                return;
            }
            if (TfPsiPatterns.INSTANCE.getRootBlock().accepts((Object)parent) && TfCompletionUtil.INSTANCE.getRootBlockKeywords().contains(type)) {
                HCLElement[] hCLElementArray = block.getNameElements();
                Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray, (String)"getNameElements(...)");
                ProblemsHolder.ProblemBuilder problemBuilder = holder.problem((PsiElement)ArraysKt.first((Object[])hCLElementArray), HCLBundle.message("unknown.block.type.inspection.missing.closing.brace.error.message", new Object[0])).highlight(ProblemHighlightType.GENERIC_ERROR);
                HCLElement[] hCLElementArray2 = block.getNameElements();
                Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray2, (String)"getNameElements(...)");
                Object object = ArraysKt.first((Object[])hCLElementArray2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                problemBuilder.fix((ModCommandAction)new AddClosingBraceFix((PsiElement)object)).register();
                return;
            }
            this.registerUnknownBlockProblem(block, holder, type);
        } else {
            return;
        }
    }

    private final void registerUnknownBlockProblem(HCLBlock block, ProblemsHolder holder, String type) {
        HCLElement[] hCLElementArray = block.getNameElements();
        Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray, (String)"getNameElements(...)");
        Object[] objectArray = new Object[]{type};
        holder.problem((PsiElement)ArraysKt.first((Object[])hCLElementArray), HCLBundle.message("unknown.block.type.inspection.unknown.block.type.error.message", objectArray)).maybeFix(TfInitActionKt.createQuickFixNotInitialized(block)).fix((ModCommandAction)new RemoveBlockQuickFix(block)).register();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/inspection/TfUnknownBlockTypeInspection$TfBlockVisitor;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/TfUnknownBlockTypeInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
    public final class TfBlockVisitor
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public TfBlockVisitor(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitBlock(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            ProgressIndicatorProvider.checkCanceled();
            String type = org.intellij.terraform.hcl.psi.UtilKt.getNameElementUnquoted(block, 0);
            CharSequence charSequence = type;
            if (!(charSequence == null || charSequence.length() == 0)) {
                TfUnknownBlockTypeInspection.this.doCheck(block, this.holder, type);
            }
        }
    }
}

