/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.actions.AddProviderAction;
import org.intellij.terraform.config.actions.TfInitActionKt;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.config.model.TfTypeModel;
import org.intellij.terraform.config.model.TypeModelProvider;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016J*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/intellij/terraform/config/inspection/TfUnknownResourceInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "allowedIdentifiers", "", "", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getTypeForBlock", "Lorg/intellij/terraform/config/model/BlockType;", "blockType", "identifier", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "model", "Lorg/intellij/terraform/config/model/TfTypeModel;", "getBlockTypeString", "TfBlockVisitor", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfUnknownResourceInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfUnknownResourceInspection.kt\norg/intellij/terraform/config/inspection/TfUnknownResourceInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class TfUnknownResourceInspection
extends LocalInspectionTool {
    @NotNull
    private final List<String> allowedIdentifiers;

    public TfUnknownResourceInspection() {
        Object[] objectArray = new String[]{"resource", "data", "provider"};
        this.allowedIdentifiers = CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new TfBlockVisitor(holder);
    }

    private final BlockType getTypeForBlock(String blockType, String identifier, HCLBlock block, TfTypeModel model) {
        return switch (blockType) {
            case "resource" -> model.getResourceType(identifier, block);
            case "data" -> model.getDataSourceType(identifier, block);
            case "provider" -> model.getProviderType(identifier, block);
            default -> null;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getBlockTypeString(HCLBlock block, List<String> allowedIdentifiers) {
        String string;
        String string2 = org.intellij.terraform.hcl.psi.UtilKt.getNameElementUnquoted(block, 0);
        String string3 = string2;
        if (string2 == null) return null;
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        string3 = string4;
        if (string4 == null) return null;
        String it = string = string3;
        boolean bl = false;
        if (!allowedIdentifiers.contains(it)) return null;
        String string5 = string;
        return string5;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/inspection/TfUnknownResourceInspection$TfBlockVisitor;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/TfUnknownResourceInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
    public final class TfBlockVisitor
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public TfBlockVisitor(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitBlock(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            ProgressIndicatorProvider.checkCanceled();
            String string = TfUnknownResourceInspection.this.getBlockTypeString(block, TfUnknownResourceInspection.this.allowedIdentifiers);
            if (string == null) {
                return;
            }
            String blockTypeString = string;
            String string2 = org.intellij.terraform.hcl.psi.UtilKt.getNameElementUnquoted(block, 1);
            if (string2 == null) {
                return;
            }
            String identifier = string2;
            TfTypeModel model = TypeModelProvider.Companion.getModel(block);
            ProviderType provider = model.getProviderType(identifier, block);
            if (provider == null) {
                PsiElement psiElement = block;
                Object[] objectArray = new Object[]{blockTypeString, identifier};
                String string3 = HCLBundle.message("unknown.resource.identifier.inspection.error.message", objectArray);
                Object[] objectArray2 = new LocalQuickFix[]{TfInitActionKt.createQuickFixNotInitialized(block), new AddProviderAction(block)};
                Collection collection = CollectionsKt.listOfNotNull((Object[])objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                objectArray = (LocalQuickFix[])com.intellij.util.containers.UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
                this.holder.registerProblem(psiElement, string3, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
            } else if (TfUnknownResourceInspection.this.getTypeForBlock(blockTypeString, identifier, block, model) == null) {
                PsiElement psiElement = block;
                Object[] objectArray = new Object[]{blockTypeString, identifier, provider.getFullName()};
                String string4 = HCLBundle.message("unknown.resource.identifier.for.known.provider", objectArray);
                Collection collection = CollectionsKt.listOfNotNull((Object)TfInitActionKt.createQuickFixNotInitialized(block));
                Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                objectArray = (LocalQuickFix[])com.intellij.util.containers.UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
                this.holder.registerProblem(psiElement, string4, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
            }
        }
    }
}

