/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IndexingIteratorsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.terraform.TemporaryProgressIndicatorReincarnationUtilsKt;
import org.intellij.terraform.config.TerraformLanguage;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.HclTypeModelKt;
import org.intellij.terraform.config.model.ModuleDetectionUtil;
import org.intellij.terraform.config.model.ModuleKt;
import org.intellij.terraform.config.model.TfTypeModel;
import org.intellij.terraform.config.model.TypeModelProvider;
import org.intellij.terraform.config.model.Variable;
import org.intellij.terraform.config.model.local.TfLocalSchemaService;
import org.intellij.terraform.config.model.version.VersionConstraint;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hcl.psi.common.LiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 F2\u00020\u0001:\u0001FB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\rJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0003J \u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0006\u0010\u0019\u001a\u00020\u0010J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 2\u0006\u0010!\u001a\u00020\u001eH\u0002J\u0018\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020$0#0\tJ\u001c\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020$\u0018\u00010#2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010&\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J$\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\t2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010+\u001a\u00020\rJ6\u0010-\u001a\b\u0012\u0004\u0012\u00020*0\t2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u0002002\n\b\u0002\u00101\u001a\u0004\u0018\u00010\r2\n\b\u0002\u00102\u001a\u0004\u0018\u00010\rH\u0002J$\u00103\u001a\b\u0012\u0004\u0012\u00020*0\t2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ$\u00104\u001a\b\u0012\u0004\u0012\u00020*0\t2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020*0\t2\u0006\u00106\u001a\u00020\rJ\u0018\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\r0#0\tJ\u0018\u00108\u001a\b\u0012\u0004\u0012\u00020*0\t2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\f\u00109\u001a\b\u0012\u0004\u0012\u00020*0\tJ\b\u0010:\u001a\u0004\u0018\u00010*J\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\r0\tJ\u0006\u0010<\u001a\u00020\u001bJ\u0013\u0010A\u001a\u00020\u001b2\b\u0010B\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010C\u001a\u000200H\u0016J\u0006\u0010D\u001a\u00020ER\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010=\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\u00a8\u0006G"}, d2={"Lorg/intellij/terraform/config/model/Module;", "", "moduleRoot", "Lcom/intellij/psi/PsiFileSystemItem;", "<init>", "(Lcom/intellij/psi/PsiFileSystemItem;)V", "getModuleRoot", "()Lcom/intellij/psi/PsiFileSystemItem;", "getAllVariables", "", "Lorg/intellij/terraform/config/model/Variable;", "findVariable", "name", "", "findVariables", "getModuleSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "fallbackCalculateModuleAwareSearchScope", "context", "findClosestRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "possibleRoots", "currentFile", "findRootsFromManifest", "dotTerraformDir", "getTerraformModuleScope", "processAllFilesWithVariables", "", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiFile;", "getAllVariablesDeclaredInFile", "", "psiFile", "getAllLocals", "Lkotlin/Pair;", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "findLocal", "process", "Lcom/intellij/psi/search/PsiElementProcessor;", "Lorg/intellij/terraform/hcl/psi/HCLFile;", "getDefinedResources", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "type", "findDefinedRequiredProvider", "getDefinedHclBlocks", "identifier", "numberOfArguments", "", "firstArgument", "secondArgument", "getDefinedDataSources", "getDefinedEphemeralResources", "findProviders", "search", "getDefinedProviders", "getDefinedModules", "getDefinedOutputs", "getTerraformBlockWithProvidersOrFirst", "getTerraformRequiredVersion", "isHCL2Supported", "model", "Lorg/intellij/terraform/config/model/TfTypeModel;", "getModel", "()Lorg/intellij/terraform/config/model/TfTypeModel;", "equals", "other", "hashCode", "getType", "Lorg/intellij/terraform/config/model/HclType;", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Module.kt\norg/intellij/terraform/config/model/Module\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,453:1\n1#2:454\n1#2:489\n30#3,2:455\n827#4:457\n855#4,2:458\n774#4:462\n865#4,2:463\n1999#4,14:465\n1617#4,9:479\n1869#4:488\n1870#4:490\n1626#4:491\n295#4,2:492\n295#4:494\n1761#4,3:496\n296#4:499\n37#5,2:460\n455#6:495\n*S KotlinDebug\n*F\n+ 1 Module.kt\norg/intellij/terraform/config/model/Module\n*L\n185#1:489\n169#1:455,2\n172#1:457\n172#1:458,2\n180#1:462\n180#1:463,2\n181#1:465,14\n185#1:479,9\n185#1:488\n185#1:490\n185#1:491\n257#1:492,2\n362#1:494\n363#1:496,3\n362#1:499\n173#1:460,2\n363#1:495\n*E\n"})
public final class Module {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiFileSystemItem moduleRoot;
    @NotNull
    private static final Logger LOG;

    private Module(PsiFileSystemItem moduleRoot) {
        this.moduleRoot = moduleRoot;
    }

    @NotNull
    public final PsiFileSystemItem getModuleRoot() {
        return this.moduleRoot;
    }

    @NotNull
    public final List<Variable> getAllVariables() {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        Set collected = set;
        this.processAllFilesWithVariables((Processor<PsiFile>)((Processor)arg_0 -> Module.getAllVariables$lambda$0(collected, this, arg_0)));
        return CollectionsKt.toList((Iterable)collected);
    }

    @Deprecated(message="There may be declaration duplicates", replaceWith=@ReplaceWith(expression="findVariables(name)", imports={}))
    @Nullable
    public final Variable findVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Companion.CollectVariablesVisitor visitor = new Companion.CollectVariablesVisitor(name);
        this.process((PsiElementProcessor<HCLFile>)((PsiElementProcessor)arg_0 -> Module.findVariable$lambda$0(visitor, arg_0)));
        return (Variable)CollectionsKt.firstOrNull((Iterable)visitor.getCollected());
    }

    @NotNull
    public final List<Variable> findVariables(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        Set collected = set;
        this.processAllFilesWithVariables((Processor<PsiFile>)((Processor)arg_0 -> Module.findVariables$lambda$0(collected, this, name, arg_0)));
        return CollectionsKt.toList((Iterable)collected);
    }

    private final GlobalSearchScope getModuleSearchScope() {
        if (ModuleKt.isFallbackVariableSearchEnabled()) {
            return this.fallbackCalculateModuleAwareSearchScope(this.moduleRoot);
        }
        VirtualFile virtualFile = this.moduleRoot.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile moduleRootVf = virtualFile;
        return GlobalSearchScopes.directoryScope((Project)this.moduleRoot.getProject(), (VirtualFile)moduleRootVf, (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Remove after 2024.3 release if no usages of `isFallbackVariableSearchEnabled` detected")
    private final GlobalSearchScope fallbackCalculateModuleAwareSearchScope(PsiFileSystemItem context) {
        void $this$filterNotTo$iv$iv;
        VirtualFile exactModuleRoot;
        VirtualFile virtualFile;
        Object serviceClass$iv;
        Object manifestRoots;
        Object object;
        Object object2;
        VirtualFile currentFileDir;
        VirtualFile currentFile;
        block12: {
            block11: {
                VirtualFile virtualFile2;
                VirtualFile virtualFile3 = context.getVirtualFile();
                if (virtualFile3 == null) {
                    return null;
                }
                VirtualFile it = virtualFile2 = (currentFile = virtualFile3);
                boolean bl = false;
                Object object3 = it.isDirectory() ? virtualFile2 : null;
                if (object3 == null) {
                    object3 = currentFileDir = currentFile.getParent();
                }
                if (!ModuleKt.isDeepVariableSearchEnabled()) {
                    return GlobalSearchScopes.directoryScope((Project)context.getProject(), (VirtualFile)currentFileDir, (boolean)false);
                }
                Project project = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                VirtualFile terraformDir = ModuleDetectionUtil.INSTANCE.getTerraformDirSomewhere(currentFile, project);
                if (terraformDir != null && currentFileDir != null && VfsUtil.isAncestor((VirtualFile)terraformDir, (VirtualFile)currentFile, (boolean)true)) {
                    return GlobalSearchScopes.directoryScope((Project)context.getProject(), (VirtualFile)currentFileDir, (boolean)false);
                }
                object2 = terraformDir;
                if (object2 == null) break block11;
                VirtualFile it2 = object2;
                boolean bl2 = false;
                List<VirtualFile> list = this.findRootsFromManifest(context, it2);
                object2 = list;
                if (list != null) break block12;
            }
            object2 = CollectionsKt.emptyList();
        }
        if ((object = this.findClosestRoot((List<? extends VirtualFile>)(manifestRoots = object2), currentFile)) == null) {
            Project project = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            serviceClass$iv = TfLocalSchemaService.class;
            Object object4 = $this$service$iv.getService((Class)serviceClass$iv);
            if (object4 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, (Class)serviceClass$iv);
            }
            VirtualFile virtualFile4 = ((TfLocalSchemaService)object4).findLockFile(currentFile);
            object = virtualFile4 != null ? virtualFile4.getParent() : null;
        }
        if ((virtualFile = (exactModuleRoot = object)) == null && (virtualFile = currentFileDir) == null) {
            return null;
        }
        VirtualFile dirToSearchIn = virtualFile;
        Iterable $this$filterNot$iv = (Iterable)manifestRoots;
        boolean $i$f$filterNot = false;
        serviceClass$iv = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (VfsUtil.isAncestor((VirtualFile)it, (VirtualFile)dirToSearchIn, (boolean)false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List otherModuleRoots = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = otherModuleRoots;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        GlobalSearchScope globalSearchScope = GlobalSearchScopes.directoriesScope((Project)context.getProject(), (boolean)true, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"directoriesScope(...)");
        GlobalSearchScope exclusion = globalSearchScope;
        return GlobalSearchScopes.directoryScope((Project)context.getProject(), (VirtualFile)dirToSearchIn, (exactModuleRoot != null ? 1 : 0) != 0).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)exclusion));
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile findClosestRoot(List<? extends VirtualFile> possibleRoots, VirtualFile currentFile) {
        Object v0;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = possibleRoots;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!VfsUtil.isAncestor((VirtualFile)it, (VirtualFile)currentFile, (boolean)false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                VirtualFile it = (VirtualFile)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getPath().length();
                do {
                    Object e$iv = iterator$iv.next();
                    VirtualFile it2 = (VirtualFile)e$iv;
                    $i$a$-maxByOrNull-Module$findClosestRoot$2 = false;
                    int v$iv = it2.getPath().length();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> findRootsFromManifest(PsiFileSystemItem context, VirtualFile dotTerraformDir) {
        void $this$mapNotNullTo$iv$iv;
        UserDataHolder userDataHolder = (UserDataHolder)context;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ModuleDetectionUtil.ModulesManifest modulesManifest = ModuleDetectionUtil.INSTANCE.getManifestForDirectory(dotTerraformDir, userDataHolder, project).getValue();
        if (modulesManifest == null) {
            return CollectionsKt.emptyList();
        }
        ModuleDetectionUtil.ModulesManifest manifest = modulesManifest;
        Iterable $this$mapNotNull$iv = manifest.getModules();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            String path;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ModuleDetectionUtil.ModuleManifest module = (ModuleDetectionUtil.ModuleManifest)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)module.getDir()), (String)"toSystemIndependentName(...)");
            if (manifest.getContext().findFileByRelativePath(path) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final GlobalSearchScope getTerraformModuleScope() {
        GlobalSearchScope globalSearchScope = this.getModuleSearchScope();
        if (globalSearchScope == null) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.projectScope((Project)this.moduleRoot.getProject());
            globalSearchScope = globalSearchScope2;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"projectScope(...)");
        }
        GlobalSearchScope searchScope = globalSearchScope;
        Project project = this.moduleRoot.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ModuleKt.restrictToTerraformFiles(searchScope, project);
    }

    private final boolean processAllFilesWithVariables(Processor<PsiFile> processor) {
        GlobalSearchScope terraformScope = this.getTerraformModuleScope();
        return (Boolean)TemporaryProgressIndicatorReincarnationUtilsKt.withGuaranteedProgressIndicator(() -> Module.processAllFilesWithVariables$lambda$0(this, terraformScope, processor));
    }

    private final Collection<Variable> getAllVariablesDeclaredInFile(PsiFile psiFile) {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psiFile), () -> Module.getAllVariablesDeclaredInFile$lambda$0(psiFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Collection)object;
    }

    @NotNull
    public final List<Pair<String, HCLProperty>> getAllLocals() {
        Companion.CollectLocalsVisitor visitor = new Companion.CollectLocalsVisitor(null, 1, null);
        this.process((PsiElementProcessor<HCLFile>)((PsiElementProcessor)arg_0 -> Module.getAllLocals$lambda$0(visitor, arg_0)));
        return CollectionsKt.toList((Iterable)visitor.getCollected());
    }

    @Nullable
    public final Pair<String, HCLProperty> findLocal(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Companion.CollectLocalsVisitor visitor = new Companion.CollectLocalsVisitor(name);
        this.process((PsiElementProcessor<HCLFile>)((PsiElementProcessor)arg_0 -> Module.findLocal$lambda$0(visitor, arg_0)));
        return (Pair)CollectionsKt.firstOrNull((Iterable)visitor.getCollected());
    }

    private final boolean process(PsiElementProcessor<HCLFile> processor) {
        if (this.moduleRoot instanceof HCLFile) {
            if (Intrinsics.areEqual((Object)((HCLFile)this.moduleRoot).getLanguage(), (Object)TerraformLanguage.INSTANCE)) {
                return processor.execute((PsiElement)this.moduleRoot);
            }
            return false;
        }
        boolean bl = this.moduleRoot instanceof PsiDirectory;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return this.moduleRoot.processChildren(arg_0 -> Module.process$lambda$0(processor, arg_0));
    }

    @NotNull
    public final List<HCLBlock> getDefinedResources(@Nullable String type, @Nullable String name) {
        return this.getDefinedHclBlocks("resource", 2, type, name);
    }

    public static /* synthetic */ List getDefinedResources$default(Module module, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return module.getDefinedResources(string, string2);
    }

    @Nullable
    public final HCLProperty findDefinedRequiredProvider(@NotNull String type) {
        HCLBlock hCLBlock;
        block6: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            for (HCLBlock terraformBlock : (Iterable)Module.getDefinedHclBlocks$default(this, "terraform", 0, null, null, 12, null)) {
                HCLBlock hCLBlock2;
                HCLBlock hCLBlock3;
                boolean bl = false;
                Object object = terraformBlock.getObject();
                if (object != null && (object = object.getBlockList()) != null) {
                    Object v1;
                    block5: {
                        Iterable $this$firstOrNull$iv = (Iterable)object;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            HCLBlock it = (HCLBlock)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"required_providers")) continue;
                            v1 = element$iv;
                            break block5;
                        }
                        v1 = null;
                    }
                    hCLBlock3 = v1;
                } else {
                    hCLBlock3 = null;
                }
                if ((hCLBlock2 = hCLBlock3) == null) continue;
                hCLBlock = hCLBlock2;
                break block6;
            }
            hCLBlock = null;
        }
        if (hCLBlock == null) {
            return null;
        }
        HCLBlock requiredProvidersBlock = hCLBlock;
        HCLObject hCLObject = requiredProvidersBlock.getObject();
        return hCLObject != null ? hCLObject.findProperty(type) : null;
    }

    private final List<HCLBlock> getDefinedHclBlocks(String identifier, int numberOfArguments, String firstArgument, String secondArgument) {
        List found = new ArrayList();
        this.process((PsiElementProcessor<HCLFile>)((PsiElementProcessor)arg_0 -> Module.getDefinedHclBlocks$lambda$0(identifier, numberOfArguments, found, firstArgument, secondArgument, arg_0)));
        return found;
    }

    static /* synthetic */ List getDefinedHclBlocks$default(Module module, String string, int n, String string2, String string3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        return module.getDefinedHclBlocks(string, n, string2, string3);
    }

    @NotNull
    public final List<HCLBlock> getDefinedDataSources(@Nullable String type, @Nullable String name) {
        return this.getDefinedHclBlocks("data", 2, type, name);
    }

    public static /* synthetic */ List getDefinedDataSources$default(Module module, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return module.getDefinedDataSources(string, string2);
    }

    @NotNull
    public final List<HCLBlock> getDefinedEphemeralResources(@Nullable String type, @Nullable String name) {
        return this.getDefinedHclBlocks("ephemeral", 2, type, name);
    }

    public static /* synthetic */ List getDefinedEphemeralResources$default(Module module, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return module.getDefinedEphemeralResources(string, string2);
    }

    @NotNull
    public final List<HCLBlock> findProviders(@NotNull String search) {
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        char[] cArray = new char[]{'.'};
        List split = StringsKt.split$default((CharSequence)search, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String type = (String)split.get(0);
        String alias = (String)CollectionsKt.getOrNull((List)split, (int)1);
        ArrayList found = new ArrayList();
        this.process((PsiElementProcessor<HCLFile>)((PsiElementProcessor)arg_0 -> Module.findProviders$lambda$0(alias, type, found, arg_0)));
        return found;
    }

    @NotNull
    public final List<Pair<HCLBlock, String>> getDefinedProviders() {
        ArrayList found = new ArrayList();
        this.process((PsiElementProcessor<HCLFile>)((PsiElementProcessor)arg_0 -> Module.getDefinedProviders$lambda$0(found, arg_0)));
        return found;
    }

    @NotNull
    public final List<HCLBlock> getDefinedModules(@Nullable String name) {
        return Module.getDefinedHclBlocks$default(this, "module", 1, name, null, 8, null);
    }

    public static /* synthetic */ List getDefinedModules$default(Module module, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return module.getDefinedModules(string);
    }

    @NotNull
    public final List<HCLBlock> getDefinedOutputs() {
        return Module.getDefinedHclBlocks$default(this, "output", 1, null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final HCLBlock getTerraformBlockWithProvidersOrFirst() {
        HCLBlock blockWithRequiredProviders;
        HCLBlock hCLBlock;
        Object v2;
        List terraformBlocks;
        block6: {
            terraformBlocks = Module.getDefinedHclBlocks$default(this, "terraform", 0, null, null, 12, null);
            Iterable $this$firstOrNull$iv = terraformBlocks;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block5: {
                    void $this$any$iv;
                    HCLBlock block = (HCLBlock)element$iv;
                    boolean bl2 = false;
                    Object $this$childrenOfType$iv = block;
                    boolean $i$f$childrenOfType = false;
                    List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, HCLBlock.class);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                    $this$childrenOfType$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            HCLBlock it = (HCLBlock)element$iv2;
                            boolean bl3 = false;
                            if (!TfPsiPatterns.INSTANCE.getRequiredProvidersBlock().accepts((Object)it)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v2 = element$iv;
                break block6;
            }
            v2 = null;
        }
        if ((hCLBlock = (blockWithRequiredProviders = (HCLBlock)v2)) == null) {
            hCLBlock = (HCLBlock)CollectionsKt.firstOrNull((List)terraformBlocks);
        }
        return hCLBlock;
    }

    @NotNull
    public final List<String> getTerraformRequiredVersion() {
        ArrayList found = new ArrayList();
        this.process((PsiElementProcessor<HCLFile>)((PsiElementProcessor)arg_0 -> Module.getTerraformRequiredVersion$lambda$0(found, arg_0)));
        return found;
    }

    public final boolean isHCL2Supported() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this.moduleRoot), (CachedValueProvider)new Companion.IsHCL2SupportedCachedValueProvider(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    @NotNull
    public final TfTypeModel getModel() {
        return TypeModelProvider.Companion.getGlobalModel();
    }

    public boolean equals(@Nullable Object other) {
        VirtualFile file;
        if (!(other instanceof Module)) {
            return false;
        }
        VirtualFile virtualFile = file = this.moduleRoot.getVirtualFile();
        return virtualFile != null ? Intrinsics.areEqual((Object)virtualFile, (Object)((Module)other).moduleRoot.getVirtualFile()) : Intrinsics.areEqual((Object)this.moduleRoot, (Object)((Module)other).moduleRoot);
    }

    public int hashCode() {
        VirtualFile virtualFile = this.moduleRoot.getVirtualFile();
        return (virtualFile != null ? (UserDataHolder)virtualFile : (UserDataHolder)this.moduleRoot).hashCode();
    }

    @NotNull
    public final HclType getType() {
        HashMap result2 = new HashMap();
        List<HCLBlock> outputs = this.getDefinedOutputs();
        for (HCLBlock output : outputs) {
            HCLElement hCLElement = output.getObject();
            HCLExpression value = hCLElement != null && (hCLElement = hCLElement.findProperty("value")) != null ? hCLElement.getValue() : null;
            ((Map)result2).put(output.getName(), ExtensionsKt.getType(value));
        }
        List<Variable> variables = this.getAllVariables();
        for (Variable variable : variables) {
            ((Map)result2).put(variable.getName(), variable.getCombinedType());
        }
        return HclTypeModelKt.ObjectType$default(result2, null, 2, null);
    }

    private static final boolean getAllVariables$lambda$0(Set $collected, Module this$0, PsiFile it) {
        Intrinsics.checkNotNull((Object)it);
        $collected.addAll(this$0.getAllVariablesDeclaredInFile(it));
        return true;
    }

    private static final boolean findVariable$lambda$0(Companion.CollectVariablesVisitor $visitor, HCLFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file.acceptChildren($visitor);
        return $visitor.getCollected().isEmpty();
    }

    private static final boolean findVariables$lambda$0(Set $collected, Module this$0, String $name, PsiFile it) {
        Collection collection = $collected;
        Intrinsics.checkNotNull((Object)it);
        CollectionsKt.addAll((Collection)collection, (Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this$0.getAllVariablesDeclaredInFile(it)), arg_0 -> Module.findVariables$lambda$0$0($name, arg_0)));
        return true;
    }

    private static final boolean findVariables$lambda$0$0(String $name, Variable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)$name);
    }

    private static final boolean processAllFilesWithVariables$lambda$0(Module this$0, GlobalSearchScope $terraformScope, Processor $processor) {
        if (!PsiSearchHelper.getInstance((Project)this$0.moduleRoot.getProject()).processAllFilesWithWord("variable", $terraformScope, $processor, true)) {
            return false;
        }
        Project project = this$0.moduleRoot.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        IndexingIteratorsProvider iteratorsProvider = IndexingIteratorsProvider.Companion.getInstance(project);
        return this$0.process((PsiElementProcessor<HCLFile>)((PsiElementProcessor)arg_0 -> Module.processAllFilesWithVariables$lambda$0$0(iteratorsProvider, $processor, arg_0)));
    }

    private static final boolean processAllFilesWithVariables$lambda$0$0(IndexingIteratorsProvider $iteratorsProvider, Processor $processor, HCLFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return !$iteratorsProvider.shouldBeIndexed(virtualFile) ? $processor.process((Object)file) : true;
    }

    private static final CachedValueProvider.Result getAllVariablesDeclaredInFile$lambda$0(PsiFile $psiFile) {
        Companion.CollectVariablesVisitor visitor = new Companion.CollectVariablesVisitor(null, 1, null);
        $psiFile.acceptChildren((PsiElementVisitor)visitor);
        Object[] objectArray = new Object[]{$psiFile};
        return CachedValueProvider.Result.create(visitor.getCollected(), (Object[])objectArray);
    }

    private static final boolean getAllLocals$lambda$0(Companion.CollectLocalsVisitor $visitor, HCLFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file.acceptChildren($visitor);
        return true;
    }

    private static final boolean findLocal$lambda$0(Companion.CollectLocalsVisitor $visitor, HCLFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file.acceptChildren($visitor);
        return $visitor.getCollected().isEmpty();
    }

    private static final boolean process$lambda$0(PsiElementProcessor $processor, PsiFileSystemItem element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof HCLFile) || !Intrinsics.areEqual((Object)((HCLFile)element).getLanguage(), (Object)TerraformLanguage.INSTANCE)) {
            return true;
        }
        return $processor.execute((PsiElement)element);
    }

    private static final boolean getDefinedHclBlocks$lambda$0(String $identifier, int $numberOfArguments, List $found, String $firstArgument, String $secondArgument, HCLFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file.acceptChildren(new HCLElementVisitor($identifier, $numberOfArguments, $found, $firstArgument, $secondArgument){
            final /* synthetic */ String $identifier;
            final /* synthetic */ int $numberOfArguments;
            final /* synthetic */ List<HCLBlock> $found;
            final /* synthetic */ String $firstArgument;
            final /* synthetic */ String $secondArgument;
            {
                this.$identifier = $identifier;
                this.$numberOfArguments = $numberOfArguments;
                this.$found = $found;
                this.$firstArgument = $firstArgument;
                this.$secondArgument = $secondArgument;
            }

            public void visitBlock(HCLBlock block) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                if (!Intrinsics.areEqual((Object)UtilKt.getNameElementUnquoted(block, 0), (Object)this.$identifier)) {
                    return;
                }
                if (this.$numberOfArguments == 0) {
                    this.$found.add(block);
                    return;
                }
                String string = UtilKt.getNameElementUnquoted(block, 1);
                if (string == null) {
                    return;
                }
                String first = string;
                if (this.$firstArgument != null && !Intrinsics.areEqual((Object)first, (Object)this.$firstArgument)) {
                    return;
                }
                if (this.$numberOfArguments == 1) {
                    this.$found.add(block);
                } else {
                    String string2 = UtilKt.getNameElementUnquoted(block, 2);
                    if (string2 == null) {
                        return;
                    }
                    String second = string2;
                    if (this.$secondArgument == null || Intrinsics.areEqual((Object)this.$secondArgument, (Object)second)) {
                        this.$found.add(block);
                    }
                }
            }
        });
        return true;
    }

    private static final boolean findProviders$lambda$0(String $alias, String $type, ArrayList $found, HCLFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file.acceptChildren(new HCLElementVisitor($alias, $type, $found){
            final /* synthetic */ String $alias;
            final /* synthetic */ String $type;
            final /* synthetic */ ArrayList<HCLBlock> $found;
            {
                this.$alias = $alias;
                this.$type = $type;
                this.$found = $found;
            }

            public void visitBlock(HCLBlock o) {
                String als;
                HCLExpression value;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (!Intrinsics.areEqual((Object)"provider", (Object)UtilKt.getNameElementUnquoted(o, 0))) {
                    return;
                }
                String string = UtilKt.getNameElementUnquoted(o, 1);
                if (string == null) {
                    return;
                }
                String tp = string;
                HCLElement hCLElement = o.getObject();
                HCLExpression hCLExpression = hCLElement != null && (hCLElement = hCLElement.findProperty("alias")) != null ? hCLElement.getValue() : (value = null);
                String string2 = value instanceof HCLStringLiteral ? ((HCLStringLiteral)value).getValue() : (als = value instanceof HCLIdentifier ? ((HCLIdentifier)value).getId() : null);
                if (this.$alias == null && als == null) {
                    if (Intrinsics.areEqual((Object)this.$type, (Object)tp)) {
                        this.$found.add(o);
                    }
                } else if (Intrinsics.areEqual((Object)this.$alias, (Object)als)) {
                    this.$found.add(o);
                }
            }
        });
        return true;
    }

    private static final boolean getDefinedProviders$lambda$0(ArrayList $found, HCLFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file.acceptChildren(new HCLElementVisitor($found){
            final /* synthetic */ ArrayList<Pair<HCLBlock, String>> $found;
            {
                this.$found = $found;
            }

            public void visitBlock(HCLBlock o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (!Intrinsics.areEqual((Object)"provider", (Object)UtilKt.getNameElementUnquoted(o, 0))) {
                    return;
                }
                String string = ExtensionsKt.getProviderFQName(o);
                if (string == null) {
                    return;
                }
                String fqn = string;
                this.$found.add((Pair<HCLBlock, String>)new Pair((Object)o, (Object)fqn));
            }
        });
        return true;
    }

    private static final boolean getTerraformRequiredVersion$lambda$0(ArrayList $found, HCLFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file.acceptChildren(new HCLElementVisitor($found){
            final /* synthetic */ ArrayList<String> $found;
            {
                this.$found = $found;
            }

            public void visitBlock(HCLBlock o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (!TfPsiPatterns.INSTANCE.getTerraformRootBlock().accepts((Object)o)) {
                    return;
                }
                HCLElement hCLElement = o.getObject();
                if (hCLElement == null || (hCLElement = hCLElement.findProperty(TfTypeModel.Companion.getTerraformRequiredVersion().getName())) == null || (hCLElement = hCLElement.getValue()) == null) {
                    return;
                }
                HCLElement value = hCLElement;
                if (value instanceof LiteralExpression) {
                    this.$found.add(((LiteralExpression)((Object)value)).getUnquotedText());
                }
            }
        });
        return true;
    }

    public /* synthetic */ Module(PsiFileSystemItem moduleRoot, DefaultConstructorMarker $constructor_marker) {
        this(moduleRoot);
    }

    static {
        Logger logger = Logger.getInstance(Module.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/intellij/terraform/config/model/Module$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getModule", "Lorg/intellij/terraform/config/model/Module;", "file", "Lcom/intellij/psi/PsiFile;", "directory", "Lcom/intellij/psi/PsiDirectory;", "getAsModuleBlock", "moduleBlock", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "CollectVariablesVisitor", "CollectLocalsVisitor", "IsHCL2SupportedCachedValueProvider", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Module.kt\norg/intellij/terraform/config/model/Module$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,453:1\n1#2:454\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Module getModule(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PsiDirectory directory = file.getContainingDirectory();
            if (directory == null) {
                return new Module((PsiFileSystemItem)((HCLFile)file), null);
            }
            return this.getModule(directory);
        }

        @NotNull
        public final Module getModule(@NotNull PsiDirectory directory) {
            PsiDirectory psiDirectory;
            PsiDirectory dir;
            VirtualFile moduleRoot;
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            if (ModuleKt.isFallbackVariableSearchEnabled()) {
                return new Module((PsiFileSystemItem)directory, null);
            }
            VirtualFile virtualFile = moduleRoot = ModuleDetectionUtil.INSTANCE.findModuleRoot$intellij_terraform((PsiFileSystemItem)directory);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                v1 = directory.getManager().findDirectory(it);
            } else {
                v1 = dir = null;
            }
            if (dir == null) {
                Logger logger = LOG;
                String string = "No module root for " + directory;
                Attachment[] attachmentArray = new Attachment[1];
                VirtualFile[] virtualFileArray = directory.getVirtualFile().getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                attachmentArray[0] = new Attachment("files.txt", ArraysKt.joinToString$default((Object[])virtualFileArray, (CharSequence)"\n", null, null, (int)0, null, Companion::getModule$lambda$1, (int)30, null));
                logger.error(string, attachmentArray);
            }
            if ((psiDirectory = dir) == null) {
                psiDirectory = directory;
            }
            return new Module((PsiFileSystemItem)psiDirectory, null);
        }

        @Nullable
        public final Module getAsModuleBlock(@NotNull HCLBlock moduleBlock) {
            Intrinsics.checkNotNullParameter((Object)moduleBlock, (String)"moduleBlock");
            return ModuleDetectionUtil.INSTANCE.getAsModuleBlock(moduleBlock);
        }

        private static final CharSequence getModule$lambda$1(VirtualFile it) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/intellij/terraform/config/model/Module$Companion$CollectLocalsVisitor;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "collected", "", "Lkotlin/Pair;", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "getCollected", "()Ljava/util/Set;", "visitBlock", "", "o", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
        @SourceDebugExtension(value={"SMAP\nModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Module.kt\norg/intellij/terraform/config/model/Module$Companion$CollectLocalsVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,453:1\n1634#2,3:454\n*S KotlinDebug\n*F\n+ 1 Module.kt\norg/intellij/terraform/config/model/Module$Companion$CollectLocalsVisitor\n*L\n99#1:454,3\n*E\n"})
        private static final class CollectLocalsVisitor
        extends HCLElementVisitor {
            @Nullable
            private final String name;
            @NotNull
            private final Set<Pair<String, HCLProperty>> collected;

            public CollectLocalsVisitor(@Nullable String name) {
                this.name = name;
                this.collected = new HashSet();
            }

            public /* synthetic */ CollectLocalsVisitor(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                this(string);
            }

            @Nullable
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final Set<Pair<String, HCLProperty>> getCollected() {
                return this.collected;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitBlock(@NotNull HCLBlock o) {
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (!TfPsiPatterns.INSTANCE.getLocalsRootBlock().accepts((Object)o)) {
                    return;
                }
                HCLObject hCLObject = o.getObject();
                if (hCLObject == null) {
                    return;
                }
                HCLObject obj = hCLObject;
                if (this.name != null) {
                    HCLProperty hCLProperty = obj.findProperty(this.name);
                    if (hCLProperty == null) {
                        return;
                    }
                    HCLProperty prop = hCLProperty;
                    this.collected.add((Pair<String, HCLProperty>)TuplesKt.to((Object)prop.getName(), (Object)prop));
                    return;
                }
                List<HCLProperty> list = obj.getPropertyList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
                Iterable prop = list;
                Collection destination$iv = this.collected;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    HCLProperty hCLProperty = (HCLProperty)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to((Object)it.getName(), (Object)it));
                }
            }

            public CollectLocalsVisitor() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/intellij/terraform/config/model/Module$Companion$CollectVariablesVisitor;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "collected", "", "Lorg/intellij/terraform/config/model/Variable;", "getCollected", "()Ljava/util/Set;", "visitBlock", "", "o", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
        private static final class CollectVariablesVisitor
        extends HCLElementVisitor {
            @Nullable
            private final String name;
            @NotNull
            private final Set<Variable> collected;

            public CollectVariablesVisitor(@Nullable String name) {
                this.name = name;
                Set set = ConcurrentCollectionFactory.createConcurrentSet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
                this.collected = set;
            }

            public /* synthetic */ CollectVariablesVisitor(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                this(string);
            }

            @Nullable
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final Set<Variable> getCollected() {
                return this.collected;
            }

            @Override
            public void visitBlock(@NotNull HCLBlock o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (!TfPsiPatterns.INSTANCE.getVariableRootBlock().accepts((Object)o)) {
                    return;
                }
                if (o.getObject() == null) {
                    return;
                }
                if (this.name != null && !Intrinsics.areEqual((Object)this.name, (Object)UtilKt.getNameElementUnquoted(o, 1))) {
                    return;
                }
                this.collected.add(new Variable(o));
            }

            public CollectVariablesVisitor() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/intellij/terraform/config/model/Module$Companion$IsHCL2SupportedCachedValueProvider;", "Lcom/intellij/psi/util/CachedValueProvider;", "", "module", "Lorg/intellij/terraform/config/model/Module;", "<init>", "(Lorg/intellij/terraform/config/model/Module;)V", "getModule", "()Lorg/intellij/terraform/config/model/Module;", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "intellij.terraform"})
        @SourceDebugExtension(value={"SMAP\nModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Module.kt\norg/intellij/terraform/config/model/Module$Companion$IsHCL2SupportedCachedValueProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,453:1\n1617#2,9:454\n1869#2:463\n1870#2:465\n1626#2:466\n1803#2,3:467\n1#3:464\n*S KotlinDebug\n*F\n+ 1 Module.kt\norg/intellij/terraform/config/model/Module$Companion$IsHCL2SupportedCachedValueProvider\n*L\n107#1:454,9\n107#1:463\n107#1:465\n107#1:466\n109#1:467,3\n107#1:464\n*E\n"})
        private static final class IsHCL2SupportedCachedValueProvider
        implements CachedValueProvider<Boolean> {
            @NotNull
            private final Module module;

            public IsHCL2SupportedCachedValueProvider(@NotNull Module module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                this.module = module;
            }

            @NotNull
            public final Module getModule() {
                return this.module;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public CachedValueProvider.Result<Boolean> compute() {
                List<String> tfVersions = this.module.getTerraformRequiredVersion();
                if (!((Collection)tfVersions).isEmpty()) {
                    void $this$fold$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = tfVersions;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        VersionConstraint it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String it = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (ModuleDetectionUtil.INSTANCE.getVersionConstraint(it, false) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    VersionConstraint initial$iv = VersionConstraint.Companion.parse(">=0.12");
                    boolean $i$f$fold = false;
                    VersionConstraint accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv) {
                        void b;
                        VersionConstraint $i$f$forEach2 = (VersionConstraint)element$iv;
                        VersionConstraint a = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = VersionConstraint.Companion.intersect(a, (VersionConstraint)b);
                    }
                    VersionConstraint constraint = accumulator$iv;
                    if (constraint.isEmpty()) {
                        Object[] objectArray = new Object[]{this.module.getModuleRoot()};
                        return new CachedValueProvider.Result((Object)false, objectArray);
                    }
                }
                Object[] objectArray = new Object[]{this.module.getModuleRoot()};
                return new CachedValueProvider.Result((Object)true, objectArray);
            }
        }
    }
}

