/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Striped;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.TerraformFileType;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.ModuleDetectionUtilKt;
import org.intellij.terraform.config.model.RegistryModuleUtil;
import org.intellij.terraform.config.model.version.MalformedConstraintException;
import org.intellij.terraform.config.model.version.Version;
import org.intellij.terraform.config.model.version.VersionConstraint;
import org.intellij.terraform.config.util.TfExecutorUtilKt;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hil.psi.HCLElementLazyReference;
import org.intellij.terraform.hil.psi.ILPsiFile;
import org.intellij.terraform.hil.psi.ILRecursiveVisitor;
import org.intellij.terraform.hil.psi.ILVariable;
import org.intellij.terraform.install.TfToolType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006[\\]^_`B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u001b2\u0006\u0010\t\u001a\u00020\nH\u0002J1\u0010\u001c\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u0016\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010#2\b\u0010%\u001a\u0004\u0018\u00010#JG\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00102\b\u0010*\u001a\u0004\u0018\u00010\u00102\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010,\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010-J \u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020/03H\u0002J\u001c\u00104\u001a\u0004\u0018\u0001012\b\u00100\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u00105\u001a\u00020\u000eJ\u0010\u00106\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0010H\u0002J\u0018\u0010=\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010>\u001a\u00020#H\u0002J\u001f\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0,2\b\u0010@\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010AJ\u001d\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020C0,2\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010DJ\u001a\u0010E\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010F\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J$\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00102\n\b\u0002\u0010L\u001a\u0004\u0018\u00010MH\u0002J\u001a\u0010N\u001a\u0004\u0018\u00010\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0010H\u0002J@\u0010O\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100P2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010Q\u001a\u00020\u00132\u0006\u0010R\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0010H\u0002J\u001a\u0010S\u001a\u0004\u0018\u00010\u00152\b\u0010T\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u0017\u0010U\u001a\u0004\u0018\u00010\u00152\u0006\u0010V\u001a\u00020WH\u0000\u00a2\u0006\u0002\bXJ\u001d\u0010Y\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010ZR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020\u000e08X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u00109\u001a\r\u0012\t\u0012\u00070;\u00a2\u0006\u0002\b<0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lorg/intellij/terraform/config/model/ModuleDetectionUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getAsModuleBlock", "Lorg/intellij/terraform/config/model/Module;", "moduleBlock", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "getAsModuleBlockOrError", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$Result;", "sourceMatch", "", "modulesJsonSource", "", "moduleReference", "getManifestForDirectory", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModulesManifest;", "dotTerraform", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Lcom/intellij/openapi/util/UserDataHolder;", "project", "Lcom/intellij/openapi/project/Project;", "doGetAsModuleBlock", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "getModuleSourceString", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/psi/PsiFile;", "sourceVal", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "elementsPath", "", "Lcom/intellij/psi/PsiElement;", "getHilReferenceValue", "injectedHil", "directoryResult", "directory", "Lcom/intellij/psi/PsiDirectory;", "source", "err", "dependencies", "", "(Lcom/intellij/psi/PsiDirectory;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lcom/intellij/psi/util/CachedValueProvider$Result;", "newestModuleManifest", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModuleManifest;", "constraint", "Lorg/intellij/terraform/config/model/version/VersionConstraint;", "modules", "", "getVersionConstraint", "report", "isRelativeSource", "IsRegistrySourceKey", "Lcom/intellij/openapi/util/Key;", "IsRegistrySourceLock", "Lcom/google/common/util/concurrent/Striped;", "Ljava/util/concurrent/locks/Lock;", "Lkotlin/jvm/internal/EnhancedNullability;", "isRegistrySource", "element", "getModuleFiles", "module", "(Lorg/intellij/terraform/config/model/Module;)[Lcom/intellij/psi/PsiElement;", "getVFSChainOrVFS", "Lcom/intellij/openapi/util/ModificationTracker;", "(Lcom/intellij/psi/PsiDirectory;)[Lcom/intellij/openapi/util/ModificationTracker;", "getTerraformModulesManifestFile", "parseManifest", "logErrorAndFailInInternalMode", "", "application", "Lcom/intellij/openapi/application/Application;", "msg", "e", "", "findRelativeModule", "getKeyPrefix", "Lkotlin/Pair;", "manifest", "name", "getTerraformDirSomewhere", "virtualFile", "findModuleRoot", "context", "Lcom/intellij/psi/PsiFileSystemItem;", "findModuleRoot$intellij_terraform", "getRoots", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/openapi/vfs/VirtualFile;", "ModulesManifest", "ModuleManifest", "ModuleCachedValueProvider", "Result", "ModuleUri", "ManifestCachedValueProvider", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nModuleDetectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDetectionUtil.kt\norg/intellij/terraform/config/model/ModuleDetectionUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,569:1\n774#2:570\n865#2,2:571\n295#2,2:575\n808#2,11:584\n1563#2:595\n1634#2,3:596\n12970#3,2:573\n1400#3,2:577\n12970#3,2:582\n1#4:579\n37#5,2:580\n183#6:599\n1255#6,2:600\n184#6:602\n*S KotlinDebug\n*F\n+ 1 ModuleDetectionUtil.kt\norg/intellij/terraform/config/model/ModuleDetectionUtil\n*L\n221#1:570\n221#1:571,2\n286#1:575,2\n441#1:584,11\n441#1:595\n441#1:596,3\n258#1:573,2\n296#1:577,2\n404#1:582,2\n399#1:580,2\n536#1:599\n539#1:600,2\n536#1:602\n*E\n"})
public final class ModuleDetectionUtil {
    @NotNull
    public static final ModuleDetectionUtil INSTANCE = new ModuleDetectionUtil();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<Boolean> IsRegistrySourceKey;
    @NotNull
    private static final Striped<Lock> IsRegistrySourceLock;

    private ModuleDetectionUtil() {
    }

    @Nullable
    public final Module getAsModuleBlock(@NotNull HCLBlock moduleBlock) {
        Intrinsics.checkNotNullParameter((Object)moduleBlock, (String)"moduleBlock");
        Result result2 = (Result)CachedValuesManager.getCachedValue((PsiElement)moduleBlock, (CachedValueProvider)new ModuleCachedValueProvider(moduleBlock));
        return result2 != null ? (Module)result2.getValue() : null;
    }

    @NotNull
    public final Result<Module> getAsModuleBlockOrError(@NotNull HCLBlock moduleBlock) {
        Intrinsics.checkNotNullParameter((Object)moduleBlock, (String)"moduleBlock");
        Object object = CachedValuesManager.getCachedValue((PsiElement)moduleBlock, (CachedValueProvider)new ModuleCachedValueProvider(moduleBlock));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Result)object;
    }

    public final boolean sourceMatch(@NotNull String modulesJsonSource, @NotNull String moduleReference) {
        Intrinsics.checkNotNullParameter((Object)modulesJsonSource, (String)"modulesJsonSource");
        Intrinsics.checkNotNullParameter((Object)moduleReference, (String)"moduleReference");
        if (Intrinsics.areEqual((Object)modulesJsonSource, (Object)moduleReference) || StringsKt.endsWith$default((String)StringsKt.removePrefix((String)modulesJsonSource, (CharSequence)"/"), (String)StringsKt.removePrefix((String)moduleReference, (CharSequence)"/"), (boolean)false, (int)2, null)) {
            return true;
        }
        ModuleUri moduleUri = ModuleUri.Companion.fromModulesJsonSource(modulesJsonSource);
        if (moduleUri == null) {
            return false;
        }
        ModuleUri modUri = moduleUri;
        ModuleUri moduleUri2 = ModuleUri.Companion.fromReference(moduleReference);
        if (moduleUri2 == null) {
            return false;
        }
        ModuleUri refUri = moduleUri2;
        return modUri.couldBeReferencedBy(refUri);
    }

    @NotNull
    public final Result<ModulesManifest> getManifestForDirectory(@NotNull VirtualFile dotTerraform, @NotNull UserDataHolder file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)dotTerraform, (String)"dotTerraform");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = dotTerraform.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
        TfToolType toolType = TfExecutorUtilKt.getApplicableToolType(virtualFile);
        LOG.debug("Found .terraform directory: " + dotTerraform);
        VirtualFile virtualFile2 = this.getTerraformModulesManifestFile(project, dotTerraform);
        if (virtualFile2 == null) {
            Object[] objectArray = new Object[]{toolType.getExecutableName()};
            String string = HCLBundle.message("module.detection.error.no.modules.json.found", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new Result.Failure(string);
        }
        VirtualFile manifestFile = virtualFile2;
        LOG.debug("Found manifest.json: " + manifestFile);
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project);
        String string = manifestFile.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        ModulesManifest modulesManifest = (ModulesManifest)cachedValuesManager.getCachedValue(file, (CachedValueProvider)new ManifestCachedValueProvider(string));
        if (modulesManifest == null) {
            Object[] objectArray = new Object[]{toolType.getExecutableName()};
            String string2 = HCLBundle.message("module.detection.error.failed.parse.modules.json", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return new Result.Failure(string2);
        }
        ModulesManifest manifest = modulesManifest;
        return new Result.Success<ModulesManifest>(manifest);
    }

    /*
     * WARNING - void declaration
     */
    private final CachedValueProvider.Result<Result<Module>> doGetAsModuleBlock(HCLBlock moduleBlock) {
        PsiDirectory dir;
        Object err;
        Object[] pair;
        Object[] $this$filterTo$iv$iv;
        String string = org.intellij.terraform.hcl.psi.UtilKt.getNameElementUnquoted(moduleBlock, 1);
        if (string == null) {
            String string2 = HCLBundle.message("module.detection.error.name.not.defined", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            Object[] objectArray = new Object[]{moduleBlock};
            return new CachedValueProvider.Result(new Result.Failure(string2), objectArray);
        }
        String name = string;
        HCLElement hCLElement = moduleBlock.getObject();
        if (hCLElement == null || (hCLElement = hCLElement.findProperty("source")) == null || (hCLElement = hCLElement.getValue()) == null) {
            String string3 = HCLBundle.message("module.detection.error.no.source.property", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            Object[] objectArray = new Object[]{moduleBlock};
            return new CachedValueProvider.Result(new Result.Failure(string3), objectArray);
        }
        HCLElement sourceVal = hCLElement;
        PsiFile psiFile = moduleBlock.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile file = psiFile;
        PsiDirectory psiDirectory = file.getContainingDirectory();
        if (psiDirectory == null) {
            Object[] objectArray = new Object[]{file.getName()};
            String string4 = HCLBundle.message("module.detection.error.no.containing.directory", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            Object[] objectArray2 = new Object[]{moduleBlock, file};
            return new CachedValueProvider.Result(new Result.Failure(string4), objectArray2);
        }
        PsiDirectory directory = psiDirectory;
        VirtualFile virtualFile = directory.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        TfToolType toolType = TfExecutorUtilKt.getApplicableToolType(virtualFile);
        String string5 = ModuleDetectionUtil.getModuleSourceString$default(this, file, sourceVal, null, 4, null);
        if (string5 == null) {
            String string6 = HCLBundle.message("module.detection.error.no.module.source", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
            Object[] objectArray = new Object[]{moduleBlock};
            return new CachedValueProvider.Result(new Result.Failure(string6), objectArray);
        }
        String source = string5;
        Project project = moduleBlock.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile dotTerraform = this.getTerraformDirSomewhere(directory.getVirtualFile(), project2);
        if (dotTerraform == null) {
            Object[] objectArray = new Object[]{toolType.getExecutableName(), directory.getVirtualFile().getName()};
            String string7 = HCLBundle.message("module.detection.error.no.dir.found", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
            String err2 = string7;
            LOG.warn(err2);
            Object[] objectArray3 = new Object[]{moduleBlock};
            return this.directoryResult(directory, source, err2, objectArray3);
        }
        Result<ModulesManifest> manifestResult = this.getManifestForDirectory(dotTerraform, (UserDataHolder)file, project2);
        if (!(manifestResult instanceof Result.Success)) {
            if (manifestResult instanceof Result.Failure) {
                LOG.warn(((Result.Failure)manifestResult).getFailureString());
                Object[] objectArray = new Object[]{moduleBlock};
                return this.directoryResult(directory, source, ((Result.Failure)manifestResult).getFailureString(), objectArray);
            }
            throw new NoWhenBranchMatchedException();
        }
        ModulesManifest manifest = (ModulesManifest)((Result.Success)manifestResult).getValue();
        LOG.debug("All modules from modules.json: " + manifest.getModules());
        ModuleManifest module = null;
        if (this.isRegistrySource(source, sourceVal)) {
            void $this$filter$iv;
            HCLElement hCLElement2 = moduleBlock.getObject();
            Object object = hCLElement2 != null && (hCLElement2 = hCLElement2.findProperty("version")) != null ? hCLElement2.getValue() : null;
            HCLStringLiteral hCLStringLiteral = object instanceof HCLStringLiteral ? (HCLStringLiteral)object : null;
            String version = hCLStringLiteral != null ? hCLStringLiteral.getValue() : null;
            VersionConstraint versionConstraint = ModuleDetectionUtil.getVersionConstraint$default(this, version, false, 2, null);
            if (versionConstraint == null) {
                versionConstraint = VersionConstraint.Companion.getAnyVersion();
            }
            VersionConstraint constraint = versionConstraint;
            object = manifest.getModules();
            VersionConstraint versionConstraint2 = constraint;
            ModuleDetectionUtil moduleDetectionUtil = this;
            boolean $i$f$filter = false;
            void var16_32 = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                ModuleManifest it = (ModuleManifest)t;
                boolean bl = false;
                if (!INSTANCE.sourceMatch(it.getSource(), source)) continue;
                destination$iv$iv.add(t);
            }
            List list = (List)destination$iv$iv;
            module = moduleDetectionUtil.newestModuleManifest(versionConstraint2, list);
        } else {
            Object v17;
            block22: {
                pair = this.getKeyPrefix(directory, dotTerraform, manifest, name, source);
                String string8 = (String)pair.getFirst();
                if (string8 == null) {
                    String string9 = (String)pair.getSecond();
                    if (string9 == null) {
                        string9 = "Can't determine key prefix";
                    }
                    Object[] $i$f$filter = new Object[]{moduleBlock, dotTerraform, manifest.getContext()};
                    return this.directoryResult(directory, source, string9, $i$f$filter);
                }
                String keyPrefix = string8;
                LOG.debug("Searching for module with source '" + source + "' and keyPrefix '" + keyPrefix + "'");
                Iterable $i$f$filter = manifest.getModules();
                for (Object destination$iv$iv : $i$f$filter) {
                    ModuleManifest it = (ModuleManifest)destination$iv$iv;
                    boolean bl = false;
                    if (!(INSTANCE.sourceMatch(it.getSource(), source) && StringsKt.startsWith$default((String)it.getKey(), (String)keyPrefix, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)StringsKt.removePrefix((String)it.getKey(), (CharSequence)keyPrefix), (char)'|', (boolean)false, (int)2, null))) continue;
                    v17 = destination$iv$iv;
                    break block22;
                }
                v17 = null;
            }
            module = v17;
        }
        if (module == null) {
            pair = new Object[]{moduleBlock};
            return this.directoryResult(directory, source, null, pair);
        }
        LOG.debug("Found module " + module);
        String string10 = FileUtil.toSystemIndependentName((String)module.getFull());
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toSystemIndependentName(...)");
        String path = string10;
        VirtualFile relative = null;
        relative = manifest.getContext().findFileByRelativePath(path);
        if (relative == null) {
            $this$filterTo$iv$iv = new Object[]{path, manifest.getContext()};
            String string11 = HCLBundle.message("module.detection.error.no.relative.dir.in.manifest", $this$filterTo$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"message(...)");
            err = string11;
            LOG.debug((String)err);
            Object[] $i$f$filter = new Object[]{moduleBlock};
            return this.directoryResult(directory, source, (String)err, $i$f$filter);
        }
        LOG.debug("Absolute module dir: " + relative);
        if (this.isRelativeSource(source) && (err = this.findRelativeModule(directory, source)) != null) {
            Module it = err;
            boolean bl = false;
            LOG.debug("Shortcutting to relative module");
            Object[] objectArray = new Object[]{moduleBlock, directory, dotTerraform, manifest.getContext(), relative, INSTANCE.getModuleFiles(it)};
            return new CachedValueProvider.Result(new Result.Success<Module>(it), objectArray);
        }
        VirtualFile canonical = relative.getCanonicalFile();
        if (canonical != null && !Intrinsics.areEqual((Object)canonical, (Object)relative)) {
            boolean bl;
            block23: {
                VirtualFile[] $this$any$iv = this.getRoots(project2);
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile element$iv;
                    VirtualFile virtualFile2 = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)canonical, (boolean)true)) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
            if (bl) {
                LOG.debug("Replacing module relative path ('" + relative.getName() + "') with canonical: '" + canonical + "'");
                relative = canonical;
            }
        }
        if ((dir = PsiManager.getInstance((Project)project2).findDirectory(relative)) == null) {
            Object[] objectArray = new Object[]{relative};
            String string12 = HCLBundle.message("module.detection.error.no.psi.dir", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"message(...)");
            String err3 = string12;
            LOG.debug(err3);
            Object[] objectArray4 = new Object[]{moduleBlock};
            return this.directoryResult(directory, source, err3, objectArray4);
        }
        LOG.debug("Module search succeed, directory is " + dir);
        Module mod = Module.Companion.getModule(dir);
        if (!Intrinsics.areEqual((Object)mod.getModuleRoot(), (Object)dir)) {
            ItemPresentation itemPresentation = dir.getPresentation();
            LOG.warn("Module not found for directory " + (itemPresentation != null ? itemPresentation.getLocationString() : null) + ", for source " + source + " but found " + mod.getModuleRoot() + " instead");
        }
        Object[] objectArray = new Object[]{moduleBlock, directory, dotTerraform, manifest.getContext(), relative, this.getModuleFiles(mod)};
        return new CachedValueProvider.Result(new Result.Success<Module>(mod), objectArray);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final String getModuleSourceString(PsiFile file, HCLElement sourceVal, List<PsiElement> elementsPath) {
        block14: {
            block13: {
                block11: {
                    if (sourceVal == null) {
                        return null;
                    }
                    if (elementsPath.contains(sourceVal)) {
                        return null;
                    }
                    if (!UtilKt.isOpenTofuFile(file)) break block13;
                    var5_4 = InjectedLanguageManager.getInstance((Project)sourceVal.getProject()).getInjectedPsiFiles((PsiElement)sourceVal);
                    if (var5_4 == null) ** GOTO lbl-1000
                    var7_5 = var5_4;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (Pair)element$iv;
                        $i$a$-firstOrNull-ModuleDetectionUtil$getModuleSourceString$injectedHil$1 = false;
                        if (!(it.first instanceof ILPsiFile)) continue;
                        v0 = element$iv;
                        break block11;
                    }
                    v0 = null;
                }
                var6_16 = v0;
                if (var6_16 != null) {
                    v1 = (PsiElement)var6_16.first;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = null;
                }
                break block14;
            }
            v1 = injectedHil = null;
        }
        if (sourceVal instanceof HCLStringLiteral && injectedHil == null) {
            return ((HCLStringLiteral)sourceVal).getValue();
        }
        if (injectedHil != null) {
            v2 /* !! */  = this.getHilReferenceValue(injectedHil);
        } else {
            block12: {
                $this$firstOrNull$iv = HCLPsiUtil.INSTANCE.getReferencesSelectAware(sourceVal);
                $i$f$firstOrNull = false;
                var10_12 = $this$firstOrNull$iv.length;
                for (var9_9 = 0; var9_9 < var10_12; ++var9_9) {
                    it = element$iv = $this$firstOrNull$iv[var9_9];
                    $i$a$-firstOrNull-ModuleDetectionUtil$getModuleSourceString$sourcePsi$1 = false;
                    if (!(it instanceof HCLElementLazyReference)) continue;
                    v3 = element$iv;
                    break block12;
                }
                v3 = null;
            }
            v2 /* !! */  = v3 != null ? v3.resolve() : null;
        }
        sourcePsi = v2 /* !! */ ;
        elementsPath.add(sourceVal);
        var7_5 = sourcePsi;
        v4 = sourceString = var7_5 instanceof HCLProperty != false ? this.getModuleSourceString(file, ((HCLProperty)sourcePsi).getValue(), elementsPath) : (var7_5 instanceof HCLElement != false ? this.getModuleSourceString(file, (HCLElement)sourcePsi, elementsPath) : null);
        if (v4 != null) {
            it = v4;
            $i$a$-let-ModuleDetectionUtil$getModuleSourceString$1 = false;
            v5 = StringUtil.unquoteString((String)sourceString);
        } else {
            v5 = null;
        }
        return v5;
    }

    static /* synthetic */ String getModuleSourceString$default(ModuleDetectionUtil moduleDetectionUtil, PsiFile psiFile, HCLElement hCLElement, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = new ArrayList();
        }
        return moduleDetectionUtil.getModuleSourceString(psiFile, hCLElement, list);
    }

    @Nullable
    public final PsiElement getHilReferenceValue(@Nullable PsiElement injectedHil) {
        Ref.ObjectRef result2;
        block0: {
            result2 = new Ref.ObjectRef();
            PsiElement psiElement = injectedHil;
            if (psiElement == null) break block0;
            psiElement.accept((PsiElementVisitor)new ILRecursiveVisitor((Ref.ObjectRef<PsiElement>)result2){
                final /* synthetic */ Ref.ObjectRef<PsiElement> $result;
                {
                    this.$result = $result;
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitILVariable(ILVariable o) {
                    Object v1;
                    Ref.ObjectRef<PsiElement> objectRef;
                    block2: {
                        void $this$firstOrNull$iv;
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        PsiReference[] psiReferenceArray = o.getReferences();
                        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                        Object[] objectArray = psiReferenceArray;
                        objectRef = this.$result;
                        boolean $i$f$firstOrNull = false;
                        for (void element$iv : $this$firstOrNull$iv) {
                            PsiReference it = (PsiReference)element$iv;
                            boolean bl = false;
                            if (!(it instanceof HCLElementLazyReference)) continue;
                            v1 = element$iv;
                            break block2;
                        }
                        v1 = null;
                    }
                    PsiReference psiReference = v1;
                    PsiElement psiElement = psiReference != null ? psiReference.resolve() : null;
                    HCLProperty hCLProperty = psiElement instanceof HCLProperty ? (HCLProperty)psiElement : null;
                    Object object = objectRef.element = hCLProperty != null ? hCLProperty.getValue() : null;
                    if (this.$result.element == null) {
                        super.visitILVariable(o);
                    }
                }
            });
        }
        return (PsiElement)result2.element;
    }

    private final CachedValueProvider.Result<Result<Module>> directoryResult(PsiDirectory directory, String source, String err, Object ... dependencies) {
        Result result2;
        Module module = this.findRelativeModule(directory, source);
        if (module != null) {
            Module it = module;
            boolean bl = false;
            result2 = new Result.Success<Module>(it);
        } else {
            String string = err;
            if (string == null) {
                Object[] objectArray = new Object[]{directory.getName()};
                String string2 = HCLBundle.message("module.detection.error.no.module.dir.found", objectArray);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            result2 = new Result.Failure(string);
        }
        Result relativeModule = result2;
        module = new SpreadBuilder(4);
        module.addSpread(dependencies);
        module.add(directory);
        module.addSpread(this.getVFSChainOrVFS(directory));
        module.addSpread(this.getModuleFiles((Module)relativeModule.getValue()));
        return new CachedValueProvider.Result((Object)relativeModule, module.toArray(new Object[module.size()]));
    }

    private final ModuleManifest newestModuleManifest(VersionConstraint constraint, List<ModuleManifest> modules) {
        if (modules.isEmpty()) {
            return null;
        }
        if (modules.size() == 1) {
            ModuleManifest candidate = (ModuleManifest)CollectionsKt.first(modules);
            Version version = Version.Companion.parseOrNull(candidate.getVersion());
            if (version == null) {
                return null;
            }
            Version version2 = version;
            if (constraint.check(version2)) {
                return candidate;
            }
            return null;
        }
        TreeMap versions = new TreeMap();
        for (ModuleManifest module : modules) {
            Version version = Version.Companion.parseOrNull(module.getVersion());
            if (version == null) continue;
            ((Map)versions).put(version, module);
        }
        Set set = versions.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable iterable = set;
        Object var7_9 = null;
        for (Object t : iterable) {
            Map.Entry it = (Map.Entry)t;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            if (!constraint.check((Version)k)) continue;
            var7_9 = t;
        }
        Map.Entry entry = var7_9;
        return entry != null ? (ModuleManifest)entry.getValue() : null;
    }

    @Nullable
    public final VersionConstraint getVersionConstraint(@Nullable String constraint, boolean report) {
        CharSequence charSequence = constraint;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return VersionConstraint.Companion.getAnyVersion();
        }
        try {
            return VersionConstraint.Companion.parse(StringsKt.replace$default((String)constraint, (String)"IntellijIdeaRulezzz", (String)"0", (boolean)false, (int)4, null));
        }
        catch (MalformedConstraintException e) {
            if (StringsKt.contains$default((CharSequence)constraint, (CharSequence)"IntellijIdeaRulezzz", (boolean)false, (int)2, null)) {
                return null;
            }
            if (report) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                this.logErrorAndFailInInternalMode(application, "Cannot parse version constraint '" + constraint + "'", e);
            }
            return null;
        }
    }

    public static /* synthetic */ VersionConstraint getVersionConstraint$default(ModuleDetectionUtil moduleDetectionUtil, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return moduleDetectionUtil.getVersionConstraint(string, bl);
    }

    private final boolean isRelativeSource(String source) {
        if (StringsKt.startsWith$default((String)source, (String)"./", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.startsWith$default((String)source, (String)"../", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.startsWith$default((String)source, (String)".\\", (boolean)false, (int)2, null)) {
            return true;
        }
        return StringsKt.startsWith$default((String)source, (String)"..\\", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isRegistrySource(String source, PsiElement element) {
        Object result2 = null;
        result2 = element.getUserData(IsRegistrySourceKey);
        if (result2 != null) {
            return (Boolean)result2;
        }
        Object object = IsRegistrySourceLock.get((Object)source);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Boolean bl2 = (Boolean)element.getUserData(IsRegistrySourceKey);
            if (bl2 == null) {
                bl2 = RegistryModuleUtil.INSTANCE.parseRegistryModule(source) != null;
            }
            result2 = bl2;
            element.putUserData(IsRegistrySourceKey, result2);
            Unit unit = Unit.INSTANCE;
        }
        Object object3 = result2;
        Intrinsics.checkNotNull((Object)object3);
        return (Boolean)object3;
    }

    private final PsiElement[] getModuleFiles(Module module) {
        PsiElement[] psiElementArray;
        if (module == null) {
            return new PsiElement[0];
        }
        PsiFileSystemItem item = module.getModuleRoot();
        if (item instanceof PsiDirectory) {
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)item);
            spreadBuilder.addSpread((Object)((PsiDirectory)item).getFiles());
            psiElementArray = (PsiElement[])spreadBuilder.toArray((Object[])new PsiFileSystemItem[spreadBuilder.size()]);
        } else {
            PsiFileSystemItem[] psiFileSystemItemArray = new PsiFileSystemItem[]{item};
            psiElementArray = (PsiElement[])psiFileSystemItemArray;
        }
        return psiElementArray;
    }

    private final ModificationTracker[] getVFSChainOrVFS(PsiDirectory directory) {
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.ifEmpty(ModuleDetectionUtilKt.getVFSParents((PsiFileSystemItem)directory), ModuleDetectionUtil::getVFSChainOrVFS$lambda$0));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ModificationTracker[0]);
    }

    private final VirtualFile getTerraformModulesManifestFile(Project project, VirtualFile dotTerraform) {
        boolean bl;
        block4: {
            VirtualFile[] $this$any$iv = this.getRoots(project);
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!VfsUtilCore.isAncestor((VirtualFile)it, (VirtualFile)dotTerraform, (boolean)false)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (!bl) {
            LOG.warn("Dir " + dotTerraform + " is not under project root nor any module content roots");
            return null;
        }
        if (!dotTerraform.isValid() || !dotTerraform.exists()) {
            return null;
        }
        VirtualFile file = dotTerraform.findFileByRelativePath("modules/modules.json");
        if (file == null || !file.exists() || file.isDirectory() || !file.isValid()) {
            return null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ModulesManifest parseManifest(VirtualFile file) {
        LOG.debug("Parsing manifest file " + file);
        InputStream inputStream = file.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream stream = inputStream;
        VirtualFile virtualFile = file.getParent().getParent().getParent();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile context = virtualFile;
        Application application = ApplicationManager.getApplication();
        try {
            List list;
            Object it;
            Closeable closeable = stream;
            Throwable throwable = null;
            try {
                it = (InputStream)closeable;
                boolean bl = false;
                it = (ObjectNode)new ObjectMapper().readTree((InputStream)it);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            InputStream json = it;
            if (json == null) {
                Intrinsics.checkNotNull((Object)application);
                ModuleDetectionUtil.logErrorAndFailInInternalMode$default(this, application, "In file '" + file + "' no JSON found", null, 4, null);
                return null;
            }
            VirtualFile virtualFile2 = context;
            ArrayNode arrayNode = ExtensionsKt.array((ObjectNode)json, "Modules");
            if (arrayNode != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstance$iv;
                it = (Iterable)arrayNode;
                VirtualFile virtualFile3 = virtualFile2;
                boolean $i$f$filterIsInstance22 = false;
                void var10_15 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ObjectNode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string;
                    String string2;
                    String string3;
                    String string4;
                    void it2;
                    ObjectNode objectNode = (ObjectNode)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    String string5 = ExtensionsKt.string((ObjectNode)it2, "Source");
                    if (string5 == null) {
                        string5 = "";
                    }
                    if ((string4 = ExtensionsKt.string((ObjectNode)it2, "Key")) == null) {
                        string4 = "";
                    }
                    if ((string3 = ExtensionsKt.string((ObjectNode)it2, "Version")) == null) {
                        string3 = "";
                    }
                    if ((string2 = ExtensionsKt.string((ObjectNode)it2, "Dir")) == null) {
                        string2 = "";
                    }
                    if ((string = ExtensionsKt.string((ObjectNode)it2, "Root")) == null) {
                        string = "";
                    }
                    collection.add(new ModuleManifest(string5, string4, string3, string2, string));
                }
                list = (List)destination$iv$iv2;
                virtualFile2 = virtualFile3;
            } else {
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            VirtualFile virtualFile4 = virtualFile2;
            return new ModulesManifest(virtualFile4, list2);
        }
        catch (Throwable e) {
            Intrinsics.checkNotNull((Object)application);
            this.logErrorAndFailInInternalMode(application, "Failed to parse file '" + file + "'", e);
            return null;
        }
    }

    private final void logErrorAndFailInInternalMode(Application application, String msg, Throwable e) {
        String msg2;
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        Throwable throwable = e;
        String string = msg2 = throwable == null ? msg : msg + ": " + throwable.getMessage();
        if (e == null) {
            LOG.error(msg2);
        } else {
            LOG.error(msg2, e);
        }
        if (application.isInternal()) {
            throw new AssertionError(msg2, e);
        }
    }

    static /* synthetic */ void logErrorAndFailInInternalMode$default(ModuleDetectionUtil moduleDetectionUtil, Application application, String string, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        moduleDetectionUtil.logErrorAndFailInInternalMode(application, string, throwable);
    }

    private final Module findRelativeModule(PsiDirectory directory, String source) {
        Module module;
        VirtualFile virtualFile = directory.getVirtualFile().findFileByRelativePath(source);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile relative = virtualFile;
        if (!relative.exists() || !relative.isDirectory()) {
            return null;
        }
        PsiDirectory psiDirectory = directory.getManager().findDirectory(relative);
        if (psiDirectory != null) {
            PsiDirectory it = psiDirectory;
            boolean bl = false;
            module = Module.Companion.getModule(it);
        } else {
            module = null;
        }
        return module;
    }

    private final kotlin.Pair<String, String> getKeyPrefix(PsiDirectory directory, VirtualFile dotTerraform, ModulesManifest manifest, String name, String source) {
        String relativeToDotTerraform = VfsUtilCore.getRelativePath((VirtualFile)directory.getVirtualFile(), (VirtualFile)dotTerraform);
        String relativeToRoot = VfsUtilCore.getRelativePath((VirtualFile)directory.getVirtualFile(), (VirtualFile)dotTerraform.getParent());
        VirtualFile virtualFile = directory.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        TfToolType toolType = TfExecutorUtilKt.getApplicableToolType(virtualFile);
        if (relativeToDotTerraform != null) {
            Object v1;
            block7: {
                Iterable iterable = manifest.getModules();
                for (Object t : iterable) {
                    ModuleManifest it = (ModuleManifest)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFull(), (Object)(".terraform/" + relativeToDotTerraform))) continue;
                    v1 = t;
                    break block7;
                }
                v1 = null;
            }
            ModuleManifest currentModule = v1;
            if (currentModule != null) {
                return manifest.isTerraform012OrNewer() ? TuplesKt.to((Object)(currentModule.getKey() + "."), null) : TuplesKt.to((Object)(currentModule.getKey() + "|"), null);
            }
            Object[] objectArray = new Object[]{relativeToDotTerraform, toolType.getExecutableName()};
            String string = HCLBundle.message("module.detection.error.no.path.found", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String err = string;
            LOG.info(err);
            return TuplesKt.to(null, (Object)err);
        }
        Object currentModule = relativeToRoot;
        if (!(currentModule == null || currentModule.length() == 0) && manifest.isTerraform012OrNewer()) {
            kotlin.Pair pair;
            Object v3;
            block8: {
                Iterable iterable = manifest.getModules();
                for (Object t : iterable) {
                    ModuleManifest it = (ModuleManifest)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFull(), (Object)relativeToRoot)) continue;
                    v3 = t;
                    break block8;
                }
                v3 = null;
            }
            currentModule = v3;
            if (currentModule != null) {
                pair = TuplesKt.to((Object)(((ModuleManifest)currentModule).getKey() + "."), null);
            } else {
                Object[] objectArray = new Object[]{relativeToRoot, toolType.getExecutableName()};
                String string = HCLBundle.message("module.detection.error.no.relative.path.found", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String err = string;
                LOG.info(err);
                pair = TuplesKt.to(null, (Object)err);
            }
            return pair;
        }
        return manifest.isTerraform012OrNewer() ? TuplesKt.to((Object)name, null) : TuplesKt.to((Object)("1." + name + ";" + source), null);
    }

    @Nullable
    public final VirtualFile getTerraformDirSomewhere(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        VirtualFile virtualFile2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (virtualFile == null) {
                return null;
            }
            for (VirtualFile parent : SequencesKt.filter(ModuleDetectionUtilKt.getVFSParents(virtualFile, project), ModuleDetectionUtil::getTerraformDirSomewhere$lambda$0)) {
                VirtualFile virtualFile3;
                Object object;
                boolean bl = false;
                if (parent.findChild(".terraform") != null) {
                    VirtualFile virtualFile4;
                    VirtualFile it = virtualFile4;
                    boolean bl2 = false;
                    object = it.isDirectory() ? virtualFile4 : null;
                } else {
                    object = null;
                }
                if ((virtualFile3 = object) == null) continue;
                virtualFile2 = virtualFile3;
                break block4;
            }
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final VirtualFile findModuleRoot$intellij_terraform(@NotNull PsiFileSystemItem context) {
        Object v2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Sequence $this$firstOrNull$iv = SequencesKt.filter(ModuleDetectionUtilKt.getVFSParents(context), ModuleDetectionUtil::findModuleRoot$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block2: {
                    void $this$any$iv;
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    VirtualFile[] virtualFileArray = it.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                    Sequence sequence = SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])virtualFileArray), ModuleDetectionUtil::findModuleRoot$lambda$1$0);
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        String it2 = (String)element$iv2;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual((Object)it2, (Object)TerraformFileType.INSTANCE.getDefaultExtension()) || Intrinsics.areEqual((Object)it2, (Object)"tofu") || Intrinsics.areEqual((Object)it2, (Object)"hcl"))) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                if (!bl) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        return v2;
    }

    private final VirtualFile[] getRoots(Project project) {
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project).getContentRootsFromAllModules();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRootsFromAllModules(...)");
        return virtualFileArray;
    }

    private static final Sequence getVFSChainOrVFS$lambda$0() {
        return SequencesKt.sequenceOf((Object)VirtualFileManager.getInstance());
    }

    private static final boolean getTerraformDirSomewhere$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isDirectory();
    }

    private static final boolean findModuleRoot$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isDirectory();
    }

    private static final String findModuleRoot$lambda$1$0(VirtualFile it) {
        String string;
        String string2 = it.getExtension();
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return string;
    }

    static {
        Logger logger = Logger.getInstance(ModuleDetectionUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        IsRegistrySourceKey = new Key("TF.IsRegistrySource");
        Striped striped = Striped.lock((int)16);
        Intrinsics.checkNotNullExpressionValue((Object)striped, (String)"lock(...)");
        IsRegistrySourceLock = striped;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ManifestCachedValueProvider;", "Lcom/intellij/psi/util/CachedValueProvider;", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModulesManifest;", "fileUrl", "", "<init>", "(Ljava/lang/String;)V", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "intellij.terraform"})
    public static final class ManifestCachedValueProvider
    implements CachedValueProvider<ModulesManifest> {
        @NotNull
        private final String fileUrl;

        public ManifestCachedValueProvider(@NotNull String fileUrl) {
            Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
            this.fileUrl = fileUrl;
        }

        @Nullable
        public CachedValueProvider.Result<ModulesManifest> compute() {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(this.fileUrl);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file = virtualFile;
            if (!file.isValid() || !file.exists() || file.isDirectory()) {
                Object[] objectArray = new Object[]{file};
                return new CachedValueProvider.Result(null, objectArray);
            }
            ModulesManifest parsed = INSTANCE.parseManifest(file);
            Object[] objectArray = new Object[]{file};
            return new CachedValueProvider.Result((Object)parsed, objectArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModuleCachedValueProvider;", "Lcom/intellij/psi/util/CachedValueProvider;", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$Result;", "Lorg/intellij/terraform/config/model/Module;", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "<init>", "(Lorg/intellij/terraform/hcl/psi/HCLBlock;)V", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "intellij.terraform"})
    public static final class ModuleCachedValueProvider
    implements CachedValueProvider<Result<Module>> {
        @NotNull
        private final HCLBlock block;

        public ModuleCachedValueProvider(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.block = block;
        }

        @NotNull
        public CachedValueProvider.Result<Result<Module>> compute() {
            return INSTANCE.doGetAsModuleBlock(this.block);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModuleManifest;", "", "source", "", "key", "version", "dir", "root", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSource", "()Ljava/lang/String;", "getKey", "getVersion", "getDir", "getRoot", "full", "getFull", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terraform"})
    public static final class ModuleManifest {
        @NotNull
        private final String source;
        @NotNull
        private final String key;
        @NotNull
        private final String version;
        @NotNull
        private final String dir;
        @NotNull
        private final String root;
        @NotNull
        private final String full;

        public ModuleManifest(@NotNull String source, @NotNull String key, @NotNull String version, @NotNull String dir, @NotNull String root) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.source = source;
            this.key = key;
            this.version = version;
            this.dir = dir;
            this.root = root;
            this.full = this.dir + (String)(((CharSequence)this.root).length() > 0 ? "/" + this.root : "");
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final String getDir() {
            return this.dir;
        }

        @NotNull
        public final String getRoot() {
            return this.root;
        }

        @NotNull
        public final String getFull() {
            return this.full;
        }

        @NotNull
        public final String component1() {
            return this.source;
        }

        @NotNull
        public final String component2() {
            return this.key;
        }

        @NotNull
        public final String component3() {
            return this.version;
        }

        @NotNull
        public final String component4() {
            return this.dir;
        }

        @NotNull
        public final String component5() {
            return this.root;
        }

        @NotNull
        public final ModuleManifest copy(@NotNull String source, @NotNull String key, @NotNull String version, @NotNull String dir, @NotNull String root) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            return new ModuleManifest(source, key, version, dir, root);
        }

        public static /* synthetic */ ModuleManifest copy$default(ModuleManifest moduleManifest, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = moduleManifest.source;
            }
            if ((n & 2) != 0) {
                string2 = moduleManifest.key;
            }
            if ((n & 4) != 0) {
                string3 = moduleManifest.version;
            }
            if ((n & 8) != 0) {
                string4 = moduleManifest.dir;
            }
            if ((n & 0x10) != 0) {
                string5 = moduleManifest.root;
            }
            return moduleManifest.copy(string, string2, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "ModuleManifest(source=" + this.source + ", key=" + this.key + ", version=" + this.version + ", dir=" + this.dir + ", root=" + this.root + ")";
        }

        public int hashCode() {
            int result2 = this.source.hashCode();
            result2 = result2 * 31 + this.key.hashCode();
            result2 = result2 * 31 + this.version.hashCode();
            result2 = result2 * 31 + this.dir.hashCode();
            result2 = result2 * 31 + this.root.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleManifest)) {
                return false;
            }
            ModuleManifest moduleManifest = (ModuleManifest)other;
            if (!Intrinsics.areEqual((Object)this.source, (Object)moduleManifest.source)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.key, (Object)moduleManifest.key)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)moduleManifest.version)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dir, (Object)moduleManifest.dir)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.root, (Object)moduleManifest.root);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModuleUri;", "", "scheme", "", "authority", "repo", "path", "params", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getScheme", "()Ljava/lang/String;", "getAuthority", "getRepo", "getPath", "getParams", "couldBeReferencedBy", "", "refUri", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nModuleDetectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDetectionUtil.kt\norg/intellij/terraform/config/model/ModuleDetectionUtil$ModuleUri\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,569:1\n1#2:570\n*E\n"})
    private static final class ModuleUri {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String scheme;
        @NotNull
        private final String authority;
        @NotNull
        private final String repo;
        @NotNull
        private final String path;
        @NotNull
        private final String params;
        @NotNull
        private static final Regex URL_REGEX = new Regex("((?:\\w+::?)+)(?://)?([^/?#]*)([^?#;]*)(.*)");
        @NotNull
        private static final Regex REF_REGEX = new Regex("((?:\\w+::?)+)?(?://)?([^:/?#]*):?([^?#;]*)(.*)");

        public ModuleUri(@Nullable String scheme, @NotNull String authority, @NotNull String repo, @NotNull String path, @NotNull String params) {
            Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
            Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.scheme = scheme;
            this.authority = authority;
            this.repo = repo;
            this.path = path;
            this.params = params;
        }

        @Nullable
        public final String getScheme() {
            return this.scheme;
        }

        @NotNull
        public final String getAuthority() {
            return this.authority;
        }

        @NotNull
        public final String getRepo() {
            return this.repo;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getParams() {
            return this.params;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean couldBeReferencedBy(@NotNull ModuleUri refUri) {
            Intrinsics.checkNotNullParameter((Object)refUri, (String)"refUri");
            if (!Intrinsics.areEqual((Object)this.authority, (Object)refUri.authority)) return false;
            if (!Intrinsics.areEqual((Object)ModuleUri.couldBeReferencedBy$normalizeRepoString(this.repo), (Object)ModuleUri.couldBeReferencedBy$normalizeRepoString(refUri.repo))) return false;
            if (!Intrinsics.areEqual((Object)StringsKt.removePrefix((String)this.path, (CharSequence)"/"), (Object)StringsKt.removePrefix((String)refUri.path, (CharSequence)"/"))) return false;
            Map it = ModuleUri.Companion.parseParams(this.params, false);
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)ModuleUri.Companion.parseParams(refUri.params, true))) return true;
            if (!Intrinsics.areEqual((Object)it, (Object)ModuleUri.Companion.parseParams(refUri.params, false))) return false;
            return true;
        }

        @Nullable
        public final String component1() {
            return this.scheme;
        }

        @NotNull
        public final String component2() {
            return this.authority;
        }

        @NotNull
        public final String component3() {
            return this.repo;
        }

        @NotNull
        public final String component4() {
            return this.path;
        }

        @NotNull
        public final String component5() {
            return this.params;
        }

        @NotNull
        public final ModuleUri copy(@Nullable String scheme, @NotNull String authority, @NotNull String repo, @NotNull String path, @NotNull String params) {
            Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
            Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            return new ModuleUri(scheme, authority, repo, path, params);
        }

        public static /* synthetic */ ModuleUri copy$default(ModuleUri moduleUri, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = moduleUri.scheme;
            }
            if ((n & 2) != 0) {
                string2 = moduleUri.authority;
            }
            if ((n & 4) != 0) {
                string3 = moduleUri.repo;
            }
            if ((n & 8) != 0) {
                string4 = moduleUri.path;
            }
            if ((n & 0x10) != 0) {
                string5 = moduleUri.params;
            }
            return moduleUri.copy(string, string2, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "ModuleUri(scheme=" + this.scheme + ", authority=" + this.authority + ", repo=" + this.repo + ", path=" + this.path + ", params=" + this.params + ")";
        }

        public int hashCode() {
            int result2 = this.scheme == null ? 0 : this.scheme.hashCode();
            result2 = result2 * 31 + this.authority.hashCode();
            result2 = result2 * 31 + this.repo.hashCode();
            result2 = result2 * 31 + this.path.hashCode();
            result2 = result2 * 31 + this.params.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleUri)) {
                return false;
            }
            ModuleUri moduleUri = (ModuleUri)other;
            if (!Intrinsics.areEqual((Object)this.scheme, (Object)moduleUri.scheme)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.authority, (Object)moduleUri.authority)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.repo, (Object)moduleUri.repo)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)moduleUri.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.params, (Object)moduleUri.params);
        }

        private static final String couldBeReferencedBy$normalizeRepoString(String repo) {
            return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)repo, (CharSequence)"/"), (CharSequence)".git");
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\fJ$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModuleUri$Companion;", "", "<init>", "()V", "URL_REGEX", "Lkotlin/text/Regex;", "getURL_REGEX", "()Lkotlin/text/Regex;", "REF_REGEX", "getREF_REGEX", "splitAtDirPrefix", "Lkotlin/Pair;", "", "repoAndPath", "fromModulesJsonSource", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModuleUri;", "modulesJsonSource", "fromReference", "moduleReference", "parseParams", "", "paramString", "encode", "", "intellij.terraform"})
        @SourceDebugExtension(value={"SMAP\nModuleDetectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDetectionUtil.kt\norg/intellij/terraform/config/model/ModuleDetectionUtil$ModuleUri$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,569:1\n1#2:570\n52#3:571\n*S KotlinDebug\n*F\n+ 1 ModuleDetectionUtil.kt\norg/intellij/terraform/config/model/ModuleDetectionUtil$ModuleUri$Companion\n*L\n155#1:571\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Regex getURL_REGEX() {
                return URL_REGEX;
            }

            @NotNull
            public final Regex getREF_REGEX() {
                return REF_REGEX;
            }

            private final kotlin.Pair<String, String> splitAtDirPrefix(String repoAndPath) {
                int ind = StringsKt.indexOf$default((CharSequence)repoAndPath, (String)"//", (int)0, (boolean)false, (int)6, null);
                if (ind == -1) {
                    return TuplesKt.to((Object)repoAndPath, (Object)"");
                }
                String string = repoAndPath.substring(0, ind);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = repoAndPath.substring(ind + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return TuplesKt.to((Object)string, (Object)string2);
            }

            @Nullable
            public final ModuleUri fromModulesJsonSource(@NotNull String modulesJsonSource) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)modulesJsonSource, (String)"modulesJsonSource");
                MatchResult matchResult = this.getURL_REGEX().matchEntire((CharSequence)modulesJsonSource);
                if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
                    return null;
                }
                MatchResult matchResult2 = matchResult;
                String scheme = (String)matchResult2.getMatch().getGroupValues().get(1);
                String authority = (String)matchResult2.getMatch().getGroupValues().get(2);
                String repoAndPath = (String)matchResult2.getMatch().getGroupValues().get(3);
                String paramsStr = (String)matchResult2.getMatch().getGroupValues().get(4);
                kotlin.Pair<String, String> pair = this.splitAtDirPrefix(repoAndPath);
                String repo = (String)pair.component1();
                String dir = (String)pair.component2();
                kotlin.Pair<String, String> pair2 = this.splitAtDirPrefix(paramsStr);
                String params = (String)pair2.component1();
                String dirFromParams = (String)pair2.component2();
                String string = scheme;
                String string2 = authority;
                String string3 = repo;
                CharSequence charSequence2 = dir;
                if (charSequence2.length() == 0) {
                    String string4 = string3;
                    String string5 = string2;
                    String string6 = string;
                    boolean bl = false;
                    String string7 = dirFromParams;
                    string = string6;
                    string2 = string5;
                    string3 = string4;
                    charSequence = string7;
                } else {
                    charSequence = charSequence2;
                }
                String string8 = params;
                String string9 = (String)charSequence;
                String string10 = string3;
                String string11 = string2;
                String string12 = string;
                return new ModuleUri(string12, string11, string10, string9, string8);
            }

            @Nullable
            public final ModuleUri fromReference(@NotNull String moduleReference) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)moduleReference, (String)"moduleReference");
                MatchResult matchResult = this.getREF_REGEX().matchEntire((CharSequence)moduleReference);
                if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
                    return null;
                }
                MatchResult matchResult2 = matchResult;
                String scheme = (String)matchResult2.getMatch().getGroupValues().get(1);
                String authority = (String)matchResult2.getMatch().getGroupValues().get(2);
                String repoAndPath = (String)matchResult2.getMatch().getGroupValues().get(3);
                String paramsStr = (String)matchResult2.getMatch().getGroupValues().get(4);
                kotlin.Pair<String, String> pair = this.splitAtDirPrefix(repoAndPath);
                String repo = (String)pair.component1();
                String dir = (String)pair.component2();
                kotlin.Pair<String, String> pair2 = this.splitAtDirPrefix(paramsStr);
                String params = (String)pair2.component1();
                String dirFromParams = (String)pair2.component2();
                String string = StringUtil.nullize((String)scheme, (boolean)false);
                String string2 = authority;
                String string3 = repo;
                CharSequence charSequence2 = dir;
                if (charSequence2.length() == 0) {
                    String string4 = string3;
                    String string5 = string2;
                    String string6 = string;
                    boolean bl = false;
                    String string7 = dirFromParams;
                    string = string6;
                    string2 = string5;
                    string3 = string4;
                    charSequence = string7;
                } else {
                    charSequence = charSequence2;
                }
                String string8 = params;
                String string9 = (String)charSequence;
                String string10 = string3;
                String string11 = string2;
                String string12 = string;
                return new ModuleUri(string12, string11, string10, string9, string8);
            }

            private final Map<String, String> parseParams(String paramString, boolean encode) {
                int p;
                if (StringsKt.isBlank((CharSequence)paramString)) {
                    return MapsKt.emptyMap();
                }
                SortedMap result2 = MapsKt.sortedMapOf((kotlin.Pair[])new kotlin.Pair[0]);
                CharSequence remaining = StringsKt.startsWith$default((String)paramString, (String)"?", (boolean)false, (int)2, null) ? paramString.subSequence(1, paramString.length()) : (CharSequence)paramString;
                while (!(remaining.length() == 0) && (p = StringsKt.indexOf$default((CharSequence)remaining, (String)"=", (int)0, (boolean)false, (int)6, null)) != -1) {
                    String string;
                    String key = ((Object)remaining.subSequence(0, p)).toString();
                    remaining = remaining.subSequence(p + 1, remaining.length());
                    int p1 = StringsKt.indexOf$default((CharSequence)remaining, (String)"&", (int)0, (boolean)false, (int)6, null);
                    CharSequence value = null;
                    if (p1 == -1) {
                        value = remaining;
                        remaining = remaining.subSequence(remaining.length(), remaining.length());
                    } else {
                        value = remaining.subSequence(0, p1);
                        remaining = remaining.subSequence(p1 + 1, remaining.length());
                    }
                    Map map = result2;
                    String string2 = ((Object)value).toString();
                    boolean condition$iv = encode;
                    boolean $i$f$applyIf = false;
                    if (condition$iv) {
                        void $this$parseParams_u24lambda_u240 = $this$applyIf$iv;
                        boolean bl = false;
                        String string3 = URLEncoder.encode((String)$this$parseParams_u24lambda_u240, Charsets.UTF_8);
                        string = string3;
                        Intrinsics.checkNotNull((Object)string3);
                    } else {
                        string = $this$applyIf$iv;
                    }
                    string2 = string;
                    map.put(key, string2);
                }
                return result2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModulesManifest;", "", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "modules", "", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModuleManifest;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;)V", "getContext", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getModules", "()Ljava/util/List;", "isTerraform012OrNewer", "", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "intellij.terraform"})
    public static final class ModulesManifest {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final VirtualFile context;
        @NotNull
        private final List<ModuleManifest> modules;
        @NotNull
        private static final ModuleManifest Terraform012RootModule = new ModuleManifest("", "", "", ".", "");

        public ModulesManifest(@NotNull VirtualFile context, @NotNull List<ModuleManifest> modules) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            this.context = context;
            this.modules = modules;
        }

        @NotNull
        public final VirtualFile getContext() {
            return this.context;
        }

        @NotNull
        public final List<ModuleManifest> getModules() {
            return this.modules;
        }

        public final boolean isTerraform012OrNewer() {
            return this.modules.contains(Terraform012RootModule);
        }

        @NotNull
        public final VirtualFile component1() {
            return this.context;
        }

        @NotNull
        public final List<ModuleManifest> component2() {
            return this.modules;
        }

        @NotNull
        public final ModulesManifest copy(@NotNull VirtualFile context, @NotNull List<ModuleManifest> modules) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            return new ModulesManifest(context, modules);
        }

        public static /* synthetic */ ModulesManifest copy$default(ModulesManifest modulesManifest, VirtualFile virtualFile, List list, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = modulesManifest.context;
            }
            if ((n & 2) != 0) {
                list = modulesManifest.modules;
            }
            return modulesManifest.copy(virtualFile, list);
        }

        @NotNull
        public String toString() {
            return "ModulesManifest(context=" + this.context + ", modules=" + this.modules + ")";
        }

        public int hashCode() {
            int result2 = this.context.hashCode();
            result2 = result2 * 31 + ((Object)this.modules).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModulesManifest)) {
                return false;
            }
            ModulesManifest modulesManifest = (ModulesManifest)other;
            if (!Intrinsics.areEqual((Object)this.context, (Object)modulesManifest.context)) {
                return false;
            }
            return Intrinsics.areEqual(this.modules, modulesManifest.modules);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModulesManifest$Companion;", "", "<init>", "()V", "Terraform012RootModule", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$ModuleManifest;", "intellij.terraform"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u0004\u0018\u00018\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/config/model/ModuleDetectionUtil$Result;", "T", "", "<init>", "()V", "value", "getValue", "()Ljava/lang/Object;", "failureString", "", "getFailureString", "()Ljava/lang/String;", "Success", "Failure", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$Result$Failure;", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$Result$Success;", "intellij.terraform"})
    public static abstract sealed class Result<T> {
        private Result() {
        }

        @Nullable
        public abstract T getValue();

        @Nullable
        public abstract String getFailureString();

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0004H\u00c6\u0003J\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u0004\u0018\u00018\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/intellij/terraform/config/model/ModuleDetectionUtil$Result$Failure;", "T", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$Result;", "failureString", "", "<init>", "(Ljava/lang/String;)V", "getFailureString", "()Ljava/lang/String;", "value", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.terraform"})
        public static final class Failure<T>
        extends Result<T> {
            @NotNull
            private final String failureString;
            @Nullable
            private final T value;

            public Failure(@NotNull String failureString) {
                Intrinsics.checkNotNullParameter((Object)failureString, (String)"failureString");
                super(null);
                this.failureString = failureString;
            }

            @Override
            @NotNull
            public String getFailureString() {
                return this.failureString;
            }

            @Override
            @Nullable
            public T getValue() {
                return this.value;
            }

            @NotNull
            public final String component1() {
                return this.failureString;
            }

            @NotNull
            public final Failure<T> copy(@NotNull String failureString) {
                Intrinsics.checkNotNullParameter((Object)failureString, (String)"failureString");
                return new Failure<T>(failureString);
            }

            public static /* synthetic */ Failure copy$default(Failure failure, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = failure.failureString;
                }
                return failure.copy(string);
            }

            @NotNull
            public String toString() {
                return "Failure(failureString=" + this.failureString + ")";
            }

            public int hashCode() {
                return this.failureString.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failure)) {
                    return false;
                }
                Failure failure = (Failure)other;
                return Intrinsics.areEqual((Object)this.failureString, (Object)failure.failureString);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\nH\u00d6\u0001R\u0016\u0010\u0003\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/intellij/terraform/config/model/ModuleDetectionUtil$Result$Success;", "T", "Lorg/intellij/terraform/config/model/ModuleDetectionUtil$Result;", "value", "<init>", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "failureString", "", "getFailureString", "()Ljava/lang/String;", "component1", "copy", "(Ljava/lang/Object;)Lorg/intellij/terraform/config/model/ModuleDetectionUtil$Result$Success;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.terraform"})
        public static final class Success<T>
        extends Result<T> {
            private final T value;
            @Nullable
            private final String failureString;

            public Success(T value) {
                super(null);
                this.value = value;
            }

            @Override
            public T getValue() {
                return this.value;
            }

            @Override
            @Nullable
            public String getFailureString() {
                return this.failureString;
            }

            public final T component1() {
                return this.value;
            }

            @NotNull
            public final Success<T> copy(T value) {
                return new Success<T>(value);
            }

            public static /* synthetic */ Success copy$default(Success success, Object object, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = success.value;
                }
                return success.copy(object);
            }

            @NotNull
            public String toString() {
                return "Success(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual(this.value, success.value);
            }
        }
    }
}

