/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.loader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.ListType;
import org.intellij.terraform.config.model.MapType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.SetType;
import org.intellij.terraform.config.model.TfTypeModelKt;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.model.loader.BaseLoader;
import org.intellij.terraform.config.model.loader.LoadContext;
import org.intellij.terraform.config.model.loader.LoadersKt;
import org.intellij.terraform.config.model.loader.LoadingModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/intellij/terraform/config/model/loader/BaseLoaderV1;", "Lorg/intellij/terraform/config/model/loader/BaseLoader;", "<init>", "()V", "version", "", "getVersion", "()Ljava/lang/String;", "parseSchemaElement", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "context", "Lorg/intellij/terraform/config/model/loader/LoadContext;", "entry", "", "", "fqnPrefix", "name", "value", "parseType", "Lorg/intellij/terraform/config/model/HclType;", "string", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nloaders_v1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 loaders_v1.kt\norg/intellij/terraform/config/model/loader/BaseLoaderV1\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1#2:316\n1#2:327\n1617#3,9:317\n1869#3:326\n1870#3:328\n1626#3:329\n1563#3:330\n1634#3,3:331\n*S KotlinDebug\n*F\n+ 1 loaders_v1.kt\norg/intellij/terraform/config/model/loader/BaseLoaderV1\n*L\n93#1:327\n93#1:317,9\n93#1:326\n93#1:328\n93#1:329\n93#1:330\n93#1:331,3\n*E\n"})
public final class BaseLoaderV1
implements BaseLoader {
    @NotNull
    public static final BaseLoaderV1 INSTANCE = new BaseLoaderV1();

    private BaseLoaderV1() {
    }

    @Override
    @NotNull
    public String getVersion() {
        return "1";
    }

    @Override
    @NotNull
    public PropertyOrBlockType parseSchemaElement(@NotNull LoadContext context, @NotNull Map.Entry<String, ? extends Object> entry, @NotNull String fqnPrefix) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)fqnPrefix, (String)"fqnPrefix");
        return this.parseSchemaElement(context, entry.getKey(), entry.getValue(), fqnPrefix);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PropertyOrBlockType parseSchemaElement(@NotNull LoadContext context, @NotNull String name, @Nullable Object value, @NotNull String fqnPrefix) {
        String description;
        String string;
        boolean computed;
        boolean bl;
        boolean bl2;
        boolean has_default_function;
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fqnPrefix, (String)"fqnPrefix");
        boolean bl3 = value instanceof ObjectNode;
        if (_Assertions.ENABLED && !bl3) {
            boolean $i$a$-assert-BaseLoaderV1$parseSchemaElement$22 = false;
            String $i$a$-assert-BaseLoaderV1$parseSchemaElement$22 = "Right part of schema element (field parameters) should be object";
            throw new AssertionError((Object)$i$a$-assert-BaseLoaderV1$parseSchemaElement$22);
        }
        if (!(value instanceof ObjectNode)) {
            throw new IllegalStateException();
        }
        if (Intrinsics.areEqual((Object)name, (Object)"__timeouts__")) {
            throw new IllegalStateException("__timeouts__ not expected here");
        }
        String fqn = fqnPrefix + "." + name;
        boolean isBlock = false;
        String rawType = ExtensionsKt.string((ObjectNode)value, "Type");
        List innerTypeProperties = null;
        HclType type = this.parseType(context, rawType);
        ObjectNode elem = ExtensionsKt.obj((ObjectNode)value, "Elem");
        if (elem != null && ExtensionsKt.isNotEmpty(elem)) {
            String et;
            String string2 = ExtensionsKt.string(elem, "Type");
            if (string2 == null) {
                string2 = ExtensionsKt.string(elem, "type");
            }
            if (Intrinsics.areEqual((Object)(et = string2), (Object)"SchemaElements")) {
                String elementsType;
                String string3 = ExtensionsKt.string(elem, "ElementsType");
                if (string3 == null) {
                    string3 = ExtensionsKt.string(elem, "elements-type");
                }
                if ((elementsType = string3) != null) {
                    parsedElementsType = this.parseType(context, elementsType);
                    var14_18 = rawType;
                    if (Intrinsics.areEqual((Object)var14_18, (Object)"List")) {
                        type = new ListType(parsedElementsType);
                    } else if (Intrinsics.areEqual((Object)var14_18, (Object)"Set")) {
                        type = new SetType(parsedElementsType);
                    } else if (Intrinsics.areEqual((Object)var14_18, (Object)"Map")) {
                        type = new MapType(parsedElementsType);
                    } else if (!Intrinsics.areEqual((Object)var14_18, (Object)elementsType)) {
                        LoadersKt.warnOrFailInInternalMode(fqn + ": Type (" + rawType + ") unexpected for SchemaElements (" + elementsType + ")");
                    }
                }
            } else if (Intrinsics.areEqual((Object)et, (Object)"SchemaInfo")) {
                ObjectNode o;
                ObjectNode objectNode = ExtensionsKt.obj(elem, "Info");
                if (objectNode == null) {
                    objectNode = ExtensionsKt.obj(elem, "info");
                }
                if ((o = objectNode) != null) {
                    Set set = o.properties();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
                    innerTypeProperties = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), arg_0 -> BaseLoaderV1.parseSchemaElement$lambda$1(context, fqn, arg_0)));
                    if (Intrinsics.areEqual((Object)type, (Object)Types.INSTANCE.getArray())) {
                        isBlock = true;
                    }
                }
            } else if (et == null) {
                String t;
                String string4 = ExtensionsKt.string(elem, "Type");
                if (string4 == null) {
                    string4 = ExtensionsKt.string(elem, "type");
                }
                if ((t = string4) != null) {
                    parsedElementsType = this.parseType(context, t);
                    var14_18 = rawType;
                    if (Intrinsics.areEqual((Object)var14_18, (Object)"List")) {
                        type = new ListType(parsedElementsType);
                    } else if (Intrinsics.areEqual((Object)var14_18, (Object)"Set")) {
                        type = new SetType(parsedElementsType);
                    } else if (Intrinsics.areEqual((Object)var14_18, (Object)"Map")) {
                        type = new MapType(parsedElementsType);
                    } else if (!Intrinsics.areEqual((Object)var14_18, (Object)t)) {
                        LoadersKt.warnOrFailInInternalMode(fqn + ": Type (" + rawType + ") unexpected when present Elem.Type (" + t + ")");
                    }
                }
            } else {
                LoadersKt.warnOrFailInInternalMode(fqn + ": unexpected Elem.Type: " + et);
            }
        }
        ArrayNode arrayNode = ExtensionsKt.array((ObjectNode)value, "ConflictsWith");
        if (arrayNode != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)arrayNode;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl4 = false;
                JsonNode it = (JsonNode)element$iv$iv;
                boolean bl5 = false;
                if (it.textValue() == null) continue;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl7 = false;
                collection.add(LoadersKt.pool((String)it, context));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List conflicts = list;
        String deprecated = ExtensionsKt.string((ObjectNode)value, "Deprecated");
        ObjectNode objectNode = ExtensionsKt.obj((ObjectNode)value, "Default");
        boolean has_default = objectNode != null ? ExtensionsKt.isNotEmpty(objectNode) : false;
        String string5 = ExtensionsKt.string((ObjectNode)value, "DefaultFunc");
        boolean bl8 = string5 != null ? ((CharSequence)string5).length() > 0 : (has_default_function = false);
        LoadingModel.Additional additional = context.getModel().getExternal().get(fqn);
        if (additional == null) {
            additional = new LoadingModel.Additional(name, null, null, null, null, 30, null);
        }
        LoadingModel.Additional additional2 = additional;
        Boolean bl9 = additional2.getRequired();
        if (bl9 != null) {
            bl2 = bl9;
        } else {
            Boolean bl10 = ExtensionsKt.boolean((ObjectNode)value, "Required");
            bl2 = bl10 != null ? bl10 : false;
        }
        boolean required = bl2;
        Boolean bl11 = additional2.getOptional();
        if (bl11 != null) {
            bl = bl11;
        } else {
            Boolean bl12 = ExtensionsKt.boolean((ObjectNode)value, "Optional");
            bl = bl12 != null ? bl12 : false;
        }
        boolean optional = bl;
        Boolean bl13 = ExtensionsKt.boolean((ObjectNode)value, "Computed");
        boolean bl14 = computed = bl13 != null ? bl13 : false;
        if (Intrinsics.areEqual((Object)type, (Object)Types.INSTANCE.getObject())) {
            isBlock = true;
        }
        if ((string = additional2.getDescription()) == null) {
            string = description = ExtensionsKt.string((ObjectNode)value, "Description");
        }
        if (isBlock) {
            Object object = innerTypeProperties;
            if (object == null || (object = TfTypeModelKt.toMap((Collection)object)) == null) {
                object = MapsKt.emptyMap();
            }
            Map<String, PropertyOrBlockType> properties = object;
            String string6 = description;
            String string7 = deprecated;
            return LoadersKt.pool(new BlockType(LoadersKt.pool(name, context), 0, string6 != null ? LoadersKt.pool(string6, context) : null, null, optional, required, computed, string7 != null ? LoadersKt.pool(string7, context) : null, conflicts, null, properties, 522, null), context);
        }
        String string8 = description;
        String string9 = deprecated;
        return LoadersKt.pool(new PropertyType(LoadersKt.pool(name, context), type, additional2.getHint(), false, string8 != null ? LoadersKt.pool(string8, context) : null, null, optional, required, computed, false, string9 != null ? LoadersKt.pool(string9, context) : null, conflicts, has_default || has_default_function, 552, null), context);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public HclType parseType(@NotNull LoadContext context, @Nullable String string) {
        HclType hclType;
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string3 = string;
        String string4 = string2 = string3 != null ? StringsKt.removePrefix((String)string3, (CharSequence)"Type") : null;
        if (string2 != null) {
            int n = -1;
            switch (string2.hashCode()) {
                case 67973692: {
                    if (!string2.equals("Float")) break;
                    n = 1;
                    break;
                }
                case 83010: {
                    if (!string2.equals("Set")) break;
                    n = 2;
                    break;
                }
                case 2076426: {
                    if (!string2.equals("Bool")) break;
                    n = 3;
                    break;
                }
                case 2368702: {
                    if (!string2.equals("List")) break;
                    n = 4;
                    break;
                }
                case -1808118735: {
                    if (!string2.equals("String")) break;
                    n = 5;
                    break;
                }
                case 77116: {
                    if (!string2.equals("Map")) break;
                    n = 6;
                    break;
                }
                case 65996: {
                    if (!string2.equals("Any")) break;
                    n = 7;
                    break;
                }
                case 73679: {
                    if (!string2.equals("Int")) break;
                    n = 8;
                    break;
                }
            }
            switch (n) {
                case 3: {
                    hclType = Types.INSTANCE.getBoolean();
                    return hclType;
                }
                case 8: {
                    hclType = Types.INSTANCE.getNumber();
                    return hclType;
                }
                case 1: {
                    hclType = Types.INSTANCE.getNumber();
                    return hclType;
                }
                case 5: {
                    hclType = Types.INSTANCE.getString();
                    return hclType;
                }
                case 4: {
                    hclType = Types.INSTANCE.getArray();
                    return hclType;
                }
                case 2: {
                    hclType = Types.INSTANCE.getArray();
                    return hclType;
                }
                case 6: {
                    hclType = Types.INSTANCE.getObject();
                    return hclType;
                }
                case 7: {
                    hclType = Types.INSTANCE.getAny();
                    return hclType;
                }
            }
        }
        hclType = Types.INSTANCE.getInvalid();
        return hclType;
    }

    private static final PropertyOrBlockType parseSchemaElement$lambda$1(LoadContext $context, String $fqn, Map.Entry it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.parseSchemaElement($context, it, $fqn);
    }
}

