/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.loader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.ProvisionerType;
import org.intellij.terraform.config.model.loader.BaseLoader;
import org.intellij.terraform.config.model.loader.LoadContext;
import org.intellij.terraform.config.model.loader.LoadersKt;
import org.intellij.terraform.config.model.loader.LoadingModel;
import org.intellij.terraform.config.model.loader.TfMetadataLoader;
import org.intellij.terraform.config.model.loader.VersionedMetadataLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/intellij/terraform/config/model/loader/ProvisionerLoader;", "Lorg/intellij/terraform/config/model/loader/VersionedMetadataLoader;", "base", "Lorg/intellij/terraform/config/model/loader/BaseLoader;", "<init>", "(Lorg/intellij/terraform/config/model/loader/BaseLoader;)V", "getBase", "()Lorg/intellij/terraform/config/model/loader/BaseLoader;", "isSupportedType", "", "type", "", "load", "", "context", "Lorg/intellij/terraform/config/model/loader/LoadContext;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "fileName", "intellij.terraform"})
public abstract class ProvisionerLoader
implements VersionedMetadataLoader {
    @NotNull
    private final BaseLoader base;

    public ProvisionerLoader(@NotNull BaseLoader base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        this.base = base;
    }

    @NotNull
    protected final BaseLoader getBase() {
        return this.base;
    }

    @Override
    public boolean isSupportedType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"provisioner");
    }

    @Override
    public void load(@NotNull LoadContext context, @NotNull ObjectNode json, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        LoadingModel model = context.getModel();
        ObjectNode objectNode = ExtensionsKt.obj(json, "schemas");
        if (objectNode == null) {
            objectNode = json;
        }
        ObjectNode provisioner_schema = objectNode;
        String string = ExtensionsKt.string(provisioner_schema, "name");
        Intrinsics.checkNotNull((Object)string);
        String name = LoadersKt.pool(string, context);
        ObjectNode provisioner = ExtensionsKt.obj(provisioner_schema, "schema");
        if (provisioner == null) {
            TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("No provisioner schema in file '" + fileName + "'");
            return;
        }
        if (model.getLoaded().containsKey("provisioner." + name)) {
            TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("Provisioner '" + name + "' is already loaded from '" + model.getLoaded().get("provisioner." + name) + "'");
            return;
        }
        model.getLoaded().put("provisioner." + name, fileName);
        Set set = provisioner.properties();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
        ProvisionerType info = new ProvisionerType(name, SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), arg_0 -> ProvisionerLoader.load$lambda$0(this, context, name, arg_0))));
        model.getProvisioners().add(info);
    }

    private static final PropertyOrBlockType load$lambda$0(ProvisionerLoader this$0, LoadContext $context, String $name, Map.Entry it) {
        BaseLoader baseLoader = this$0.base;
        Intrinsics.checkNotNull((Object)it);
        return baseLoader.parseSchemaElement($context, it, $name);
    }
}

