/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.loader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.model.Argument;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.DataSourceType;
import org.intellij.terraform.config.model.EphemeralType;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.HclTypeImpl;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.config.model.ResourceType;
import org.intellij.terraform.config.model.TfFunction;
import org.intellij.terraform.config.model.loader.LoadContext;
import org.intellij.terraform.config.model.loader.LoadersKt;
import org.intellij.terraform.config.model.loader.LoadingModel;
import org.intellij.terraform.config.model.loader.ProviderMetadata;
import org.intellij.terraform.config.model.loader.TfBaseLoader;
import org.intellij.terraform.config.model.loader.TfMetadataLoader;
import org.intellij.terraform.config.model.loader.VersionedMetadataLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J2\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J.\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J.\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J0\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J0\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002\u00a8\u0006#"}, d2={"Lorg/intellij/terraform/config/model/loader/TfProvidersSchema;", "Lorg/intellij/terraform/config/model/loader/VersionedMetadataLoader;", "<init>", "()V", "isSupportedVersion", "", "version", "", "isSupportedType", "type", "load", "", "context", "Lorg/intellij/terraform/config/model/loader/LoadContext;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "fileName", "parseProviderInfo", "Lorg/intellij/terraform/config/model/ProviderType;", "name", "namespace", "obj", "file", "parseResourceInfo", "Lorg/intellij/terraform/config/model/ResourceType;", "entry", "", "", "info", "parseDataSourceInfo", "Lorg/intellij/terraform/config/model/DataSourceType;", "parseProviderFunctionInfo", "Lorg/intellij/terraform/config/model/TfFunction;", "parseEphemeralResourceInfo", "Lorg/intellij/terraform/config/model/EphemeralType;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nterraform_providers_generated.kt\nKotlin\n*S Kotlin\n*F\n+ 1 terraform_providers_generated.kt\norg/intellij/terraform/config/model/loader/TfProvidersSchema\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,386:1\n1#2:387\n1#2:396\n1#2:401\n1#2:414\n1634#3,3:388\n1634#3,3:391\n1625#3:394\n1869#3:395\n1870#3:397\n1626#3:398\n1625#3:399\n1869#3:400\n1870#3:402\n1626#3:403\n1617#3,9:404\n1869#3:413\n1870#3:415\n1626#3:416\n1563#3:417\n1634#3,3:418\n37#4,2:421\n18#4:423\n*S KotlinDebug\n*F\n+ 1 terraform_providers_generated.kt\norg/intellij/terraform/config/model/loader/TfProvidersSchema\n*L\n324#1:396\n329#1:401\n367#1:414\n319#1:388,3\n320#1:391,3\n324#1:394\n324#1:395\n324#1:397\n324#1:398\n329#1:399\n329#1:400\n329#1:402\n329#1:403\n367#1:404,9\n367#1:413\n367#1:415\n367#1:416\n368#1:417\n368#1:418,3\n369#1:421,2\n369#1:423\n*E\n"})
public final class TfProvidersSchema
implements VersionedMetadataLoader {
    @Override
    public boolean isSupportedVersion(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Object[] objectArray = new String[]{"0.1", "0.2", "1.0"};
        return CollectionsKt.listOf((Object[])objectArray).contains(version);
    }

    @Override
    public boolean isSupportedType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"terraform-providers-schema-json");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load(@NotNull LoadContext context, @NotNull ObjectNode json, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        LoadingModel model = context.getModel();
        ObjectNode objectNode = ExtensionsKt.obj(json, "schemas");
        if (objectNode == null) {
            objectNode = json;
        }
        ObjectNode objectNode2 = ExtensionsKt.obj(objectNode, "provider_schemas");
        if (objectNode2 == null) {
            return;
        }
        ObjectNode providerSchemas = objectNode2;
        Set set = providerSchemas.properties();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
        for (Map.Entry entry : CollectionsKt.asSequence((Iterable)set)) {
            void $this$mapNotNullTo$iv;
            ObjectNode ephemeralResource;
            Map.Entry it;
            Object object;
            Iterable $this$mapTo$iv;
            boolean $i$f$mapTo;
            Iterable destination$iv;
            Object object2;
            String providerFullName;
            JsonNode provider;
            block18: {
                ProviderType.ProviderCoordinates coordinates;
                block17: {
                    Intrinsics.checkNotNull((Object)entry);
                    String n = (String)entry.getKey();
                    provider = (JsonNode)entry.getValue();
                    Intrinsics.checkNotNull((Object)n);
                    coordinates = ProviderType.Companion.parseCoordinates$intellij_terraform(n);
                    providerFullName = coordinates.getNamespace() + "/" + coordinates.getName();
                    String providerKey = "provider." + providerFullName;
                    if (model.getLoaded().containsKey(providerKey)) {
                        TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("Provider '" + providerFullName + "' is already loaded from '" + model.getLoaded().get(providerKey) + "'");
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)provider, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                    ObjectNode cfr_ignored_0 = (ObjectNode)provider;
                    model.getLoaded().put(providerKey, fileName);
                    object2 = ExtensionsKt.obj((ObjectNode)provider, "provider");
                    if (object2 == null) break block17;
                    ObjectNode it2 = object2;
                    boolean bl = false;
                    ProviderType providerType = this.parseProviderInfo(context, coordinates.getName(), coordinates.getNamespace(), it2, json);
                    object2 = providerType;
                    if (providerType != null) break block18;
                }
                object2 = new ProviderType(coordinates.getName(), CollectionsKt.emptyList(), coordinates.getNamespace(), null, null, null, 56, null);
            }
            Object providerInfo = object2;
            model.getProviders().add((ProviderType)providerInfo);
            ObjectNode resources = ExtensionsKt.obj((ObjectNode)provider, "resource_schemas");
            ObjectNode dataSources = ExtensionsKt.obj((ObjectNode)provider, "data_source_schemas");
            if (resources == null && dataSources == null) {
                TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("No resources nor data-sources defined for provider '" + providerFullName + "' in file '" + fileName + "'");
            }
            if (resources != null) {
                ObjectNode resource;
                boolean bl = false;
                Set set2 = resource.properties();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"properties(...)");
                Iterable iterable = set2;
                destination$iv = model.getResources();
                $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    Map.Entry entry2 = (Map.Entry)item$iv;
                    object = destination$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    object.add(this.parseResourceInfo(context, it, (ProviderType)providerInfo));
                }
                List cfr_ignored_1 = (List)destination$iv;
            }
            if (dataSources != null) {
                ObjectNode dataSource;
                boolean bl = false;
                Set set3 = dataSource.properties();
                Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"properties(...)");
                $this$mapTo$iv = set3;
                destination$iv = model.getDataSources();
                $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    it = (Map.Entry)item$iv;
                    object = destination$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    object.add(this.parseDataSourceInfo(context, it, (ProviderType)providerInfo));
                }
                List cfr_ignored_2 = (List)destination$iv;
            }
            ObjectNode providerDefinedFunctions = ExtensionsKt.obj((ObjectNode)provider, "functions");
            if (providerDefinedFunctions != null) {
                ObjectNode function;
                boolean bl = false;
                Set set4 = function.properties();
                if (set4 != null) {
                    void $this$mapNotNullTo$iv2;
                    destination$iv = set4;
                    Collection destination$iv2 = model.getProviderDefinedFunctions();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv = $this$mapNotNullTo$iv2;
                    boolean $i$f$forEach = false;
                    object = $this$forEach$iv$iv.iterator();
                    while (object.hasNext()) {
                        TfFunction it$iv;
                        Object element$iv$iv;
                        Object element$iv = element$iv$iv = object.next();
                        boolean bl4 = false;
                        Map.Entry it3 = (Map.Entry)element$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)it3);
                        if (this.parseProviderFunctionInfo(context, it3, (ProviderType)providerInfo) == null) continue;
                        boolean bl6 = false;
                        destination$iv2.add(it$iv);
                    }
                    List cfr_ignored_3 = (List)destination$iv2;
                }
            }
            ObjectNode ephemeralResources = ExtensionsKt.obj((ObjectNode)provider, "ephemeral_resource_schemas");
            if (ephemeralResources == null) continue;
            boolean bl = false;
            Set set5 = ephemeralResource.properties();
            Intrinsics.checkNotNullExpressionValue((Object)set5, (String)"properties(...)");
            Iterable destination$iv2 = set5;
            Collection destination$iv3 = model.getEphemeralResources();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                EphemeralType it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl7 = false;
                Map.Entry it4 = (Map.Entry)element$iv;
                boolean bl8 = false;
                Intrinsics.checkNotNull((Object)it4);
                if (this.parseEphemeralResourceInfo(context, it4, (ProviderType)providerInfo) == null) continue;
                boolean bl9 = false;
                destination$iv3.add(it$iv);
            }
            List cfr_ignored_4 = (List)destination$iv3;
        }
    }

    private final ProviderType parseProviderInfo(LoadContext context, String name, String namespace, ObjectNode obj, ObjectNode file) {
        Pair<BlockType, Integer> pair = TfBaseLoader.INSTANCE.parseSchema(context, obj, name);
        if (pair == null) {
            return null;
        }
        Pair<BlockType, Integer> pair2 = pair;
        BlockType parsed = (BlockType)pair2.component1();
        int version = ((Number)pair2.component2()).intValue();
        ProviderMetadata providerMetadata = TfBaseLoader.INSTANCE.parseMetadata$intellij_terraform(ExtensionsKt.obj(file, "metadata"), name, namespace);
        return new ProviderType(providerMetadata.getName(), CollectionsKt.toList((Iterable)parsed.getProperties().values()), providerMetadata.getNamespace(), providerMetadata.getTier(), providerMetadata.getVersion(), parsed);
    }

    private final ResourceType parseResourceInfo(LoadContext context, Map.Entry<String, ? extends Object> entry, ProviderType info) {
        String name = LoadersKt.pool(entry.getKey(), context);
        boolean bl = entry.getValue() instanceof ObjectNode;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Right part of resource should be object";
            throw new AssertionError((Object)string);
        }
        Object object = entry.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode obj = (ObjectNode)object;
        Pair<BlockType, Integer> pair = TfBaseLoader.INSTANCE.parseSchema(context, obj, name);
        if (pair == null) {
            throw new IllegalArgumentException("can't parse schema parseResourceInfo " + name + ", entry = " + entry);
        }
        Pair<BlockType, Integer> pair2 = pair;
        BlockType parsed = (BlockType)pair2.component1();
        int version = ((Number)pair2.component2()).intValue();
        return new ResourceType(name, info, CollectionsKt.toList((Iterable)parsed.getProperties().values()), parsed);
    }

    private final DataSourceType parseDataSourceInfo(LoadContext context, Map.Entry<String, ? extends Object> entry, ProviderType info) {
        String name = LoadersKt.pool(entry.getKey(), context);
        boolean bl = entry.getValue() instanceof ObjectNode;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Right part of data-source should be object";
            throw new AssertionError((Object)string);
        }
        Object object = entry.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode obj = (ObjectNode)object;
        Pair<BlockType, Integer> pair = TfBaseLoader.INSTANCE.parseSchema(context, obj, name);
        if (pair == null) {
            throw new IllegalArgumentException("can't parse schema parseDataSourceInfo " + name + ", entry = " + entry);
        }
        Pair<BlockType, Integer> pair2 = pair;
        BlockType parsed = (BlockType)pair2.component1();
        int version = ((Number)pair2.component2()).intValue();
        return new DataSourceType(name, info, CollectionsKt.toList((Iterable)parsed.getProperties().values()), parsed);
    }

    /*
     * WARNING - void declaration
     */
    private final TfFunction parseProviderFunctionInfo(LoadContext context, Map.Entry<String, ? extends Object> entry, ProviderType info) {
        void $this$orEmpty$iv;
        Argument[] argumentArray;
        ArrayNode arrayNode;
        String returnType;
        String name = LoadersKt.pool(entry.getKey(), context);
        Object object = entry.getValue();
        ObjectNode objectNode = object instanceof ObjectNode ? (ObjectNode)object : null;
        if (objectNode == null) {
            return null;
        }
        ObjectNode objectNode2 = objectNode;
        String description = ExtensionsKt.string(objectNode2, "description");
        String string = ExtensionsKt.string(objectNode2, "return_type");
        if (string == null) {
            string = returnType = "";
        }
        if ((arrayNode = ExtensionsKt.array(objectNode2, "parameters")) != null) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = (Iterable)arrayNode;
            boolean $i$f$mapNotNull22 = false;
            void var13_12 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ObjectNode it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                JsonNode it = (JsonNode)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof ObjectNode ? (ObjectNode)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $i$f$mapNotNull22 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element$iv$iv$iv = (ObjectNode)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                String string2 = ExtensionsKt.string((ObjectNode)it, "type");
                if (string2 == null) {
                    string2 = "";
                }
                collection.add(new Argument(new HclTypeImpl(string2), ExtensionsKt.string((ObjectNode)it, "name")));
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            argumentArray = thisCollection$iv.toArray(new Argument[0]);
        } else {
            argumentArray = null;
        }
        arrayNode = argumentArray;
        boolean $i$f$orEmpty = false;
        Argument[] argumentArray2 = $this$orEmpty$iv;
        if (argumentArray2 == null) {
            argumentArray2 = new Argument[]{};
        }
        void parameters = argumentArray2;
        return new TfFunction(name, new HclTypeImpl(returnType), (Argument[])Arrays.copyOf(parameters, ((void)parameters).length), description, null, info.getType(), 16, null);
    }

    private final EphemeralType parseEphemeralResourceInfo(LoadContext context, Map.Entry<String, ? extends Object> entry, ProviderType info) {
        String name = LoadersKt.pool(entry.getKey(), context);
        Object object = entry.getValue();
        ObjectNode objectNode = object instanceof ObjectNode ? (ObjectNode)object : null;
        if (objectNode == null) {
            return null;
        }
        ObjectNode objectNode2 = objectNode;
        Pair<BlockType, Integer> pair = TfBaseLoader.INSTANCE.parseSchema(context, objectNode2, name);
        if (pair == null) {
            return null;
        }
        BlockType block = (BlockType)pair.component1();
        return new EphemeralType(name, info, block);
    }
}

