/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.patterns;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.TerraformFileType;
import org.intellij.terraform.config.TerraformLanguage;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.HCLTokenTypes;
import org.intellij.terraform.hcl.patterns.HCLPatterns;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLForIntro;
import org.intellij.terraform.hcl.psi.HCLHeredocContent;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010^\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110_2\u0006\u0010`\u001a\u00020aJ\u0014\u0010b\u001a\b\u0012\u0004\u0012\u00020/0\u00102\u0006\u0010c\u001a\u00020aR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0013R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0013R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0013R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0013R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0013R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0013R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0013R\u0017\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0013R\u0017\u00104\u001a\b\u0012\u0004\u0012\u0002020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0013R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020/0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0013R\u0017\u00108\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0013R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020/0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0013R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0013R\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0013R\u0017\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u0013R\u0017\u0010C\u001a\b\u0012\u0004\u0012\u00020/0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u0013R\u0017\u0010E\u001a\b\u0012\u0004\u0012\u00020/0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u0013R\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u0013R\u0017\u0010I\u001a\b\u0012\u0004\u0012\u00020/0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\u0013R\u0017\u0010K\u001a\b\u0012\u0004\u0012\u00020L0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\u0013R\u0017\u0010N\u001a\b\u0012\u0004\u0012\u00020/0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u0013R\u0017\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\u0013R\u0017\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u0013R\u0017\u0010V\u001a\b\u0012\u0004\u0012\u00020/0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\u0013R\u0017\u0010X\u001a\b\u0012\u0004\u0012\u00020/0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\u0013R\u0017\u0010Z\u001a\b\u0012\u0004\u0012\u00020/0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\u0013R\u0017\u0010\\\u001a\b\u0012\u0004\u0012\u00020/0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\u0013\u00a8\u0006e"}, d2={"Lorg/intellij/terraform/config/patterns/TfPsiPatterns;", "", "<init>", "()V", "TerraformFile", "Lcom/intellij/patterns/PsiFilePattern$Capture;", "Lorg/intellij/terraform/hcl/psi/HCLFile;", "getTerraformFile", "()Lcom/intellij/patterns/PsiFilePattern$Capture;", "TerraformVariablesFile", "getTerraformVariablesFile", "TerraformConfigFile", "getTerraformConfigFile", "ConfigOverrideFile", "getConfigOverrideFile", "RootBlock", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "getRootBlock", "()Lcom/intellij/patterns/PsiElementPattern$Capture;", "RootBlockForHCLFiles", "getRootBlockForHCLFiles", "ModuleRootBlock", "getModuleRootBlock", "VariableRootBlock", "getVariableRootBlock", "OutputRootBlock", "getOutputRootBlock", "ResourceRootBlock", "getResourceRootBlock", "DataSourceRootBlock", "getDataSourceRootBlock", "ProviderRootBlock", "getProviderRootBlock", "ProviderDefinedHclBlocks", "getProviderDefinedHclBlocks", "ProvisionerBlock", "getProvisionerBlock", "ResourceLifecycleBlock", "getResourceLifecycleBlock", "ResourceConnectionBlock", "getResourceConnectionBlock", "TerraformRootBlock", "getTerraformRootBlock", "RequiredProvidersBlock", "getRequiredProvidersBlock", "RequiredProvidersProperty", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "getRequiredProvidersProperty", "RequiredProviderIdentifier", "Lcom/intellij/psi/PsiElement;", "getRequiredProviderIdentifier", "IdentifierOfRequiredProviderProperty", "getIdentifierOfRequiredProviderProperty", "RequiredProvidersSource", "getRequiredProvidersSource", "LocalsRootBlock", "getLocalsRootBlock", "LocalsVariable", "getLocalsVariable", "Backend", "getBackend", "MovedBlock", "DynamicBlock", "getDynamicBlock", "DynamicBlockContent", "getDynamicBlockContent", "DynamicLabels", "getDynamicLabels", "DynamicBlockIterator", "getDynamicBlockIterator", "ModuleWithEmptySource", "getModuleWithEmptySource", "PropertyUnderModuleProvidersPOB", "getPropertyUnderModuleProvidersPOB", "ForVariable", "Lorg/intellij/terraform/hcl/psi/HCLIdentifier;", "getForVariable", "ResourceProviderProperty", "getResourceProviderProperty", "StringLiteralAnywhereInVariable", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "getStringLiteralAnywhereInVariable", "HeredocContentAnywhereInVariable", "Lorg/intellij/terraform/hcl/psi/HCLHeredocContent;", "getHeredocContentAnywhereInVariable", "DependsOnPattern", "getDependsOnPattern", "FromPropertyInMovedBlock", "getFromPropertyInMovedBlock", "LocalProperty", "getLocalProperty", "DescriptionProperty", "getDescriptionProperty", "createBlockPattern", "Lcom/intellij/patterns/PatternCondition;", "type", "", "propertyWithName", "name", "LazyInitElementPattern", "intellij.terraform"})
public final class TfPsiPatterns {
    @NotNull
    public static final TfPsiPatterns INSTANCE = new TfPsiPatterns();
    @NotNull
    private static final PsiFilePattern.Capture<HCLFile> TerraformFile;
    @NotNull
    private static final PsiFilePattern.Capture<HCLFile> TerraformVariablesFile;
    @NotNull
    private static final PsiFilePattern.Capture<HCLFile> TerraformConfigFile;
    @NotNull
    private static final PsiFilePattern.Capture<HCLFile> ConfigOverrideFile;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> RootBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> RootBlockForHCLFiles;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> ModuleRootBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> VariableRootBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> OutputRootBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> ResourceRootBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> DataSourceRootBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> ProviderRootBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> ProviderDefinedHclBlocks;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> ProvisionerBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> ResourceLifecycleBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> ResourceConnectionBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> TerraformRootBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> RequiredProvidersBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> RequiredProvidersProperty;
    @NotNull
    private static final PsiElementPattern.Capture<PsiElement> RequiredProviderIdentifier;
    @NotNull
    private static final PsiElementPattern.Capture<PsiElement> IdentifierOfRequiredProviderProperty;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> RequiredProvidersSource;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> LocalsRootBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> LocalsVariable;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> Backend;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> MovedBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> DynamicBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> DynamicBlockContent;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> DynamicLabels;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> DynamicBlockIterator;
    @NotNull
    private static final PsiElementPattern.Capture<HCLBlock> ModuleWithEmptySource;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> PropertyUnderModuleProvidersPOB;
    @NotNull
    private static final PsiElementPattern.Capture<HCLIdentifier> ForVariable;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> ResourceProviderProperty;
    @NotNull
    private static final PsiElementPattern.Capture<HCLStringLiteral> StringLiteralAnywhereInVariable;
    @NotNull
    private static final PsiElementPattern.Capture<HCLHeredocContent> HeredocContentAnywhereInVariable;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> DependsOnPattern;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> FromPropertyInMovedBlock;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> LocalProperty;
    @NotNull
    private static final PsiElementPattern.Capture<HCLProperty> DescriptionProperty;

    private TfPsiPatterns() {
    }

    @NotNull
    public final PsiFilePattern.Capture<HCLFile> getTerraformFile() {
        return TerraformFile;
    }

    @NotNull
    public final PsiFilePattern.Capture<HCLFile> getTerraformVariablesFile() {
        return TerraformVariablesFile;
    }

    @NotNull
    public final PsiFilePattern.Capture<HCLFile> getTerraformConfigFile() {
        return TerraformConfigFile;
    }

    @NotNull
    public final PsiFilePattern.Capture<HCLFile> getConfigOverrideFile() {
        return ConfigOverrideFile;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getRootBlock() {
        return RootBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getRootBlockForHCLFiles() {
        return RootBlockForHCLFiles;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getModuleRootBlock() {
        return ModuleRootBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getVariableRootBlock() {
        return VariableRootBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getOutputRootBlock() {
        return OutputRootBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getResourceRootBlock() {
        return ResourceRootBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getDataSourceRootBlock() {
        return DataSourceRootBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getProviderRootBlock() {
        return ProviderRootBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getProviderDefinedHclBlocks() {
        return ProviderDefinedHclBlocks;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getProvisionerBlock() {
        return ProvisionerBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getResourceLifecycleBlock() {
        return ResourceLifecycleBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getResourceConnectionBlock() {
        return ResourceConnectionBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getTerraformRootBlock() {
        return TerraformRootBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getRequiredProvidersBlock() {
        return RequiredProvidersBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getRequiredProvidersProperty() {
        return RequiredProvidersProperty;
    }

    @NotNull
    public final PsiElementPattern.Capture<PsiElement> getRequiredProviderIdentifier() {
        return RequiredProviderIdentifier;
    }

    @NotNull
    public final PsiElementPattern.Capture<PsiElement> getIdentifierOfRequiredProviderProperty() {
        return IdentifierOfRequiredProviderProperty;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getRequiredProvidersSource() {
        return RequiredProvidersSource;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getLocalsRootBlock() {
        return LocalsRootBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getLocalsVariable() {
        return LocalsVariable;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getBackend() {
        return Backend;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getDynamicBlock() {
        return DynamicBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getDynamicBlockContent() {
        return DynamicBlockContent;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getDynamicLabels() {
        return DynamicLabels;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getDynamicBlockIterator() {
        return DynamicBlockIterator;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLBlock> getModuleWithEmptySource() {
        return ModuleWithEmptySource;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getPropertyUnderModuleProvidersPOB() {
        return PropertyUnderModuleProvidersPOB;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLIdentifier> getForVariable() {
        return ForVariable;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getResourceProviderProperty() {
        return ResourceProviderProperty;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLStringLiteral> getStringLiteralAnywhereInVariable() {
        return StringLiteralAnywhereInVariable;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLHeredocContent> getHeredocContentAnywhereInVariable() {
        return HeredocContentAnywhereInVariable;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getDependsOnPattern() {
        return DependsOnPattern;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getFromPropertyInMovedBlock() {
        return FromPropertyInMovedBlock;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getLocalProperty() {
        return LocalProperty;
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> getDescriptionProperty() {
        return DescriptionProperty;
    }

    @NotNull
    public final PatternCondition<HCLBlock> createBlockPattern(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String string = "HCLBlock(" + type + ")";
        return (PatternCondition)new PatternCondition<HCLBlock>(type, string){
            final /* synthetic */ String $type;
            {
                this.$type = $type;
                super($super_call_param$1);
            }

            public boolean accepts(HCLBlock t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return Intrinsics.areEqual((Object)UtilKt.getNameElementUnquoted(t, 0), (Object)this.$type);
            }
        };
    }

    @NotNull
    public final PsiElementPattern.Capture<HCLProperty> propertyWithName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = "HCLProperty(" + name + ")";
        ObjectPattern objectPattern = PlatformPatterns.psiElement(HCLProperty.class).with((PatternCondition)new PatternCondition<HCLProperty>(name, string){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super($super_call_param$1);
            }

            public boolean accepts(HCLProperty t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return Intrinsics.areEqual((Object)this.$name, (Object)t.getName());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (PsiElementPattern.Capture)objectPattern;
    }

    static {
        PsiElementPattern psiElementPattern = PlatformPatterns.psiFile(HCLFile.class).withLanguage((Language)TerraformLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern, (String)"withLanguage(...)");
        TerraformFile = (PsiFilePattern.Capture)psiElementPattern;
        PsiElementPattern psiElementPattern2 = ((PsiFilePattern.Capture)PlatformPatterns.psiFile(HCLFile.class).withLanguage((Language)TerraformLanguage.INSTANCE)).inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().withExtension("tfvars"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern2, (String)"inVirtualFile(...)");
        TerraformVariablesFile = (PsiFilePattern.Capture)psiElementPattern2;
        ObjectPattern objectPattern = ((PsiFilePattern.Capture)PlatformPatterns.psiFile(HCLFile.class).withLanguage((Language)TerraformLanguage.INSTANCE)).andNot((ElementPattern)TerraformVariablesFile);
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"andNot(...)");
        TerraformConfigFile = (PsiFilePattern.Capture)objectPattern;
        PsiElementPattern psiElementPattern3 = ((PsiFilePattern.Capture)PlatformPatterns.psiFile(HCLFile.class).and((ElementPattern)TerraformConfigFile)).inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().withName((ElementPattern)StandardPatterns.string().with((PatternCondition)new PatternCondition<String>(){

            public boolean accepts(String t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                String suffix = "override." + TerraformFileType.INSTANCE.getDefaultExtension();
                if (!StringsKt.endsWith$default((String)t, (String)suffix, (boolean)false, (int)2, null)) {
                    return false;
                }
                return t.length() == suffix.length() || t.charAt(t.length() - suffix.length() - 1) == '_';
            }
        })));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"inVirtualFile(...)");
        ConfigOverrideFile = (PsiFilePattern.Capture)psiElementPattern3;
        TreeElementPattern treeElementPattern = PlatformPatterns.psiElement(HCLBlock.class).withParent((ElementPattern)TerraformConfigFile);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"withParent(...)");
        RootBlock = (PsiElementPattern.Capture)treeElementPattern;
        TreeElementPattern treeElementPattern2 = PlatformPatterns.psiElement(HCLBlock.class).withParent(HCLFile.class);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern2, (String)"withParent(...)");
        RootBlockForHCLFiles = (PsiElementPattern.Capture)treeElementPattern2;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).and((ElementPattern)RootBlock)).with(INSTANCE.createBlockPattern("module"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        ModuleRootBlock = (PsiElementPattern.Capture)psiElementPattern3;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).and((ElementPattern)RootBlock)).with(INSTANCE.createBlockPattern("variable"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        VariableRootBlock = (PsiElementPattern.Capture)psiElementPattern3;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).and((ElementPattern)RootBlock)).with(INSTANCE.createBlockPattern("output"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        OutputRootBlock = (PsiElementPattern.Capture)psiElementPattern3;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).and((ElementPattern)RootBlock)).with(INSTANCE.createBlockPattern("resource"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        ResourceRootBlock = (PsiElementPattern.Capture)psiElementPattern3;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).and((ElementPattern)RootBlock)).with(INSTANCE.createBlockPattern("data"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        DataSourceRootBlock = (PsiElementPattern.Capture)psiElementPattern3;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).withParent((ElementPattern)TerraformConfigFile)).with(INSTANCE.createBlockPattern("provider"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        ProviderRootBlock = (PsiElementPattern.Capture)psiElementPattern3;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).and((ElementPattern)RootBlock)).with((PatternCondition)new PatternCondition<HCLBlock>(){

            public boolean accepts(HCLBlock block, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                String name = UtilKt.getNameElementUnquoted(block, 0);
                Object[] objectArray = new String[]{"resource", "data", "ephemeral"};
                return CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)name);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        ProviderDefinedHclBlocks = (PsiElementPattern.Capture)psiElementPattern3;
        ElementPattern[] elementPatternArray = new ElementPattern[1];
        elementPatternArray[0] = ResourceRootBlock;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).withParent(StandardPatterns.or((ElementPattern[])elementPatternArray))).with(INSTANCE.createBlockPattern("provisioner"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        ProvisionerBlock = (PsiElementPattern.Capture)psiElementPattern3;
        elementPatternArray = new ElementPattern[1];
        elementPatternArray[0] = ResourceRootBlock;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).withParent(StandardPatterns.or((ElementPattern[])elementPatternArray))).with(INSTANCE.createBlockPattern("lifecycle"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        ResourceLifecycleBlock = (PsiElementPattern.Capture)psiElementPattern3;
        elementPatternArray = new ElementPattern[2];
        elementPatternArray[0] = ResourceRootBlock;
        elementPatternArray[1] = ProvisionerBlock;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).withParent(StandardPatterns.or((ElementPattern[])elementPatternArray))).with(INSTANCE.createBlockPattern("connection"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        ResourceConnectionBlock = (PsiElementPattern.Capture)psiElementPattern3;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).and((ElementPattern)RootBlock)).with(INSTANCE.createBlockPattern("terraform"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        TerraformRootBlock = (PsiElementPattern.Capture)psiElementPattern3;
        TreeElementPattern treeElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).with(INSTANCE.createBlockPattern("required_providers"))).withSuperParent(2, (ElementPattern)TerraformRootBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern3, (String)"withSuperParent(...)");
        RequiredProvidersBlock = (PsiElementPattern.Capture)treeElementPattern3;
        TreeElementPattern treeElementPattern4 = PlatformPatterns.psiElement(HCLProperty.class).withSuperParent(2, (ElementPattern)RequiredProvidersBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern4, (String)"withSuperParent(...)");
        RequiredProvidersProperty = (PsiElementPattern.Capture)treeElementPattern4;
        TreeElementPattern treeElementPattern5 = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)TerraformConfigFile)).withParent((ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(2, (ElementPattern)RequiredProvidersBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern5, (String)"withSuperParent(...)");
        RequiredProviderIdentifier = (PsiElementPattern.Capture)treeElementPattern5;
        TreeElementPattern treeElementPattern6 = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLElementTypes.ID)).inFile((ElementPattern)TerraformConfigFile)).inside((ElementPattern)HCLPatterns.INSTANCE.getObject().withParent((ElementPattern)RequiredProvidersProperty));
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern6, (String)"inside(...)");
        IdentifierOfRequiredProviderProperty = (PsiElementPattern.Capture)treeElementPattern6;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLProperty.class).withSuperParent(2, (ElementPattern)RequiredProvidersProperty)).with((PatternCondition)new PatternCondition<HCLProperty>(){

            public boolean accepts(HCLProperty t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return Intrinsics.areEqual((Object)t.getName(), (Object)"source");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        RequiredProvidersSource = (PsiElementPattern.Capture)psiElementPattern3;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).and((ElementPattern)RootBlock)).with(INSTANCE.createBlockPattern("locals"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        LocalsRootBlock = (PsiElementPattern.Capture)psiElementPattern3;
        TreeElementPattern treeElementPattern7 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLProperty.class).withParent(HCLObject.class)).withSuperParent(2, (ElementPattern)LocalsRootBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern7, (String)"withSuperParent(...)");
        LocalsVariable = (PsiElementPattern.Capture)treeElementPattern7;
        TreeElementPattern treeElementPattern8 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).with(INSTANCE.createBlockPattern("backend"))).withSuperParent(2, (ElementPattern)TerraformRootBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern8, (String)"withSuperParent(...)");
        Backend = (PsiElementPattern.Capture)treeElementPattern8;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).and((ElementPattern)RootBlock)).with(INSTANCE.createBlockPattern("moved"));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        MovedBlock = (PsiElementPattern.Capture)psiElementPattern3;
        Ref dynamicContentRef = new Ref();
        ElementPattern[] elementPatternArray2 = new ElementPattern[5];
        elementPatternArray2[0] = ResourceRootBlock;
        elementPatternArray2[1] = DataSourceRootBlock;
        elementPatternArray2[2] = ProviderRootBlock;
        elementPatternArray2[3] = ProvisionerBlock;
        elementPatternArray2[4] = new LazyInitElementPattern(dynamicContentRef);
        TreeElementPattern treeElementPattern9 = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).with(INSTANCE.createBlockPattern("dynamic"))).withSuperParent(2, (ElementPattern)HCLPatterns.INSTANCE.getBlock())).inside(true, StandardPatterns.or((ElementPattern[])elementPatternArray2));
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern9, (String)"inside(...)");
        DynamicBlock = (PsiElementPattern.Capture)treeElementPattern9;
        TreeElementPattern treeElementPattern10 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).with(INSTANCE.createBlockPattern("content"))).withSuperParent(2, (ElementPattern)DynamicBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern10, (String)"withSuperParent(...)");
        DynamicBlockContent = (PsiElementPattern.Capture)treeElementPattern10;
        dynamicContentRef.set(DynamicBlockContent);
        TreeElementPattern treeElementPattern11 = INSTANCE.propertyWithName("labels").withSuperParent(2, (ElementPattern)DynamicBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern11, (String)"withSuperParent(...)");
        DynamicLabels = (PsiElementPattern.Capture)treeElementPattern11;
        TreeElementPattern treeElementPattern12 = INSTANCE.propertyWithName("iterator").withSuperParent(2, (ElementPattern)DynamicBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern12, (String)"withSuperParent(...)");
        DynamicBlockIterator = (PsiElementPattern.Capture)treeElementPattern12;
        psiElementPattern3 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLBlock.class).and((ElementPattern)ModuleRootBlock)).with((PatternCondition)new PatternCondition<HCLBlock>(){

            public boolean accepts(HCLBlock t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                HCLElement hCLElement = t.getObject();
                if (hCLElement == null || (hCLElement = hCLElement.findProperty("source")) == null) {
                    return true;
                }
                HCLElement source = hCLElement;
                Object object = source.getValue();
                return object != null && (object = object.getText()) != null ? ((CharSequence)object).length() == 0 : false;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        ModuleWithEmptySource = (PsiElementPattern.Capture)psiElementPattern3;
        elementPatternArray = new ElementPattern[]{INSTANCE.propertyWithName("providers"), PlatformPatterns.psiElement(HCLBlock.class).with((PatternCondition)new PatternCondition<HCLBlock>(){

            public boolean accepts(HCLBlock t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return t.getNameElements().length == 1 && Intrinsics.areEqual((Object)t.getName(), (Object)"providers");
            }
        })};
        TreeElementPattern treeElementPattern13 = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLProperty.class).withSuperParent(1, (ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(2, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(HCLPatterns.INSTANCE.getPropertyOrBlock())).andOr(elementPatternArray))).withSuperParent(3, (ElementPattern)HCLPatterns.INSTANCE.getObject())).withSuperParent(4, (ElementPattern)ModuleRootBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern13, (String)"withSuperParent(...)");
        PropertyUnderModuleProvidersPOB = (PsiElementPattern.Capture)treeElementPattern13;
        ObjectPattern objectPattern2 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLIdentifier.class).withParent(HCLForIntro.class)).with((PatternCondition)new PatternCondition<HCLIdentifier>(){

            public boolean accepts(HCLIdentifier t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                PsiElement psiElement = t.getParent();
                HCLForIntro hCLForIntro = psiElement instanceof HCLForIntro ? (HCLForIntro)psiElement : null;
                if (hCLForIntro == null) {
                    return false;
                }
                HCLForIntro intro = hCLForIntro;
                return t == intro.getVar1() || t == intro.getVar2();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern2, (String)"with(...)");
        ForVariable = (PsiElementPattern.Capture)objectPattern2;
        elementPatternArray = new ElementPattern[2];
        elementPatternArray[0] = ResourceRootBlock;
        elementPatternArray[1] = DataSourceRootBlock;
        TreeElementPattern treeElementPattern14 = ((PsiElementPattern.Capture)INSTANCE.propertyWithName("provider").withParent(HCLObject.class)).withSuperParent(2, StandardPatterns.or((ElementPattern[])elementPatternArray));
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern14, (String)"withSuperParent(...)");
        ResourceProviderProperty = (PsiElementPattern.Capture)treeElementPattern14;
        TreeElementPattern treeElementPattern15 = PlatformPatterns.psiElement(HCLStringLiteral.class).inside(true, (ElementPattern)VariableRootBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern15, (String)"inside(...)");
        StringLiteralAnywhereInVariable = (PsiElementPattern.Capture)treeElementPattern15;
        TreeElementPattern treeElementPattern16 = PlatformPatterns.psiElement(HCLHeredocContent.class).inside(true, (ElementPattern)VariableRootBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern16, (String)"inside(...)");
        HeredocContentAnywhereInVariable = (PsiElementPattern.Capture)treeElementPattern16;
        elementPatternArray = new ElementPattern[4];
        elementPatternArray[0] = ResourceRootBlock;
        elementPatternArray[1] = DataSourceRootBlock;
        elementPatternArray[2] = ModuleRootBlock;
        elementPatternArray[3] = OutputRootBlock;
        psiElementPattern3 = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLProperty.class).withSuperParent(1, HCLObject.class)).withSuperParent(2, StandardPatterns.or((ElementPattern[])elementPatternArray))).with((PatternCondition)new PatternCondition<HCLProperty>(){

            public boolean accepts(HCLProperty t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return Intrinsics.areEqual((Object)t.getName(), (Object)"depends_on");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern3, (String)"with(...)");
        DependsOnPattern = (PsiElementPattern.Capture)psiElementPattern3;
        ObjectPattern objectPattern3 = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLProperty.class).withSuperParent(1, HCLObject.class)).withSuperParent(2, (ElementPattern)MovedBlock)).with((PatternCondition)new PatternCondition<HCLProperty>(){

            public boolean accepts(HCLProperty t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return Intrinsics.areEqual((Object)t.getName(), (Object)"from");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern3, (String)"with(...)");
        FromPropertyInMovedBlock = (PsiElementPattern.Capture)objectPattern3;
        TreeElementPattern treeElementPattern17 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(HCLProperty.class).withSuperParent(1, HCLObject.class)).withSuperParent(2, (ElementPattern)LocalsRootBlock);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern17, (String)"withSuperParent(...)");
        LocalProperty = (PsiElementPattern.Capture)treeElementPattern17;
        DescriptionProperty = INSTANCE.propertyWithName("description");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/intellij/terraform/config/patterns/TfPsiPatterns$LazyInitElementPattern;", "T", "Lcom/intellij/patterns/ElementPattern;", "delegate", "Lcom/intellij/openapi/util/Ref;", "<init>", "(Lcom/intellij/openapi/util/Ref;)V", "accepts", "", "o", "", "context", "Lcom/intellij/util/ProcessingContext;", "getCondition", "Lcom/intellij/patterns/ElementPatternCondition;", "intellij.terraform"})
    private static final class LazyInitElementPattern<T>
    implements ElementPattern<T> {
        @NotNull
        private final Ref<ElementPattern<T>> delegate;

        public LazyInitElementPattern(@NotNull Ref<ElementPattern<T>> delegate) {
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            this.delegate = delegate;
        }

        public boolean accepts(@Nullable Object o) {
            return ((ElementPattern)this.delegate.get()).accepts(o);
        }

        public boolean accepts(@Nullable Object o, @Nullable ProcessingContext context) {
            return ((ElementPattern)this.delegate.get()).accepts(o, context);
        }

        @NotNull
        public ElementPatternCondition<T> getCondition() {
            ElementPatternCondition elementPatternCondition = ((ElementPattern)this.delegate.get()).getCondition();
            Intrinsics.checkNotNullExpressionValue((Object)elementPatternCondition, (String)"getCondition(...)");
            return elementPatternCondition;
        }
    }
}

