/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.Variable;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hil.psi.HCLElementLazyReference;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/psi/ModuleVariableReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nModuleVariableReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleVariableReferenceProvider.kt\norg/intellij/terraform/config/psi/ModuleVariableReferenceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1563#2:47\n1634#2,3:48\n1563#2:51\n1634#2,3:52\n*S KotlinDebug\n*F\n+ 1 ModuleVariableReferenceProvider.kt\norg/intellij/terraform/config/psi/ModuleVariableReferenceProvider\n*L\n39#1:47\n39#1:48,3\n42#1:51\n42#1:52,3\n*E\n"})
public final class ModuleVariableReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final ModuleVariableReferenceProvider INSTANCE = new ModuleVariableReferenceProvider();

    private ModuleVariableReferenceProvider() {
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(element instanceof HCLIdentifier)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        if (!HCLPsiUtil.INSTANCE.isPropertyKey(element)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        HCLBlock hCLBlock = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)element, HCLBlock.class, (boolean)true);
        if (hCLBlock == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        HCLBlock block = hCLBlock;
        String string = UtilKt.getNameElementUnquoted(block, 0);
        if (string == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        String type = string;
        if (!Intrinsics.areEqual((Object)type, (Object)"module")) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        if (Module.Companion.getAsModuleBlock(block) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        HCLElementLazyReference[] hCLElementLazyReferenceArray = new HCLElementLazyReference[]{new HCLElementLazyReference(element, false, null, ModuleVariableReferenceProvider::getReferencesByElement$lambda$0, 4, null)};
        return (PsiReference[])hCLElementLazyReferenceArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getReferencesByElement$lambda$0(HCLElementLazyReference $this$HCLElementLazyReference, boolean incomplete, boolean bl) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$HCLElementLazyReference, (String)"$this$HCLElementLazyReference");
        PsiElement psiElement = $this$HCLElementLazyReference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        HCLIdentifier element = (HCLIdentifier)psiElement;
        HCLBlock hCLBlock = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)element, HCLBlock.class, (boolean)true);
        if (hCLBlock == null) {
            return CollectionsKt.emptyList();
        }
        HCLBlock block = hCLBlock;
        String string = UtilKt.getNameElementUnquoted(block, 0);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String type = string;
        if (!Intrinsics.areEqual((Object)type, (Object)"module")) {
            return CollectionsKt.emptyList();
        }
        Module module = Module.Companion.getAsModuleBlock(block);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        if (incomplete) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = module2.getAllVariables();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Variable variable = (Variable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getDeclaration());
            }
            list = (List)destination$iv$iv;
        } else {
            void $this$mapTo$iv$iv;
            String string2 = element.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
            String value = string2;
            Iterable $this$map$iv = module2.findVariables(StringsKt.substringBefore$default((String)value, (char)'.', null, (int)2, null));
            boolean $i$f$map = false;
            Iterable destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Variable bl2 = (Variable)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it.getDeclaration());
            }
            list = (List)destination$iv$iv2;
        }
        return list;
    }
}

