/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.refactoring;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.psi.TfElementGenerator;
import org.intellij.terraform.config.refactoring.BaseIntroduceOperation;
import org.intellij.terraform.config.refactoring.BaseIntroduceVariableHandler;
import org.intellij.terraform.config.refactoring.IntroduceOperation;
import org.intellij.terraform.config.refactoring.IntroduceValidator;
import org.intellij.terraform.config.refactoring.TfIntroduceVariableHandler;
import org.intellij.terraform.config.refactoring.TfIntroduceVariableHandlerKt;
import org.intellij.terraform.config.refactoring.VariableIntroduceDialog;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLTokenTypes;
import org.intellij.terraform.hcl.navigation.HCLQualifiedNameProvider;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLElementGenerator;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.common.BaseExpression;
import org.intellij.terraform.hil.refactoring.ILIntroduceVariableHandler;
import org.intellij.terraform.hil.refactoring.ILRefactoringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000 12\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\"\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0005J\u0012\u0010\u0016\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0005J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0004J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0004J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0004J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u0006H\u0004J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0015H\u0004J\u001a\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J \u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010$\u001a\u00020\u0002H\u0004J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\"0.2\u0006\u0010$\u001a\u00020\u0002H\u0002J\u0010\u0010/\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0004J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\"0.2\u0006\u0010$\u001a\u00020\u0002H\u0004R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00062"}, d2={"Lorg/intellij/terraform/config/refactoring/TfIntroduceVariableHandler;", "Lorg/intellij/terraform/config/refactoring/BaseIntroduceVariableHandler;", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "<init>", "()V", "createOperation", "Lorg/intellij/terraform/config/refactoring/IntroduceOperation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "performAction", "", "operation", "Lorg/intellij/terraform/config/refactoring/BaseIntroduceOperation;", "smartIntroduce", "", "checkIntroduceContext", "element", "Lcom/intellij/psi/PsiElement;", "isValidIntroduceContext", "isValidIntroduceVariant", "performActionOnElement", "performActionOnElementOccurrences", "performInplaceIntroduce", "performIntroduceWithDialog", "performRefactoring", "createDeclaration", "performReplace", "declaration", "createExpression", "name", "", "replaceExpression", "expression", "newExpression", "addDeclaration", "getOccurrences", "", "validator", "Lorg/intellij/terraform/config/refactoring/IntroduceValidator;", "getValidator", "()Lorg/intellij/terraform/config/refactoring/IntroduceValidator;", "getSuggestedNames", "", "ensureName", "generateSuggestedNames", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfIntroduceVariableHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfIntroduceVariableHandler.kt\norg/intellij/terraform/config/refactoring/TfIntroduceVariableHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n37#2,2:417\n774#3:419\n865#3,2:420\n1#4:422\n*S KotlinDebug\n*F\n+ 1 TfIntroduceVariableHandler.kt\norg/intellij/terraform/config/refactoring/TfIntroduceVariableHandler\n*L\n227#1:417,2\n355#1:419\n355#1:420,2\n*E\n"})
public final class TfIntroduceVariableHandler
extends BaseIntroduceVariableHandler<HCLElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntroduceValidator validator = new IntroduceValidator();

    @NotNull
    protected IntroduceOperation createOperation(@NotNull Editor editor, @NotNull PsiFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new IntroduceOperation(project, editor, file, null);
    }

    @Override
    public void performAction(@NotNull BaseIntroduceOperation<HCLElement> operation) {
        TemplateState templateState;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        if (!(operation instanceof IntroduceOperation)) {
            return;
        }
        PsiFile file = ((IntroduceOperation)operation).getFile();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)((PsiElement)file))) {
            return;
        }
        Editor editor = ((IntroduceOperation)operation).getEditor();
        if (editor.getSettings().isVariableInplaceRenameEnabled() && (templateState = TemplateManagerImpl.getTemplateState((Editor)((IntroduceOperation)operation).getEditor())) != null && !templateState.isFinished()) {
            return;
        }
        PsiElement element1 = null;
        PsiElement element2 = null;
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        if (selectionModel2.hasSelection()) {
            element1 = file.findElementAt(selectionModel2.getSelectionStart());
            element2 = file.findElementAt(selectionModel2.getSelectionEnd() - 1);
            if (element1 instanceof PsiWhiteSpace) {
                int startOffset = ((PsiWhiteSpace)element1).getTextRange().getEndOffset();
                element1 = file.findElementAt(startOffset);
            }
            if (element2 instanceof PsiWhiteSpace) {
                int endOffset = ((PsiWhiteSpace)element2).getTextRange().getStartOffset();
                element2 = file.findElementAt(endOffset - 1);
            }
        } else {
            if (this.smartIntroduce((IntroduceOperation)operation)) {
                return;
            }
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            CaretModel caretModel2 = caretModel;
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int lineNumber = document2.getLineNumber(caretModel2.getOffset());
            if (lineNumber >= 0 && lineNumber < document2.getLineCount()) {
                element1 = file.findElementAt(document2.getLineStartOffset(lineNumber));
                element2 = file.findElementAt(document2.getLineEndOffset(lineNumber) - 1);
            }
        }
        Project project = ((IntroduceOperation)operation).getProject();
        if (element1 == null || element2 == null) {
            BaseIntroduceVariableHandler.Companion.showCannotPerformError(project, editor);
            return;
        }
        if ((element1 = (PsiElement)Companion.getSelectedExpression(project, file, element1, element2)) == null || !this.isValidIntroduceVariant(element1)) {
            BaseIntroduceVariableHandler.Companion.showCannotPerformError(project, editor);
            return;
        }
        if (!this.checkIntroduceContext(file, editor, element1)) {
            return;
        }
        ((IntroduceOperation)operation).setElement(element1);
        this.performActionOnElement((IntroduceOperation)operation);
    }

    private final boolean smartIntroduce(IntroduceOperation operation) {
        int offset;
        Editor editor = operation.getEditor();
        PsiFile file = operation.getFile();
        PsiElement elementAtCaret = file.findElementAt(offset = editor.getCaretModel().getOffset());
        if ((elementAtCaret instanceof PsiWhiteSpace && offset == ((PsiWhiteSpace)elementAtCaret).getTextOffset() || elementAtCaret == null) && offset > 0) {
            elementAtCaret = file.findElementAt(offset - 1);
        }
        if (!this.checkIntroduceContext(file, editor, elementAtCaret) || elementAtCaret == null) {
            return true;
        }
        SmartList expressions = new SmartList();
        PsiTreeUtil.treeWalkUp((PsiElement)elementAtCaret, null, (arg_0, arg_1) -> TfIntroduceVariableHandler.smartIntroduce$lambda$0(this, expressions, arg_0, arg_1));
        if (expressions.isEmpty()) {
            return false;
        }
        if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            operation.setElement((PsiElement)expressions.get(0));
            this.performActionOnElement(operation);
            return true;
        }
        IntroduceTargetChooser.showChooser((Editor)editor, (List)((List)expressions), (Pass)((Pass)new Pass<HCLElement>(operation, this){
            final /* synthetic */ IntroduceOperation $operation;
            final /* synthetic */ TfIntroduceVariableHandler this$0;
            {
                this.$operation = $operation;
                this.this$0 = $receiver;
            }

            public void pass(HCLElement expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                this.$operation.setElement(expression);
                TfIntroduceVariableHandler.access$performActionOnElement(this.this$0, this.$operation);
            }
        }), arg_0 -> TfIntroduceVariableHandler.smartIntroduce$lambda$1(smartIntroduce.3.INSTANCE, arg_0));
        return true;
    }

    @Contract(value="_,_,null -> false")
    protected final boolean checkIntroduceContext(@NotNull PsiFile file, @NotNull Editor editor, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!this.isValidIntroduceContext(element)) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BaseIntroduceVariableHandler.Companion.showCannotPerformError(project, editor);
            return false;
        }
        return true;
    }

    @Contract(value="null -> false")
    protected final boolean isValidIntroduceContext(@Nullable PsiElement element) {
        return element != null;
    }

    private final boolean isValidIntroduceVariant(PsiElement element) {
        if (HCLTokenTypes.STRING_LITERALS.contains(element.getNode().getElementType())) {
            PsiElement psiElement = element.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
            return this.isValidIntroduceVariant(psiElement);
        }
        if (!(element instanceof HCLStringLiteral)) {
            return false;
        }
        PsiElement psiElement = ((HCLStringLiteral)element).getParent();
        HCLProperty hCLProperty = psiElement instanceof HCLProperty ? (HCLProperty)psiElement : null;
        if (hCLProperty == null) {
            return false;
        }
        HCLProperty property = hCLProperty;
        return property.getValue() == element;
    }

    private final void performActionOnElement(IntroduceOperation operation) {
        PsiElement element = operation.getElement();
        HCLElement initializer = (HCLElement)element;
        operation.setInitializer((PsiElement)initializer);
        if (initializer != null) {
            operation.setOccurrences(this.getOccurrences(element, initializer));
            operation.setSuggestedNames(this.getSuggestedNames(initializer));
        }
        if (operation.getOccurrences().isEmpty()) {
            operation.setReplaceAll(false);
        }
        this.performActionOnElementOccurrences(operation);
    }

    protected final void performActionOnElementOccurrences(@NotNull IntroduceOperation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Editor editor = operation.getEditor();
        if (editor.getSettings().isVariableInplaceRenameEnabled()) {
            this.ensureName(operation);
            if (operation.isReplaceAll()) {
                this.performInplaceIntroduce(operation);
            } else {
                OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)operation.getElement(), operation.getOccurrences(), (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(operation, this){
                    final /* synthetic */ IntroduceOperation $operation;
                    final /* synthetic */ TfIntroduceVariableHandler this$0;
                    {
                        this.$operation = $operation;
                        this.this$0 = $receiver;
                    }

                    public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                        Intrinsics.checkNotNullParameter((Object)replaceChoice, (String)"replaceChoice");
                        this.$operation.setReplaceAll(replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
                        this.this$0.performInplaceIntroduce(this.$operation);
                    }
                });
            }
        } else {
            this.performIntroduceWithDialog(operation);
        }
    }

    protected final void performInplaceIntroduce(@NotNull IntroduceOperation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        PsiElement statement = this.performRefactoring(operation);
        if (statement instanceof HCLBlock) {
            List<PsiElement> occurrences = operation.getOccurrences();
            PsiElement occurrence = ILIntroduceVariableHandler.Companion.findOccurrenceUnderCaret(occurrences, operation.getEditor());
            operation.getEditor().getCaretModel().moveToOffset(((HCLBlock)statement).getTextOffset());
            Editor editor = operation.getEditor();
            Project project = operation.getProject();
            String string = HCLBundle.message("hil.inplace.variable.introducer.title", new Object[0]);
            Collection $this$toTypedArray$iv = operation.getOccurrences();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PsiElement[] psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
            InplaceVariableIntroducer introducer2 = (InplaceVariableIntroducer)new InplaceVariableIntroducer<PsiElement>(statement, editor, project, string, psiElementArray){
                final /* synthetic */ PsiElement $statement;
                {
                    this.$statement = $statement;
                    super((PsiNamedElement)$statement, $super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, null);
                }

                protected PsiElement checkLocalScope() {
                    return (PsiElement)((HCLBlock)this.$statement).getContainingFile();
                }
            };
            introducer2.performInplaceRefactoring(new LinkedHashSet<String>(operation.getSuggestedNames()));
        }
    }

    protected final void performIntroduceWithDialog(@NotNull IntroduceOperation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Project project = operation.getProject();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.ensureName(operation);
        }
        if (operation.getName() == null) {
            VariableIntroduceDialog dialog = new VariableIntroduceDialog(project, HCLBundle.message("introduce.variable.title", new Object[0]), this.validator, operation);
            if (!dialog.showAndGet()) {
                return;
            }
            operation.setName(dialog.getName());
            operation.setReplaceAll(dialog.doReplaceAllOccurrences());
        }
        PsiElement psiElement = this.performRefactoring(operation);
        if (psiElement == null) {
            return;
        }
        PsiElement declaration = psiElement;
        Editor editor = operation.getEditor();
        editor.getCaretModel().moveToOffset(declaration.getTextRange().getEndOffset());
        editor.getSelectionModel().removeSelection();
    }

    @Nullable
    protected final PsiElement performRefactoring(@NotNull IntroduceOperation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        PsiElement declaration = this.createDeclaration(operation);
        if (declaration == null) {
            BaseIntroduceVariableHandler.Companion.showCannotPerformError(operation.getProject(), operation.getEditor());
            return null;
        }
        declaration = this.performReplace(declaration, operation);
        declaration = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)declaration);
        return declaration;
    }

    private final PsiElement createDeclaration(IntroduceOperation operation) {
        HCLElement hCLElement = (HCLElement)operation.getInitializer();
        if (hCLElement == null) {
            return null;
        }
        HCLElement expr = hCLElement;
        String string = operation.getName();
        if (string == null) {
            return null;
        }
        String name = string;
        HclType hclType = TfIntroduceVariableHandlerKt.access$getExpectedType(expr);
        if (hclType == null) {
            BaseExpression baseExpression = expr instanceof BaseExpression ? (BaseExpression)((Object)expr) : null;
            hclType = baseExpression != null ? ExtensionsKt.getType(baseExpression) : null;
            if (hclType == null) {
                hclType = Types.INSTANCE.getString();
            }
        }
        HclType type = hclType;
        return new TfElementGenerator(operation.getProject()).createVariable(name, type, expr);
    }

    private final PsiElement performReplace(PsiElement declaration, IntroduceOperation operation) {
        Object t = operation.getInitializer();
        Intrinsics.checkNotNull(t);
        HCLElement expression = (HCLElement)t;
        Project project = operation.getProject();
        PsiFile[] psiFileArray = new PsiFile[]{expression.getContainingFile()};
        Object object = WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])psiFileArray).compute(() -> TfIntroduceVariableHandler.performReplace$lambda$0(declaration, project, this, operation, expression));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (PsiElement)object;
    }

    private final PsiElement createExpression(Project project, String name) {
        return HCLElementGenerator.createStringLiteral$default(new TfElementGenerator(project), "${var." + name + "}", null, 2, null);
    }

    @NotNull
    protected final PsiElement replaceExpression(@NotNull PsiElement expression, @NotNull PsiElement newExpression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)newExpression, (String)"newExpression");
        PsiElement psiElement = expression.replace(newExpression);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"replace(...)");
        return psiElement;
    }

    private final PsiElement addDeclaration(IntroduceOperation operation, PsiElement declaration) {
        PsiElement anchor;
        if (operation.isReplaceAll()) {
            v0 = ILIntroduceVariableHandler.Companion.findAnchor(operation.getOccurrences());
        } else {
            Object t = operation.getInitializer();
            Intrinsics.checkNotNull(t);
            v0 = anchor = ILIntroduceVariableHandler.Companion.findAnchor((PsiElement)t);
        }
        if (anchor == null) {
            CommonRefactoringUtil.showErrorHint((Project)operation.getProject(), (Editor)operation.getEditor(), (String)RefactoringBundle.getCannotRefactorMessage((String)HCLBundle.message("refactoring.introduce.anchor.error", new Object[0])), (String)HCLBundle.message("refactoring.introduce.error", new Object[0]), null);
            return null;
        }
        return anchor.getParent().addBefore(declaration, anchor);
    }

    @NotNull
    protected final List<PsiElement> getOccurrences(@Nullable PsiElement element, @NotNull HCLElement expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiElement context = null;
        context = (PsiElement)expression.getContainingFile();
        return ILRefactoringUtil.INSTANCE.getOccurrences(expression, context);
    }

    @NotNull
    public final IntroduceValidator getValidator() {
        return this.validator;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> getSuggestedNames(HCLElement expression) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Collection<String> candidates = this.generateSuggestedNames(expression);
        Iterable iterable = candidates;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.validator.checkPossibleName(it, expression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List res = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (res.isEmpty()) {
            for (String name : candidates) {
                int index = 1;
                while (!this.validator.checkPossibleName(name + index, expression)) {
                    ++index;
                }
                res.add(name + index);
            }
        }
        if (res.isEmpty()) {
            ((Collection)res).add("a");
        }
        return res;
    }

    protected final void ensureName(@NotNull IntroduceOperation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        if (operation.getName() == null) {
            Collection<String> suggestedNames = operation.getSuggestedNames();
            Collection<String> collection = suggestedNames;
            if (!(collection == null || collection.isEmpty())) {
                operation.setName((String)CollectionsKt.first((Iterable)suggestedNames));
            } else {
                operation.setName("x");
            }
        }
    }

    @NotNull
    protected final Collection<String> generateSuggestedNames(@NotNull HCLElement expression) {
        HclType type;
        HclType hclType;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        String text = expression.getText();
        PsiElement parent = expression.getParent();
        if (parent instanceof HCLProperty) {
            candidates.add(((HCLProperty)parent).getName());
        }
        String string = HCLQualifiedNameProvider.Companion.getQualifiedName(parent);
        if (string != null) {
            String it = string;
            boolean bl = false;
            ((Collection)candidates).add(it);
        }
        if (text != null) {
            candidates.addAll(ILRefactoringUtil.INSTANCE.generateNames(text));
        }
        if ((hclType = TfIntroduceVariableHandlerKt.access$getExpectedType(expression)) == null) {
            BaseExpression baseExpression = expression instanceof BaseExpression ? (BaseExpression)((Object)expression) : null;
            hclType = baseExpression != null ? ExtensionsKt.getType(baseExpression) : null;
        }
        if ((type = hclType) != null) {
            candidates.addAll(ILRefactoringUtil.INSTANCE.generateNamesByType(type.getPresentableText()));
        }
        return candidates;
    }

    private static final boolean smartIntroduce$lambda$0(TfIntroduceVariableHandler this$0, SmartList $expressions, PsiElement elem, PsiElement psiElement) {
        if (elem instanceof PsiFile || elem instanceof HCLBlock || elem instanceof HCLProperty) {
            return false;
        }
        if (elem instanceof HCLElement && this$0.isValidIntroduceVariant(elem)) {
            $expressions.add((Object)elem);
        }
        return true;
    }

    private static final String smartIntroduce$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PsiElement performReplace$lambda$0(PsiElement $declaration, Project $project, TfIntroduceVariableHandler this$0, IntroduceOperation $operation, HCLElement $expression) {
        try {
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement($declaration);
            MessageBus messageBus = $project.getMessageBus();
            Topic topic = RefactoringEventListener.REFACTORING_EVENT_TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"REFACTORING_EVENT_TOPIC");
            ((RefactoringEventListener)messageBus.syncPublisher(topic)).refactoringStarted(ILIntroduceVariableHandler.Companion.getREFACTORING_ID(), afterData);
            PsiElement result2 = this$0.addDeclaration($operation, $declaration);
            String string = $operation.getName();
            Intrinsics.checkNotNull((Object)string);
            PsiElement newExpression = this$0.createExpression($project, string);
            if ($operation.isReplaceAll()) {
                ArrayList<PsiElement> newOccurrences = new ArrayList<PsiElement>();
                for (PsiElement occurrence : $operation.getOccurrences()) {
                    PsiElement replaced = this$0.replaceExpression(occurrence, newExpression);
                    newOccurrences.add(replaced);
                }
                $operation.setOccurrences((List<PsiElement>)newOccurrences);
            } else {
                PsiElement replaced = this$0.replaceExpression($expression, newExpression);
                $operation.setOccurrences(CollectionsKt.listOf((Object)replaced));
            }
            PsiElement psiElement = result2;
            return psiElement;
        }
        finally {
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement($declaration);
            MessageBus messageBus = $project.getMessageBus();
            Topic topic = RefactoringEventListener.REFACTORING_EVENT_TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"REFACTORING_EVENT_TOPIC");
            ((RefactoringEventListener)messageBus.syncPublisher(topic)).refactoringDone(ILIntroduceVariableHandler.Companion.getREFACTORING_ID(), afterData);
        }
    }

    public static final /* synthetic */ void access$performActionOnElement(TfIntroduceVariableHandler $this, IntroduceOperation operation) {
        $this.performActionOnElement(operation);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lorg/intellij/terraform/config/refactoring/TfIntroduceVariableHandler$Companion;", "", "<init>", "()V", "getSelectedExpression", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "element1", "Lcom/intellij/psi/PsiElement;", "element2", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final HCLElement getSelectedExpression(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement element1, @NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)element1, (String)"element1");
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element2");
            PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
            if (parent != null && !(parent instanceof HCLElement)) {
                parent = PsiTreeUtil.getParentOfType((PsiElement)parent, HCLElement.class);
            }
            if (parent == null) {
                return null;
            }
            if (!(parent instanceof HCLElement)) {
                return null;
            }
            if (element1 == PsiTreeUtil.getDeepestFirst((PsiElement)parent) && element2 == PsiTreeUtil.getDeepestLast((PsiElement)parent)) {
                return (HCLElement)parent;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

