/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WslPath;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.intellij.terraform.config.TfConstants;
import org.intellij.terraform.config.util.HistoryProcessListener;
import org.intellij.terraform.config.util.TfCommandLineService;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.install.TfToolType;
import org.intellij.terraform.runtime.TfToolConfigurable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TfExecutor {
    private static final Logger LOGGER = Logger.getInstance(TfExecutor.class);
    @NotNull
    private final Map<String, String> myExtraEnvironment;
    @NotNull
    private final ParametersList myParameterList;
    @NotNull
    private final ProcessOutput myProcessOutput;
    @NotNull
    private final Project myProject;
    @Nullable
    private String myWorkDirectory;
    private boolean myShowOutputOnError;
    private boolean myShowNotificationsOnError;
    private boolean myShowNotificationsOnSuccess;
    private GeneralCommandLine.ParentEnvironmentType myParentEnvironmentType;
    private boolean myPtyDisabled;
    @Nullable
    private String myExePath;
    @Nullable
    @Nls
    private String myPresentableName;
    private OSProcessHandler myProcessHandler;
    private final Collection<ProcessListener> myProcessListeners;
    private final TfToolType myToolType;

    private TfExecutor(@NotNull Project project, TfToolType toolType) {
        if (project == null) {
            TfExecutor.$$$reportNull$$$0(0);
        }
        this.myExtraEnvironment = new HashMap<String, String>();
        this.myParameterList = new ParametersList();
        this.myProcessOutput = new ProcessOutput();
        this.myParentEnvironmentType = GeneralCommandLine.ParentEnvironmentType.CONSOLE;
        this.myProcessListeners = new ArrayList<ProcessListener>();
        this.myProject = project;
        this.myToolType = toolType;
        this.myExePath = toolType.getToolSettings(project).getToolPath();
    }

    @NotNull
    public static TfExecutor in(@NotNull Project project, TfToolType toolType) {
        if (project == null) {
            TfExecutor.$$$reportNull$$$0(1);
        }
        return new TfExecutor(project, toolType);
    }

    @NotNull
    public TfExecutor withPresentableName(@Nullable @Nls String presentableName) {
        this.myPresentableName = presentableName;
        TfExecutor tfExecutor = this;
        if (tfExecutor == null) {
            TfExecutor.$$$reportNull$$$0(2);
        }
        return tfExecutor;
    }

    @NotNull
    public TfExecutor withExePath(@Nullable String exePath) {
        this.myExePath = exePath;
        TfExecutor tfExecutor = this;
        if (tfExecutor == null) {
            TfExecutor.$$$reportNull$$$0(3);
        }
        return tfExecutor;
    }

    @NotNull
    public TfExecutor withWorkDirectory(@Nullable String workDirectory) {
        this.myWorkDirectory = workDirectory;
        TfExecutor tfExecutor = this;
        if (tfExecutor == null) {
            TfExecutor.$$$reportNull$$$0(4);
        }
        return tfExecutor;
    }

    public TfExecutor withProcessListener(@NotNull ProcessListener listener) {
        if (listener == null) {
            TfExecutor.$$$reportNull$$$0(5);
        }
        this.myProcessListeners.add(listener);
        return this;
    }

    @NotNull
    public TfExecutor withExtraEnvironment(@NotNull Map<String, String> environment) {
        if (environment == null) {
            TfExecutor.$$$reportNull$$$0(6);
        }
        this.myExtraEnvironment.putAll(environment);
        TfExecutor tfExecutor = this;
        if (tfExecutor == null) {
            TfExecutor.$$$reportNull$$$0(7);
        }
        return tfExecutor;
    }

    @NotNull
    public TfExecutor withPassParentEnvironment(boolean passParentEnvironment) {
        this.myParentEnvironmentType = passParentEnvironment ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE;
        TfExecutor tfExecutor = this;
        if (tfExecutor == null) {
            TfExecutor.$$$reportNull$$$0(8);
        }
        return tfExecutor;
    }

    @NotNull
    public TfExecutor withParameterString(@NotNull String parameterString) {
        if (parameterString == null) {
            TfExecutor.$$$reportNull$$$0(9);
        }
        this.myParameterList.addParametersString(parameterString);
        TfExecutor tfExecutor = this;
        if (tfExecutor == null) {
            TfExecutor.$$$reportNull$$$0(10);
        }
        return tfExecutor;
    }

    @NotNull
    public TfExecutor withParameters(String ... parameters) {
        if (parameters == null) {
            TfExecutor.$$$reportNull$$$0(11);
        }
        this.myParameterList.addAll(parameters);
        TfExecutor tfExecutor = this;
        if (tfExecutor == null) {
            TfExecutor.$$$reportNull$$$0(12);
        }
        return tfExecutor;
    }

    @NotNull
    public TfExecutor withParameters(@NotNull List<String> parameters) {
        if (parameters == null) {
            TfExecutor.$$$reportNull$$$0(13);
        }
        this.myParameterList.addAll(parameters);
        TfExecutor tfExecutor = this;
        if (tfExecutor == null) {
            TfExecutor.$$$reportNull$$$0(14);
        }
        return tfExecutor;
    }

    @NotNull
    public TfExecutor showOutputOnError() {
        this.myShowOutputOnError = true;
        TfExecutor tfExecutor = this;
        if (tfExecutor == null) {
            TfExecutor.$$$reportNull$$$0(15);
        }
        return tfExecutor;
    }

    @NotNull
    public TfExecutor disablePty() {
        this.myPtyDisabled = true;
        TfExecutor tfExecutor = this;
        if (tfExecutor == null) {
            TfExecutor.$$$reportNull$$$0(16);
        }
        return tfExecutor;
    }

    @NotNull
    public TfExecutor showNotifications(boolean onError, boolean onSuccess) {
        this.myShowNotificationsOnError = onError;
        this.myShowNotificationsOnSuccess = onSuccess;
        TfExecutor tfExecutor = this;
        if (tfExecutor == null) {
            TfExecutor.$$$reportNull$$$0(17);
        }
        return tfExecutor;
    }

    @Nullable
    public String getWorkDirectory() {
        return this.myWorkDirectory;
    }

    public boolean execute() {
        return this.execute((ExecutionMode)new ExecutionModes.SameThreadMode(this.getPresentableName()));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    public boolean execute(ExecutionMode executionMode) {
        ThreadingAssertions.assertBackgroundThread();
        Logger.getInstance(this.getClass()).assertTrue(this.myProcessHandler == null, (Object)"Process has already run with this executor instance");
        final Ref result2 = Ref.create((Object)false);
        GeneralCommandLine commandLine = null;
        try {
            void executionMode2;
            commandLine = this.createCommandLine();
            GeneralCommandLine finalCommandLine = ((TfCommandLineService)ApplicationManager.getApplication().getService(TfCommandLineService.class)).wrapCommandLine(commandLine);
            this.myProcessHandler = new KillableColoredProcessHandler(finalCommandLine);
            final HistoryProcessListener historyProcessListener = new HistoryProcessListener();
            this.myProcessHandler.addProcessListener((ProcessListener)historyProcessListener);
            for (ProcessListener listener : this.myProcessListeners) {
                this.myProcessHandler.addProcessListener(listener);
            }
            CapturingProcessAdapter processAdapter = new CapturingProcessAdapter(this.myProcessOutput){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.processTerminated(event);
                    boolean success = event.getExitCode() == 0 && TfExecutor.this.myProcessOutput.getStderr().isEmpty();
                    boolean nothingToShow = TfExecutor.this.myProcessOutput.getStdout().isEmpty() && TfExecutor.this.myProcessOutput.getStderr().isEmpty();
                    boolean cancelledByUser = (event.getExitCode() == -1 || event.getExitCode() == 2) && nothingToShow;
                    result2.set((Object)success);
                    if (success) {
                        if (TfExecutor.this.myShowNotificationsOnSuccess) {
                            TfExecutor.this.showNotification(HCLBundle.message("TfExecutor.finished.successfully.notification.text", new Object[0]), NotificationType.INFORMATION);
                        }
                    } else if (cancelledByUser) {
                        if (TfExecutor.this.myShowNotificationsOnError) {
                            TfExecutor.this.showNotification(HCLBundle.message("TfExecutor.interrupted.notification.text", new Object[0]), NotificationType.WARNING);
                        }
                    } else if (TfExecutor.this.myShowOutputOnError) {
                        ApplicationManager.getApplication().invokeLater(() -> TfExecutor.this.showOutput(TfExecutor.this.myProcessHandler, historyProcessListener));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/terraform/config/util/TfExecutor$1", "processTerminated"));
                }
            };
            this.myProcessHandler.addProcessListener((ProcessListener)processAdapter);
            this.myProcessHandler.startNotify();
            ExecutionHelper.executeExternalProcess((Project)this.myProject, (ProcessHandler)this.myProcessHandler, (ExecutionMode)executionMode2, (GeneralCommandLine)commandLine);
            LOGGER.debug("Finished `" + this.getPresentableName() + "` with result: " + String.valueOf(result2.get()));
            return (Boolean)result2.get();
        }
        catch (ExecutionException e) {
            if (this.myShowOutputOnError) {
                ExecutionHelper.showErrors((Project)this.myProject, Collections.singletonList(e), (String)this.getPresentableName(), null);
            }
            if (this.myShowNotificationsOnError) {
                this.showNotification(StringUtil.notNullize((String)e.getMessage(), (String)HCLBundle.message("TfExecutor.unknown.error.notification.text", new Object[0])), NotificationType.ERROR);
            }
            String commandLineInfo = commandLine != null ? commandLine.getCommandLineString() : "not constructed";
            LOGGER.debug("Finished `" + this.getPresentableName() + "` with an exception. Commandline: " + commandLineInfo, (Throwable)e);
            return false;
        }
    }

    @Nullable
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    private void showNotification(@NotNull @Nls String message, NotificationType type) {
        if (message == null) {
            TfExecutor.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String title = this.getPresentableName();
            Notification notification = TfConstants.getNotificationGroup().createNotification(title, message, type);
            if (type == NotificationType.ERROR) {
                notification.addAction((AnAction)new NotificationAction(this, HCLBundle.message("terraform.open.settings", new Object[0])){

                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (notification == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        ShowSettingsUtil.getInstance().showSettingsDialog(e.getProject(), TfToolConfigurable.class);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                        }
                        objectArray[1] = "org/intellij/terraform/config/util/TfExecutor$2";
                        objectArray[2] = "actionPerformed";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
        });
    }

    private void showOutput(@NotNull OSProcessHandler originalHandler, @NotNull HistoryProcessListener historyProcessListener) {
        if (originalHandler == null) {
            TfExecutor.$$$reportNull$$$0(19);
        }
        if (historyProcessListener == null) {
            TfExecutor.$$$reportNull$$$0(20);
        }
        if (this.myShowOutputOnError) {
            KillableColoredProcessHandler outputHandler = new KillableColoredProcessHandler(originalHandler.getProcess(), null);
            RunContentExecutor runContentExecutor = new RunContentExecutor(this.myProject, (ProcessHandler)outputHandler).withTitle(this.getPresentableName()).withActivateToolWindow(this.myShowOutputOnError);
            Disposer.register((Disposable)this.myProject, (Disposable)runContentExecutor);
            runContentExecutor.run();
            historyProcessListener.apply((ProcessHandler)outputHandler);
        }
        if (this.myShowNotificationsOnError) {
            this.showNotification(HCLBundle.message("TfExecutor.failed.to.run.notification.text", new Object[0]), NotificationType.ERROR);
        }
    }

    @NotNull
    public GeneralCommandLine createCommandLine() throws ExecutionException {
        String exePath = Objects.requireNonNull(this.myExePath);
        WslPath wslPath = WslPath.parseWindowsUncPath((String)exePath);
        if (wslPath != null) {
            exePath = wslPath.getLinuxPath();
        }
        GeneralCommandLine commandLine = !this.myPtyDisabled && PtyCommandLine.isEnabled() ? new PtyCommandLine() : new GeneralCommandLine();
        commandLine.withExePath(exePath);
        commandLine.getEnvironment().putAll(this.myExtraEnvironment);
        if (this.myWorkDirectory != null) {
            commandLine.withWorkingDirectory(Path.of(this.myWorkDirectory, new String[0]));
        }
        commandLine.addParameters(this.myParameterList.getList());
        commandLine.withParentEnvironmentType(this.myParentEnvironmentType);
        commandLine.withCharset(StandardCharsets.UTF_8);
        if (wslPath != null) {
            WSLCommandLineOptions wslOptions = new WSLCommandLineOptions().setExecuteCommandInShell(false).setPassEnvVarsUsingInterop(true);
            commandLine = wslPath.getDistribution().patchCommandLine(commandLine, this.myProject, wslOptions);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            TfExecutor.$$$reportNull$$$0(21);
        }
        return generalCommandLine;
    }

    @NotNull
    @Nls
    String getPresentableName() {
        String string = (String)ObjectUtils.notNull((Object)this.myPresentableName, (Object)this.myToolType.getDisplayName());
        if (string == null) {
            TfExecutor.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7, 8, 10, 12, 14, 15, 16, 17, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/terraform/config/util/TfExecutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterString";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalHandler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyProcessListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/terraform/config/util/TfExecutor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withPresentableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withExePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withWorkDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtraEnvironment";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withPassParentEnvironment";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withParameterString";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withParameters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "showOutputOnError";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "disablePty";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "showNotifications";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "in";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withProcessListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withExtraEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withParameterString";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withParameters";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showOutput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7, 8, 10, 12, 14, 15, 16, 17, 21, 22 -> new IllegalStateException(string);
        };
    }
}

