/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/terraform/hcl/SymbolCollector;", "Lcom/intellij/util/indexing/FileBasedIndex$ValueProcessor;", "Ljava/lang/Void;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/navigation/NavigationItem;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Lcom/intellij/util/Processor;)V", "getProcessor", "()Lcom/intellij/util/Processor;", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "process", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kind", "intellij.terraform"})
final class SymbolCollector
implements FileBasedIndex.ValueProcessor<Void> {
    @NotNull
    private final String name;
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private final Processor<? super NavigationItem> processor;
    @NotNull
    private final PsiManager psiManager;

    public SymbolCollector(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super NavigationItem> processor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        this.name = name;
        this.scope = scope;
        this.processor = processor;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.psiManager = psiManager;
    }

    @NotNull
    public final Processor<? super NavigationItem> getProcessor() {
        return this.processor;
    }

    public boolean process(@NotNull VirtualFile file, @Nullable Void kind) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.scope.contains(file)) {
            return true;
        }
        PsiFile psiFile = this.psiManager.findFile(file);
        if (psiFile instanceof HCLFile) {
            ((HCLFile)psiFile).acceptChildren((PsiElementVisitor)new PsiRecursiveVisitor(this){
                private boolean stop;
                final /* synthetic */ SymbolCollector this$0;
                {
                    this.this$0 = $receiver;
                }

                public void visitElement(HCLElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    ProgressIndicatorProvider.checkCanceled();
                    if (!this.stop) {
                        element.acceptChildren(this);
                    }
                }

                public void visitProperty(HCLProperty o) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        if (Intrinsics.areEqual((Object)SymbolCollector.access$getName$p(this.this$0), (Object)o.getName()) && !this.this$0.getProcessor().process((Object)o)) {
                            this.stop = true;
                            return;
                        }
                        ProgressIndicatorProvider.checkCanceled();
                        HCLExpression hCLExpression = o.getValue();
                        if (hCLExpression == null) break block1;
                        hCLExpression.accept(this);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitBlock(HCLBlock o) {
                    block8: {
                        block7: {
                            block6: {
                                boolean bl;
                                block5: {
                                    void $this$any$iv;
                                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                                    if (Intrinsics.areEqual((Object)SymbolCollector.access$getName$p(this.this$0), (Object)o.getFullName())) break block6;
                                    HCLElement[] hCLElementArray = o.getNameElements();
                                    Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray, (String)"getNameElements(...)");
                                    Object[] objectArray = hCLElementArray;
                                    SymbolCollector symbolCollector = this.this$0;
                                    boolean $i$f$any = false;
                                    for (void element$iv : $this$any$iv) {
                                        HCLElement it = (HCLElement)element$iv;
                                        boolean bl2 = false;
                                        if (!Intrinsics.areEqual((Object)SymbolCollector.access$getName$p(symbolCollector), (Object)it.getName())) continue;
                                        bl = true;
                                        break block5;
                                    }
                                    bl = false;
                                }
                                if (!bl) break block7;
                            }
                            if (!this.this$0.getProcessor().process((Object)o)) {
                                this.stop = true;
                                return;
                            }
                        }
                        ProgressIndicatorProvider.checkCanceled();
                        HCLObject hCLObject = o.getObject();
                        if (hCLObject == null) break block8;
                        hCLObject.acceptChildren(this);
                    }
                }
            });
        }
        return true;
    }

    public static final /* synthetic */ String access$getName$p(SymbolCollector $this) {
        return $this.name;
    }
}

