/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.codeinsight;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.codeinsight.TfCompletionUtil;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.hcl.HCLTokenTypes;
import org.intellij.terraform.hcl.codeinsight.HclBlockPropertiesCompletionProviderKt;
import org.intellij.terraform.hcl.patterns.HCLPatterns;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.terragrunt.model.TerragruntTypeModelKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a8\u0006\u0013"}, d2={"Lorg/intellij/terraform/hcl/codeinsight/HclRootBlockCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "createRootBlockPattern", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/intellij/psi/PsiElement;", "filePattern", "Lcom/intellij/patterns/PsiFilePattern$Capture;", "Lorg/intellij/terraform/hcl/psi/HCLFile;", "createBlockHeaderPattern", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHclRootBlockCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HclRootBlockCompletionProvider.kt\norg/intellij/terraform/hcl/codeinsight/HclRootBlockCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1563#2:60\n1634#2,3:61\n*S KotlinDebug\n*F\n+ 1 HclRootBlockCompletionProvider.kt\norg/intellij/terraform/hcl/codeinsight/HclRootBlockCompletionProvider\n*L\n40#1:60\n40#1:61,3\n*E\n"})
public final class HclRootBlockCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final HclRootBlockCompletionProvider INSTANCE = new HclRootBlockCompletionProvider();

    private HclRootBlockCompletionProvider() {
    }

    /*
     * WARNING - void declaration
     */
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        void $this$mapTo$iv$iv;
        List<PropertyOrBlockType> list;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        if (position.getParent() == null) {
            return;
        }
        PsiFile psiFile = position.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile psiFile2 = psiFile;
        if (UtilKt.isTerraformCompatiblePsiFile(psiFile2)) {
            list = TfCompletionUtil.INSTANCE.getRootBlockSorted();
        } else if (org.intellij.terraform.terragrunt.UtilKt.isTerragruntPsiFile(psiFile2)) {
            list = org.intellij.terraform.terragrunt.UtilKt.isTerragruntStack(psiFile2) ? TerragruntTypeModelKt.getStackRootBlocks() : TerragruntTypeModelKt.getTerragruntBlocksAndAttributes();
        } else {
            return;
        }
        List<BlockType> rootBlocks = list;
        Iterable $this$map$iv = rootBlocks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PropertyOrBlockType propertyOrBlockType = (PropertyOrBlockType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TfCompletionUtil.createPropertyOrBlockType$default(TfCompletionUtil.INSTANCE, (PropertyOrBlockType)it, null, null, 6, null));
        }
        List rootLookups = (List)destination$iv$iv;
        HclBlockPropertiesCompletionProviderKt.addResultsWithCustomSorter(result2, rootLookups);
    }

    @NotNull
    public final PsiElementPattern.Capture<PsiElement> createRootBlockPattern(@NotNull PsiFilePattern.Capture<HCLFile> filePattern) {
        Intrinsics.checkNotNullParameter(filePattern, (String)"filePattern");
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)filePattern)).withParent((ElementPattern)HCLPatterns.INSTANCE.getFile());
        PsiElementPattern.Capture capture2 = PlatformPatterns.psiElement();
        Intrinsics.checkNotNullExpressionValue((Object)capture2, (String)"psiElement(...)");
        ObjectPattern objectPattern = capture.andNot((ElementPattern)org.intellij.terraform.hcl.psi.UtilKt.afterSiblingSkipping2((PsiElementPattern)capture2, (ElementPattern<? extends Object>)((ElementPattern)HCLPatterns.INSTANCE.getWhiteSpace()), HCLPatterns.INSTANCE.getIdentifierOrStringLiteralOrSimple()));
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"andNot(...)");
        return (PsiElementPattern.Capture)objectPattern;
    }

    @NotNull
    public final PsiElementPattern.Capture<PsiElement> createBlockHeaderPattern(@NotNull PsiFilePattern.Capture<HCLFile> filePattern) {
        Intrinsics.checkNotNullParameter(filePattern, (String)"filePattern");
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(HCLTokenTypes.IDENTIFYING_LITERALS)).inFile((ElementPattern)filePattern);
        PsiElementPattern.Capture capture2 = (PsiElementPattern.Capture)PlatformPatterns.psiElement().and(HCLPatterns.INSTANCE.getIdentifierOrStringLiteral());
        PsiElementPattern.Capture capture3 = PlatformPatterns.psiElement();
        Intrinsics.checkNotNullExpressionValue((Object)capture3, (String)"psiElement(...)");
        TreeElementPattern treeElementPattern = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)capture.withParent((ElementPattern)capture2.andNot((ElementPattern)org.intellij.terraform.hcl.psi.UtilKt.afterSiblingSkipping2((PsiElementPattern)capture3, (ElementPattern<? extends Object>)((ElementPattern)HCLPatterns.INSTANCE.getWhiteSpace()), HCLPatterns.INSTANCE.getIdentifierOrStringLiteralOrSimple())))).withSuperParent(2, (ElementPattern)HCLPatterns.INSTANCE.getBlock())).withSuperParent(3, (ElementPattern)HCLPatterns.INSTANCE.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"withSuperParent(...)");
        return (PsiElementPattern.Capture)treeElementPattern;
    }
}

