/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.codeinsight.hint;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/hcl/codeinsight/hint/HCLTypeProvider;", "Lcom/intellij/lang/ExpressionTypeProvider;", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "<init>", "()V", "getInformationHint", "", "element", "getExpressionsAt", "", "elementAt", "Lcom/intellij/psi/PsiElement;", "getErrorHint", "isSupportedExpression", "", "e", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLTypeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLTypeProvider.kt\norg/intellij/terraform/hcl/codeinsight/hint/HCLTypeProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n774#2:49\n865#2,2:50\n*S KotlinDebug\n*F\n+ 1 HCLTypeProvider.kt\norg/intellij/terraform/hcl/codeinsight/hint/HCLTypeProvider\n*L\n34#1:49\n34#1:50,2\n*E\n"})
public final class HCLTypeProvider
extends ExpressionTypeProvider<HCLElement> {
    @NotNull
    public String getInformationHint(@NotNull HCLElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String text = null;
        if (element instanceof HCLBlock) {
            text = "block";
            HclType type = TfModelHelper.INSTANCE.getBlockType((HCLBlock)element);
            if (type != null) {
                text = type.getPresentableText();
            }
        } else {
            text = element instanceof HCLProperty ? "property" : "<unknown>";
        }
        String string = StringUtil.escapeXmlEntities((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<HCLElement> getExpressionsAt(@NotNull PsiElement elementAt) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)elementAt, (String)"elementAt");
        JBIterable jBIterable = SyntaxTraverser.psiApi().parents((Object)elementAt);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"parents(...)");
        Iterable $this$filter$iv = CollectionsKt.filterIsInstance((Iterable)((Iterable)jBIterable), HCLElement.class);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            HCLElement it = (HCLElement)element$iv$iv;
            boolean bl = false;
            if (!this.isSupportedExpression(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public String getErrorHint() {
        return "No expression found";
    }

    private final boolean isSupportedExpression(HCLElement e) {
        HCLElement hCLElement = e;
        return hCLElement instanceof HCLProperty ? true : hCLElement instanceof HCLBlock;
    }
}

