/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.generation.IndentedCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenterUtil;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.editor.HCLCommenterDataHolder;
import org.intellij.terraform.hcl.formatter.HclCodeStyleSettings;
import org.intellij.terraform.hcl.formatter.LineCommenterPrefix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u000eH\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J(\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J(\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J*\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\b\u0010.\u001a\u0004\u0018\u00010\u0003H\u0016J*\u0010/\u001a\u0002002\u0006\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\b\u0010.\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\u0010\u001a\u00020\b2\u0006\u0010)\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0003H\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010(\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0003H\u0016J*\u00101\u001a\u0004\u0018\u00010+2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0003H\u0016J \u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0003H\u0016J(\u00104\u001a\u00020\u001c2\u0006\u00103\u001a\u00020!2\u0006\u00105\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0003H\u0016J(\u00106\u001a\u0002002\u0006\u00103\u001a\u00020!2\u0006\u00105\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0003H\u0016J(\u00107\u001a\u0002002\u0006\u00103\u001a\u00020!2\u0006\u00105\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0003H\u0016J\r\u00108\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u00020\u001c2\u0006\u00105\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010;\u001a\u00020\u001c2\u0006\u00105\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010<\u001a\u00020\b2\u0006\u0010.\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/intellij/terraform/hcl/editor/HCLCommenter;", "Lcom/intellij/lang/CodeDocumentationAwareCommenter;", "Lcom/intellij/codeInsight/generation/SelfManagingCommenter;", "Lorg/intellij/terraform/hcl/editor/HCLCommenterDataHolder;", "Lcom/intellij/codeInsight/generation/IndentedCommenter;", "<init>", "()V", "BLOCK_COMMENT_PREFIX", "", "BLOCK_COMMENT_SUFFIX", "LINE_POUND_COMMENT", "LINE_DOUBLE_SLASH_COMMENT", "getLineCommentPrefix", "getLineCommentPrefixes", "", "getBlockCommentPrefix", "getBlockCommentSuffix", "getCommentedBlockCommentPrefix", "getCommentedBlockCommentSuffix", "getLineCommentTokenType", "Lcom/intellij/psi/tree/IElementType;", "getLineCommentTokenTypes", "getBlockCommentTokenType", "getDocumentationCommentTokenType", "getDocumentationCommentPrefix", "getDocumentationCommentLinePrefix", "getDocumentationCommentSuffix", "isDocumentationComment", "", "element", "Lcom/intellij/psi/PsiComment;", "createLineCommentingState", "startLine", "", "endLine", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "createBlockCommentingState", "selectionStart", "selectionEnd", "insertBlockComment", "Lcom/intellij/openapi/util/TextRange;", "startOffset", "endOffset", "data", "uncommentBlockComment", "", "getBlockCommentRange", "getCommentPrefix", "line", "isLineCommented", "offset", "uncommentLine", "commentLine", "forceIndentedLineComment", "()Ljava/lang/Boolean;", "isPoundSignComment", "isDoubleSlashesComment", "lineCommentPrefix", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLCommenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLCommenter.kt\norg/intellij/terraform/hcl/editor/HCLCommenter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class HCLCommenter
implements CodeDocumentationAwareCommenter,
SelfManagingCommenter<HCLCommenterDataHolder>,
IndentedCommenter {
    @NotNull
    private final String BLOCK_COMMENT_PREFIX;
    @NotNull
    private final String BLOCK_COMMENT_SUFFIX;
    @NotNull
    private final String LINE_POUND_COMMENT = LineCommenterPrefix.POUND_SIGN.getPrefix();
    @NotNull
    private final String LINE_DOUBLE_SLASH_COMMENT = LineCommenterPrefix.DOUBLE_SLASHES.getPrefix();

    public HCLCommenter() {
        this.BLOCK_COMMENT_PREFIX = "/*";
        this.BLOCK_COMMENT_SUFFIX = "*/";
    }

    @NotNull
    public String getLineCommentPrefix() {
        return this.LINE_POUND_COMMENT;
    }

    @NotNull
    public List<String> getLineCommentPrefixes() {
        Object[] objectArray = new String[]{this.LINE_POUND_COMMENT, this.LINE_DOUBLE_SLASH_COMMENT};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getBlockCommentPrefix() {
        return this.BLOCK_COMMENT_PREFIX;
    }

    @NotNull
    public String getBlockCommentSuffix() {
        return this.BLOCK_COMMENT_SUFFIX;
    }

    @Nullable
    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    @Nullable
    public IElementType getLineCommentTokenType() {
        return HCLElementTypes.LINE_HASH_COMMENT;
    }

    @NotNull
    public List<IElementType> getLineCommentTokenTypes() {
        Object[] objectArray = new IElementType[]{HCLElementTypes.LINE_HASH_COMMENT, HCLElementTypes.LINE_C_COMMENT};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public IElementType getBlockCommentTokenType() {
        return HCLElementTypes.BLOCK_COMMENT;
    }

    @Nullable
    public IElementType getDocumentationCommentTokenType() {
        return null;
    }

    @Nullable
    public String getDocumentationCommentPrefix() {
        return null;
    }

    @Nullable
    public String getDocumentationCommentLinePrefix() {
        return null;
    }

    @Nullable
    public String getDocumentationCommentSuffix() {
        return null;
    }

    public boolean isDocumentationComment(@Nullable PsiComment element) {
        return false;
    }

    @NotNull
    public HCLCommenterDataHolder createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new HCLCommenterDataHolder(file);
    }

    @NotNull
    public HCLCommenterDataHolder createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new HCLCommenterDataHolder(file);
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, @NotNull Document document, @Nullable HCLCommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        TextRange textRange = SelfManagingCommenterUtil.insertBlockComment((int)startOffset, (int)endOffset, (Document)document, (String)this.BLOCK_COMMENT_PREFIX, (String)this.BLOCK_COMMENT_SUFFIX);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"insertBlockComment(...)");
        return textRange;
    }

    public void uncommentBlockComment(int startOffset, int endOffset, @NotNull Document document, @Nullable HCLCommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        SelfManagingCommenterUtil.uncommentBlockComment((int)startOffset, (int)endOffset, (Document)document, (String)this.BLOCK_COMMENT_PREFIX, (String)this.BLOCK_COMMENT_SUFFIX);
    }

    @NotNull
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull HCLCommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        return this.getBlockCommentSuffix();
    }

    @NotNull
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull HCLCommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        return this.getBlockCommentPrefix();
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull HCLCommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        return SelfManagingCommenterUtil.getBlockCommentRange((int)selectionStart, (int)selectionEnd, (Document)document, (String)this.BLOCK_COMMENT_PREFIX, (String)this.BLOCK_COMMENT_SUFFIX);
    }

    @NotNull
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull HCLCommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        return this.getLineCommentPrefix();
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull HCLCommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        return this.isPoundSignComment(offset, document) || this.isDoubleSlashesComment(offset, document);
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull HCLCommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        if (this.isLineCommented(line, offset, document, data)) {
            int lengthOfComment = this.isPoundSignComment(offset, document) ? this.LINE_POUND_COMMENT.length() : this.LINE_DOUBLE_SLASH_COMMENT.length();
            boolean hasSpace = CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(offset + lengthOfComment), (CharSequence)" ");
            document.deleteString(offset, offset + lengthOfComment + (hasSpace ? 1 : 0));
        }
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull HCLCommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        document.insertString(offset, (CharSequence)this.lineCommentPrefix(data));
    }

    @NotNull
    public Boolean forceIndentedLineComment() {
        return true;
    }

    private final boolean isPoundSignComment(int offset, Document document) {
        return CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)this.LINE_POUND_COMMENT);
    }

    private final boolean isDoubleSlashesComment(int offset, Document document) {
        return CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)this.LINE_DOUBLE_SLASH_COMMENT);
    }

    private final String lineCommentPrefix(HCLCommenterDataHolder data) {
        LineCommenterPrefix lineCommenterPrefix;
        Object v2;
        block3: {
            PsiFile psiFile = data.getPsiFile();
            if (psiFile == null) {
                return this.LINE_POUND_COMMENT + " ";
            }
            PsiFile file = psiFile;
            CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getCustomSettings((PsiFile)file, HclCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            HclCodeStyleSettings settings = (HclCodeStyleSettings)customCodeStyleSettings;
            Iterable iterable = (Iterable)LineCommenterPrefix.getEntries();
            for (Object t : iterable) {
                LineCommenterPrefix it = (LineCommenterPrefix)((Object)t);
                boolean bl = false;
                if (!(it == settings.LINE_COMMENTER_CHARACTER)) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        if ((lineCommenterPrefix = (LineCommenterPrefix)v2) == null) {
            lineCommenterPrefix = LineCommenterPrefix.POUND_SIGN;
        }
        LineCommenterPrefix lineCommenterChar = lineCommenterPrefix;
        return lineCommenterChar.getPrefix() + " ";
    }
}

