/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.TerraformFileType;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLParserDefinitionKt;
import org.intellij.terraform.hcl.HCLSyntaxHighlighter;
import org.intellij.terraform.hcl.formatter.HclCodeStyleSettings;
import org.intellij.terraform.hcl.formatter.LineCommenterPrefix;
import org.intellij.terraform.hcl.formatter.PropertyAlignment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010 \u001a\u00020\u0010H\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u000b0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/intellij/terraform/hcl/formatter/HclCodeStyleOtherPanel;", "Lcom/intellij/application/options/CodeStyleAbstractPanel;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "<init>", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "alignmentComboBox", "Lcom/intellij/ui/CollectionComboBoxModel;", "Lorg/intellij/terraform/hcl/formatter/PropertyAlignment;", "kotlin.jvm.PlatformType", "commentSymbolComboBox", "Lorg/intellij/terraform/hcl/formatter/LineCommenterPrefix;", "reformatCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "importProviders", "settingsPanel", "Ljavax/swing/JPanel;", "getRightMargin", "", "createHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getPreviewText", "", "apply", "", "isModified", "", "resetImpl", "getPanel", "intellij.terraform"})
public final class HclCodeStyleOtherPanel
extends CodeStyleAbstractPanel {
    @NotNull
    private final CollectionComboBoxModel<PropertyAlignment> alignmentComboBox;
    @NotNull
    private final CollectionComboBoxModel<LineCommenterPrefix> commentSymbolComboBox;
    private JBCheckBox reformatCheckBox;
    private JBCheckBox importProviders;
    @NotNull
    private final JPanel settingsPanel;

    /*
     * WARNING - void declaration
     */
    public HclCodeStyleOtherPanel(@NotNull CodeStyleSettings settings) {
        void $this$_init__u24lambda_u241;
        DialogPanel dialogPanel;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.alignmentComboBox = new CollectionComboBoxModel((List)PropertyAlignment.getEntries());
        this.commentSymbolComboBox = new CollectionComboBoxModel((List)LineCommenterPrefix.getEntries());
        this.settingsPanel = new JPanel(new BorderLayout());
        DialogPanel dialogPanel2 = dialogPanel = BuilderKt.panel(arg_0 -> HclCodeStyleOtherPanel._init_$lambda$0(this, arg_0));
        JPanel jPanel = this.settingsPanel;
        boolean bl = false;
        $this$_init__u24lambda_u241.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 10));
        jPanel.add((Component)dialogPanel, "West");
        JPanel previewPanel = new JPanel();
        this.installPreviewPanel(previewPanel);
        this.settingsPanel.add((Component)previewPanel, "Center");
    }

    protected int getRightMargin() {
        return 0;
    }

    @NotNull
    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((SyntaxHighlighter)((SyntaxHighlighter)new HCLSyntaxHighlighter(HCLParserDefinitionKt.createHclLexer())), (EditorColorsScheme)scheme);
        Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"createHighlighter(...)");
        return editorHighlighter;
    }

    @NotNull
    protected FileType getFileType() {
        return (FileType)TerraformFileType.INSTANCE;
    }

    @NotNull
    protected String getPreviewText() {
        return "provider \"aws\" {\n  region = \"us-east-1\"\n}\n\nresource \"aws_instance\" \"example\" {\n  ami                    = \"ami-0c55b159cbfafe1f0\"\n  instance_type          = \"t2.micro\"\n  key_name               = aws_key_pair.deployer.key_name\n  vpc_security_group_ids = [aws_security_group.allow_ssh.id]\n\n  tags = {\n    Name = \"ExampleInstance\"\n  }\n}";
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        JBCheckBox jBCheckBox;
        LineCommenterPrefix lineCommenterPrefix;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(HclCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        HclCodeStyleSettings tfSettings = (HclCodeStyleSettings)customCodeStyleSettings;
        PropertyAlignment propertyAlignment = (PropertyAlignment)((Object)this.alignmentComboBox.getSelected());
        if (propertyAlignment == null) {
            propertyAlignment = tfSettings.PROPERTY_ALIGNMENT = PropertyAlignment.ON_EQUALS;
        }
        if ((lineCommenterPrefix = (LineCommenterPrefix)((Object)this.commentSymbolComboBox.getSelected())) == null) {
            lineCommenterPrefix = tfSettings.LINE_COMMENTER_CHARACTER = LineCommenterPrefix.POUND_SIGN;
        }
        if ((jBCheckBox = this.reformatCheckBox) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reformatCheckBox");
            jBCheckBox = null;
        }
        tfSettings.RUN_TF_FMT_ON_REFORMAT = jBCheckBox.isSelected();
        JBCheckBox jBCheckBox2 = this.importProviders;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importProviders");
            jBCheckBox2 = null;
        }
        tfSettings.IMPORT_PROVIDERS_AUTOMATICALLY = jBCheckBox2.isSelected();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(HclCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        HclCodeStyleSettings tfSettings = (HclCodeStyleSettings)customCodeStyleSettings;
        JBCheckBox jBCheckBox = this.reformatCheckBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reformatCheckBox");
            jBCheckBox = null;
        }
        if (jBCheckBox.isSelected() != tfSettings.RUN_TF_FMT_ON_REFORMAT) return true;
        if (this.alignmentComboBox.getSelected() != tfSettings.PROPERTY_ALIGNMENT) return true;
        if (this.commentSymbolComboBox.getSelected() != tfSettings.LINE_COMMENTER_CHARACTER) return true;
        JBCheckBox jBCheckBox2 = this.importProviders;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importProviders");
            jBCheckBox2 = null;
        }
        if (jBCheckBox2.isSelected() == tfSettings.IMPORT_PROVIDERS_AUTOMATICALLY) return false;
        return true;
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(HclCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        HclCodeStyleSettings tfSettings = (HclCodeStyleSettings)customCodeStyleSettings;
        this.alignmentComboBox.setSelectedItem((Object)tfSettings.PROPERTY_ALIGNMENT);
        this.commentSymbolComboBox.setSelectedItem((Object)tfSettings.LINE_COMMENTER_CHARACTER);
        JBCheckBox jBCheckBox = this.reformatCheckBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reformatCheckBox");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(tfSettings.RUN_TF_FMT_ON_REFORMAT);
        JBCheckBox jBCheckBox2 = this.importProviders;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importProviders");
            jBCheckBox2 = null;
        }
        jBCheckBox2.setSelected(tfSettings.IMPORT_PROVIDERS_AUTOMATICALLY);
    }

    @NotNull
    public JPanel getPanel() {
        return this.settingsPanel;
    }

    private static final Unit _init_$lambda$0(HclCodeStyleOtherPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = HCLBundle.message("code.style.align.properties.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> HclCodeStyleOtherPanel.lambda$0$0(this$0, arg_0));
        String string2 = HCLBundle.message("code.style.line.commenter.character.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> HclCodeStyleOtherPanel.lambda$0$1(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> HclCodeStyleOtherPanel.lambda$0$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> HclCodeStyleOtherPanel.lambda$0$3(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(HclCodeStyleOtherPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)this$0.alignmentComboBox), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(HclCodeStyleOtherPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)this$0.commentSymbolComboBox), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2(HclCodeStyleOtherPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = HCLBundle.message("code.style.import.provider.automatically", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.importProviders = (JBCheckBox)$this$row.checkBox(string).gap(RightGap.SMALL).getComponent();
        String string2 = HCLBundle.message("code.style.import.provider.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.contextHelp(string2, HCLBundle.message("code.style.import.provider.header", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$3(HclCodeStyleOtherPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = HCLBundle.message("code.style.run.tf.fmt.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.reformatCheckBox = (JBCheckBox)$this$row.checkBox(string).gap(RightGap.SMALL).getComponent();
        String string2 = HCLBundle.message("code.style.run.tf.fmt.comment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.contextHelp(string2, HCLBundle.message("code.style.run.tf.fmt.header", new Object[0]));
        return Unit.INSTANCE;
    }
}

