/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.HCLTokenTypes;
import org.intellij.terraform.hcl.Icons;
import org.intellij.terraform.hcl.psi.HCLArray;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLBooleanLiteral;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLHeredocContent;
import org.intellij.terraform.hcl.psi.HCLHeredocLiteral;
import org.intellij.terraform.hcl.psi.HCLHeredocMarker;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLLiteral;
import org.intellij.terraform.hcl.psi.HCLNumberLiteral;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hcl.psi.impl.HCLPsiImplUtilsKt;
import org.intellij.terraform.hcl.psi.impl.HCLQuoter;
import org.intellij.terraform.hcl.psi.impl.HCLStringLiteralTextEscaper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001IB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0018J\u0018\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020%J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020%J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020(J\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020(J\u0015\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u001b\u001a\u00020(\u00a2\u0006\u0002\u0010,J\u0015\u0010-\u001a\u0004\u0018\u00010+2\u0006\u0010.\u001a\u00020/\u00a2\u0006\u0002\u00100J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u00101\u001a\u00020+J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\b032\u0006\u0010.\u001a\u00020/J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\b032\u0006\u0010.\u001a\u00020/J\u0014\u00105\u001a\b\u0012\u0004\u0012\u000206032\u0006\u0010.\u001a\u00020/J(\u00107\u001a\b\u0012\u0004\u0012\u00020\b032\u0006\u0010.\u001a\u00020/2\b\b\u0002\u00108\u001a\u00020+2\b\b\u0002\u00109\u001a\u00020\u001aJ\u000e\u0010:\u001a\u00020+2\u0006\u0010.\u001a\u00020/J\u000e\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020;J\u000e\u0010\u0016\u001a\u00020<2\u0006\u0010\u001b\u001a\u00020=J\u0010\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020\bH\u0002J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\bH\u0002J\u0018\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020+2\u0006\u0010E\u001a\u00020+H\u0002J\u000e\u0010F\u001a\u00020\b2\u0006\u0010G\u001a\u00020HR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/HCLPsiImplUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getName", "", "property", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "getFullName", "marker", "Lorg/intellij/terraform/hcl/psi/HCLHeredocMarker;", "getNameElement", "Lorg/intellij/terraform/hcl/psi/HCLExpression;", "getNameElements", "", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "(Lorg/intellij/terraform/hcl/psi/HCLBlock;)[Lorg/intellij/terraform/hcl/psi/HCLElement;", "getValue", "getObject", "Lorg/intellij/terraform/hcl/psi/HCLObject;", "isQuotedString", "", "literal", "Lorg/intellij/terraform/hcl/psi/HCLLiteral;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "array", "Lorg/intellij/terraform/hcl/psi/HCLArray;", "o", "findProperty", "object", "name", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "getQuoteSymbol", "", "Lorg/intellij/terraform/hcl/psi/HCLHeredocLiteral;", "isIndented", "getIndentation", "", "(Lorg/intellij/terraform/hcl/psi/HCLHeredocLiteral;)Ljava/lang/Integer;", "getMinimalIndentation", "content", "Lorg/intellij/terraform/hcl/psi/HCLHeredocContent;", "(Lorg/intellij/terraform/hcl/psi/HCLHeredocContent;)Ljava/lang/Integer;", "trimFirst", "getLines", "", "getLinesWithEOL", "getLinesRaw", "", "getLinesInternal", "indentation", "eols", "getLinesCount", "Lorg/intellij/terraform/hcl/psi/HCLBooleanLiteral;", "", "Lorg/intellij/terraform/hcl/psi/HCLNumberLiteral;", "getNumericValue", "text", "getSuffixValue", "", "suffix", "pow", "a", "b", "getId", "identifier", "Lorg/intellij/terraform/hcl/psi/HCLIdentifier;", "AbstractItemPresentation", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLPsiImplUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLPsiImplUtils.kt\norg/intellij/terraform/hcl/psi/impl/HCLPsiImplUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,380:1\n1#2:381\n37#3,2:382\n13805#4,2:384\n*S KotlinDebug\n*F\n+ 1 HCLPsiImplUtils.kt\norg/intellij/terraform/hcl/psi/impl/HCLPsiImplUtils\n*L\n76#1:382,2\n242#1:384,2\n*E\n"})
public final class HCLPsiImplUtils {
    @NotNull
    public static final HCLPsiImplUtils INSTANCE = new HCLPsiImplUtils();
    @NotNull
    private static final Logger LOG;

    private HCLPsiImplUtils() {
    }

    @NotNull
    public final String getName(@NotNull HCLProperty property) {
        String string;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        HCLExpression hCLExpression = property.getNameElement();
        Intrinsics.checkNotNullExpressionValue((Object)hCLExpression, (String)"getNameElement(...)");
        HCLExpression identifier = hCLExpression;
        if (identifier instanceof HCLStringLiteral) {
            String string2 = ((HCLStringLiteral)identifier).getValue();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
        } else if (identifier instanceof HCLIdentifier) {
            String string3 = ((HCLIdentifier)identifier).getId();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
        } else {
            String string4 = StringUtil.unescapeStringCharacters((String)identifier.getText());
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"unescapeStringCharacters(...)");
        }
        return string;
    }

    @NotNull
    public final String getName(@NotNull HCLBlock block) {
        String string;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        PsiElement identifier = block.getNameIdentifier();
        if (identifier == null) {
            string = this.getFullName(block);
        } else if (identifier instanceof HCLStringLiteral) {
            String string2 = ((HCLStringLiteral)identifier).getValue();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
        } else if (identifier instanceof HCLIdentifier) {
            String string3 = ((HCLIdentifier)identifier).getId();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
        } else {
            String string4 = identifier.getText();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        }
        return string;
    }

    @NotNull
    public final String getFullName(@NotNull HCLBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        HCLElement[] hCLElementArray = block.getNameElements();
        Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray, (String)"getNameElements(...)");
        HCLElement[] elements = hCLElementArray;
        StringBuilder sb = new StringBuilder();
        for (HCLElement element : elements) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            sb.append(StringUtil.unescapeStringCharacters((String)HCLPsiUtil.stripQuotes(string))).append(' ');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @NotNull
    public final String getName(@NotNull HCLHeredocMarker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        String string = marker.getFirstChild().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final HCLExpression getNameElement(@NotNull HCLProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        PsiElement firstChild = property.getFirstChild();
        boolean bl = firstChild instanceof HCLExpression;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Excepted expression, got " + firstChild.getClass().getName();
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)firstChild, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLExpression");
        return (HCLExpression)firstChild;
    }

    @NotNull
    public final HCLElement[] getNameElements(@NotNull HCLBlock block) {
        HCLElement[] hCLElementArray;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                Object result2 = null;
                for (PsiElement child = block.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof HCLIdentifier) && !(child instanceof HCLStringLiteral)) continue;
                    if (result2 == null) {
                        result2 = (List)new SmartList();
                    }
                    result2.add((HCLElement)child);
                }
                hCLElementArray = result2;
                if (result2 == null) break block5;
                Collection $this$toTypedArray$iv = (Collection)hCLElementArray;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                hCLElementArray = thisCollection$iv.toArray(new HCLElement[0]);
                if (hCLElementArray != null) break block6;
            }
            hCLElementArray = new HCLElement[]{};
        }
        return hCLElementArray;
    }

    @Nullable
    public final HCLExpression getValue(@NotNull HCLProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return (HCLExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.getNameElement(property), HCLExpression.class);
    }

    @Nullable
    public final HCLObject getObject(@NotNull HCLBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return (HCLObject)PsiTreeUtil.getNextSiblingOfType((PsiElement)block.getFirstChild(), HCLObject.class);
    }

    public final boolean isQuotedString(@NotNull HCLLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        return literal.getNode().findChildByType(HCLTokenTypes.STRING_LITERALS) != null;
    }

    @NotNull
    public final ItemPresentation getPresentation(@NotNull HCLProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return new AbstractItemPresentation(property){
            final /* synthetic */ HCLProperty $property;
            {
                this.$property = $property;
                super($property);
            }

            public Icon getIcon(boolean unused) {
                if (this.$property.getValue() instanceof HCLArray) {
                    Icon icon = AllIcons.Json.Array;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Array");
                    return icon;
                }
                if (this.$property.getValue() instanceof HCLObject) {
                    Icon icon = AllIcons.Json.Object;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Object");
                    return icon;
                }
                return Icons.INSTANCE.getProperty();
            }
        };
    }

    @NotNull
    public final ItemPresentation getPresentation(@NotNull HCLBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return new AbstractItemPresentation(block){
            final /* synthetic */ HCLBlock $block;
            {
                this.$block = $block;
                super($block);
            }

            public String getPresentableText() {
                String string = this.$block.getFullName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullName(...)");
                return string;
            }

            public Icon getIcon(boolean unused) {
                if (this.$block.getObject() instanceof HCLArray) {
                    Icon icon = AllIcons.Json.Array;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Array");
                    return icon;
                }
                if (this.$block.getObject() != null) {
                    Icon icon = AllIcons.Json.Object;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Object");
                    return icon;
                }
                return Icons.INSTANCE.getProperty();
            }
        };
    }

    @NotNull
    public final ItemPresentation getPresentation(@NotNull HCLArray array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return new AbstractItemPresentation(array){

            public String getPresentableText() {
                return "hcl.array";
            }

            public Icon getIcon(boolean unused) {
                return Icons.INSTANCE.getArray();
            }
        };
    }

    @NotNull
    public final ItemPresentation getPresentation(@NotNull HCLObject o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return new AbstractItemPresentation(o){

            public String getPresentableText() {
                return "hcl.object";
            }

            public Icon getIcon(boolean unused) {
                return Icons.INSTANCE.getObject();
            }
        };
    }

    @Nullable
    public final HCLProperty findProperty(@NotNull HCLObject object, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (HCLProperty property : object.getPropertyList()) {
            if (!Intrinsics.areEqual((Object)property.getName(), (Object)name)) continue;
            return property;
        }
        return null;
    }

    @NotNull
    public final String getValue(@NotNull HCLStringLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        String string = literal.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String stripQuotes = HCLPsiUtil.stripQuotes(string);
        boolean interpolations = UtilKt.isInHCLFileWithInterpolations(literal);
        StringBuilder out = new StringBuilder(stripQuotes.length());
        boolean decode = HCLStringLiteralTextEscaper.Companion.parseStringCharacters(stripQuotes, out, null, interpolations);
        if (decode) {
            String string2 = out.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
        String string3 = literal.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        return HCLQuoter.INSTANCE.unquote(string3, interpolations, true);
    }

    public final char getQuoteSymbol(@NotNull HCLStringLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        return literal.getText().charAt(0);
    }

    @NotNull
    public final String getValue(@NotNull HCLHeredocLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        HCLHeredocContent hCLHeredocContent = literal.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)hCLHeredocContent, (String)"getContent(...)");
        Integer n = literal.getIndentation();
        return this.getValue(hCLHeredocContent, n != null ? n : 0);
    }

    public final boolean isIndented(@NotNull HCLHeredocLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        String string = literal.getMarkerStart().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.startsWith$default((CharSequence)string, (char)'-', (boolean)false, (int)2, null);
    }

    @Nullable
    public final Integer getIndentation(@NotNull HCLHeredocLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        if (!this.isIndented(literal)) {
            return null;
        }
        HCLHeredocMarker hCLHeredocMarker = literal.getMarkerEnd();
        if (hCLHeredocMarker == null) {
            return null;
        }
        HCLHeredocMarker markerEnd = hCLHeredocMarker;
        String string = markerEnd.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int indentation = HCLPsiImplUtilsKt.getIndentation(string);
        Integer n = literal.getContent().getMinimalIndentation();
        if (n == null) {
            return indentation;
        }
        int contentMinIndentation = n;
        if (contentMinIndentation < indentation) {
            return 0;
        }
        return indentation;
    }

    @Nullable
    public final Integer getMinimalIndentation(@NotNull HCLHeredocContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ASTNode[] aSTNodeArray = content.getNode().getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        ASTNode[] children = aSTNodeArray;
        ASTNode prev = null;
        int indentation = Integer.MAX_VALUE;
        for (ASTNode child : children) {
            if (Intrinsics.areEqual((Object)child.getElementType(), (Object)HCLElementTypes.HD_EOL)) {
                ASTNode aSTNode = prev;
                if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)HCLElementTypes.HD_EOL)) {
                    return 0;
                }
            } else {
                CharSequence charSequence = child.getChars();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
                indentation = Math.min(indentation, HCLPsiImplUtilsKt.getIndentation(charSequence));
            }
            prev = child;
        }
        if (indentation == Integer.MAX_VALUE) {
            return null;
        }
        return indentation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getValue(@NotNull HCLHeredocContent content, int trimFirst) {
        void $this$forEach$iv;
        ASTNode[] children;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        StringBuilder builder = new StringBuilder();
        ASTNode[] aSTNodeArray = content.getNode().getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        ASTNode[] aSTNodeArray2 = children = aSTNodeArray;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence;
            StringBuilder stringBuilder;
            void element$iv;
            void it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getElementType(), (Object)HCLElementTypes.HD_EOL)) {
                stringBuilder = builder.append(it.getChars());
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)it.getChars(), (String)"getChars(...)");
            int n2 = charSequence.length();
            stringBuilder = builder.append(((Object)charSequence.subSequence(trimFirst, n2)).toString());
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String getValue$default(HCLPsiImplUtils hCLPsiImplUtils, HCLHeredocContent hCLHeredocContent, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return hCLPsiImplUtils.getValue(hCLHeredocContent, n);
    }

    @NotNull
    public final List<String> getLines(@NotNull HCLHeredocContent content) {
        int n;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        PsiElement parent = content.getParent();
        if (parent instanceof HCLHeredocLiteral) {
            Integer n2 = ((HCLHeredocLiteral)parent).getIndentation();
            n = n2 != null ? n2 : 0;
        } else {
            n = 0;
        }
        int indentation = n;
        return this.getLinesInternal(content, indentation, false);
    }

    @NotNull
    public final List<String> getLinesWithEOL(@NotNull HCLHeredocContent content) {
        int n;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        PsiElement parent = content.getParent();
        if (parent instanceof HCLHeredocLiteral) {
            Integer n2 = ((HCLHeredocLiteral)parent).getIndentation();
            n = n2 != null ? n2 : 0;
        } else {
            n = 0;
        }
        int indentation = n;
        return this.getLinesInternal(content, indentation, true);
    }

    @NotNull
    public final List<CharSequence> getLinesRaw(@NotNull HCLHeredocContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return HCLPsiImplUtils.getLinesInternal$default(this, content, 0, false, 2, null);
    }

    @NotNull
    public final List<String> getLinesInternal(@NotNull HCLHeredocContent content, int indentation, boolean eols) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ASTNode[] aSTNodeArray = content.getNode().getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        ASTNode[] children = aSTNodeArray;
        ArrayList<Object> result2 = new ArrayList<Object>((children.length + 1) / 2);
        ASTNode prev = null;
        for (ASTNode child : children) {
            boolean bl;
            if (Intrinsics.areEqual((Object)child.getElementType(), (Object)HCLElementTypes.HD_EOL)) {
                if (prev != null) {
                    String string = prev.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String string2 = string.substring(indentation);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    result2.add(string2 + (eols ? child.getText() : ""));
                    prev = null;
                    continue;
                }
                result2.add(eols ? child.getText() : "");
                continue;
            }
            boolean bl2 = bl = prev == null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Unexpected heredoc content:\n" + DebugUtil.psiToString((PsiElement)content, (boolean)true);
                throw new AssertionError((Object)string);
            }
            prev = child;
        }
        if (prev != null) {
            String string = prev.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string3 = string.substring(indentation);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            result2.add(string3);
        }
        return result2;
    }

    public static /* synthetic */ List getLinesInternal$default(HCLPsiImplUtils hCLPsiImplUtils, HCLHeredocContent hCLHeredocContent, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return hCLPsiImplUtils.getLinesInternal(hCLHeredocContent, n, bl);
    }

    public final int getLinesCount(@NotNull HCLHeredocContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ASTNode node = content.getNode();
        int counter = 0;
        for (ASTNode cn = node.getFirstChildNode(); cn != null; cn = cn.getTreeNext()) {
            if (!Intrinsics.areEqual((Object)cn.getElementType(), (Object)HCLElementTypes.HD_EOL)) continue;
            ++counter;
        }
        return counter;
    }

    public final boolean getValue(@NotNull HCLBooleanLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        return literal.textMatches("true");
    }

    @NotNull
    public final Number getValue(@NotNull HCLNumberLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        String text = literal.getText();
        Intrinsics.checkNotNull((Object)text);
        return this.getNumericValue(text);
    }

    private final Number getNumericValue(String text) {
        String base = null;
        long suffix = 0L;
        if (StringsKt.contains$default((CharSequence)"KMGB", (char)Character.toUpperCase(StringsKt.last((CharSequence)text)), (boolean)false, (int)2, null)) {
            int index = 0;
            index = StringsKt.contains$default((CharSequence)"KMGB", (char)Character.toUpperCase(text.charAt(StringsKt.getLastIndex((CharSequence)text) - 1)), (boolean)false, (int)2, null) ? StringsKt.getLastIndex((CharSequence)text) - 1 : StringsKt.getLastIndex((CharSequence)text);
            String string = text.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            base = string;
            String string2 = text.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            suffix = this.getSuffixValue(string2);
        } else {
            base = text;
            suffix = 1L;
        }
        Number number = StringsKt.toIntOrNull((String)base);
        if (number != null) {
            int it = ((Number)number).intValue();
            boolean bl = false;
            long l = (long)it * suffix;
            if (l > Integer.MAX_VALUE) {
                return l;
            }
            return (int)l;
        }
        number = StringsKt.toDoubleOrNull((String)base);
        if (number != null) {
            double it = ((Number)number).doubleValue();
            boolean bl = false;
            return it * (double)suffix;
        }
        throw new NumberFormatException("Non-number value '" + base + "'");
    }

    private final long getSuffixValue(String suffix) {
        int base = 0;
        switch (suffix.length()) {
            case 1: {
                base = 1000;
                break;
            }
            case 2: {
                LOG.assertTrue(Character.toLowerCase(suffix.charAt(1)) == 'b', (Object)("Second suffix char must be 'b' or 'B': " + suffix));
                base = 1024;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported suffix '" + suffix + "'");
            }
        }
        switch (Character.toLowerCase(suffix.charAt(0))) {
            case 'k': {
                return this.pow(base, 1);
            }
            case 'm': {
                return this.pow(base, 2);
            }
            case 'g': {
                return this.pow(base, 3);
            }
        }
        throw new IllegalArgumentException("Unsupported suffix '" + suffix + "'");
    }

    private final long pow(int a, int b) {
        if (b == 0) {
            return 1L;
        }
        long result2 = a;
        int i = 1;
        int n = b - 1;
        if (i <= n) {
            while (true) {
                result2 *= (long)a;
                if (i == n) break;
                ++i;
            }
        }
        return result2;
    }

    @NotNull
    public final String getId(@NotNull HCLIdentifier identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        String string = identifier.getFirstChild().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    static {
        Logger logger = Logger.getInstance(HCLPsiImplUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/intellij/terraform/hcl/psi/impl/HCLPsiImplUtils$AbstractItemPresentation;", "Lcom/intellij/navigation/ItemPresentation;", "element", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "<init>", "(Lorg/intellij/terraform/hcl/psi/HCLElement;)V", "getElement", "()Lorg/intellij/terraform/hcl/psi/HCLElement;", "getPresentableText", "", "getLocationString", "getIcon", "Ljavax/swing/Icon;", "unused", "", "intellij.terraform"})
    public static class AbstractItemPresentation
    implements ItemPresentation {
        @NotNull
        private final HCLElement element;

        public AbstractItemPresentation(@NotNull HCLElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.element = element;
        }

        @NotNull
        public final HCLElement getElement() {
            return this.element;
        }

        @Nullable
        public String getPresentableText() {
            if (this.element instanceof PsiNamedElement) {
                HCLElement hCLElement = this.element;
                Intrinsics.checkNotNull((Object)hCLElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiNamedElement");
                return ((PsiNamedElement)hCLElement).getName();
            }
            return null;
        }

        @Nullable
        public String getLocationString() {
            return null;
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            return null;
        }
    }
}

