/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.codeinsight;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.codeinsight.TfCompletionUtil;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLForObjectExpression;
import org.intellij.terraform.hcl.psi.common.BaseExpression;
import org.intellij.terraform.hcl.psi.common.Identifier;
import org.intellij.terraform.hcl.psi.common.ProviderDefinedFunction;
import org.intellij.terraform.hcl.psi.common.SelectExpression;
import org.intellij.terraform.hil.HILElementTypes;
import org.intellij.terraform.hil.HILSyntaxHighlighter;
import org.intellij.terraform.hil.codeinsight.HILVariableAnnotatorKt;
import org.intellij.terraform.hil.psi.impl.ILExpressionBaseKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/intellij/terraform/hil/codeinsight/HILVariableAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "DEBUG", "", "ellipsis", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "commas", "rParens", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "createInfo", "debug", "", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "annotateLeftmostInSelection", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "isProviderDefinedFunction", "intellij.terraform"})
public final class HILVariableAnnotator
implements Annotator,
DumbAware {
    private final boolean DEBUG = ApplicationManager.getApplication().isUnitTestMode();
    @NotNull
    private final TokenSet ellipsis;
    @NotNull
    private final TokenSet commas;
    @NotNull
    private final TokenSet rParens;

    public HILVariableAnnotator() {
        IElementType[] iElementTypeArray = new IElementType[]{HILElementTypes.OP_ELLIPSIS, HCLElementTypes.OP_ELLIPSIS};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.ellipsis = tokenSet;
        iElementTypeArray = new IElementType[]{HILElementTypes.COMMA, HCLElementTypes.COMMA};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        this.commas = tokenSet2;
        iElementTypeArray = new IElementType[]{HILElementTypes.R_PAREN, HCLElementTypes.R_PAREN};
        TokenSet tokenSet3 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"create(...)");
        this.rParens = tokenSet3;
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        ASTNode aSTNode = element.getNode();
        if (this.ellipsis.contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null))) {
            if (element.getParent() instanceof HCLForObjectExpression) {
                return;
            }
            PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element);
            if (this.commas.contains(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null)) {
                holder.newAnnotation(HighlightSeverity.ERROR, HCLBundle.message("hil.variable.annotator.expression.start.expected", new Object[0])).create();
            } else {
                PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
                if (!this.rParens.contains(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null)) {
                    holder.newAnnotation(HighlightSeverity.ERROR, HCLBundle.message("hil.variable.annotator.expanded.function.argument.must.be.immediately.followed.by.closing.parentheses", new Object[0])).create();
                }
            }
            return;
        }
        if (this.isProviderDefinedFunction(element, holder)) {
            return;
        }
        if (!(element instanceof BaseExpression)) {
            return;
        }
        HCLElement hCLElement = ILExpressionBaseKt.getHCLHost((BaseExpression)element);
        if (hCLElement == null) {
            return;
        }
        HCLElement host = hCLElement;
        PsiFile hostFile = host.getContainingFile();
        if (!(hostFile instanceof HCLFile) || !((HCLFile)hostFile).isInterpolationsAllowed()) {
            return;
        }
        if (!(element instanceof Identifier)) {
            return;
        }
        PsiElement parent = ((Identifier)element).getParent();
        if (parent instanceof SelectExpression) {
            if (((SelectExpression)parent).getFrom() == element) {
                this.annotateLeftmostInSelection((Identifier)element, holder);
            } else if (HILVariableAnnotatorKt.isScopeElementReference((Identifier)element, (SelectExpression)parent)) {
                this.createInfo(holder, "scope value reference", HILSyntaxHighlighter.Companion.getTIL_PROPERTY_REFERENCE());
            } else if (HILVariableAnnotatorKt.isResourceInstanceReference((Identifier)element, (SelectExpression)parent)) {
                this.createInfo(holder, "resource instance reference", HILSyntaxHighlighter.Companion.getTIL_RESOURCE_INSTANCE_REFERENCE());
            } else if (HILVariableAnnotatorKt.isResourcePropertyReference((Identifier)element, (SelectExpression)parent)) {
                this.createInfo(holder, "property reference", HILSyntaxHighlighter.Companion.getTIL_PROPERTY_REFERENCE());
            }
        }
    }

    private final void createInfo(AnnotationHolder holder, @NlsSafe String debug, TextAttributesKey textAttributesKey) {
        if (this.DEBUG) {
            holder.newAnnotation(HighlightSeverity.INFORMATION, debug).textAttributes(textAttributesKey).create();
        } else {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(textAttributesKey).create();
        }
    }

    private final void annotateLeftmostInSelection(Identifier element, AnnotationHolder holder) {
        if (CollectionsKt.contains((Iterable)TfCompletionUtil.INSTANCE.getScopes(), (Object)element.getName())) {
            this.createInfo(holder, "global scope", HILSyntaxHighlighter.Companion.getTIL_PREDEFINED_SCOPE());
        } else {
            this.createInfo(holder, "resource type reference", HILSyntaxHighlighter.Companion.getTIL_RESOURCE_TYPE_REFERENCE());
        }
    }

    private final boolean isProviderDefinedFunction(PsiElement element, AnnotationHolder holder) {
        PsiElement psiElement = element.getParent();
        ProviderDefinedFunction providerDefinedFunction = psiElement instanceof ProviderDefinedFunction ? (ProviderDefinedFunction)psiElement : null;
        if (providerDefinedFunction == null) {
            return false;
        }
        ProviderDefinedFunction parent = providerDefinedFunction;
        if (!(element instanceof Identifier) || parent.getKeyword() != element) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Identifier)element).getText(), (Object)"provider")) {
            holder.newAnnotation(HighlightSeverity.ERROR, HCLBundle.message("hil.annotator.provider.defined.function.keyword", new Object[0])).create();
            return true;
        }
        return false;
    }
}

