/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hil.GoUtil;
import org.intellij.terraform.hil.HILElementTypes;
import org.intellij.terraform.hil.HILTypes;
import org.intellij.terraform.hil.psi.ILBinaryExpression;
import org.intellij.terraform.hil.psi.ILConditionalExpression;
import org.intellij.terraform.hil.psi.ILElementVisitor;
import org.intellij.terraform.hil.psi.ILExpression;
import org.intellij.terraform.hil.psi.ILLiteralExpression;
import org.intellij.terraform.hil.psi.ILUnaryExpression;
import org.intellij.terraform.hil.psi.impl.ILExpressionBaseKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/hil/inspection/HILOperationTypesMismatchInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "MyEV", "intellij.terraform"})
public final class HILOperationTypesMismatchInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        return UtilKt.isTerraformCompatiblePsiFile(topLevelFile);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/hil/inspection/HILOperationTypesMismatchInspection$MyEV;", "Lorg/intellij/terraform/hil/psi/ILElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/hil/inspection/HILOperationTypesMismatchInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitILBinaryExpression", "", "operation", "Lorg/intellij/terraform/hil/psi/ILBinaryExpression;", "visitILUnaryExpression", "Lorg/intellij/terraform/hil/psi/ILUnaryExpression;", "visitILConditionalExpression", "Lorg/intellij/terraform/hil/psi/ILConditionalExpression;", "intellij.terraform"})
    public final class MyEV
    extends ILElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitILBinaryExpression(@NotNull ILBinaryExpression operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            ProgressIndicatorProvider.checkCanceled();
            if (ILExpressionBaseKt.getHCLHost(operation) == null) {
                return;
            }
            ILExpression iLExpression = operation.getLeftOperand();
            Intrinsics.checkNotNullExpressionValue((Object)iLExpression, (String)"<get-leftOperand>(...)");
            ILExpression left = iLExpression;
            ILExpression iLExpression2 = operation.getRightOperand();
            if (iLExpression2 == null) {
                return;
            }
            ILExpression right = iLExpression2;
            HclType leftType = ExtensionsKt.getType(left);
            HclType rightType = ExtensionsKt.getType(right);
            IElementType iElementType = operation.getNode().getElementType();
            if (HILTypes.INSTANCE.getILBinaryNumericOnlyOperations().contains(iElementType)) {
                Object[] objectArray;
                if (leftType != null && !Intrinsics.areEqual((Object)leftType, (Object)Types.INSTANCE.getNumber()) && !Intrinsics.areEqual((Object)leftType, (Object)Types.INSTANCE.getAny())) {
                    objectArray = new Object[]{leftType.getPresentableText()};
                    this.holder.registerProblem((PsiElement)left, HCLBundle.message("hil.operation.types.mismatch.inspection.number.expected.error.message", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                if (rightType != null && !Intrinsics.areEqual((Object)rightType, (Object)Types.INSTANCE.getNumber()) && !Intrinsics.areEqual((Object)rightType, (Object)Types.INSTANCE.getAny())) {
                    objectArray = new Object[]{rightType.getPresentableText()};
                    this.holder.registerProblem((PsiElement)right, HCLBundle.message("hil.operation.types.mismatch.inspection.number.expected.error.message", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                return;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)HILElementTypes.IL_BINARY_EQUALITY_EXPRESSION)) {
                return;
            }
            if (HILTypes.INSTANCE.getILBinaryBooleanOnlyOperations().contains(iElementType)) {
                Object[] objectArray;
                if (leftType != null && !Intrinsics.areEqual((Object)leftType, (Object)Types.INSTANCE.getBoolean()) && !Intrinsics.areEqual((Object)leftType, (Object)Types.INSTANCE.getAny())) {
                    objectArray = new Object[]{leftType.getPresentableText()};
                    this.holder.registerProblem((PsiElement)left, HCLBundle.message("hil.operation.types.mismatch.inspection.boolean.expected.error.message", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                if (rightType != null && !Intrinsics.areEqual((Object)rightType, (Object)Types.INSTANCE.getBoolean()) && !Intrinsics.areEqual((Object)rightType, (Object)Types.INSTANCE.getAny())) {
                    objectArray = new Object[]{rightType.getPresentableText()};
                    this.holder.registerProblem((PsiElement)right, HCLBundle.message("hil.operation.types.mismatch.inspection.boolean.expected.error.message", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                return;
            }
        }

        @Override
        public void visitILUnaryExpression(@NotNull ILUnaryExpression operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            ProgressIndicatorProvider.checkCanceled();
            if (ILExpressionBaseKt.getHCLHost(operation) == null) {
                return;
            }
            ILExpression iLExpression = operation.getOperand();
            if (iLExpression == null) {
                return;
            }
            ILExpression operand = iLExpression;
            IElementType iElementType = operation.getOperationSign();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"<get-operationSign>(...)");
            IElementType sign = iElementType;
            HclType hclType = ExtensionsKt.getType(operand);
            if (hclType == null) {
                return;
            }
            HclType type = hclType;
            IElementType iElementType2 = sign;
            if (Intrinsics.areEqual((Object)iElementType2, (Object)HILElementTypes.OP_PLUS) || Intrinsics.areEqual((Object)iElementType2, (Object)HILElementTypes.OP_MINUS)) {
                if (!Intrinsics.areEqual((Object)type, (Object)Types.INSTANCE.getNumber()) && !Intrinsics.areEqual((Object)type, (Object)Types.INSTANCE.getAny())) {
                    Object[] objectArray = new Object[]{type.getPresentableText()};
                    this.holder.registerProblem((PsiElement)operand, HCLBundle.message("hil.operation.types.mismatch.inspection.number.expected.error.message", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                return;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)HILElementTypes.OP_NOT)) {
                if (!Intrinsics.areEqual((Object)type, (Object)Types.INSTANCE.getBoolean()) && !Intrinsics.areEqual((Object)type, (Object)Types.INSTANCE.getAny())) {
                    Object[] objectArray = new Object[]{type.getPresentableText()};
                    this.holder.registerProblem((PsiElement)operand, HCLBundle.message("hil.operation.types.mismatch.inspection.boolean.expected.error.message", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                return;
            }
        }

        @Override
        public void visitILConditionalExpression(@NotNull ILConditionalExpression operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            ProgressIndicatorProvider.checkCanceled();
            if (ILExpressionBaseKt.getHCLHost(operation) == null) {
                return;
            }
            ILExpression iLExpression = operation.getCondition();
            Intrinsics.checkNotNullExpressionValue((Object)iLExpression, (String)"<get-condition>(...)");
            ILExpression condition = iLExpression;
            HclType type = ExtensionsKt.getType(condition);
            if (!Intrinsics.areEqual((Object)type, (Object)Types.INSTANCE.getBoolean())) {
                if (Intrinsics.areEqual((Object)type, (Object)Types.INSTANCE.getString())) {
                    if (condition instanceof ILLiteralExpression && ((ILLiteralExpression)condition).getDoubleQuotedString() != null) {
                        String string = ((ILLiteralExpression)condition).getUnquotedText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-unquotedText>(...)");
                        if (!GoUtil.INSTANCE.isBoolean(string)) {
                            this.holder.registerProblem((PsiElement)condition, HCLBundle.message("hil.operation.types.mismatch.inspection.boolean.or.string.expected.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                        }
                    }
                } else if (!Intrinsics.areEqual((Object)type, (Object)Types.INSTANCE.getAny())) {
                    this.holder.registerProblem((PsiElement)condition, HCLBundle.message("hil.operation.types.mismatch.inspection.boolean.or.string.expected.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
            ProgressIndicatorProvider.checkCanceled();
            ILExpression iLExpression2 = operation.getThen();
            if (iLExpression2 == null) {
                return;
            }
            ILExpression left = iLExpression2;
            ILExpression iLExpression3 = operation.getOtherwise();
            if (iLExpression3 == null) {
                return;
            }
            ILExpression right = iLExpression3;
            HclType l = ExtensionsKt.getType(left);
            HclType r = ExtensionsKt.getType(right);
            ProgressIndicatorProvider.checkCanceled();
            if (!(Intrinsics.areEqual((Object)l, (Object)r) || l == null || r == null || Intrinsics.areEqual((Object)l, (Object)Types.INSTANCE.getAny()) || Intrinsics.areEqual((Object)r, (Object)Types.INSTANCE.getAny()) || Intrinsics.areEqual((Object)l, (Object)Types.INSTANCE.getString()) || Intrinsics.areEqual((Object)r, (Object)Types.INSTANCE.getString()) || Intrinsics.areEqual((Object)l, (Object)r))) {
                Object[] objectArray = new Object[]{l.getPresentableText(), r.getPresentableText()};
                this.holder.registerProblem((PsiElement)operation, HCLBundle.message("hil.operation.types.mismatch.inspection.both.branches.must.have.same.type.error.message", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
    }
}

