/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.inspection;

import com.intellij.BundleBase;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.actions.TfInitActionKt;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLLanguage;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.common.Identifier;
import org.intellij.terraform.hcl.psi.common.SelectExpression;
import org.intellij.terraform.hil.HILLanguage;
import org.intellij.terraform.hil.codeinsight.HILVariableAnnotatorKt;
import org.intellij.terraform.hil.psi.ILSelectFromSomethingReferenceProviderKt;
import org.intellij.terraform.hil.psi.impl.ILExpressionBaseKt;
import org.intellij.terraform.opentofu.patterns.OpenTofuPatterns;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0014\u0010\u0011\u001a\u00020\t2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0016\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\tR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/intellij/terraform/hil/inspection/HILUnresolvedReferenceInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "allowedLanguages", "", "Lcom/intellij/lang/Language;", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "isFromPropertyInMovedBlock", "expression", "Lorg/intellij/terraform/hcl/psi/common/SelectExpression;", "isUrlReference", "reference", "Lcom/intellij/psi/PsiReference;", "getErrorDescription", "", "hasBadResolve", "checkSoft", "Companion", "MyEV", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHILUnresolvedReferenceInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILUnresolvedReferenceInspection.kt\norg/intellij/terraform/hil/inspection/HILUnresolvedReferenceInspection\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,155:1\n66#2,2:156\n*S KotlinDebug\n*F\n+ 1 HILUnresolvedReferenceInspection.kt\norg/intellij/terraform/hil/inspection/HILUnresolvedReferenceInspection\n*L\n118#1:156,2\n*E\n"})
public final class HILUnresolvedReferenceInspection
extends LocalInspectionTool
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Language> allowedLanguages;
    @NotNull
    private static final Logger LOG;

    public HILUnresolvedReferenceInspection() {
        Object[] objectArray = new Language[]{HCLLanguage.INSTANCE, HILLanguage.INSTANCE};
        this.allowedLanguages = SetsKt.setOf((Object[])objectArray);
    }

    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (this.allowedLanguages.contains(file.getLanguage()) || UtilKt.isTerraformCompatiblePsiFile(file)) && UtilKt.isTerraformCompatiblePsiFile(InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    private final boolean isFromPropertyInMovedBlock(SelectExpression<?> expression) {
        PsiElement $this$parentOfType_u24default$iv = expression;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        HCLProperty hCLProperty = (HCLProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, HCLProperty.class, (boolean)true);
        if (hCLProperty == null) {
            return false;
        }
        HCLProperty property = hCLProperty;
        return TfPsiPatterns.INSTANCE.getFromPropertyInMovedBlock().accepts((Object)property);
    }

    public final boolean isUrlReference(@NotNull PsiReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return reference instanceof FileReferenceOwner;
    }

    @Nls
    @NotNull
    public final String getErrorDescription(@NotNull PsiReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        String messagePattern = null;
        if (reference instanceof EmptyResolveMessageProvider) {
            String string = ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUnresolvedMessagePattern(...)");
            messagePattern = string;
        } else {
            String string = HCLBundle.message("hil.unresolved.reference.inspection.unresolved.reference.error.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            messagePattern = string;
        }
        String description = null;
        try {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)reference.getCanonicalText(), (String)"getCanonicalText(...)");
            description = BundleBase.format((String)messagePattern, (Object[])objectArray);
        }
        catch (IllegalArgumentException ex) {
            description = messagePattern;
        }
        return description;
    }

    public final boolean hasBadResolve(@NotNull PsiReference reference, boolean checkSoft) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        if (!checkSoft && reference.isSoft()) {
            return false;
        }
        return ILSelectFromSomethingReferenceProviderKt.resolve(reference, false, true).isEmpty();
    }

    static {
        Logger logger = Logger.getInstance(HILUnresolvedReferenceInspection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/terraform/hil/inspection/HILUnresolvedReferenceInspection$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J%\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000b2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/intellij/terraform/hil/inspection/HILUnresolvedReferenceInspection$MyEV;", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/hil/inspection/HILUnresolvedReferenceInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "visitIdentifier", "Lorg/intellij/terraform/hcl/psi/common/Identifier;", "checkReferences", "value", "doCheckRefs", "references", "", "Lcom/intellij/psi/PsiReference;", "(Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/PsiReference;)V", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nHILUnresolvedReferenceInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HILUnresolvedReferenceInspection.kt\norg/intellij/terraform/hil/inspection/HILUnresolvedReferenceInspection$MyEV\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,155:1\n80#2:156\n1255#3,2:157\n18#4:159\n*S KotlinDebug\n*F\n+ 1 HILUnresolvedReferenceInspection.kt\norg/intellij/terraform/hil/inspection/HILUnresolvedReferenceInspection$MyEV\n*L\n59#1:156\n59#1:157,2\n108#1:159\n*E\n"})
    public final class MyEV
    extends PsiElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        /*
         * WARNING - void declaration
         */
        public void visitElement(@NotNull PsiElement element) {
            boolean bl;
            block3: {
                void $this$parentsOfType$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element;
                boolean withSelf$iv = true;
                boolean $i$f$parentsOfType = false;
                Sequence $this$any$iv = PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, HCLBlock.class, (boolean)withSelf$iv);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    HCLBlock it = (HCLBlock)element$iv;
                    boolean bl2 = false;
                    if (!OpenTofuPatterns.INSTANCE.getEncryptionBlock().accepts((Object)it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
            if (element instanceof Identifier) {
                this.visitIdentifier((Identifier)element);
                return;
            }
            ProgressIndicatorProvider.checkCanceled();
        }

        private final void visitIdentifier(Identifier element) {
            ProgressIndicatorProvider.checkCanceled();
            if (ILExpressionBaseKt.getHCLHost(element) == null) {
                return;
            }
            PsiElement psiElement = element.getParent();
            SelectExpression selectExpression = psiElement instanceof SelectExpression ? (SelectExpression)psiElement : null;
            if (selectExpression == null) {
                return;
            }
            SelectExpression parent = selectExpression;
            if (HILUnresolvedReferenceInspection.this.isFromPropertyInMovedBlock(parent)) {
                return;
            }
            if (parent.getFrom() == element) {
                this.checkReferences(element);
            } else if (HILVariableAnnotatorKt.isScopeElementReference(element, parent)) {
                this.checkReferences(element);
            } else if (HILVariableAnnotatorKt.isResourceInstanceReference(element, parent)) {
                this.checkReferences(element);
            } else if (HILVariableAnnotatorKt.isResourcePropertyReference(element, parent)) {
                this.checkReferences(element);
            }
        }

        private final void checkReferences(PsiElement value) {
            this.doCheckRefs(value, HCLPsiUtil.INSTANCE.getReferencesSelectAware(value));
        }

        private final void doCheckRefs(PsiElement value, PsiReference[] references) {
            for (PsiReference reference : references) {
                LocalQuickFix[] localQuickFixArray;
                TextRange referenceRange;
                ProgressManager.checkCanceled();
                if (reference.getElement() != value || HILUnresolvedReferenceInspection.this.isUrlReference(reference) || !HILUnresolvedReferenceInspection.this.hasBadResolve(reference, false)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)reference.getRangeInElement(), (String)"getRangeInElement(...)");
                String description = HILUnresolvedReferenceInspection.this.getErrorDescription(reference);
                if (referenceRange.getStartOffset() > referenceRange.getEndOffset()) {
                    LOG.error("Reference range start offset > end offset:  " + reference + ", start offset: " + referenceRange.getStartOffset() + ", end offset: " + referenceRange.getEndOffset());
                }
                LocalQuickFix[] $this$doCheckRefs_u24lambda_u240 = localQuickFixArray = CollectionsKt.createListBuilder();
                boolean bl = false;
                if (reference instanceof LocalQuickFixProvider) {
                    Collection collection = (Collection)$this$doCheckRefs_u24lambda_u240;
                    Object[] $this$orEmpty$iv = ((LocalQuickFixProvider)reference).getQuickFixes();
                    boolean $i$f$orEmpty = false;
                    Object[] objectArray = $this$orEmpty$iv;
                    if ($this$orEmpty$iv == null) {
                        objectArray = new LocalQuickFix[]{};
                    }
                    CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
                }
                PsiElement psiElement = reference.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
                com.intellij.util.containers.UtilKt.addIfNotNull((List)$this$doCheckRefs_u24lambda_u240, (Object)TfInitActionKt.createQuickFixNotInitialized(psiElement));
                List fixes = CollectionsKt.build((List)localQuickFixArray);
                Collection collection = fixes;
                Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                localQuickFixArray = (LocalQuickFix[])com.intellij.util.containers.UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
                this.holder.registerProblem(value, description, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, referenceRange, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        }
    }
}

