/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hil.HILTokenTypes;
import org.intellij.terraform.hil.psi.ILExpression;
import org.intellij.terraform.hil.psi.ILLiteralExpression;
import org.intellij.terraform.hil.psi.ILMethodCallExpression;
import org.intellij.terraform.hil.psi.ILUnaryExpression;
import org.intellij.terraform.hil.psi.ILVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/intellij/terraform/hil/psi/impl/HILPsiImplUtils;", "", "<init>", "()V", "getQualifier", "Lorg/intellij/terraform/hil/psi/ILExpression;", "expression", "Lorg/intellij/terraform/hil/psi/ILMethodCallExpression;", "getMethod", "Lorg/intellij/terraform/hil/psi/ILVariable;", "getName", "", "variable", "getUnquotedText", "literal", "Lorg/intellij/terraform/hil/psi/ILLiteralExpression;", "getOperationSign", "Lcom/intellij/psi/tree/IElementType;", "Lorg/intellij/terraform/hil/psi/ILUnaryExpression;", "intellij.terraform"})
public final class HILPsiImplUtils {
    @NotNull
    public static final HILPsiImplUtils INSTANCE = new HILPsiImplUtils();

    private HILPsiImplUtils() {
    }

    @Nullable
    public final ILExpression getQualifier(@NotNull ILMethodCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ILExpression iLExpression = expression.getCallee();
        Intrinsics.checkNotNullExpressionValue((Object)iLExpression, (String)"<get-callee>(...)");
        ILExpression select = iLExpression;
        return select == expression.getMethod() ? null : select;
    }

    @Nullable
    public final ILVariable getMethod(@NotNull ILMethodCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiElement sibling = expression.getParameterList().getPrevSibling();
        if (sibling instanceof ILVariable) {
            return (ILVariable)sibling;
        }
        return null;
    }

    @NotNull
    public final String getName(@NotNull ILVariable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        String string = variable.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final String getUnquotedText(@NotNull ILLiteralExpression literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        PsiElement dqs = literal.getDoubleQuotedString();
        if (dqs != null) {
            String string = StringUtil.unquoteString((String)dqs.getText());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
            return string;
        }
        String string = literal.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final IElementType getOperationSign(@NotNull ILUnaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Object[] objectArray = expression.getNode().getChildren(HILTokenTypes.INSTANCE.getIL_UNARY_OPERATORS());
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getChildren(...)");
        Object[] nodes = objectArray;
        IElementType iElementType = ((ASTNode)ArraysKt.first((Object[])nodes)).getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        return iElementType;
    }
}

