/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hil.refactoring;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.psi.TfElementGenerator;
import org.intellij.terraform.config.refactoring.BaseIntroduceOperation;
import org.intellij.terraform.config.refactoring.BaseIntroduceVariableHandler;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.common.BaseExpression;
import org.intellij.terraform.hil.psi.ILElementGenerator;
import org.intellij.terraform.hil.psi.ILExpression;
import org.intellij.terraform.hil.psi.ILExpressionHolder;
import org.intellij.terraform.hil.psi.ILLiteralExpression;
import org.intellij.terraform.hil.psi.ILMethodCallExpression;
import org.intellij.terraform.hil.psi.ILParameterList;
import org.intellij.terraform.hil.psi.ILParenthesizedExpression;
import org.intellij.terraform.hil.psi.ILPsiFile;
import org.intellij.terraform.hil.psi.ILSelectExpression;
import org.intellij.terraform.hil.psi.ILVariable;
import org.intellij.terraform.hil.psi.impl.ILExpressionBaseKt;
import org.intellij.terraform.hil.refactoring.ILIntroduceDialog;
import org.intellij.terraform.hil.refactoring.ILIntroduceVariableHandler;
import org.intellij.terraform.hil.refactoring.ILRefactoringUtil;
import org.intellij.terraform.hil.refactoring.IntroduceOperation;
import org.intellij.terraform.hil.refactoring.IntroduceValidator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u0016\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\"\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0004J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0015H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J \u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010$\u001a\u00020\u0002H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\"0.2\u0006\u0010$\u001a\u00020\u0002H\u0002J\u0010\u0010/\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\"0.2\u0006\u0010$\u001a\u00020\u0002H\u0002J\u0010\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u0015H\u0002R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00064"}, d2={"Lorg/intellij/terraform/hil/refactoring/ILIntroduceVariableHandler;", "Lorg/intellij/terraform/config/refactoring/BaseIntroduceVariableHandler;", "Lorg/intellij/terraform/hil/psi/ILExpression;", "<init>", "()V", "createOperation", "Lorg/intellij/terraform/hil/refactoring/IntroduceOperation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "performAction", "", "operation", "Lorg/intellij/terraform/config/refactoring/BaseIntroduceOperation;", "smartIntroduce", "", "checkIntroduceContext", "element", "Lcom/intellij/psi/PsiElement;", "isValidIntroduceContext", "isValidIntroduceVariant", "performActionOnElement", "performActionOnElementOccurrences", "performInplaceIntroduce", "performIntroduceWithDialog", "performRefactoring", "createDeclaration", "performReplace", "declaration", "createExpression", "name", "", "replaceExpression", "expression", "newExpression", "addDeclaration", "getOccurrences", "", "validator", "Lorg/intellij/terraform/hil/refactoring/IntroduceValidator;", "getValidator", "()Lorg/intellij/terraform/hil/refactoring/IntroduceValidator;", "getSuggestedNames", "", "ensureName", "generateSuggestedNames", "outermostParenthesizedILExpression", "expr", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nILIntroduceVariableHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ILIntroduceVariableHandler.kt\norg/intellij/terraform/hil/refactoring/ILIntroduceVariableHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,440:1\n774#2:441\n865#2,2:442\n1563#2:444\n1634#2,3:445\n*S KotlinDebug\n*F\n+ 1 ILIntroduceVariableHandler.kt\norg/intellij/terraform/hil/refactoring/ILIntroduceVariableHandler\n*L\n378#1:441\n378#1:442,2\n325#1:444\n325#1:445,3\n*E\n"})
public class ILIntroduceVariableHandler
extends BaseIntroduceVariableHandler<ILExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntroduceValidator validator = new IntroduceValidator();
    @NonNls
    @NotNull
    private static final String REFACTORING_ID = "hil.refactoring.extractVariable";

    @NotNull
    protected IntroduceOperation createOperation(@NotNull Editor editor, @NotNull PsiFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new IntroduceOperation(project, editor, file, null);
    }

    @Override
    public void performAction(@NotNull BaseIntroduceOperation<ILExpression> operation) {
        TemplateState templateState;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        if (!(operation instanceof IntroduceOperation)) {
            return;
        }
        PsiFile file = ((IntroduceOperation)operation).getFile();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)((PsiElement)file))) {
            return;
        }
        Editor editor = ((IntroduceOperation)operation).getEditor();
        if (editor.getSettings().isVariableInplaceRenameEnabled() && (templateState = TemplateManagerImpl.getTemplateState((Editor)((IntroduceOperation)operation).getEditor())) != null && !templateState.isFinished()) {
            return;
        }
        PsiElement element1 = null;
        PsiElement element2 = null;
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        if (selectionModel2.hasSelection()) {
            element1 = file.findElementAt(selectionModel2.getSelectionStart());
            element2 = file.findElementAt(selectionModel2.getSelectionEnd() - 1);
            if (element1 instanceof PsiWhiteSpace) {
                int startOffset = ((PsiWhiteSpace)element1).getTextRange().getEndOffset();
                element1 = file.findElementAt(startOffset);
            }
            if (element2 instanceof PsiWhiteSpace) {
                int endOffset = ((PsiWhiteSpace)element2).getTextRange().getStartOffset();
                element2 = file.findElementAt(endOffset - 1);
            }
        } else {
            if (this.smartIntroduce((IntroduceOperation)operation)) {
                return;
            }
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            CaretModel caretModel2 = caretModel;
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int lineNumber = document2.getLineNumber(caretModel2.getOffset());
            if (lineNumber >= 0 && lineNumber < document2.getLineCount()) {
                element1 = file.findElementAt(document2.getLineStartOffset(lineNumber));
                element2 = file.findElementAt(document2.getLineEndOffset(lineNumber) - 1);
            }
        }
        Project project = ((IntroduceOperation)operation).getProject();
        if (element1 == null || element2 == null) {
            BaseIntroduceVariableHandler.Companion.showCannotPerformError(project, editor);
            return;
        }
        if ((element1 = (PsiElement)ILRefactoringUtil.INSTANCE.getSelectedExpression(element1, element2)) == null || !this.isValidIntroduceVariant(element1)) {
            BaseIntroduceVariableHandler.Companion.showCannotPerformError(project, editor);
            return;
        }
        if (!this.checkIntroduceContext(file, editor, element1)) {
            return;
        }
        ((IntroduceOperation)operation).setElement(element1);
        this.performActionOnElement((IntroduceOperation)operation);
    }

    private final boolean smartIntroduce(IntroduceOperation operation) {
        int offset;
        Editor editor = operation.getEditor();
        PsiFile file = operation.getFile();
        PsiElement elementAtCaret = file.findElementAt(offset = editor.getCaretModel().getOffset());
        if ((elementAtCaret instanceof PsiWhiteSpace && offset == ((PsiWhiteSpace)elementAtCaret).getTextOffset() || elementAtCaret == null) && offset > 0) {
            elementAtCaret = file.findElementAt(offset - 1);
        }
        if (!this.checkIntroduceContext(file, editor, elementAtCaret)) {
            return true;
        }
        ArrayList<PsiElement> expressions = new ArrayList<PsiElement>();
        while (elementAtCaret != null && !(elementAtCaret instanceof ILExpressionHolder) && !(elementAtCaret instanceof ILPsiFile)) {
            if (elementAtCaret instanceof ILExpression && this.isValidIntroduceVariant(elementAtCaret)) {
                expressions.add(elementAtCaret);
            }
            elementAtCaret = elementAtCaret.getParent();
        }
        if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            operation.setElement((PsiElement)expressions.get(0));
            this.performActionOnElement(operation);
            return true;
        }
        if (expressions.size() > 1) {
            IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions, (Pass)((Pass)new Pass<ILExpression>(operation, this){
                final /* synthetic */ IntroduceOperation $operation;
                final /* synthetic */ ILIntroduceVariableHandler this$0;
                {
                    this.$operation = $operation;
                    this.this$0 = $receiver;
                }

                public void pass(ILExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.$operation.setElement(expression);
                    ILIntroduceVariableHandler.access$performActionOnElement(this.this$0, this.$operation);
                }
            }), arg_0 -> ILIntroduceVariableHandler.smartIntroduce$lambda$0(smartIntroduce.2.INSTANCE, arg_0));
            return true;
        }
        return false;
    }

    private final boolean checkIntroduceContext(PsiFile file, Editor editor, PsiElement element) {
        if (!this.isValidIntroduceContext(element)) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BaseIntroduceVariableHandler.Companion.showCannotPerformError(project, editor);
            return false;
        }
        return true;
    }

    private final boolean isValidIntroduceContext(PsiElement element) {
        return element != null;
    }

    private final boolean isValidIntroduceVariant(PsiElement element) {
        ILMethodCallExpression call;
        PsiElement psiElement = element.getParent();
        ILMethodCallExpression iLMethodCallExpression = call = psiElement instanceof ILMethodCallExpression ? (ILMethodCallExpression)psiElement : null;
        if (call != null && call.getCallee() == element) {
            return false;
        }
        if (element instanceof ILParameterList) {
            return false;
        }
        return element instanceof ILLiteralExpression;
    }

    private final void performActionOnElement(IntroduceOperation operation) {
        PsiElement element = operation.getElement();
        ILExpression initializer = (ILExpression)element;
        operation.setInitializer((PsiElement)initializer);
        if (initializer != null) {
            operation.setOccurrences(this.getOccurrences(element, initializer));
            operation.setSuggestedNames(this.getSuggestedNames(initializer));
        }
        if (operation.getOccurrences().isEmpty()) {
            operation.setReplaceAll(false);
        }
        this.performActionOnElementOccurrences(operation);
    }

    private final void performActionOnElementOccurrences(IntroduceOperation operation) {
        Editor editor = operation.getEditor();
        if (editor.getSettings().isVariableInplaceRenameEnabled()) {
            this.ensureName(operation);
            if (operation.isReplaceAll()) {
                this.performInplaceIntroduce(operation);
            } else {
                OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)operation.getElement(), operation.getOccurrences(), (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(operation, this){
                    final /* synthetic */ IntroduceOperation $operation;
                    final /* synthetic */ ILIntroduceVariableHandler this$0;
                    {
                        this.$operation = $operation;
                        this.this$0 = $receiver;
                    }

                    public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                        Intrinsics.checkNotNullParameter((Object)replaceChoice, (String)"replaceChoice");
                        this.$operation.setReplaceAll(replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
                        this.this$0.performInplaceIntroduce(this.$operation);
                    }
                });
            }
        } else {
            this.performIntroduceWithDialog(operation);
        }
    }

    protected final void performInplaceIntroduce(@NotNull IntroduceOperation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        PsiElement statement = this.performRefactoring(operation);
        if (statement instanceof HCLBlock) {
            PsiElement elementForCaret;
            PsiElement psiElement = ((HCLBlock)statement).getNameIdentifier();
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement target = psiElement;
            List<PsiElement> occurrences = operation.getOccurrences();
            PsiElement occurrence = Companion.findOccurrenceUnderCaret(occurrences, operation.getEditor());
            PsiElement psiElement2 = occurrence;
            if (psiElement2 == null) {
                psiElement2 = target;
            }
            if ((elementForCaret = psiElement2) instanceof ILSelectExpression) {
                ILExpression iLExpression = ((ILSelectExpression)elementForCaret).getField();
                Intrinsics.checkNotNull((Object)iLExpression, (String)"null cannot be cast to non-null type org.intellij.terraform.hil.psi.ILVariable");
                elementForCaret = (ILVariable)iLExpression;
            }
            operation.getEditor().getCaretModel().moveToOffset(elementForCaret.getTextRange().getStartOffset());
        }
    }

    private final void performIntroduceWithDialog(IntroduceOperation operation) {
        Project project = operation.getProject();
        if (operation.getName() == null) {
            ILIntroduceDialog dialog = new ILIntroduceDialog(project, HCLBundle.message("hil.introduce.variable.handler.dialog.caption", new Object[0]), this.validator, operation);
            if (!dialog.showAndGet()) {
                return;
            }
            operation.setName(dialog.getName());
            operation.setReplaceAll(dialog.doReplaceAllOccurrences());
        }
        PsiElement psiElement = this.performRefactoring(operation);
        if (psiElement == null) {
            return;
        }
        PsiElement declaration = psiElement;
        Editor editor = operation.getEditor();
        editor.getCaretModel().moveToOffset(declaration.getTextRange().getEndOffset());
        editor.getSelectionModel().removeSelection();
    }

    private final PsiElement performRefactoring(IntroduceOperation operation) {
        PsiElement declaration = this.createDeclaration(operation);
        if (declaration == null) {
            BaseIntroduceVariableHandler.Companion.showCannotPerformError(operation.getProject(), operation.getEditor());
            return null;
        }
        declaration = this.performReplace(declaration, operation);
        declaration = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)declaration);
        return declaration;
    }

    private final PsiElement createDeclaration(IntroduceOperation operation) {
        ILExpression iLExpression = (ILExpression)operation.getInitializer();
        if (iLExpression == null) {
            return null;
        }
        ILExpression expr = iLExpression;
        String string = operation.getName();
        if (string == null) {
            return null;
        }
        String name = string;
        HclType hclType = ExtensionsKt.getType(expr);
        if (hclType == null) {
            hclType = Types.INSTANCE.getString();
        }
        HclType type = hclType;
        return new TfElementGenerator(operation.getProject()).createVariable(name, type, expr);
    }

    private final PsiElement performReplace(PsiElement declaration, IntroduceOperation operation) {
        Object t = operation.getInitializer();
        Intrinsics.checkNotNull(t);
        ILExpression expression = (ILExpression)t;
        Project project = operation.getProject();
        PsiFile[] psiFileArray = new PsiFile[1];
        HCLElement hCLElement = ILExpressionBaseKt.getHCLHost(expression);
        if (hCLElement == null || (hCLElement = hCLElement.getContainingFile()) == null) {
            hCLElement = expression.getContainingFile();
        }
        psiFileArray[0] = hCLElement;
        Object object = WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])psiFileArray).compute(() -> ILIntroduceVariableHandler.performReplace$lambda$0(declaration, project, this, operation, expression));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (PsiElement)object;
    }

    private final PsiElement createExpression(Project project, String name) {
        return new ILElementGenerator(project).createVarReference(name);
    }

    private final PsiElement replaceExpression(PsiElement expression, PsiElement newExpression) {
        PsiElement psiElement = this.outermostParenthesizedILExpression(expression).replace(newExpression);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"replace(...)");
        return psiElement;
    }

    private final PsiElement addDeclaration(IntroduceOperation operation, PsiElement declaration) {
        PsiElement anchor;
        if (operation.isReplaceAll()) {
            v0 = Companion.findAnchor(operation.getOccurrences());
        } else {
            Object t = operation.getInitializer();
            Intrinsics.checkNotNull(t);
            v0 = anchor = Companion.findAnchor((PsiElement)t);
        }
        if (anchor == null) {
            CommonRefactoringUtil.showErrorHint((Project)operation.getProject(), (Editor)operation.getEditor(), (String)RefactoringBundle.getCannotRefactorMessage((String)HCLBundle.message("refactoring.introduce.anchor.error", new Object[0])), (String)HCLBundle.message("refactoring.introduce.error", new Object[0]), null);
            return null;
        }
        return anchor.getParent().addBefore(declaration, anchor);
    }

    private final List<PsiElement> getOccurrences(PsiElement element, ILExpression expression) {
        PsiElement context;
        ILExpressionHolder iLExpressionHolder = (ILExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)element, ILExpressionHolder.class, (boolean)true);
        PsiElement psiElement = context = iLExpressionHolder != null ? (PsiElement)iLExpressionHolder : element;
        if (context == null) {
            context = (PsiElement)expression.getContainingFile();
        }
        return ILRefactoringUtil.INSTANCE.getOccurrences(expression, context);
    }

    @NotNull
    public final IntroduceValidator getValidator() {
        return this.validator;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> getSuggestedNames(ILExpression expression) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Collection<String> candidates = this.generateSuggestedNames(expression);
        Iterable iterable = candidates;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.validator.checkPossibleName(it, expression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List res = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (res.isEmpty()) {
            for (String name : candidates) {
                int index = 1;
                while (!this.validator.checkPossibleName(name + index, expression)) {
                    ++index;
                }
                res.add(name + index);
            }
        }
        if (res.isEmpty()) {
            ((Collection)res).add("a");
        }
        return res;
    }

    private final void ensureName(IntroduceOperation operation) {
        if (operation.getName() == null) {
            Collection<String> suggestedNames = operation.getSuggestedNames();
            Collection<String> collection = suggestedNames;
            if (!(collection == null || collection.isEmpty())) {
                operation.setName((String)CollectionsKt.first((Iterable)suggestedNames));
            } else {
                operation.setName("x");
            }
        }
    }

    private final Collection<String> generateSuggestedNames(ILExpression expression) {
        ILParameterList list;
        HclType type;
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        String text = expression.getText();
        if (expression instanceof ILMethodCallExpression) {
            text = ((ILMethodCallExpression)expression).getCallee().getText();
        }
        if (text != null) {
            candidates.addAll(ILRefactoringUtil.INSTANCE.generateNames(text));
        }
        if ((type = ExtensionsKt.getType(expression)) != null) {
            candidates.addAll(ILRefactoringUtil.INSTANCE.generateNamesByType(type.getPresentableText()));
        }
        if ((list = (ILParameterList)PsiTreeUtil.getParentOfType((PsiElement)expression, ILParameterList.class)) != null) {
            PsiElement psiElement = list.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hil.psi.ILMethodCallExpression");
            ILMethodCallExpression call = (ILMethodCallExpression)psiElement;
            candidates.add("arg");
        }
        return candidates;
    }

    private final PsiElement outermostParenthesizedILExpression(PsiElement expr) {
        if (!(expr instanceof ILExpression)) {
            return expr;
        }
        ILExpression e = (ILExpression)expr;
        while (e.getParent() instanceof ILParenthesizedExpression) {
            PsiElement psiElement = e.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hil.psi.ILParenthesizedExpression");
            e = (ILParenthesizedExpression)psiElement;
        }
        return e;
    }

    private static final String smartIntroduce$lambda$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final PsiElement performReplace$lambda$0(PsiElement $declaration, Project $project, ILIntroduceVariableHandler this$0, IntroduceOperation $operation, ILExpression $expression) {
        try {
            Iterable iterable;
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement($declaration);
            MessageBus messageBus = $project.getMessageBus();
            Topic topic = RefactoringEventListener.REFACTORING_EVENT_TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"REFACTORING_EVENT_TOPIC");
            ((RefactoringEventListener)messageBus.syncPublisher(topic)).refactoringStarted(REFACTORING_ID, afterData);
            PsiElement result2 = this$0.addDeclaration($operation, $declaration);
            String string = $operation.getName();
            Intrinsics.checkNotNull((Object)string);
            PsiElement newExpression = this$0.createExpression($project, string);
            if ($operation.isReplaceAll()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                iterable = $operation.getOccurrences();
                IntroduceOperation introduceOperation = $operation;
                boolean $i$f$map = false;
                void var10_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PsiElement psiElement = (PsiElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this$0.replaceExpression((PsiElement)it, newExpression));
                }
                introduceOperation.setOccurrences((List)destination$iv$iv);
            } else {
                PsiElement replaced = this$0.replaceExpression($expression, newExpression);
                $operation.setOccurrences(CollectionsKt.listOf((Object)replaced));
            }
            iterable = result2;
            return iterable;
        }
        finally {
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement($declaration);
            MessageBus messageBus = $project.getMessageBus();
            Topic topic = RefactoringEventListener.REFACTORING_EVENT_TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"REFACTORING_EVENT_TOPIC");
            ((RefactoringEventListener)messageBus.syncPublisher(topic)).refactoringDone(REFACTORING_ID, afterData);
        }
    }

    public static final /* synthetic */ void access$performActionOnElement(ILIntroduceVariableHandler $this, IntroduceOperation operation) {
        $this.performActionOnElement(operation);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/hil/refactoring/ILIntroduceVariableHandler$Companion;", "", "<init>", "()V", "REFACTORING_ID", "", "getREFACTORING_ID", "()Ljava/lang/String;", "findOccurrenceUnderCaret", "Lcom/intellij/psi/PsiElement;", "occurrences", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "findAnchor", "occurrence", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nILIntroduceVariableHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ILIntroduceVariableHandler.kt\norg/intellij/terraform/hil/refactoring/ILIntroduceVariableHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,440:1\n295#2,2:441\n1617#2,9:444\n1869#2:453\n1870#2:455\n1626#2:456\n1563#2:457\n1634#2,3:458\n1617#2,9:461\n1869#2:470\n1870#2:472\n1626#2:473\n1#3:443\n1#3:454\n1#3:471\n*S KotlinDebug\n*F\n+ 1 ILIntroduceVariableHandler.kt\norg/intellij/terraform/hil/refactoring/ILIntroduceVariableHandler$Companion\n*L\n43#1:441,2\n64#1:444,9\n64#1:453\n64#1:455\n64#1:456\n74#1:457\n74#1:458,3\n77#1:461,9\n77#1:470\n77#1:472\n77#1:473\n64#1:454\n77#1:471\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getREFACTORING_ID() {
            return REFACTORING_ID;
        }

        @Nullable
        public final PsiElement findOccurrenceUnderCaret(@NotNull List<? extends PsiElement> occurrences, @NotNull Editor editor) {
            Object v0;
            int offset;
            block5: {
                Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                if (occurrences.isEmpty()) {
                    return null;
                }
                offset = editor.getCaretModel().getOffset();
                Iterable $this$firstOrNull$iv = occurrences;
                boolean bl = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!it.getTextRange().contains(offset)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            PsiElement psiElement = v0;
            if (psiElement != null) {
                PsiElement psiElement2 = psiElement;
                boolean bl = false;
                return psiElement2;
            }
            int line = editor.getDocument().getLineNumber(offset);
            for (PsiElement psiElement3 : occurrences) {
                PsiUtilCore.ensureValid((PsiElement)psiElement3);
                if (!psiElement3.isValid() || editor.getDocument().getLineNumber(psiElement3.getTextRange().getStartOffset()) != line) continue;
                return psiElement3;
            }
            Iterator<? extends PsiElement> iterator = occurrences.iterator();
            if (iterator.hasNext()) {
                PsiElement psiElement4 = iterator.next();
                PsiUtilCore.ensureValid((PsiElement)psiElement4);
                return psiElement4;
            }
            return null;
        }

        @Nullable
        public final PsiElement findAnchor(@NotNull PsiElement occurrence) {
            Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
            return this.findAnchor(CollectionsKt.listOf((Object)occurrence));
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PsiElement findAnchor(@NotNull List<? extends PsiElement> occurrences) {
            PsiElement aChildren;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
            Iterable $this$mapNotNull$iv = occurrences;
            boolean $i$f$mapNotNull22 = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiElement it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof BaseExpression ? (PsiElement)ILExpressionBaseKt.getHCLHost((BaseExpression)it) : it) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List hosts = (List)destination$iv$iv;
            if (hosts.isEmpty()) {
                return null;
            }
            Iterable $i$f$mapNotNull22 = hosts;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element$iv$iv$iv = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getTextRange().getStartOffset());
            }
            Comparable comparable = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv2));
            Intrinsics.checkNotNull((Object)comparable);
            int minOffset = ((Number)((Object)comparable)).intValue();
            Iterable $this$mapNotNull$iv2 = hosts;
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$mapTo22 = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                PsiFile it$iv$iv;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
                boolean bl = false;
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl4 = false;
                if (it.getContainingFile() == null) continue;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            PsiFile psiFile = (PsiFile)CollectionsKt.firstOrNull((List)((List)destination$iv$iv3));
            if (psiFile == null) {
                return null;
            }
            PsiFile statements = psiFile;
            PsiElement child = null;
            PsiElement[] psiElementArray = statements.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            PsiElement[] psiElementArray2 = psiElementArray;
            int n = psiElementArray2.length;
            for (int i = 0; i < n && !(child = (aChildren = psiElementArray2[i])).getTextRange().contains(minOffset); ++i) {
            }
            return child;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

