/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.install;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.install.FailedInstallation;
import org.intellij.terraform.install.InstallationResult;
import org.intellij.terraform.install.SuccessfulInstallation;
import org.intellij.terraform.install.TfBinaryInstallerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0002J&\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u001c\u0010\u001c\u001a\u00020\u001d2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006("}, d2={"Lorg/intellij/terraform/install/TfBinaryInstaller;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "runInstallation", "Lorg/intellij/terraform/install/InstallationResult;", "binaryName", "", "urlProvider", "installDirectory", "Ljava/nio/file/Path;", "download", "findBinary", "Lkotlin/Pair;", "file", "unpackArchiveIfNeeded", "normalizeBinaryPath", "binaryPath", "makeExecutable", "", "binary", "moveToInstallationDir", "installationDir", "addInstallationDirToPath", "cleanup", "", "folder", "readPathFromRegistry", "appendToPath", "oldPath", "newEntry", "updatePathInRegistry", "value", "createRequest", "Lcom/intellij/util/io/RequestBuilder;", "url", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfBinaryInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfBinaryInstaller.kt\norg/intellij/terraform/install/TfBinaryInstaller\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n13#2:261\n13#2:262\n13#2:263\n13#2:264\n13#2:268\n13#2:269\n13#2:270\n13#2:271\n13#2:272\n13#2:273\n13#2:274\n13#2:275\n13#2:276\n13#2:283\n2746#3,3:265\n1761#3,3:277\n774#3:280\n865#3,2:281\n*S KotlinDebug\n*F\n+ 1 TfBinaryInstaller.kt\norg/intellij/terraform/install/TfBinaryInstaller\n*L\n43#1:261\n60#1:262\n74#1:263\n83#1:264\n121#1:268\n138#1:269\n158#1:270\n159#1:271\n164#1:272\n176#1:273\n183#1:274\n193#1:275\n217#1:276\n243#1:283\n105#1:265,3\n227#1:277,3\n232#1:280\n232#1:281,2\n*E\n"})
public final class TfBinaryInstaller {
    @NotNull
    private final CoroutineScope scope;

    public TfBinaryInstaller(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @RequiresBackgroundThread
    @NotNull
    public final InstallationResult runInstallation(@NotNull String binaryName, @NotNull String urlProvider, @Nullable Path installDirectory) {
        Path normalizedBinary;
        Intrinsics.checkNotNullParameter((Object)binaryName, (String)"binaryName");
        Intrinsics.checkNotNullParameter((Object)urlProvider, (String)"urlProvider");
        if (((CharSequence)binaryName).length() == 0) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfBinaryInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("No binary name provided");
            Supplier<String> supplier = HCLBundle.messagePointer("binary.installation.failed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        Path path = this.download(urlProvider);
        if (path == null) {
            Object[] objectArray = new Object[]{binaryName};
            Supplier<String> supplier = HCLBundle.messagePointer("binary.installation.download.failed", objectArray);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        Path download = path;
        Pair<Path, Path> pair = this.findBinary(download, binaryName);
        if (pair == null) {
            Object[] objectArray = new Object[]{binaryName};
            Supplier<String> supplier = HCLBundle.messagePointer("binary.installation.search.failed", objectArray);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        Pair<Path, Path> pair2 = pair;
        Path folder = (Path)pair2.component1();
        Path binaryPath = (Path)pair2.component2();
        Path path2 = normalizedBinary = !Intrinsics.areEqual((Object)binaryName, (Object)PathsKt.getName((Path)binaryPath)) ? this.normalizeBinaryPath(binaryName, binaryPath) : binaryPath;
        if (!SystemInfoRt.isWindows && !this.makeExecutable(normalizedBinary)) {
            this.cleanup(download, folder);
            Object[] objectArray = new Object[]{binaryName};
            Supplier<String> supplier = HCLBundle.messagePointer("binary.installation.make.executable.failed", objectArray);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        if (installDirectory == null) {
            this.cleanup(download, folder);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfBinaryInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("No binary installation dir provided");
            Supplier<String> supplier = HCLBundle.messagePointer("binary.installation.failed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        if (!this.moveToInstallationDir(normalizedBinary, installDirectory)) {
            this.cleanup(download, folder);
            Object[] objectArray = new Object[]{installDirectory};
            Supplier<String> supplier = HCLBundle.messagePointer("binary.installation.move.to.installation.dir.failed", objectArray);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        this.cleanup(download, folder);
        String[] stringArray = new String[]{binaryName};
        Path path3 = Paths.get(((Object)installDirectory.toAbsolutePath()).toString(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        return new SuccessfulInstallation(path3);
    }

    private final Path download(String urlProvider) {
        if (((CharSequence)urlProvider).length() == 0) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfBinaryInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("No binary download URL provided");
            return null;
        }
        String[] stringArray = new String[]{StringsKt.substringAfterLast$default((String)urlProvider, (char)'/', null, (int)2, null)};
        Path file = Paths.get(PathManager.getTempPath(), stringArray);
        try {
            this.createRequest(urlProvider).saveToFile(file, null);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfBinaryInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to download binary from: " + urlProvider, (Throwable)e);
            return null;
        }
        return file;
    }

    private final Pair<Path, Path> findBinary(Path file, String binaryName) {
        if (Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)binaryName)) {
            return TuplesKt.to((Object)file, (Object)file);
        }
        Path path = this.unpackArchiveIfNeeded(file);
        if (path == null) {
            return null;
        }
        Path folder = path;
        if (Files.isRegularFile(folder, new LinkOption[0])) {
            return TuplesKt.to((Object)folder, (Object)folder);
        }
        Optional<Object> optional = Files.walk(folder, new FileVisitOption[0]).filter(arg_0 -> TfBinaryInstaller.findBinary$lambda$1(arg_0 -> TfBinaryInstaller.findBinary$lambda$0(binaryName, arg_0), arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
        Path path2 = (Path)OptionalsKt.getOrNull(optional);
        if (path2 == null) {
            return null;
        }
        Path binary = path2;
        return TuplesKt.to((Object)folder, (Object)binary);
    }

    private final Path unpackArchiveIfNeeded(Path download) {
        Path archiveContent;
        boolean bl;
        String downloadFileName;
        block6: {
            downloadFileName = PathsKt.getName((Path)download);
            Iterable $this$none$iv = TfBinaryInstallerKt.access$getSUPPORTED_ARCHIVE_TYPES$p();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)downloadFileName, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return download;
        }
        if (StringsKt.endsWith$default((String)downloadFileName, (String)".zip", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{StringsKt.removeSuffix((String)downloadFileName, (CharSequence)".zip")};
            archiveContent = Paths.get(((Object)download.getParent()).toString(), stringArray);
            new Decompressor.Zip(download).withZipExtensions().extract(archiveContent);
            return archiveContent;
        }
        if (StringsKt.endsWith$default((String)downloadFileName, (String)".tar.gz", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{StringsKt.removeSuffix((String)downloadFileName, (CharSequence)".tar.gz")};
            archiveContent = Paths.get(((Object)download.getParent()).toString(), stringArray);
            new Decompressor.Tar(download).extract(archiveContent);
            return archiveContent;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TfBinaryInstaller.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Unsupported archive type: " + downloadFileName);
        return null;
    }

    private final Path normalizeBinaryPath(String binaryName, Path binaryPath) {
        Path normalizedBinaryPath = binaryPath.getParent().resolve(binaryName);
        Files.move(binaryPath, normalizedBinaryPath, new CopyOption[0]);
        Intrinsics.checkNotNull((Object)normalizedBinaryPath);
        return normalizedBinaryPath;
    }

    private final boolean makeExecutable(Path binary) {
        try {
            Path path = binary;
            PosixFilePermission[] posixFilePermissionArray = new PosixFilePermission[]{PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OWNER_EXECUTE};
            Intrinsics.checkNotNullExpressionValue((Object)Files.setPosixFilePermissions(path, SetsKt.setOf((Object[])posixFilePermissionArray)), (String)"setPosixFilePermissions(...)");
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfBinaryInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to make '" + ((Object)binary.toAbsolutePath()).toString() + "' executable", (Throwable)e);
        }
        return Files.isExecutable(binary);
    }

    private final boolean moveToInstallationDir(Path binary, Path installationDir) {
        try {
            GeneralCommandLine generalCommandLine;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(installationDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Files.createDirectories(installationDir, new FileAttribute[0]);
            }
            if (SystemInfoRt.isWindows) {
                var4_3 = new String[]{"cmd.exe", "/c", "move", ((Object)binary.toAbsolutePath()).toString(), ((Object)installationDir.toAbsolutePath()).toString()};
                GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(var4_3);
                generalCommandLine = generalCommandLine2;
            } else {
                var4_3 = new String[]{"mv", ((Object)binary.toAbsolutePath()).toString(), ((Object)installationDir.toAbsolutePath()).toString()};
                GeneralCommandLine generalCommandLine3 = new GeneralCommandLine(var4_3);
                Object[] objectArray = new Object[]{installationDir};
                String string = HCLBundle.message("binary.installation.move.to.installation.dir", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                generalCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)generalCommandLine3, (String)string);
            }
            GeneralCommandLine commandLine = generalCommandLine;
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfBinaryInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            if (!output.checkSuccess(logger)) {
                $i$f$logger = false;
                Logger logger2 = Logger.getInstance(TfBinaryInstaller.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.error(output.getStderr());
                return false;
            }
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfBinaryInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
            return false;
        }
        return !SystemInfoRt.isWindows || this.addInstallationDirToPath(installationDir);
    }

    private final boolean addInstallationDirToPath(Path installationDir) {
        String userPath;
        String newUserPath;
        String locationToAdd = ((Object)installationDir.toAbsolutePath()).toString();
        String string = this.readPathFromRegistry();
        if (string == null) {
            string = "";
        }
        if ((newUserPath = this.appendToPath(userPath = string, locationToAdd)) == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfBinaryInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("The '" + locationToAdd + "' location is already in the user PATH (`" + userPath + "`)");
            return true;
        }
        if (!this.updatePathInRegistry(newUserPath)) {
            return false;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TfBinaryInstaller.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("The '" + locationToAdd + "' location is added to the user PATH (`" + userPath + "`)");
        return true;
    }

    private final void cleanup(Path download, Path folder) {
        try {
            if (download != null) {
                NioFiles.deleteRecursively((Path)download);
            }
            if (folder != null) {
                NioFiles.deleteRecursively((Path)folder);
            }
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfBinaryInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("An exception thrown during cleanup after binary installation", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readPathFromRegistry() {
        try {
            WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
            int rc = Advapi32.INSTANCE.RegOpenKeyEx(WinReg.HKEY_CURRENT_USER, "Environment", 0, 131609, phkKey);
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
            try {
                Object object = Advapi32Util.registryGetValue((WinReg.HKEY)phkKey.getValue(), (String)"", (String)"Path");
                String string = object != null ? object.toString() : null;
                return string;
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)phkKey.getValue());
            }
        }
        catch (Win32Exception t) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfBinaryInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unable to read registry key 'WinReg.HKEY_CURRENT_USER\\Environment' valueName 'Path': " + t.getMessage());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String appendToPath(String oldPath, String newEntry) {
        void $this$filterTo$iv$iv;
        boolean alreadyAdded;
        List pathElements;
        String pathSeparator;
        block5: {
            pathSeparator = FileSystems.getDefault().getSeparator();
            CharSequence charSequence = oldPath;
            String[] stringArray = new String[1];
            Intrinsics.checkNotNull((Object)pathSeparator);
            stringArray[0] = pathSeparator;
            pathElements = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Iterable $this$any$iv = pathElements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it, (String)newEntry, (boolean)true)) continue;
                    v1 = true;
                    break block5;
                }
                v1 = alreadyAdded = false;
            }
        }
        if (alreadyAdded) {
            return null;
        }
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)pathElements, (Object)newEntry);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)p0).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, arg_0 -> TfBinaryInstaller.appendToPath$lambda$1(pathSeparator, arg_0), (int)30, null);
    }

    private final boolean updatePathInRegistry(String value) {
        try {
            int branch = 512;
            Advapi32Util.registryCreateKey((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Environment", (int)branch);
            Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Environment", (String)"Path", (String)value, (int)branch);
            return true;
        }
        catch (Win32Exception t) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TfBinaryInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unable to write registry key 'HKEY_CURRENT_USER\\Environment' valueName 'Path': " + t.getMessage());
            return false;
        }
    }

    private final RequestBuilder createRequest(String url) {
        RequestBuilder requestBuilder = HttpRequests.request((String)url).productNameAsUserAgent();
        Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"productNameAsUserAgent(...)");
        return requestBuilder;
    }

    private static final boolean findBinary$lambda$0(String $binaryName, Path it) {
        return Intrinsics.areEqual((Object)((Object)it.getFileName()).toString(), (Object)$binaryName);
    }

    private static final boolean findBinary$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence appendToPath$lambda$1(String $pathSeparator, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + $pathSeparator;
    }
}

