/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.install;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.system.CpuArch;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.intellij.terraform.install.TfBinaryInstaller;
import org.intellij.terraform.install.TfToolsUtilKt;
import org.intellij.terraform.opentofu.runtime.OpenTofuProjectSettings;
import org.intellij.terraform.runtime.TfProjectSettings;
import org.intellij.terraform.runtime.TfToolSettings;
import org.intellij.terraform.terragrunt.runtime.TerragruntProjectSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\u0012\u001a\u00020\u0003H$J\u000e\u0010\u0013\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0003H\u0004J\b\u0010\u0016\u001a\u00020\u0003H\u0004J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u001b"}, d2={"Lorg/intellij/terraform/install/TfToolType;", "", "executableName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getExecutableName", "()Ljava/lang/String;", "TERRAFORM", "OPENTOFU", "TERRAGRUNT", "getBinaryName", "displayName", "getDisplayName", "getToolSettings", "Lorg/intellij/terraform/runtime/TfToolSettings;", "project", "Lcom/intellij/openapi/project/Project;", "fetchDownloadUrl", "getDownloadUrl", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOSName", "getArchName", "getInstallationDirectory", "Ljava/nio/file/Path;", "toSystemIndependentName", "filePath", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfToolsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfToolsUtil.kt\norg/intellij/terraform/install/TfToolType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public abstract class TfToolType
extends Enum<TfToolType> {
    @NotNull
    private final String executableName;
    public static final /* enum */ TfToolType TERRAFORM = new TERRAFORM("TERRAFORM", 0);
    public static final /* enum */ TfToolType OPENTOFU = new OPENTOFU("OPENTOFU", 1);
    public static final /* enum */ TfToolType TERRAGRUNT = new TERRAGRUNT("TERRAGRUNT", 2);
    private static final /* synthetic */ TfToolType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private TfToolType(String executableName) {
        this.executableName = executableName;
    }

    @NotNull
    public final String getExecutableName() {
        return this.executableName;
    }

    @NotNull
    public final String getBinaryName() {
        return TfToolsUtilKt.getBinaryName(this.executableName);
    }

    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract TfToolSettings getToolSettings(@NotNull Project var1);

    @NotNull
    protected abstract String fetchDownloadUrl();

    @Nullable
    public final Object getDownloadUrl(@NotNull Continuation<? super String> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, null){
            int label;
            final /* synthetic */ TfToolType this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return this.this$0.fetchDownloadUrl();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    protected final String getOSName() {
        return SystemInfoRt.isWindows ? "windows" : (SystemInfoRt.isLinux ? "linux" : (SystemInfoRt.isMac ? "darwin" : (SystemInfoRt.isFreeBSD ? "freebsd" : "")));
    }

    @NotNull
    protected final String getArchName() {
        CpuArch cpuArch = CpuArch.CURRENT;
        return switch (cpuArch == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cpuArch.ordinal()]) {
            case 1 -> "386";
            case 2 -> "amd64";
            case 3 -> "arm";
            case 4 -> "arm64";
            default -> "";
        };
    }

    @Nullable
    public Path getInstallationDirectory() {
        Path path;
        if (SystemInfoRt.isWindows) {
            String string;
            String it = string = StringsKt.substringBefore$default((String)this.getBinaryName(), (char)'.', null, (int)2, null);
            boolean bl = false;
            String string2 = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 == null) {
                return null;
            }
            String binaryFolderName = string2;
            Object p0 = System.getProperty("user.home") + "/.jetbrains/" + binaryFolderName + "/";
            boolean bl2 = false;
            p0 = this.toSystemIndependentName((String)p0);
            boolean bl3 = false;
            path = Paths.get((String)p0, new String[0]);
        } else {
            path = Paths.get("/usr/local/bin/", new String[0]);
        }
        return path;
    }

    private final String toSystemIndependentName(String filePath) {
        String pathSeparator = FileSystems.getDefault().getSeparator();
        Intrinsics.checkNotNull((Object)pathSeparator);
        return StringsKt.replace$default((String)filePath, (String)pathSeparator, (String)"/", (boolean)false, (int)4, null);
    }

    public static TfToolType[] values() {
        return (TfToolType[])$VALUES.clone();
    }

    public static TfToolType valueOf(String value) {
        return Enum.valueOf(TfToolType.class, value);
    }

    @NotNull
    public static EnumEntries<TfToolType> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ TfToolType(String $enum$name, int $enum$ordinal, String executableName, DefaultConstructorMarker $constructor_marker) {
        this(executableName);
    }

    static {
        $VALUES = tfToolTypeArray = new TfToolType[]{TfToolType.TERRAFORM, TfToolType.OPENTOFU, TfToolType.TERRAGRUNT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0003H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u000b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005\u00a8\u0006\u000e"}, d2={"org/intellij/terraform/install/TfToolType.OPENTOFU", "Lorg/intellij/terraform/install/TfToolType;", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "fetchDownloadUrl", "getToolSettings", "Lorg/intellij/terraform/runtime/TfToolSettings;", "project", "Lcom/intellij/openapi/project/Project;", "downloadServerUrl", "getDownloadServerUrl", "fetchTofuLatestStableVersion", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfToolsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfToolsUtil.kt\norg/intellij/terraform/install/TfToolType$OPENTOFU\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,188:1\n30#2,2:189\n13#3:191\n*S KotlinDebug\n*F\n+ 1 TfToolsUtil.kt\norg/intellij/terraform/install/TfToolType$OPENTOFU\n*L\n65#1:189,2\n78#1:191\n*E\n"})
    static final class OPENTOFU
    extends TfToolType {
        @NotNull
        private final String displayName;

        /*
         * WARNING - void declaration
         */
        OPENTOFU() {
            void var1_1;
            this.displayName = "OpenTofu";
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        protected String fetchDownloadUrl() {
            String string = this.fetchTofuLatestStableVersion();
            if (string == null) {
                string = "1.10.5";
            }
            String latestTofuVersion = string;
            return this.getDownloadServerUrl() + "/v" + latestTofuVersion + "/tofu_" + latestTofuVersion + "_" + this.getOSName() + "_" + this.getArchName() + ".zip";
        }

        @Override
        @NotNull
        public TfToolSettings getToolSettings(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<OpenTofuProjectSettings> serviceClass$iv = OpenTofuProjectSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TfToolSettings)object;
        }

        private final String getDownloadServerUrl() {
            return "https://github.com/opentofu/opentofu/releases/download";
        }

        private final String fetchTofuLatestStableVersion() {
            String string;
            try {
                String string2 = HttpRequests.request((String)"https://get.opentofu.org/tofu/api.json").readString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
                String response = string2;
                JsonNode jsonNode = new ObjectMapper().readTree(response);
                JsonNode jsonNode2 = jsonNode.get("versions");
                string = jsonNode2 != null && (jsonNode2 = (JsonNode)CollectionsKt.first((Iterable)((Iterable)jsonNode2))) != null && (jsonNode2 = jsonNode2.get("id")) != null ? jsonNode2.asText() : null;
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TfBinaryInstaller.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Failed to fetch the latest stable OpenTofu version", (Throwable)e);
                string = null;
            }
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0003H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u000b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005\u00a8\u0006\u000e"}, d2={"org/intellij/terraform/install/TfToolType.TERRAFORM", "Lorg/intellij/terraform/install/TfToolType;", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "fetchDownloadUrl", "getToolSettings", "Lorg/intellij/terraform/runtime/TfToolSettings;", "project", "Lcom/intellij/openapi/project/Project;", "downloadServerUrl", "getDownloadServerUrl", "fetchTfLatestStableVersion", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfToolsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfToolsUtil.kt\norg/intellij/terraform/install/TfToolType$TERRAFORM\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,188:1\n30#2,2:189\n13#3:191\n*S KotlinDebug\n*F\n+ 1 TfToolsUtil.kt\norg/intellij/terraform/install/TfToolType$TERRAFORM\n*L\n38#1:189,2\n51#1:191\n*E\n"})
    static final class TERRAFORM
    extends TfToolType {
        @NotNull
        private final String displayName;

        /*
         * WARNING - void declaration
         */
        TERRAFORM() {
            void var1_1;
            this.displayName = "Terraform";
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        protected String fetchDownloadUrl() {
            String string = this.fetchTfLatestStableVersion();
            if (string == null) {
                string = "1.13.0";
            }
            String latestTfVersion = string;
            return this.getDownloadServerUrl() + "/" + latestTfVersion + "/terraform_" + latestTfVersion + "_" + this.getOSName() + "_" + this.getArchName() + ".zip";
        }

        @Override
        @NotNull
        public TfToolSettings getToolSettings(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TfProjectSettings> serviceClass$iv = TfProjectSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TfToolSettings)object;
        }

        private final String getDownloadServerUrl() {
            return "https://releases.hashicorp.com/terraform";
        }

        private final String fetchTfLatestStableVersion() {
            String string;
            try {
                String string2 = HttpRequests.request((String)"https://checkpoint-api.hashicorp.com/v1/check/terraform").readString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
                String response = string2;
                JsonNode jsonNode = new ObjectMapper().readTree(response);
                Object object = jsonNode.get("current_version");
                string = object != null && (object = object.asText()) != null ? StringsKt.removePrefix((String)object, (CharSequence)"v") : null;
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TfBinaryInstaller.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Failed to fetch the latest stable Terraform version", (Throwable)e);
                string = null;
            }
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0003H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u000b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005\u00a8\u0006\u000e"}, d2={"org/intellij/terraform/install/TfToolType.TERRAGRUNT", "Lorg/intellij/terraform/install/TfToolType;", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "fetchDownloadUrl", "getToolSettings", "Lorg/intellij/terraform/runtime/TfToolSettings;", "project", "Lcom/intellij/openapi/project/Project;", "downloadServerUrl", "getDownloadServerUrl", "fetchTerragruntStableVersion", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfToolsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfToolsUtil.kt\norg/intellij/terraform/install/TfToolType$TERRAGRUNT\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,188:1\n30#2,2:189\n13#3:191\n*S KotlinDebug\n*F\n+ 1 TfToolsUtil.kt\norg/intellij/terraform/install/TfToolType$TERRAGRUNT\n*L\n92#1:189,2\n105#1:191\n*E\n"})
    static final class TERRAGRUNT
    extends TfToolType {
        @NotNull
        private final String displayName;

        /*
         * WARNING - void declaration
         */
        TERRAGRUNT() {
            void var1_1;
            this.displayName = "Terragrunt";
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        protected String fetchDownloadUrl() {
            String string = this.fetchTerragruntStableVersion();
            if (string == null) {
                string = "v0.86.2";
            }
            String latestTerragruntVersion = string;
            return this.getDownloadServerUrl() + "/" + latestTerragruntVersion + "/terragrunt_" + this.getOSName() + "_" + this.getArchName() + (Intrinsics.areEqual((Object)this.getOSName(), (Object)"windows") ? ".exe" : "");
        }

        @Override
        @NotNull
        public TfToolSettings getToolSettings(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TerragruntProjectSettings> serviceClass$iv = TerragruntProjectSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TfToolSettings)object;
        }

        private final String getDownloadServerUrl() {
            return "https://github.com/gruntwork-io/terragrunt/releases/download";
        }

        private final String fetchTerragruntStableVersion() {
            String string;
            try {
                String string2 = HttpRequests.request((String)"https://api.github.com/repos/gruntwork-io/terragrunt/releases/latest").readString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
                String response = string2;
                JsonNode jsonNode = new ObjectMapper().readTree(response);
                JsonNode jsonNode2 = jsonNode.get("tag_name");
                string = jsonNode2 != null ? jsonNode2.asText() : null;
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TfBinaryInstaller.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Failed to fetch the latest stable Terragrunt version", (Throwable)e);
                string = null;
            }
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.X86.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

