/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.opentofu.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.Hint;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.ReferenceHint;
import org.intellij.terraform.config.model.SimpleValueHint;
import org.intellij.terraform.config.model.TfTypeModelKt;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.opentofu.model.AbstractEncryptionMethod;
import org.intellij.terraform.opentofu.model.AbstractEncryptionProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020'0\u000b2\u0006\u0010(\u001a\u00020)H\u0000\u001a\u001c\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020'0\u000b2\u0006\u0010(\u001a\u00020)H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\"\u0014\u0010\b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0005\" \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0014\u0010\u000f\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0014\u0010\u0016\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\" \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0011\u0010\u001a\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0014\u0010\u001c\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011\"\u0014\u0010\u001e\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0011\"\u0014\u0010 \u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0011\"\u0014\u0010\"\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0011\"\u0014\u0010$\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0011\u00a8\u0006+"}, d2={"abstractProviderInstance", "Lorg/intellij/terraform/config/model/BlockType;", "Pbkdf2Provider", "Lorg/intellij/terraform/opentofu/model/AbstractEncryptionProvider;", "getPbkdf2Provider", "()Lorg/intellij/terraform/opentofu/model/AbstractEncryptionProvider;", "AwsKmsProvider", "getAwsKmsProvider", "GcpKmsProvider", "getGcpKmsProvider", "encryptionKeyProviders", "", "", "getEncryptionKeyProviders", "()Ljava/util/Map;", "AbstractEncryptionMethodInstance", "getAbstractEncryptionMethodInstance", "()Lorg/intellij/terraform/config/model/BlockType;", "UnencryptedMethod", "Lorg/intellij/terraform/opentofu/model/AbstractEncryptionMethod;", "getUnencryptedMethod", "()Lorg/intellij/terraform/opentofu/model/AbstractEncryptionMethod;", "AesGcmMethod", "getAesGcmMethod", "encryptionMethods", "getEncryptionMethods", "fallbackMethod", "getFallbackMethod", "State", "getState", "Plan", "getPlan", "RemoteStateDataSource", "getRemoteStateDataSource", "DefaultDataSource", "getDefaultDataSource", "RemoteStateDataSources", "getRemoteStateDataSources", "getEncryptionKeyProviderProperties", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "getEncryptionMethodProperties", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nOpenTofuTypeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenTofuTypeModel.kt\norg/intellij/terraform/opentofu/model/OpenTofuTypeModelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,156:1\n1563#2:157\n1634#2,3:158\n1208#2,2:163\n1236#2,4:165\n1208#2,2:169\n1236#2,4:171\n37#3,2:161\n*S KotlinDebug\n*F\n+ 1 OpenTofuTypeModel.kt\norg/intellij/terraform/opentofu/model/OpenTofuTypeModelKt\n*L\n44#1:157\n44#1:158,3\n65#1:163,2\n65#1:165,4\n102#1:169,2\n102#1:171,4\n44#1:161,2\n*E\n"})
public final class OpenTofuTypeModelKt {
    @NotNull
    private static final BlockType abstractProviderInstance;
    @NotNull
    private static final AbstractEncryptionProvider Pbkdf2Provider;
    @NotNull
    private static final AbstractEncryptionProvider AwsKmsProvider;
    @NotNull
    private static final AbstractEncryptionProvider GcpKmsProvider;
    @NotNull
    private static final Map<String, AbstractEncryptionProvider> encryptionKeyProviders;
    @NotNull
    private static final BlockType AbstractEncryptionMethodInstance;
    @NotNull
    private static final AbstractEncryptionMethod UnencryptedMethod;
    @NotNull
    private static final AbstractEncryptionMethod AesGcmMethod;
    @NotNull
    private static final Map<String, AbstractEncryptionMethod> encryptionMethods;
    @NotNull
    private static final BlockType fallbackMethod;
    @NotNull
    private static final BlockType State;
    @NotNull
    private static final BlockType Plan;
    @NotNull
    private static final BlockType RemoteStateDataSource;
    @NotNull
    private static final BlockType DefaultDataSource;
    @NotNull
    private static final BlockType RemoteStateDataSources;

    @NotNull
    public static final AbstractEncryptionProvider getPbkdf2Provider() {
        return Pbkdf2Provider;
    }

    @NotNull
    public static final AbstractEncryptionProvider getAwsKmsProvider() {
        return AwsKmsProvider;
    }

    @NotNull
    public static final AbstractEncryptionProvider getGcpKmsProvider() {
        return GcpKmsProvider;
    }

    @NotNull
    public static final Map<String, AbstractEncryptionProvider> getEncryptionKeyProviders() {
        return encryptionKeyProviders;
    }

    @NotNull
    public static final BlockType getAbstractEncryptionMethodInstance() {
        return AbstractEncryptionMethodInstance;
    }

    @NotNull
    public static final AbstractEncryptionMethod getUnencryptedMethod() {
        return UnencryptedMethod;
    }

    @NotNull
    public static final AbstractEncryptionMethod getAesGcmMethod() {
        return AesGcmMethod;
    }

    @NotNull
    public static final Map<String, AbstractEncryptionMethod> getEncryptionMethods() {
        return encryptionMethods;
    }

    @NotNull
    public static final BlockType getFallbackMethod() {
        return fallbackMethod;
    }

    @NotNull
    public static final BlockType getState() {
        return State;
    }

    @NotNull
    public static final BlockType getPlan() {
        return Plan;
    }

    @NotNull
    public static final BlockType getRemoteStateDataSource() {
        return RemoteStateDataSource;
    }

    @NotNull
    public static final BlockType getDefaultDataSource() {
        return DefaultDataSource;
    }

    @NotNull
    public static final BlockType getRemoteStateDataSources() {
        return RemoteStateDataSources;
    }

    @NotNull
    public static final Map<String, PropertyOrBlockType> getEncryptionKeyProviderProperties(@NotNull HCLBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        String string = UtilKt.getNameElementUnquoted(block, 1);
        if (string == null) {
            return MapsKt.emptyMap();
        }
        String type = string;
        Object object = encryptionKeyProviders.get(type);
        if (object == null || (object = ((BlockType)object).getProperties()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @NotNull
    public static final Map<String, PropertyOrBlockType> getEncryptionMethodProperties(@NotNull HCLBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        String string = UtilKt.getNameElementUnquoted(block, 1);
        if (string == null) {
            return MapsKt.emptyMap();
        }
        String type = string;
        Object object = encryptionMethods.get(type);
        if (object == null || (object = ((BlockType)object).getProperties()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    static {
        AbstractEncryptionMethod it;
        Map map;
        Object element$iv$iv;
        Object $this$associateByTo$iv$iv;
        void $this$toTypedArray$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        abstractProviderInstance = new BlockType("key_provider", 0, null, null, false, false, false, null, null, null, null, 2046, null);
        Object[] objectArray = new PropertyType[5];
        Object object = Types.INSTANCE.getString();
        Object object2 = HCLBundle.message("opentofu.key_provider.pbkdf2.passphrase.description", new Object[0]);
        objectArray[0] = new PropertyType("passphrase", (HclType)object, null, false, (String)object2, null, false, true, false, false, null, null, false, 8044, null);
        object = Types.INSTANCE.getNumber();
        Object object3 = new Object[]{1, 32};
        object2 = HCLBundle.message("opentofu.key_provider.pbkdf2.key_length.description", object3);
        Iterable iterable = (Iterable)RangesKt.reversed((IntProgression)((IntProgression)new IntRange(1, 32)));
        int n = 1;
        Object[] objectArray2 = objectArray;
        String string = "pbkdf2";
        boolean $i$f$map = false;
        void var7_14 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it2;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf((int)it2));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length);
        object3 = new SimpleValueHint(stringArray2);
        objectArray2[n] = new PropertyType("key_length", (HclType)object, (Hint)object3, false, (String)object2, null, false, false, false, false, null, null, false, 8168, null);
        objectArray[2] = new PropertyType("iterations", Types.INSTANCE.getNumber(), null, false, HCLBundle.message("opentofu.key_provider.pbkdf2.iterations.description", new Object[0]), null, false, false, false, false, null, null, false, 8172, null);
        objectArray[3] = new PropertyType("salt_length", Types.INSTANCE.getNumber(), null, false, HCLBundle.message("opentofu.key_provider.pbkdf2.salt_length.description", new Object[0]), null, false, false, false, false, null, null, false, 8172, null);
        object = new String[]{"sha256", "sha512"};
        objectArray[4] = new PropertyType("hash_function", Types.INSTANCE.getString(), new SimpleValueHint((String)object), false, HCLBundle.message("opentofu.key_provider.pbkdf2.hash_function.description", new Object[0]), null, false, false, false, false, null, null, false, 8168, null);
        BlockType blockType = abstractProviderInstance;
        List list = CollectionsKt.listOf((Object[])objectArray);
        String string2 = string;
        Pbkdf2Provider = new AbstractEncryptionProvider(string2, list, blockType);
        objectArray = new PropertyType[3];
        object = Types.INSTANCE.getString();
        object2 = HCLBundle.message("opentofu.key_provider.aws_kms.kms_key_id.description", new Object[0]);
        objectArray[0] = new PropertyType("kms_key_id", (HclType)object, null, false, (String)object2, null, false, true, false, false, null, null, false, 8044, null);
        object = Types.INSTANCE.getString();
        object3 = new String[]{"SYMMETRIC_DEFAULT", "HMAC_224", "HMAC_256", "HMAC_384", "HMAC_512", "RSA_2048", "RSA_3072", "RSA_4096", "ECC_NIST_P256", "ECC_NIST_P384", "ECC_NIST_P521", "ECC_SECG_P256K1", "SM2"};
        object2 = new SimpleValueHint((String[])object3);
        object3 = HCLBundle.message("opentofu.key_provider.aws_kms.key_spec.description", new Object[0]);
        objectArray[1] = new PropertyType("key_spec", (HclType)object, (Hint)object2, false, (String)object3, null, false, true, false, false, null, null, false, 8040, null);
        objectArray[2] = new PropertyType("region", Types.INSTANCE.getString(), null, false, null, null, false, true, false, false, null, null, false, 8060, null);
        AwsKmsProvider = new AbstractEncryptionProvider("aws_kms", CollectionsKt.listOf((Object[])objectArray), abstractProviderInstance);
        objectArray = new PropertyType[2];
        object = Types.INSTANCE.getString();
        object2 = HCLBundle.message("opentofu.key_provider.gcp_kms.kms_encryption_key.description", new Object[0]);
        objectArray[0] = new PropertyType("kms_encryption_key", (HclType)object, null, false, (String)object2, null, false, true, false, false, null, null, false, 8044, null);
        object = Types.INSTANCE.getNumber();
        object3 = new Object[]{1, 1024};
        object2 = HCLBundle.message("opentofu.key_provider.gcp_kms.key_length.description", object3);
        objectArray[1] = new PropertyType("key_length", (HclType)object, null, false, (String)object2, null, false, true, false, false, null, null, false, 8044, null);
        GcpKmsProvider = new AbstractEncryptionProvider("gcp_kms", CollectionsKt.listOf((Object[])objectArray), abstractProviderInstance);
        objectArray = new AbstractEncryptionProvider[]{AwsKmsProvider, GcpKmsProvider, Pbkdf2Provider};
        Object $this$associateBy$iv = (String[])CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        object3 = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            destination$iv$iv = (AbstractEncryptionProvider)element$iv$iv;
            map = destination$iv$iv2;
            boolean bl = false;
            map.put(((AbstractEncryptionProvider)((Object)it)).getType(), element$iv$iv);
        }
        encryptionKeyProviders = destination$iv$iv2;
        AbstractEncryptionMethodInstance = new BlockType("method", 2, null, null, false, false, false, null, null, null, null, 2044, null);
        UnencryptedMethod = new AbstractEncryptionMethod("unencrypted", CollectionsKt.emptyList(), AbstractEncryptionMethodInstance);
        $this$associateBy$iv = new String[]{"key_provider.#name"};
        AesGcmMethod = new AbstractEncryptionMethod("aes_gcm", CollectionsKt.listOf((Object)new PropertyType("keys", Types.INSTANCE.getString(), new ReferenceHint((String[])$this$associateBy$iv), false, null, null, false, true, false, false, null, null, false, 8056, null)), AbstractEncryptionMethodInstance);
        $this$associateBy$iv = new AbstractEncryptionMethod[]{AesGcmMethod, UnencryptedMethod};
        $this$associateBy$iv = CollectionsKt.listOf((Object[])$this$associateBy$iv);
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        iterator2 = $this$associateByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (AbstractEncryptionMethod)element$iv$iv;
            map = destination$iv$iv2;
            boolean bl = false;
            map.put(it.getType(), element$iv$iv);
        }
        encryptionMethods = destination$iv$iv2;
        objectArray = new String[]{"method.#name"};
        fallbackMethod = new BlockType("fallback", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object)new PropertyType("method", Types.INSTANCE.getString(), new ReferenceHint((String[])objectArray), false, null, null, false, false, false, false, null, null, false, 8184, null))), 1022, null);
        objectArray = new Object[3];
        String[] stringArray3 = new String[]{"method.#name"};
        objectArray[0] = new PropertyType("method", Types.INSTANCE.getString(), new ReferenceHint(stringArray3), false, null, null, false, false, false, false, null, null, false, 8184, null);
        objectArray[1] = new PropertyType("enforced", Types.INSTANCE.getBoolean(), null, false, null, null, false, false, false, false, null, null, false, 8188, null);
        objectArray[2] = fallbackMethod;
        State = new BlockType("state", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1022, null);
        objectArray = new Object[3];
        stringArray3 = new String[]{"method.#name"};
        objectArray[0] = new PropertyType("method", Types.INSTANCE.getString(), new ReferenceHint(stringArray3), false, null, null, false, false, false, false, null, null, false, 8184, null);
        objectArray[1] = new PropertyType("enforced", Types.INSTANCE.getBoolean(), null, false, null, null, false, false, false, false, null, null, false, 8188, null);
        objectArray[2] = fallbackMethod;
        Plan = new BlockType("plan", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1022, null);
        RemoteStateDataSource = new BlockType("remote_state_data_source", 1, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object)new PropertyType("method", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null))), 1020, null);
        DefaultDataSource = new BlockType("default", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object)new PropertyType("method", Types.INSTANCE.getString(), null, false, null, null, false, false, false, false, null, null, false, 8188, null))), 1022, null);
        objectArray = new BlockType[]{DefaultDataSource, RemoteStateDataSource};
        RemoteStateDataSources = new BlockType("remote_state_data_sources", 0, null, null, false, false, false, null, null, null, TfTypeModelKt.toMap(CollectionsKt.listOf((Object[])objectArray)), 1022, null);
    }
}

