/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.terragrunt.codeinsight;

import com.intellij.psi.PsiFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.terragrunt.UtilKt;
import org.intellij.terraform.terragrunt.model.TerragruntTypeModelKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/intellij/terraform/terragrunt/codeinsight/TerragruntUnitHelper;", "", "<init>", "()V", "getBlockProperties", "", "", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
public final class TerragruntUnitHelper {
    @NotNull
    public static final TerragruntUnitHelper INSTANCE = new TerragruntUnitHelper();

    private TerragruntUnitHelper() {
    }

    @NotNull
    public final Map<String, PropertyOrBlockType> getBlockProperties(@NotNull HCLBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        String string = org.intellij.terraform.hcl.psi.UtilKt.getNameElementUnquoted(block, 0);
        if (string == null) {
            return MapsKt.emptyMap();
        }
        String type = string;
        if (!(block.getParent() instanceof PsiFile)) {
            return TfModelHelper.INSTANCE.traverseParentBlockProperties(block, type);
        }
        PsiFile psiFile = block.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile file = psiFile;
        Map<String, BlockType> rootBlocks = UtilKt.isTerragruntStack(file) ? TerragruntTypeModelKt.getStackRootBlocksMap() : TerragruntTypeModelKt.getTerragruntRootBlocksMap();
        BlockType blockType = rootBlocks.get(type);
        Map map = blockType != null ? blockType.getProperties() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }
}

