/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.ide.terraformNotifier;

import com.goide.statistics.GoTerraformUsageCollector;
import com.intellij.go.ide.terraformNotifier.TerraformNudgeBundle;
import com.intellij.go.ide.terraformNotifier.icons.GOIdeTerraformNotifierIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J0\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0002J\f\u0010)\u001a\u00020\u000e*\u00020&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/go/ide/terraformNotifier/TerraformFolderBadgeRendererInjector;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "appFirstShownKey", "", "appDismissedKey", "threeMonthsMs", "", "origRendererKey", "appFirstShown", "markAppFirstShown", "", "isDismissed", "", "dismiss", "isPromoActive", "execute", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disableTooltip", "tree", "Ljavax/swing/JTree;", "isTFFile", "n", "installHelpTooltipOnTree", "isOverPill", "original", "Ljavax/swing/tree/TreeCellRenderer;", "path", "Ljavax/swing/tree/TreePath;", "row", "", "mousePoint", "Ljava/awt/Point;", "restoreOriginalRenderer", "resolveDirectoryVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "value", "", "hasTfChild", "intellij.go.ide.terraformNotifier"})
public final class TerraformFolderBadgeRendererInjector
implements ProjectActivity {
    @NotNull
    private final String appFirstShownKey;
    @NotNull
    private final String appDismissedKey;
    private final long threeMonthsMs;
    @NotNull
    private final String origRendererKey;

    public TerraformFolderBadgeRendererInjector() {
        this.appFirstShownKey = "goland.terraform.promotion.firstShownAt";
        this.appDismissedKey = "goland.terraform.promotion.dismissed";
        this.threeMonthsMs = 7776000000L;
        this.origRendererKey = "goland.tf.promotion.enabled";
    }

    private final long appFirstShown() {
        return PropertiesComponent.getInstance().getLong(this.appFirstShownKey, 0L);
    }

    private final void markAppFirstShown() {
        PropertiesComponent.getInstance().setValue(this.appFirstShownKey, String.valueOf(System.currentTimeMillis()));
    }

    private final boolean isDismissed() {
        return PropertiesComponent.getInstance().getBoolean(this.appDismissedKey, false);
    }

    private final void dismiss() {
        PropertiesComponent.getInstance().setValue(this.appDismissedKey, true);
    }

    private final boolean isPromoActive() {
        if (this.isDismissed()) {
            return false;
        }
        long first = this.appFirstShown();
        if (first == 0L) {
            return true;
        }
        return System.currentTimeMillis() - first <= this.threeMonthsMs;
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (!this.isPromoActive()) {
            return Unit.INSTANCE;
        }
        AbstractProjectViewPane abstractProjectViewPane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane();
        if (abstractProjectViewPane == null) {
            return Unit.INSTANCE;
        }
        AbstractProjectViewPane pane = abstractProjectViewPane;
        JComponent jComponent = pane.getComponentToFocus();
        JTree jTree = jComponent instanceof JTree ? (JTree)jComponent : null;
        if (jTree == null) {
            return Unit.INSTANCE;
        }
        JTree tree = jTree;
        TreeCellRenderer original = tree.getCellRenderer();
        tree.putClientProperty(this.origRendererKey, original);
        TreeCellRenderer renderer2 = new TreeCellRenderer(original, this, project){
            final /* synthetic */ TreeCellRenderer $original;
            final /* synthetic */ TerraformFolderBadgeRendererInjector this$0;
            final /* synthetic */ Project $project;
            {
                this.$original = $original;
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JComponent textComp;
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Component base = this.$original.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (!TerraformFolderBadgeRendererInjector.access$isPromoActive(this.this$0)) {
                    Intrinsics.checkNotNull((Object)base);
                    return base;
                }
                VirtualFile virtualFile = TerraformFolderBadgeRendererInjector.access$resolveDirectoryVirtualFile(this.this$0, value);
                if (virtualFile == null) {
                    Intrinsics.checkNotNull((Object)base);
                    return base;
                }
                VirtualFile dir = virtualFile;
                if (!TerraformFolderBadgeRendererInjector.access$hasTfChild(this.this$0, dir)) {
                    Intrinsics.checkNotNull((Object)base);
                    return base;
                }
                if (TerraformFolderBadgeRendererInjector.access$appFirstShown(this.this$0) == 0L) {
                    TerraformFolderBadgeRendererInjector.access$markAppFirstShown(this.this$0);
                }
                GoTerraformUsageCollector.INSTANCE.logBadgeShown(this.$project);
                JLabel jLabel = new JLabel(GOIdeTerraformNotifierIcons.TerraformPromo);
                JComponent $this$getTreeCellRendererComponent_u24lambda_u240 = jLabel;
                boolean bl = false;
                $this$getTreeCellRendererComponent_u24lambda_u240.setOpaque(false);
                JLabel iconLabel = jLabel;
                JComponent $this$getTreeCellRendererComponent_u24lambda_u241 = $this$getTreeCellRendererComponent_u24lambda_u240 = new JPanel();
                boolean bl2 = false;
                $this$getTreeCellRendererComponent_u24lambda_u241.setOpaque(false);
                $this$getTreeCellRendererComponent_u24lambda_u241.setLayout(new BoxLayout($this$getTreeCellRendererComponent_u24lambda_u241, 0));
                JComponent container = $this$getTreeCellRendererComponent_u24lambda_u240;
                JComponent jComponent = textComp = base instanceof JComponent ? (JComponent)base : null;
                if (jComponent != null) {
                    jComponent.setMaximumSize(textComp.getPreferredSize());
                }
                container.add(textComp);
                container.add(Box.createHorizontalStrut(6));
                container.add(iconLabel);
                return container;
            }
        };
        tree.setCellRenderer(renderer2);
        this.installHelpTooltipOnTree(tree, project);
        SimpleMessageBusConnection simpleMessageBusConnection = project.getMessageBus().simpleConnect();
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        simpleMessageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(this, tree, project){
            final /* synthetic */ TerraformFolderBadgeRendererInjector this$0;
            final /* synthetic */ JTree $tree;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$tree = $tree;
                this.$project = $project;
            }

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                if (TerraformFolderBadgeRendererInjector.access$isTFFile(this.this$0, string2)) {
                    TerraformFolderBadgeRendererInjector.access$dismiss(this.this$0);
                    TerraformFolderBadgeRendererInjector.access$disableTooltip(this.this$0, this.$tree);
                    TerraformFolderBadgeRendererInjector.access$restoreOriginalRenderer(this.this$0, this.$project);
                }
            }
        });
        return Unit.INSTANCE;
    }

    private final void disableTooltip(JTree tree) {
        HelpTooltip.setMasterPopupOpenCondition((Component)tree, TerraformFolderBadgeRendererInjector::disableTooltip$lambda$0);
        tree.setToolTipText(null);
    }

    private final boolean isTFFile(String n) {
        return StringsKt.endsWith$default((String)n, (String)".tf", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)n, (String)".tfvars", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)n, (String)".tf.json", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)n, (Object)"terragrunt.hcl");
    }

    private final void installHelpTooltipOnTree(JTree tree, Project project) {
        Object object = tree.getClientProperty(this.origRendererKey);
        TreeCellRenderer treeCellRenderer = object instanceof TreeCellRenderer ? (TreeCellRenderer)object : null;
        if (treeCellRenderer == null) {
            treeCellRenderer = tree.getCellRenderer();
        }
        TreeCellRenderer original = treeCellRenderer;
        new HelpTooltip().setTitle(TerraformNudgeBundle.INSTANCE.message("tooltip.header.help", new Object[0])).setDescription(TerraformNudgeBundle.INSTANCE.message("tooltip.body.help", new Object[0])).setLink(TerraformNudgeBundle.INSTANCE.message("tooltip.link.readMore", new Object[0]), () -> TerraformFolderBadgeRendererInjector.installHelpTooltipOnTree$lambda$0(project)).installOn((JComponent)tree);
        HelpTooltip.setMasterPopupOpenCondition((Component)tree, () -> TerraformFolderBadgeRendererInjector.installHelpTooltipOnTree$lambda$1(this, tree, original, project));
    }

    private final boolean isOverPill(JTree tree, TreeCellRenderer original, TreePath path, int row, Point mousePoint) {
        Rectangle rectangle = tree.getRowBounds(row);
        if (rectangle == null) {
            return false;
        }
        Rectangle rb = rectangle;
        Component component = original.getTreeCellRendererComponent(tree, path.getLastPathComponent(), false, tree.isExpanded(row), false, row, false);
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        if (jComponent == null) {
            return false;
        }
        JComponent base = jComponent;
        int textW = base.getPreferredSize().width;
        int pillX = rb.x + textW + 6;
        Rectangle pillRect = new Rectangle(pillX, rb.y, GOIdeTerraformNotifierIcons.TerraformPromo.getIconWidth(), rb.height);
        return pillRect.contains(mousePoint);
    }

    private final void restoreOriginalRenderer(Project project) {
        AbstractProjectViewPane abstractProjectViewPane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane();
        if (abstractProjectViewPane == null) {
            return;
        }
        AbstractProjectViewPane pane = abstractProjectViewPane;
        JComponent jComponent = pane.getComponentToFocus();
        JTree jTree = jComponent instanceof JTree ? (JTree)jComponent : null;
        if (jTree == null) {
            return;
        }
        JTree tree = jTree;
        Object object = tree.getClientProperty(this.origRendererKey);
        TreeCellRenderer treeCellRenderer = object instanceof TreeCellRenderer ? (TreeCellRenderer)object : null;
        if (treeCellRenderer == null) {
            return;
        }
        TreeCellRenderer orig = treeCellRenderer;
        tree.setCellRenderer(orig);
        tree.repaint();
    }

    private final VirtualFile resolveDirectoryVirtualFile(Object value) {
        Object nodeObj;
        DefaultMutableTreeNode defaultMutableTreeNode = value instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)value : null;
        Object object = nodeObj = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
        if (!(nodeObj instanceof PsiDirectoryNode)) {
            return null;
        }
        return ((PsiDirectoryNode)nodeObj).getVirtualFile();
    }

    private final boolean hasTfChild(VirtualFile $this$hasTfChild) {
        VirtualFile[] virtualFileArray = $this$hasTfChild.getChildren();
        if (virtualFileArray == null) {
            return false;
        }
        for (VirtualFile c : virtualFileArray) {
            if (c.isDirectory()) continue;
            String string = c.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (!this.isTFFile(string2)) continue;
            return true;
        }
        return false;
    }

    private static final boolean disableTooltip$lambda$0() {
        return false;
    }

    private static final void installHelpTooltipOnTree$lambda$0(Project $project) {
        GoTerraformUsageCollector.INSTANCE.logTooltipLinkClicked($project);
        BrowserUtil.browse((URL)new URL(TerraformNudgeBundle.INSTANCE.message("help.url", new Object[0])));
    }

    private static final boolean installHelpTooltipOnTree$lambda$1(TerraformFolderBadgeRendererInjector this$0, JTree $tree, TreeCellRenderer $original, Project $project) {
        PointerInfo pointerInfo;
        if (!this$0.isPromoActive()) {
            return false;
        }
        try {
            pointerInfo = MouseInfo.getPointerInfo();
        }
        catch (Throwable throwable) {
            pointerInfo = null;
        }
        PointerInfo pointerInfo2 = pointerInfo;
        if (pointerInfo2 == null) {
            return false;
        }
        PointerInfo info = pointerInfo2;
        Point pt = new Point(info.getLocation());
        SwingUtilities.convertPointFromScreen(pt, $tree);
        if (!$tree.isShowing() || !$tree.isDisplayable()) {
            return false;
        }
        int row = $tree.getRowForLocation(pt.x, pt.y);
        if (row < 0) {
            return false;
        }
        TreePath treePath = $tree.getPathForRow(row);
        if (treePath == null) {
            return false;
        }
        TreePath path = treePath;
        Object object = path.getLastPathComponent();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLastPathComponent(...)");
        VirtualFile virtualFile = this$0.resolveDirectoryVirtualFile(object);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile dir = virtualFile;
        if (!this$0.hasTfChild(dir)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)$original);
        boolean isOver = this$0.isOverPill($tree, $original, path, row, pt);
        if (!isOver) {
            return false;
        }
        GoTerraformUsageCollector.INSTANCE.logTooltipShown($project);
        return true;
    }

    public static final /* synthetic */ boolean access$isPromoActive(TerraformFolderBadgeRendererInjector $this) {
        return $this.isPromoActive();
    }

    public static final /* synthetic */ VirtualFile access$resolveDirectoryVirtualFile(TerraformFolderBadgeRendererInjector $this, Object value) {
        return $this.resolveDirectoryVirtualFile(value);
    }

    public static final /* synthetic */ boolean access$hasTfChild(TerraformFolderBadgeRendererInjector $this, VirtualFile $receiver) {
        return $this.hasTfChild($receiver);
    }

    public static final /* synthetic */ long access$appFirstShown(TerraformFolderBadgeRendererInjector $this) {
        return $this.appFirstShown();
    }

    public static final /* synthetic */ void access$markAppFirstShown(TerraformFolderBadgeRendererInjector $this) {
        $this.markAppFirstShown();
    }

    public static final /* synthetic */ boolean access$isTFFile(TerraformFolderBadgeRendererInjector $this, String n) {
        return $this.isTFFile(n);
    }

    public static final /* synthetic */ void access$dismiss(TerraformFolderBadgeRendererInjector $this) {
        $this.dismiss();
    }

    public static final /* synthetic */ void access$disableTooltip(TerraformFolderBadgeRendererInjector $this, JTree tree) {
        $this.disableTooltip(tree);
    }

    public static final /* synthetic */ void access$restoreOriginalRenderer(TerraformFolderBadgeRendererInjector $this, Project project) {
        $this.restoreOriginalRenderer(project);
    }
}

