/*
 * Decompiled with CFR 0.152.
 */
package com.goide;

import com.goide.GoOsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoEnvironmentUtil {
    private GoEnvironmentUtil() {
    }

    @NotNull
    public static String getBinaryFileNameForPath(@NotNull @NonNls String path) {
        if (path == null) {
            GoEnvironmentUtil.$$$reportNull$$$0(0);
        }
        boolean isWindows = GoOsManager.isWindows();
        return GoEnvironmentUtil.getBinaryFileNameForPath(path, isWindows);
    }

    @NonNls
    @NotNull
    public static String getBinaryFileNameForPath(@NonNls @NotNull String path, boolean isWindows) {
        if (path == null) {
            GoEnvironmentUtil.$$$reportNull$$$0(1);
        }
        return GoEnvironmentUtil.getBinaryFileNameForPath(path, "", isWindows);
    }

    @NonNls
    @NotNull
    public static String getBinaryFileNameForPath(@NonNls @NotNull String path, @NonNls @NotNull String suffix, boolean isWindows) {
        if (path == null) {
            GoEnvironmentUtil.$$$reportNull$$$0(2);
        }
        if (suffix == null) {
            GoEnvironmentUtil.$$$reportNull$$$0(3);
        }
        String resultBinaryName = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)path)) + suffix;
        String string = isWindows ? resultBinaryName + ".exe" : resultBinaryName;
        if (string == null) {
            GoEnvironmentUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static @NonNls String @NotNull [] getGaeExecutableFileNames(boolean gcloudInstallation) {
        if (GoOsManager.isWindows()) {
            String[] stringArray;
            if (gcloudInstallation) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "goapp.cmd";
                stringArray2[1] = "goapp.bat";
                stringArray = stringArray2;
                stringArray2[2] = "goapp.exe";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "goapp.bat";
            }
            if (stringArray == null) {
                GoEnvironmentUtil.$$$reportNull$$$0(5);
            }
            return stringArray;
        }
        String[] stringArray = new String[]{"goapp"};
        if (stringArray == null) {
            GoEnvironmentUtil.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Nullable
    public static String retrieveGoPathFromEnvironment() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        String path = EnvironmentUtil.getValue((String)"GOPATH");
        return path != null ? path : PathMacros.getInstance().getValue("GOPATH");
    }

    @Nullable
    public static String retrieveGoBinFromEnvironment() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        String path = (String)ObjectUtils.notNull((Object)EnvironmentUtil.getValue((String)"GOBIN"), () -> (String)ObjectUtils.notNull((Object)PathMacros.getInstance().getValue("GOPATH"), (Object)""));
        if (path.contains("$HOME")) {
            path = path.replaceAll("\\$HOME", SystemProperties.getUserHome());
        }
        return StringUtil.nullize((String)path);
    }

    @NotNull
    public static @NotNull Couple<@NotNull String> prependPathEntry(@NotNull String s, @NotNull Map<String, String> envMap) {
        if (s == null) {
            GoEnvironmentUtil.$$$reportNull$$$0(7);
        }
        if (envMap == null) {
            GoEnvironmentUtil.$$$reportNull$$$0(8);
        }
        Couple<String> pathEntry = GoEnvironmentUtil.getPathEntry(envMap);
        Couple couple = Couple.of((Object)((String)pathEntry.first), (Object)(StringUtil.isNotEmpty((String)((String)pathEntry.second)) ? s + File.pathSeparator + (String)pathEntry.second : s));
        if (couple == null) {
            GoEnvironmentUtil.$$$reportNull$$$0(9);
        }
        return couple;
    }

    @NotNull
    public static Couple<String> getPathEntry(@NotNull Map<String, String> envMap) {
        if (envMap == null) {
            GoEnvironmentUtil.$$$reportNull$$$0(10);
        }
        if (GoOsManager.isWindows()) {
            for (Map.Entry<String, String> entry : envMap.entrySet()) {
                if (!"PATH".equalsIgnoreCase(entry.getKey())) continue;
                Couple couple = Couple.of((Object)entry.getKey(), (Object)entry.getValue());
                if (couple == null) {
                    GoEnvironmentUtil.$$$reportNull$$$0(11);
                }
                return couple;
            }
            Couple couple = Couple.of((Object)"Path", null);
            if (couple == null) {
                GoEnvironmentUtil.$$$reportNull$$$0(12);
            }
            return couple;
        }
        Couple couple = Couple.of((Object)"PATH", (Object)envMap.get("PATH"));
        if (couple == null) {
            GoEnvironmentUtil.$$$reportNull$$$0(13);
        }
        return couple;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 9, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/GoEnvironmentUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/GoEnvironmentUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryFileNameForPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGaeExecutableFileNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prependPathEntry";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryFileNameForPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prependPathEntry";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPathEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 9, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

