/*
 * Decompiled with CFR 0.152.
 */
package com.goide.actions;

import com.goide.i18n.GoBundle;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GoAttachDetachContentRootUndoableAction
extends GlobalUndoableAction {
    private final Module module;
    private final VirtualFile directory;
    private final boolean myAttach;

    public static void attach(@NotNull Module module, @NotNull VirtualFile directory) {
        if (module == null) {
            GoAttachDetachContentRootUndoableAction.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            GoAttachDetachContentRootUndoableAction.$$$reportNull$$$0(1);
        }
        GoAttachDetachContentRootUndoableAction.attachOrDetach(module, directory, GoBundle.message((String)"go.attach.directory.action.text", (Object[])new Object[]{directory.getPresentableName()}), true);
    }

    public static void detach(@NotNull Module module, @NotNull VirtualFile directory) {
        if (module == null) {
            GoAttachDetachContentRootUndoableAction.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            GoAttachDetachContentRootUndoableAction.$$$reportNull$$$0(3);
        }
        GoAttachDetachContentRootUndoableAction.attachOrDetach(module, directory, GoBundle.message((String)"go.detach.directory.action.text", (Object[])new Object[]{directory.getPresentableName()}), false);
    }

    private static void attachOrDetach(@NotNull Module module, @NotNull VirtualFile directory, @Nls @NotNull String title, boolean attach) {
        if (module == null) {
            GoAttachDetachContentRootUndoableAction.$$$reportNull$$$0(4);
        }
        if (directory == null) {
            GoAttachDetachContentRootUndoableAction.$$$reportNull$$$0(5);
        }
        if (title == null) {
            GoAttachDetachContentRootUndoableAction.$$$reportNull$$$0(6);
        }
        WriteCommandAction.writeCommandAction((Project)module.getProject()).withName(title).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> {
            GoAttachDetachContentRootUndoableAction undoable = new GoAttachDetachContentRootUndoableAction(module, directory, attach);
            undoable.redo();
            UndoManager.getInstance((Project)module.getProject()).undoableActionPerformed((UndoableAction)undoable);
        });
    }

    GoAttachDetachContentRootUndoableAction(@NotNull Module module, @NotNull VirtualFile directory, boolean attach) {
        if (module == null) {
            GoAttachDetachContentRootUndoableAction.$$$reportNull$$$0(7);
        }
        if (directory == null) {
            GoAttachDetachContentRootUndoableAction.$$$reportNull$$$0(8);
        }
        this.module = module;
        this.directory = directory;
        this.myAttach = attach;
    }

    public void undo() {
        if (!this.module.isDisposed()) {
            if (this.myAttach) {
                this.detach();
            } else {
                this.attach();
            }
        }
    }

    public void redo() {
        if (!this.module.isDisposed()) {
            if (this.myAttach) {
                this.attach();
            } else {
                this.detach();
            }
        }
    }

    private void attach() {
        ModuleRootModificationUtil.addContentRoot((Module)this.module, (VirtualFile)this.directory);
    }

    private void detach() {
        ModuleRootModificationUtil.updateModel((Module)this.module, model -> {
            for (ContentEntry entry : model.getContentEntries()) {
                if (!this.directory.equals(entry.getFile())) continue;
                model.removeContentEntry(entry);
                return;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        objectArray2[1] = "com/goide/actions/GoAttachDetachContentRootUndoableAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "attach";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detach";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "attachOrDetach";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

