/*
 * Decompiled with CFR 0.152.
 */
package com.goide.appengine.wizard;

import com.goide.GoGeneratedIcons;
import com.goide.appengine.wizard.GoAppEngineProjectGeneratorPeer;
import com.goide.appengine.wizard.GoNewAppEngineProjectSettings;
import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.application.GoApplicationConfiguration;
import com.goide.execution.application.GoApplicationRunConfigurationType;
import com.goide.i18n.GoBundle;
import com.goide.project.GoBuildTargetSettings;
import com.goide.project.GoModuleBuilderBase;
import com.goide.project.GoModuleSettings;
import com.goide.project.GoProjectLibrariesService;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.combobox.GoBasedSdkChooserCombo;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.intellij.DynamicBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GoAppEngineModuleBuilder
extends GoModuleBuilderBase<GoNewAppEngineProjectSettings> {
    private static final Logger LOG = Logger.getInstance(GoAppEngineModuleBuilder.class);

    public GoAppEngineModuleBuilder() {
        super(new GoAppEngineProjectGeneratorPeer());
    }

    public String getPresentableName() {
        return GoBundle.message((String)"go.app.engine.wizard.name", (Object[])new Object[0]);
    }

    public Icon getNodeIcon() {
        return GoGeneratedIcons.AppEngine;
    }

    public int getWeight() {
        return 1098;
    }

    @Override
    protected void moduleCreated(@NotNull Module module, boolean isCreatingNewProject) {
        String contentEntryPath;
        VirtualFile baseDir;
        if (module == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(0);
        }
        if (isCreatingNewProject) {
            VgoProjectSettings.getInstance(module.getProject()).setIntegrationEnabled(false);
            GoProjectLibrariesService.getInstance(module.getProject()).setIndexEntireGopath(((GoNewAppEngineProjectSettings)this.getSettings()).indexEntireGoPath);
        }
        VirtualFile virtualFile = baseDir = (contentEntryPath = this.getContentEntryPath()) != null ? LocalFileSystem.getInstance().findFileByPath(contentEntryPath) : null;
        if (baseDir != null) {
            GoAppEngineModuleBuilder.createAppEngineApplication(module.getProject(), module, baseDir, (Object)this);
        }
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDescription() {
        return GoBundle.message((String)"go.app.engine.wizard.description", (Object[])new Object[0]);
    }

    @NotNull
    public static GoBasedSdkChooserCombo.Validator<GoSdk> validator() {
        GoBasedSdkChooserCombo.Validator<GoSdk> validator = sdk -> sdk.supportsAppEngine() ? ValidationResult.OK : new ValidationResult(GoBundle.message((String)"go.app.engine.not.gae.sdk.validation.message", (Object[])new Object[0]));
        if (validator == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(1);
        }
        return validator;
    }

    public static void createAppEngineApplication(@NotNull Project project, @NotNull Module module, @NotNull VirtualFile baseDir, @NotNull Object requestor) {
        if (project == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(2);
        }
        if (module == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(3);
        }
        if (baseDir == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(4);
        }
        if (requestor == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(5);
        }
        try {
            GoSdk sdk = GoSdkService.getInstance(project).getSdk(null);
            GoModuleSettings moduleSettings = GoModuleSettings.getInstance(module);
            GoBuildTargetSettings buildTargetSettings = moduleSettings.getBuildTargetSettings();
            buildTargetSettings.customFlags = (String[])ArrayUtil.append((Object[])buildTargetSettings.customFlags, (Object)"appengine");
            String applicationName = GoPsiImplUtil.sanitizePackageName(baseDir.getName()).toLowerCase(DynamicBundle.getLocale());
            VirtualFile helloWorld = (VirtualFile)WriteAction.compute(() -> GoAppEngineModuleBuilder.createApplicationFile(applicationName, baseDir, sdk, requestor));
            VirtualFile appYaml = (VirtualFile)WriteAction.compute(() -> GoAppEngineModuleBuilder.createAppYamlFile(baseDir, sdk, requestor));
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                if (appYaml.isValid()) {
                    FileEditorManager.getInstance((Project)project).openFile(appYaml, true);
                    GoAppEngineModuleBuilder.createRunConfigurations(project, sdk, helloWorld);
                }
                if (helloWorld.isValid()) {
                    FileEditorManager.getInstance((Project)project).openFile(helloWorld, true);
                }
            });
        }
        catch (IOException e) {
            LOG.error("Cannot create project template", (Throwable)e);
        }
    }

    private static void createRunConfigurations(@NotNull Project project, @NotNull GoSdk sdk, @NotNull VirtualFile helloWorld) {
        if (project == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(6);
        }
        if (sdk == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(7);
        }
        if (helloWorld == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> ReadAction.run(() -> {
            RunnerAndConfigurationSettings configurationSettings;
            if (project.isDisposed()) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = configurationSettings = sdk.supportsAppEngine() ? GoAppEngineModuleBuilder.createBuildRunConfiguration(project, runManager, helloWorld) : null;
            if (configurationSettings != null) {
                runManager.addConfiguration(configurationSettings);
                runManager.setSelectedConfiguration(configurationSettings);
            }
        }));
    }

    private static RunnerAndConfigurationSettings createBuildRunConfiguration(@NotNull Project project, @NotNull RunManager runManager, @NotNull VirtualFile helloWorld) {
        if (project == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(9);
        }
        if (runManager == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(10);
        }
        if (helloWorld == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(11);
        }
        if (!helloWorld.isValid()) {
            return null;
        }
        GoApplicationRunConfigurationType configurationType = GoApplicationRunConfigurationType.getInstance();
        ConfigurationFactory configurationFactory = configurationType.getConfigurationFactories()[0];
        RunnerAndConfigurationSettings configurationSettings = runManager.createConfiguration(GoBundle.message((String)"go.app.engine.wizard.name", (Object[])new Object[0]), configurationFactory);
        RunConfiguration configuration = configurationSettings.getConfiguration();
        if (configuration instanceof GoApplicationConfiguration) {
            VirtualFile directory = helloWorld.getParent();
            String importPath = GoSdkUtil.getImportPath(PsiManager.getInstance((Project)project).findDirectory(directory), false);
            if (StringUtil.isNotEmpty((String)importPath)) {
                ((GoApplicationConfiguration)configuration).setPackage(importPath);
                ((GoApplicationConfiguration)configuration).setKind(GoBuildingRunConfiguration.Kind.PACKAGE);
            } else {
                ((GoApplicationConfiguration)configuration).setDirectoryPath(directory.getPresentableUrl());
                ((GoApplicationConfiguration)configuration).setKind(GoBuildingRunConfiguration.Kind.DIRECTORY);
            }
            ((GoApplicationConfiguration)configuration).setWorkingDirectory(directory.getPresentableUrl());
        }
        return configurationSettings;
    }

    private static VirtualFile createApplicationFile(@NotNull String applicationName, @NotNull VirtualFile baseDir, @NotNull GoSdk sdk, @NotNull Object requestor) throws IOException {
        if (applicationName == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(12);
        }
        if (baseDir == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(13);
        }
        if (sdk == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(14);
        }
        if (requestor == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(15);
        }
        @NonNls Object content2 = sdk.supportsAppEngine() ? "package main\n\nimport (\n\t\"fmt\"\n\t\"log\"\n\t\"net/http\"\n\t\"os\"\n)\n\nfunc main() {\n\thttp.HandleFunc(\"/\", indexHandler)\n\tport := os.Getenv(\"PORT\")\n\tif port == \"\" {\n\t\tport = \"8080\"\n\t\tlog.Printf(\"Defaulting to port %s\", port)\n\t}\n\n\tlog.Printf(\"Listening on port %s\", port)\n\tlog.Printf(\"Open http://localhost:%s in the browser\", port)\n\tlog.Fatal(http.ListenAndServe(fmt.Sprintf(\":%s\", port), nil))\n}\n\nfunc indexHandler(w http.ResponseWriter, r *http.Request) {\n\tif r.URL.Path != \"/\" {\n\t\thttp.NotFound(w, r)\n\t\treturn\n\t}\n\t_, err := fmt.Fprint(w, \"Hello, World!\")\n\tif err != nil {\n\t\tw.WriteHeader(http.StatusInternalServerError)\n\t}\n}" : "package " + applicationName + "\n\nimport (\n\t\"fmt\"\n\t\"net/http\"\n)\n\nfunc init() {\n\thttp.HandleFunc(\"/\", handle)\n}\n\nfunc handle(w http.ResponseWriter, r *http.Request) {\n\t_, err := fmt.Fprint(w, \"<html><body>Hello, World!</body></html>\")\n\tif err != nil {\n\t\tw.WriteHeader(http.StatusInternalServerError)\n\t}\n}";
        return GoAppEngineModuleBuilder.createFile(applicationName + ".go", (String)content2, baseDir, requestor);
    }

    private static VirtualFile createAppYamlFile(@NotNull VirtualFile baseDir, @NotNull GoSdk sdk, @NotNull Object requestor) throws IOException {
        String majorVersion;
        if (baseDir == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(16);
        }
        if (sdk == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(17);
        }
        if (requestor == null) {
            GoAppEngineModuleBuilder.$$$reportNull$$$0(18);
        }
        @NonNls Object runtime = "go";
        if (sdk.supportsAppEngine() && (majorVersion = GoSdkUtil.getSdkMajorVersion(sdk.getVersion())) != null) {
            runtime = "go" + majorVersion.replaceAll("\\.", "");
        }
        return GoAppEngineModuleBuilder.createFile("app.yaml", "runtime: " + (String)runtime + "\napi_version: go1\n\nhandlers:\n- url: /.*\n  script: _go_app", baseDir, requestor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/appengine/wizard/GoAppEngineModuleBuilder";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 5: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 7: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helloWorld";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/appengine/wizard/GoAppEngineModuleBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "validator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "moduleCreated";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAppEngineApplication";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfigurations";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createBuildRunConfiguration";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createApplicationFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createAppYamlFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

