/*
 * Decompiled with CFR 0.152.
 */
package com.goide.comments;

import com.goide.comments.GoCommentToken;
import com.goide.comments.GoCommentTokenType;
import com.goide.util.GoUtil;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GoCommentLexer {
    private final String myText;
    private int myOffset;

    GoCommentLexer(@NotNull String text) {
        if (text == null) {
            GoCommentLexer.$$$reportNull$$$0(0);
        }
        this.myText = text;
    }

    int getOffset() {
        return this.myOffset;
    }

    void setOffset(int offset) {
        this.myOffset = offset;
    }

    @Nullable
    GoCommentToken getNext() {
        int start;
        char c;
        if (this.myOffset >= this.myText.length()) {
            return null;
        }
        if ((c = this.myText.charAt(start = this.myOffset++)) == ' ' || c == '\t' || c == '\n' || c == '\r') {
            return new GoCommentToken(GoCommentTokenType.SPACE, new TextRange(start, this.myOffset));
        }
        if (GoUtil.isValidGoIdentifierCharacter(c)) {
            while (this.myOffset < this.myText.length() && GoUtil.isValidGoIdentifierCharacter(this.myText.charAt(this.myOffset))) {
                ++this.myOffset;
            }
            return new GoCommentToken(GoCommentTokenType.WORD, new TextRange(start, this.myOffset));
        }
        return new GoCommentToken(GoCommentTokenType.PUNCTUATION, new TextRange(start, this.myOffset));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/goide/comments/GoCommentLexer", "<init>"));
    }
}

