/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddBracketsInsertHandler
extends ParenthesesInsertHandler<LookupElement> {
    static final AddBracketsInsertHandler INSTANCE = new AddBracketsInsertHandler(1);
    private final int myTabOutOffset;

    public AddBracketsInsertHandler(int tabOutOffset) {
        assert (tabOutOffset > 0);
        this.myTabOutOffset = tabOutOffset;
    }

    protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement element) {
        return true;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        int tail;
        int lbracket;
        boolean putCaretInside;
        if (context == null) {
            AddBracketsInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            AddBracketsInsertHandler.$$$reportNull$$$0(1);
        }
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        context.commitDocument();
        PsiElement element = this.findNextToken(context);
        char completionChar = context.getCompletionChar();
        boolean bl = putCaretInside = completionChar == '[' || this.placeCaretInsideParentheses(context, item);
        if (completionChar == '[') {
            context.setAddCompletionChar(false);
        }
        if (AddBracketsInsertHandler.isToken(element, "[")) {
            lbracket = element.getTextRange().getStartOffset();
            if (completionChar != '[' && completionChar != '\t') {
                editor.getCaretModel().moveToOffset(context.getTailOffset());
            } else {
                editor.getCaretModel().moveToOffset(lbracket + 1);
            }
            context.setTailOffset(lbracket + 1);
            PsiElement rbracketElement = AddBracketsInsertHandler.findRightBracket(element);
            if (rbracketElement != null) {
                int rbracket = rbracketElement.getTextRange().getStartOffset();
                context.setTailOffset(rbracket + 1);
                if (!putCaretInside) {
                    for (int i = lbracket + 1; i < rbracket; ++i) {
                        if (Character.isWhitespace(document.getCharsSequence().charAt(i))) continue;
                        return;
                    }
                    editor.getCaretModel().moveToOffset(context.getTailOffset());
                } else {
                    editor.getCaretModel().moveToOffset(lbracket + 1);
                }
                return;
            }
        } else {
            lbracket = context.getTailOffset();
            document.insertString(lbracket, (CharSequence)"[");
            editor.getCaretModel().moveToOffset(lbracket + 1);
        }
        if (context.getCompletionChar() == '[' && (tail = context.getTailOffset()) < document.getTextLength() && StringUtil.isJavaIdentifierPart((char)document.getCharsSequence().charAt(tail))) {
            return;
        }
        int rbracket = context.getTailOffset();
        document.insertString(rbracket, (CharSequence)"]");
        if (putCaretInside) {
            TabOutScopesTracker.getInstance().registerScopeRange(editor, lbracket, rbracket, rbracket + this.myTabOutOffset);
        } else {
            editor.getCaretModel().moveToOffset(context.getTailOffset());
        }
    }

    @Nullable
    private static PsiElement findRightBracket(@NotNull PsiElement leftBracket) {
        if (leftBracket == null) {
            AddBracketsInsertHandler.$$$reportNull$$$0(2);
        }
        for (PsiElement next = leftBracket.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (!AddBracketsInsertHandler.isToken(next, "]")) continue;
            return next;
        }
        return null;
    }

    @Contract(value="null,_->false")
    private static boolean isToken(@Nullable PsiElement element, @NotNull String text) {
        if (text == null) {
            AddBracketsInsertHandler.$$$reportNull$$$0(3);
        }
        return element != null && element.textMatches((CharSequence)text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftBracket";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/goide/completion/AddBracketsInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findRightBracket";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

