/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.completion.GoCompletionUtil;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public final class BracesInsertHandler
implements InsertHandler<LookupElement> {
    public static final BracesInsertHandler ONE_LINER = new BracesInsertHandler(true);
    public static final BracesInsertHandler INSTANCE = new BracesInsertHandler(false);
    private final boolean myOneLine;

    private BracesInsertHandler(boolean oneLine) {
        this.myOneLine = oneLine;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        boolean atBrace;
        if (context == null) {
            BracesInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            BracesInsertHandler.$$$reportNull$$$0(1);
        }
        Editor editor = context.getEditor();
        int origin = editor.getCaretModel().getOffset();
        PsiFile file2 = context.getFile().getOriginalFile();
        PsiElement caretElement = file2.findElementAt(origin);
        GoType type = (GoType)PsiTreeUtil.getParentOfType((PsiElement)caretElement, GoType.class);
        boolean typeWithBraces = type instanceof GoInterfaceType || type instanceof GoStructType;
        GoFunctionOrMethodDeclaration function = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)type, GoFunctionOrMethodDeclaration.class);
        boolean functionWithoutBlock = function != null && function.getBlock() == null;
        CharSequence documentText = context.getDocument().getImmutableCharSequence();
        int offset = BracesInsertHandler.skipWhiteSpaces(origin, documentText);
        boolean bl = atBrace = documentText.charAt(offset) != '{';
        if (atBrace || typeWithBraces && functionWithoutBlock) {
            String braces = GoCompletionUtil.isAtElementValueWithNewLineCheap(context) ? "{}," : "{}";
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)braces, (boolean)false, (boolean)false);
            offset = editor.getCaretModel().getOffset();
        }
        int braceOffset = offset + 1;
        editor.getCaretModel().moveToOffset(braceOffset);
        if (this.myOneLine) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            EditorActionHandler enterAction = EditorActionManager.getInstance().getActionHandler("EditorEnter");
            enterAction.execute(editor, editor.getCaretModel().getCurrentCaret(), EditorUtil.getEditorDataContext((Editor)editor));
            CodeStyleManager.getInstance((Project)context.getProject()).reformatText(file2, context.getStartOffset(), braceOffset);
        });
    }

    private static int skipWhiteSpaces(int offset, @NotNull CharSequence documentText) {
        if (documentText == null) {
            BracesInsertHandler.$$$reportNull$$$0(2);
        }
        while (offset < documentText.length() && StringUtil.isWhiteSpace((char)documentText.charAt(offset))) {
            ++offset;
        }
        return Math.min(documentText.length() - 1, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentText";
                break;
            }
        }
        objectArray2[1] = "com/goide/completion/BracesInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "skipWhiteSpaces";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

