/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.codeInsight.GoCodeInsightSettings;
import com.goide.codeInsight.imports.GoImport;
import com.goide.completion.GoAutoImportInsertHandler;
import com.goide.completion.GoCompletionUtil;
import com.goide.completion.GoKeywordCompletionContributor;
import com.goide.completion.GoLookupElementOptions;
import com.goide.completion.GoParameterNameDecorator;
import com.goide.execution.testing.GoTestFinder;
import com.goide.index.GoAliasToImportPathIndexKt;
import com.goide.inspections.GoDuplicatesSearch;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoSignature;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeReference;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.sdk.GoPackageUtil;
import com.goide.stubs.index.GoAllPublicNamesIndex;
import com.goide.stubs.index.GoIdFilter;
import com.goide.util.GoUtil;
import com.goide.util.GoVendorScope;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.text.matching.KeyboardLayoutUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoAutoImportCompletionContributor
extends CompletionContributor {
    private final int myLimit = Registry.intValue((String)"ide.completion.variant.limit");

    public GoAutoImportCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)GoAutoImportCompletionContributor.inGoFileOrFragmentWithImports(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                GoFile file2;
                PsiFile psiFile;
                PsiElement parent;
                PsiElement position;
                block20: {
                    block19: {
                        if (parameters == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (context == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (result == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        boolean hasOtherVariants = GoAutoImportCompletionContributor.runRemainingContributors(parameters, result);
                        if (parameters.isAutoPopup() && hasOtherVariants && !GoCodeInsightSettings.getInstance().isShowAutoImportVariantsInAutoPopup()) {
                            return;
                        }
                        position = parameters.getPosition();
                        parent = position.getParent();
                        if (GoPsiImplUtil.prevDot(parent)) {
                            return;
                        }
                        if (GoKeywordCompletionContributor.onTheVeryStartOfCaseClause().accepts((Object)position)) {
                            return;
                        }
                        if (GoPsiUtil.isTypeReferenceBeforeUnexpectedTokens(parent, "=", "{")) {
                            return;
                        }
                        if (GoPsiUtil.isUnexpectedTypeReferenceInsteadOfChan(parent)) {
                            return;
                        }
                        psiFile = parameters.getOriginalFile();
                        if (!(psiFile instanceof GoFile)) break block19;
                        file2 = (GoFile)psiFile;
                        if (parent instanceof GoReferenceExpressionBase) break block20;
                    }
                    return;
                }
                PrefixMatcher matcher = (result = 1.adjustMatcher(parameters, result, parent)).getPrefixMatcher();
                if (matcher.getPrefix().isEmpty()) {
                    result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(0));
                    return;
                }
                GoResolvable qualifier = ((GoReferenceExpressionBase)parent).getResolvableQualifier();
                if (qualifier != null && qualifier.resolve() != null) {
                    return;
                }
                ArrayList<ElementProcessor> processors = new ArrayList<ElementProcessor>();
                if (parent instanceof GoReferenceExpression && !GoPsiImplUtil.isUnaryBitAndExpressionOperand(parent)) {
                    processors.add(new FunctionsProcessor());
                    processors.add(new VariablesAndConstantsProcessor());
                }
                if (parent instanceof GoReferenceExpression || parent instanceof GoTypeReferenceExpression) {
                    processors.add(new TypesProcessor(parent));
                }
                if (processors.isEmpty()) {
                    return;
                }
                NamedElementProcessor processor2 = new NamedElementProcessor(processors, file2, result, GoUtil.module((PsiElement)psiFile), position);
                Project project = position.getProject();
                GoUtil.ExceptTestsScope scope = new GoUtil.ExceptTestsScope(GoUtil.goPathResolveScope((PsiElement)file2));
                GoPackage aPackage = GoPackage.of(GoAutoImportCompletionContributor.getOriginalFile(file2));
                if (aPackage != null) {
                    GoUtil.TestsScope excludeScope = GoTestFinder.isTestFileWithTestPackage((PsiFile)file2) ? new GoUtil.TestsScope(aPackage.getScope()) : aPackage.getScope();
                    scope = scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)excludeScope));
                }
                IdFilter idFilter = GoIdFilter.getProductionFilter(project);
                Collection<NameInfo> names = GoAutoImportCompletionContributor.collectAndSortAllPublicProductionNames(matcher, (GlobalSearchScope)scope, idFilter, file2);
                int count = 0;
                for (NameInfo info : names) {
                    processor2.setName(info);
                    for (GoNamedElement element : StubIndex.getElements(GoAllPublicNamesIndex.ALL_PUBLIC_NAMES, (Object)info.getName(), (Project)project, (GlobalSearchScope)scope, (IdFilter)idFilter, GoNamedElement.class)) {
                        if (processor2.process(element) || ++count <= GoAutoImportCompletionContributor.this.myLimit) continue;
                        return;
                    }
                }
            }

            private static CompletionResultSet adjustMatcher(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull PsiElement parent) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (parent == null) {
                    1.$$$reportNull$$$0(5);
                }
                int startOffset = parent.getTextRange().getStartOffset();
                String newPrefix = parameters.getEditor().getDocument().getText(TextRange.create((int)startOffset, (int)parameters.getOffset()));
                return result.withPrefixMatcher(GoCompletionUtil.createPrefixMatcher(newPrefix));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/completion/GoAutoImportCompletionContributor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addCompletions";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "adjustMatcher";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean runRemainingContributors(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(1);
        }
        Ref hasOtherVariants = Ref.create((Object)false);
        result.runRemainingContributors(parameters, completionResult -> {
            hasOtherVariants.set((Object)true);
            result.passResult(completionResult);
        });
        return (Boolean)hasOtherVariants.get();
    }

    @NotNull
    private static GoFile getOriginalFile(@NotNull GoFile file2) {
        PsiElement context;
        if (file2 == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(2);
        }
        GoFile contextFile = (context = file2.getContext()) != null ? (GoFile)((Object)ObjectUtils.tryCast((Object)context.getContainingFile(), GoFile.class)) : null;
        GoFile goFile = (GoFile)((Object)ObjectUtils.notNull((Object)((Object)contextFile), (Object)((Object)file2)));
        if (goFile == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(3);
        }
        return goFile;
    }

    @NotNull
    private static Collection<NameInfo> collectAndSortAllPublicProductionNames(@NotNull PrefixMatcher matcher, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull GoFile file2) {
        if (matcher == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(6);
        }
        String prefix = matcher.getPrefix();
        assert (!prefix.isEmpty());
        HashSet<String> existingImportPaths = new HashSet<String>();
        ResolveState state = GoPsiImplUtil.createContextOnElement((PsiElement)file2);
        MultiMap importsWithAliases = MultiMap.createSet();
        for (GoImportSpec spec : file2.getImportMap().values()) {
            String alias = spec.getAlias();
            if ("_".equals(alias)) continue;
            existingImportPaths.add(spec.getPath());
            if (!spec.isDot() && alias == null) continue;
            for (String packageName : GoPsiImplUtil.getImportQualifiersToUseInFile(spec.resolve(state), spec.getPath())) {
                importsWithAliases.putValue((Object)packageName, (Object)new GoImport(spec.getPath(), alias));
            }
        }
        Character first = Character.valueOf(prefix.charAt(0));
        Character firstFixed = (Character)ObjectUtils.chooseNotNull((Object)KeyboardLayoutUtil.getAsciiForChar((char)first.charValue()), (Object)first);
        Project project = file2.getProject();
        Module module = GoUtil.module((PsiElement)file2);
        GlobalSearchScope importPathSearchScope = GoUtil.moduleScopeWithoutLibraries(project, module);
        if (module != null) {
            importPathSearchScope = importPathSearchScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)new GoVendorScope(module)));
        }
        for (String alias : GoAliasToImportPathIndexKt.getAllAliases(project)) {
            if (!GoAutoImportCompletionContributor.startsWithChar(alias, first, firstFixed)) continue;
            for (String importPath : GoAliasToImportPathIndexKt.getImportPathsByAlias(importPathSearchScope, alias)) {
                if (existingImportPaths.contains(importPath)) continue;
                for (GoPackage pkg : GoPackageUtil.findByImportPath(importPath, project, module, state)) {
                    ProgressManager.checkCanceled();
                    importsWithAliases.putValue((Object)pkg.getName(), (Object)new GoImport(importPath, alias));
                }
            }
        }
        ArrayList<NameInfo> allNames = new ArrayList<NameInfo>();
        StubIndex.getInstance().processAllKeys(GoAllPublicNamesIndex.ALL_PUBLIC_NAMES, s -> {
            ProgressManager.checkCanceled();
            boolean matchedByOriginalPackageName = false;
            if (GoAutoImportCompletionContributor.startsWithChar(s, first, firstFixed) && matcher.isStartMatch(s) || matcher.isStartMatch(GoUtil.substringAfter(s, '.'))) {
                matchedByOriginalPackageName = true;
            }
            HashSet<GoImport> matchedAliasedImports = new HashSet<GoImport>();
            String packageName = GoAutoImportCompletionContributor.substringBefore(s, '.');
            for (GoImport importWithAlias : importsWithAliases.get((Object)packageName)) {
                String aliasedName = GoAutoImportCompletionContributor.replacePackageWithAlias(s, importWithAlias.getAlias());
                if (!GoAutoImportCompletionContributor.startsWithChar(aliasedName, first, firstFixed) || !matcher.isStartMatch(aliasedName)) continue;
                matchedAliasedImports.add(importWithAlias);
            }
            if (matchedByOriginalPackageName || !matchedAliasedImports.isEmpty()) {
                allNames.add(new NameInfo((String)s, matchedByOriginalPackageName, (Set<GoImport>)matchedAliasedImports));
            }
            return true;
        }, scope, idFilter);
        ArrayList<NameInfo> arrayList = allNames;
        if (arrayList == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static boolean startsWithChar(@Nullable String str, @NotNull Character prefix, @Nullable Character prefixFixed) {
        if (prefix == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(8);
        }
        if (str == null || str.isEmpty()) {
            return false;
        }
        char prefixUpper = Character.toUpperCase(prefix.charValue());
        Character prefixUpperFixed = prefixFixed == null ? null : Character.valueOf(Character.toUpperCase(prefixFixed.charValue()));
        char at0 = Character.toUpperCase(str.charAt(0));
        if (at0 == prefixUpper || prefixUpperFixed != null && prefixUpperFixed.equals(Character.valueOf(at0))) {
            return true;
        }
        int dotIndex = str.indexOf(".");
        if (dotIndex > 0 && dotIndex < str.length() - 1) {
            char atDot = Character.toUpperCase(str.charAt(dotIndex + 1));
            return atDot == prefixUpper || prefixUpperFixed != null && prefixUpperFixed.equals(Character.valueOf(atDot));
        }
        return false;
    }

    private static PsiElementPattern.Capture<PsiElement> inGoFileOrFragmentWithImports() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiElement(GoFile.class).with(GoCompletionUtil.condition("code fragment with imports", file2 -> !(file2 instanceof GoCodeFragment) || ((GoCodeFragment)((Object)file2)).supportsImports())));
    }

    @NotNull
    private static String substringBefore(@NotNull String s, char c) {
        int i;
        if (s == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(9);
        }
        if ((i = s.indexOf(c)) == -1) {
            String string = s;
            if (string == null) {
                GoAutoImportCompletionContributor.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = s.substring(0, i);
        if (string == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String replacePackageWithAlias(@NotNull String qualifiedName, @Nullable String alias) {
        if (qualifiedName == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(12);
        }
        Object object = alias != null ? alias + "." + GoUtil.substringAfter(qualifiedName, '.') : qualifiedName;
        if (object == null) {
            GoAutoImportCompletionContributor.$$$reportNull$$$0(13);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 10, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/GoAutoImportCompletionContributor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/GoAutoImportCompletionContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAndSortAllPublicProductionNames";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBefore";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "replacePackageWithAlias";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runRemainingContributors";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalFile";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectAndSortAllPublicProductionNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startsWithChar";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "substringBefore";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replacePackageWithAlias";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 10, 11, 13 -> new IllegalStateException(string);
        };
    }

    private static final class NameInfo {
        private final String myName;
        private final boolean myMatchedByOriginalPackageName;
        private final Set<GoImport> myImportsWithAliases;

        private NameInfo(@NotNull String name, boolean matchedByOriginalPackageName, @NotNull Set<GoImport> importsWithAliases) {
            if (name == null) {
                NameInfo.$$$reportNull$$$0(0);
            }
            if (importsWithAliases == null) {
                NameInfo.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myMatchedByOriginalPackageName = matchedByOriginalPackageName;
            this.myImportsWithAliases = importsWithAliases;
        }

        @NotNull
        String getName() {
            String string = this.myName;
            if (string == null) {
                NameInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        private boolean isMatchedByOriginalPackageName() {
            return this.myMatchedByOriginalPackageName;
        }

        @NotNull
        private Set<GoImport> getImportsWithAliases() {
            Set<GoImport> set = this.myImportsWithAliases;
            if (set == null) {
                NameInfo.$$$reportNull$$$0(3);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importsWithAliases";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/completion/GoAutoImportCompletionContributor$NameInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/completion/GoAutoImportCompletionContributor$NameInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportsWithAliases";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ExistingImportData {
        public final boolean exists;
        public final boolean isDot;
        public final Set<String> aliases;
        public final String importPath;

        private ExistingImportData(boolean exists, boolean isDot, Set<String> aliases, @NotNull String importPath) {
            if (importPath == null) {
                ExistingImportData.$$$reportNull$$$0(0);
            }
            this.exists = exists;
            this.isDot = isDot;
            this.aliases = aliases;
            this.importPath = importPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPath", "com/goide/completion/GoAutoImportCompletionContributor$ExistingImportData", "<init>"));
        }
    }

    private static final class NamedElementProcessor
    implements Processor<GoNamedElement> {
        @NotNull
        private final Collection<ElementProcessor> myProcessors;
        @NotNull
        private final CompletionResultSet myResult;
        @NotNull
        private final Set<String> myNamesInContext;
        private NameInfo myNameInfo;
        @NotNull
        private final MultiMap<String, GoImportSpec> myImportMap;
        @NotNull
        private final Map<String, GoImportSpec> myImportedPackages;
        @Nullable
        private final Module myModule;
        private final boolean myVendoringEnabled;

        private NamedElementProcessor(@NotNull Collection<ElementProcessor> processors, @NotNull GoFile contextFile, @NotNull CompletionResultSet result, @Nullable Module module, @NotNull PsiElement context) {
            if (processors == null) {
                NamedElementProcessor.$$$reportNull$$$0(0);
            }
            if (contextFile == null) {
                NamedElementProcessor.$$$reportNull$$$0(1);
            }
            if (result == null) {
                NamedElementProcessor.$$$reportNull$$$0(2);
            }
            if (context == null) {
                NamedElementProcessor.$$$reportNull$$$0(3);
            }
            this.myNameInfo = null;
            this.myProcessors = processors;
            this.myVendoringEnabled = GoVendoringUtil.isVendoringEnabled(module);
            this.myImportedPackages = contextFile.getImportedPackagesMap();
            this.myImportMap = contextFile.getImportMap();
            this.myModule = module;
            this.myResult = result;
            this.myNamesInContext = GoNameSuggestionProvider.getNamesInContext(context, true);
            new GoDuplicatesSearch.TopLevelScopeSearch().processAllElements(contextFile, (PairProcessor<String, GoDuplicatesSearch.Duplicate>)((PairProcessor)(name, duplicate) -> this.myNamesInContext.add((String)name)));
        }

        public void setName(@NotNull NameInfo info) {
            if (info == null) {
                NamedElementProcessor.$$$reportNull$$$0(4);
            }
            this.myNameInfo = info;
        }

        public boolean process(@NotNull GoNamedElement element) {
            if (element == null) {
                NamedElementProcessor.$$$reportNull$$$0(5);
            }
            ProgressManager.checkCanceled();
            if (!GoPsiUtil.isTopLevelDeclaration(element)) {
                return true;
            }
            Boolean allowed = null;
            ExistingImportData importData = null;
            boolean withVendoring = GoVendoringUtil.isVendoringEnabled(this.myModule);
            for (ElementProcessor processor2 : this.myProcessors) {
                if (!processor2.isMine(element)) continue;
                importData = this.cachedImportData(element, importData);
                if (!(allowed = this.cachedAllowed(element, allowed, withVendoring)).booleanValue() || importData.isDot) break;
                if (importData.aliases.isEmpty() || processor2.process(this.myNameInfo.getName(), element, importData, this.myResult)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        private Boolean cachedAllowed(@NotNull GoNamedElement element, @Nullable Boolean existingValue, boolean withVendoring) {
            if (element == null) {
                NamedElementProcessor.$$$reportNull$$$0(6);
            }
            if (existingValue != null) {
                Boolean bl = existingValue;
                if (bl == null) {
                    NamedElementProcessor.$$$reportNull$$$0(7);
                }
                return bl;
            }
            Boolean bl = GoPsiImplUtil.canBeAutoImported(element.getContainingFile(), false, this.myModule, withVendoring);
            if (bl == null) {
                NamedElementProcessor.$$$reportNull$$$0(8);
            }
            return bl;
        }

        @NotNull
        private ExistingImportData cachedImportData(@NotNull GoNamedElement element, @Nullable ExistingImportData existingValue) {
            if (element == null) {
                NamedElementProcessor.$$$reportNull$$$0(9);
            }
            if (existingValue != null) {
                ExistingImportData existingImportData = existingValue;
                if (existingImportData == null) {
                    NamedElementProcessor.$$$reportNull$$$0(10);
                }
                return existingImportData;
            }
            GoFile declarationFile = element.getContainingFile();
            String importPath = declarationFile.getImportPath(this.myVendoringEnabled);
            if (importPath == null) {
                return new ExistingImportData(false, false, Collections.emptySet(), "");
            }
            GoImportSpec existingImport = this.myImportedPackages.get(importPath);
            if (existingImport != null) {
                Set<String> aliases = Collections.singleton(existingImport.getAlias());
                return new ExistingImportData(true, existingImport.isDot(), aliases, existingImport.getPath());
            }
            String packageName = declarationFile.getPackageName();
            Collection importsWithSamePackage = this.myImportMap.get((Object)packageName);
            for (GoImportSpec spec : importsWithSamePackage) {
                for (GoPackage aPackage : spec.resolve(ResolveState.initial())) {
                    if (aPackage.find(f -> f == declarationFile) == null) continue;
                    Set<String> aliases = Collections.singleton(spec.getAlias());
                    return new ExistingImportData(true, spec.isDot(), aliases, spec.getPath());
                }
            }
            TreeSet<String> possibleAliases = new TreeSet<String>();
            if (packageName != null && this.myNameInfo.isMatchedByOriginalPackageName()) {
                possibleAliases.add(UniqueNameGenerator.generateUniqueName((String)packageName, this.myNamesInContext));
            }
            for (GoImport importWithAlias : this.myNameInfo.getImportsWithAliases()) {
                String alias = importWithAlias.getAlias();
                assert (alias != null);
                if (!importPath.equals(importWithAlias.getImportPath())) continue;
                possibleAliases.add(UniqueNameGenerator.generateUniqueName((String)alias, this.myNamesInContext));
            }
            return new ExistingImportData(false, false, possibleAliases, importPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/completion/GoAutoImportCompletionContributor$NamedElementProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/completion/GoAutoImportCompletionContributor$NamedElementProcessor";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cachedAllowed";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cachedImportData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "cachedAllowed";
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "cachedImportData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 10 -> new IllegalStateException(string);
            };
        }
    }

    private static final class TypesProcessor
    implements ElementProcessor {
        @Nullable
        private final PsiElement myParent;
        @NotNull
        private final Set<String> myUsedNames;
        private final boolean mySuggestParameterName;

        private TypesProcessor(@Nullable PsiElement parent) {
            this.myParent = parent;
            this.mySuggestParameterName = GoParameterNameDecorator.shouldSuggestNamesInParameters(this.myParent);
            this.myUsedNames = this.mySuggestParameterName ? GoNameSuggestionProvider.getNamesInContext(PsiTreeUtil.getParentOfType((PsiElement)this.myParent, GoSignature.class)) : Collections.emptySet();
        }

        @Override
        public boolean process(@NotNull String name, @NotNull GoNamedElement element, @NotNull ExistingImportData importData, @NotNull CompletionResultSet result) {
            if (name == null) {
                TypesProcessor.$$$reportNull$$$0(0);
            }
            if (element == null) {
                TypesProcessor.$$$reportNull$$$0(1);
            }
            if (importData == null) {
                TypesProcessor.$$$reportNull$$$0(2);
            }
            if (result == null) {
                TypesProcessor.$$$reportNull$$$0(3);
            }
            GoTypeSpec spec = (GoTypeSpec)element;
            boolean forTypes = this.myParent instanceof GoTypeReferenceExpression;
            double priority = importData.exists ? (forTypes ? 35.0 : 35.0) : (forTypes ? 5.0 : 5.0);
            for (String alias : importData.aliases) {
                String lookupString = GoAutoImportCompletionContributor.replacePackageWithAlias(name, alias);
                GoImport goImport = lookupString.equals(name) ? new GoImport(importData.importPath) : new GoImport(importData.importPath, alias);
                InsertHandler<LookupElement> insertHandler = forTypes ? GoAutoImportInsertHandler.Lazy.SIMPLE_TYPE_INSERT_HANDLER : GoAutoImportInsertHandler.Lazy.TYPED_EXPRESSION_INSERT_HANDLER;
                GoLookupElementOptions options = new GoLookupElementOptions().setLookupString(lookupString).setInsertHandler(insertHandler).setImport(goImport).setPriority(priority);
                LookupElement origin = forTypes ? GoCompletionUtil.createTypeLookupElement(spec, options) : GoCompletionUtil.createTypedExpressionLookupElement(spec, options);
                result.addElement(this.mySuggestParameterName ? GoParameterNameDecorator.withParameterNameIfNeeded(origin, name, this.myUsedNames) : origin);
            }
            return false;
        }

        @Override
        public boolean isMine(@NotNull GoNamedElement element) {
            if (element == null) {
                TypesProcessor.$$$reportNull$$$0(4);
            }
            if (this.myParent != null && element instanceof GoTypeSpec) {
                PsiReference reference = this.myParent.getReference();
                return !(reference instanceof GoTypeReference) || ((GoTypeReference)reference).allowed((GoTypeSpec)element);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/goide/completion/GoAutoImportCompletionContributor$TypesProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FunctionsProcessor
    implements ElementProcessor {
        private FunctionsProcessor() {
        }

        @Override
        public boolean process(@NotNull String name, @NotNull GoNamedElement element, @NotNull ExistingImportData importData, @NotNull CompletionResultSet result) {
            if (name == null) {
                FunctionsProcessor.$$$reportNull$$$0(0);
            }
            if (element == null) {
                FunctionsProcessor.$$$reportNull$$$0(1);
            }
            if (importData == null) {
                FunctionsProcessor.$$$reportNull$$$0(2);
            }
            if (result == null) {
                FunctionsProcessor.$$$reportNull$$$0(3);
            }
            GoFunctionDeclaration function = (GoFunctionDeclaration)element;
            double priority = importData.exists ? 35.0 : 5.0;
            for (String alias : importData.aliases) {
                String lookupString = GoAutoImportCompletionContributor.replacePackageWithAlias(name, alias);
                GoImport goImport = lookupString.equals(name) ? new GoImport(importData.importPath) : new GoImport(importData.importPath, alias);
                GoLookupElementOptions options = new GoLookupElementOptions().setLookupString(lookupString).setImport(goImport).setInsertHandler(GoAutoImportInsertHandler.Lazy.VARIABLE_OR_FUNCTION_INSERT_HANDLER).setPriority(priority);
                result.addElement(GoCompletionUtil.createFunctionOrMethodLookupElement(function, options));
            }
            return false;
        }

        @Override
        public boolean isMine(@NotNull GoNamedElement element) {
            if (element == null) {
                FunctionsProcessor.$$$reportNull$$$0(4);
            }
            return element instanceof GoFunctionDeclaration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/goide/completion/GoAutoImportCompletionContributor$FunctionsProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariablesAndConstantsProcessor
    implements ElementProcessor {
        private VariablesAndConstantsProcessor() {
        }

        @Override
        public boolean process(@NotNull String name, @NotNull GoNamedElement element, @NotNull ExistingImportData importData, @NotNull CompletionResultSet result) {
            if (name == null) {
                VariablesAndConstantsProcessor.$$$reportNull$$$0(0);
            }
            if (element == null) {
                VariablesAndConstantsProcessor.$$$reportNull$$$0(1);
            }
            if (importData == null) {
                VariablesAndConstantsProcessor.$$$reportNull$$$0(2);
            }
            if (result == null) {
                VariablesAndConstantsProcessor.$$$reportNull$$$0(3);
            }
            double priority = importData.exists ? 35.0 : 5.0;
            for (String alias : importData.aliases) {
                String lookupString = GoAutoImportCompletionContributor.replacePackageWithAlias(name, alias);
                GoImport goImport = lookupString.equals(name) ? new GoImport(importData.importPath) : new GoImport(importData.importPath, alias);
                GoLookupElementOptions options = new GoLookupElementOptions().setLookupString(lookupString).setImport(goImport).setInsertHandler(GoAutoImportInsertHandler.Lazy.VARIABLE_OR_FUNCTION_INSERT_HANDLER).setPriority(priority);
                result.addElement(GoCompletionUtil.createVariableLikeLookupElement(element, options));
            }
            return false;
        }

        @Override
        public boolean isMine(@NotNull GoNamedElement element) {
            if (element == null) {
                VariablesAndConstantsProcessor.$$$reportNull$$$0(4);
            }
            return element instanceof GoVarDefinition || element instanceof GoConstDefinition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/goide/completion/GoAutoImportCompletionContributor$VariablesAndConstantsProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface ElementProcessor {
        public boolean process(@NotNull String var1, @NotNull GoNamedElement var2, @NotNull ExistingImportData var3, @NotNull CompletionResultSet var4);

        public boolean isMine(@NotNull GoNamedElement var1);
    }
}

