/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.GoIcons;
import com.goide.completion.GoCompletionUtil;
import com.goide.directiveComment.GoDirectiveComment;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameters;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoCommentCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NotNull
    private static final PatternCondition<PsiComment> IS_DIRECTIVE_COMMENT = GoCompletionUtil.condition("directive comment", GoDirectiveComment::isDirectiveComment);
    private static final PsiElementPattern.Capture<PsiComment> DECLARATION_COMMENT = (PsiElementPattern.Capture)PlatformPatterns.psiComment().andOr(new ElementPattern[]{PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiFile()), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(GoVarOrConstDeclaration.class))).withSuperParent(2, (ElementPattern)PlatformPatterns.psiFile()), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(GoTypeDeclaration.class))).withSuperParent(2, (ElementPattern)PlatformPatterns.psiFile())});

    public GoCommentCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiComment().without(IS_DIRECTIVE_COMMENT), new GoCommentsCompletionProvider());
    }

    private static void addCommentOwnerNames(@NotNull CompletionResultSet result, @NotNull PsiElement owner, @NotNull Set<String> names) {
        if (result == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(1);
        }
        if (names == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(2);
        }
        if (owner instanceof GoFunctionOrMethodDeclaration) {
            GoReceiver receiver;
            Iterator<GoTypeSpec> func = (GoFunctionOrMethodDeclaration)owner;
            GoCommentCompletionContributor.addElement(result, (GoNamedElement)((Object)func), 15, names);
            GoSignature signature = func.getSignature();
            if (signature != null) {
                GoParameters resultParameters;
                for (GoParamDefinition param : signature.getParameters().getDefinitionList()) {
                    GoCommentCompletionContributor.addElement(result, param, 10, names);
                }
                GoResult funcResult = signature.getResult();
                if (funcResult != null && (resultParameters = funcResult.getParameters()) != null) {
                    for (GoParamDefinition resultParam : resultParameters.getDefinitionList()) {
                        GoCommentCompletionContributor.addElement(result, resultParam, 10, names);
                    }
                }
            }
            if (func instanceof GoMethodDeclaration && (receiver = ((GoMethodDeclaration)((Object)func)).getReceiver()) != null) {
                GoCommentCompletionContributor.addElement(result, receiver, 10, names);
            }
        }
        if (owner instanceof GoVarOrConstDeclaration) {
            GoPsiUtil.processDefinitions((GoVarOrConstDeclaration)owner, (Processor<GoNamedElement>)((Processor)element -> {
                GoCommentCompletionContributor.addElement(result, element, 15, names);
                return true;
            }));
        }
        if (owner instanceof GoVarOrConstSpec) {
            for (GoVarOrConstDefinition definition : ((GoVarOrConstSpec)owner).getDefinitionList()) {
                GoCommentCompletionContributor.addElement(result, definition, 15, names);
            }
        }
        if (owner instanceof GoTypeDeclaration) {
            for (GoTypeSpec spec : ((GoTypeDeclaration)owner).getTypeSpecList()) {
                GoCommentCompletionContributor.addElement(result, spec, 15, names);
            }
        }
        if (owner instanceof GoTypeSpec) {
            GoTypeSpec spec = (GoTypeSpec)owner;
            GoCommentCompletionContributor.addElement(result, spec, 15, names);
        }
    }

    private static void addPackageNames(@NotNull CompletionResultSet result, @NotNull PsiFile originalFile, @Nullable PsiElement declaration, @NotNull Set<String> names) {
        if (result == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(3);
        }
        if (originalFile == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(4);
        }
        if (names == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(5);
        }
        if (originalFile instanceof GoFile) {
            GoPackage goPackage = GoPackage.of((GoFile)originalFile);
            if (goPackage != null) {
                goPackage.processFiles((Processor<? super PsiFile>)((Processor)file2 -> {
                    GoCommentCompletionContributor.addFileDefinitions(file2, result, declaration, names);
                    return true;
                }));
            } else {
                GoCommentCompletionContributor.addFileDefinitions(originalFile, result, declaration, names);
            }
        }
    }

    private static void addFileDefinitions(@NotNull PsiFile file2, @NotNull CompletionResultSet result, @Nullable PsiElement exclude, @NotNull Set<String> names) {
        GoFile goFile;
        if (file2 == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(6);
        }
        if (result == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(7);
        }
        if (names == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(8);
        }
        if ((goFile = (GoFile)((Object)ObjectUtils.tryCast((Object)file2, GoFile.class))) == null) {
            return;
        }
        int priority = 5;
        goFile.getVars().forEach(it -> {
            if (it != exclude) {
                GoCommentCompletionContributor.addElement(result, it, priority, names);
            }
        });
        goFile.getConstants().forEach(it -> {
            if (it != exclude) {
                GoCommentCompletionContributor.addElement(result, it, priority, names);
            }
        });
        goFile.getFunctions().forEach(it -> {
            if (it != exclude) {
                GoCommentCompletionContributor.addElement(result, it, priority, names);
            }
        });
        goFile.getMethods().forEach(it -> {
            if (it != exclude) {
                GoCommentCompletionContributor.addElement(result, it, priority, names);
            }
        });
        goFile.getTypes().forEach(it -> {
            if (it != exclude) {
                GoCommentCompletionContributor.addElement(result, it, priority, names);
            }
        });
    }

    private static void addElement(@NotNull CompletionResultSet result, @NotNull GoNamedElement element, int priority, @NotNull Set<String> names) {
        String name;
        Icon icon;
        if (result == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(9);
        }
        if (element == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(10);
        }
        if (names == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(11);
        }
        if ((icon = GoCommentCompletionContributor.getIcon(element)) == null) {
            return;
        }
        String string = name = !element.isBlank() ? element.getName() : null;
        if (StringUtil.isNotEmpty((String)name)) {
            LookupElement lookupElement = LookupElementBuilder.create((String)name).withPsiElement((PsiElement)element).withIcon(icon).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)priority));
            names.add(name);
        }
    }

    @Nullable
    private static Icon getIcon(@NotNull GoNamedElement element) {
        if (element == null) {
            GoCommentCompletionContributor.$$$reportNull$$$0(12);
        }
        if (element instanceof GoVarDefinition) {
            return GoIcons.VARIABLE;
        }
        if (element instanceof GoConstDefinition) {
            return GoIcons.CONSTANT;
        }
        if (element instanceof GoFunctionDeclaration) {
            return GoIcons.FUNCTION;
        }
        if (element instanceof GoMethodDeclaration) {
            return GoIcons.METHOD;
        }
        if (element instanceof GoTypeSpec) {
            return ((GoTypeSpec)element).getSpecType() instanceof GoInterfaceType ? GoIcons.INTERFACE : GoIcons.TYPE;
        }
        if (element instanceof GoParamDefinition) {
            return GoIcons.PARAMETER;
        }
        if (element instanceof GoReceiver) {
            return GoIcons.RECEIVER;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/goide/completion/GoCommentCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommentOwnerNames";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addPackageNames";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileDefinitions";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoCommentsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private GoCommentsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiComment comment;
            if (parameters == null) {
                GoCommentsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                GoCommentsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                GoCommentsCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((comment = (PsiComment)ObjectUtils.tryCast((Object)parameters.getPosition(), PsiComment.class)) != null && parameters.getInvocationCount() > 0) {
                List<Object> upperComments;
                HashSet<String> names = new HashSet<String>();
                CompletionResultSet caseInsensitiveResult = result.caseInsensitive();
                PsiElement declaration = DECLARATION_COMMENT.accepts((Object)comment) ? PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)comment) : null;
                List<Object> list = upperComments = declaration != null ? GoDocumentationProvider.getUpperComments(declaration) : Collections.emptyList();
                if (declaration != null && upperComments.contains(comment)) {
                    GoCommentCompletionContributor.addCommentOwnerNames(caseInsensitiveResult, declaration, names);
                }
                GoCommentCompletionContributor.addPackageNames(caseInsensitiveResult, parameters.getOriginalFile(), declaration, names);
                WordCompletionContributor.addWordCompletionVariants((CompletionResultSet)result, (CompletionParameters)parameters, names);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/goide/completion/GoCommentCompletionContributor$GoCommentsCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

