/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.completion.GoCompletionUtil;
import com.goide.completion.GoImportPathsProvider;
import com.goide.completion.GoImportsFilter;
import com.goide.execution.testing.GoTestFinder;
import com.goide.psi.GoImportSpec;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoImportPathsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        GoImportSpec spec;
        if (parameters == null) {
            GoImportPathsCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GoImportPathsCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            GoImportPathsCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((spec = (GoImportSpec)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), GoImportSpec.class)) == null) {
            return;
        }
        String path = spec.getPath();
        if (path.startsWith("./") || path.startsWith("../")) {
            return;
        }
        String newPrefix = parameters.getEditor().getDocument().getText(TextRange.create((int)(spec.getTextRange().getStartOffset() + spec.getPathOffset()), (int)parameters.getOffset()));
        result = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(newPrefix));
        Module module = GoUtil.module((PsiElement)parameters.getOriginalFile());
        if (module != null) {
            GlobalSearchScope scope = GoUtil.goPathResolveScope(module, (PsiElement)parameters.getOriginalFile());
            GoImportPathsCompletionProvider.addCompletions(result, module, (PsiElement)parameters.getOriginalFile(), scope, false, true);
        }
    }

    public static void addCompletions(@NotNull CompletionResultSet result, @NotNull Module module, @Nullable PsiElement context, @NotNull GlobalSearchScope scope, boolean allowMain, boolean useVendoredPathsIfPossible) {
        if (result == null) {
            GoImportPathsCompletionProvider.$$$reportNull$$$0(3);
        }
        if (module == null) {
            GoImportPathsCompletionProvider.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            GoImportPathsCompletionProvider.$$$reportNull$$$0(5);
        }
        Project project = module.getProject();
        boolean vendoringEnabled = useVendoredPathsIfPossible && GoVendoringUtil.isVendoringEnabled(module);
        String contextImportPath = GoCompletionUtil.getContextImportPath(context, vendoringEnabled);
        List importsFilters = GoImportsFilter.EP_NAME.getExtensionList();
        PsiFile contextFile = context != null ? context.getContainingFile() : null;
        boolean testFileWithTestPackage = GoTestFinder.isTestFileWithTestPackage(contextFile);
        for (GoImportPathsProvider provider : GoImportPathsProvider.EP_NAME.getExtensionList()) {
            provider.processImportPaths(module, scope, allowMain, vendoringEnabled, (PairProcessor<? super String, ? super PsiDirectory>)((PairProcessor)(importPath, directory) -> {
                if (StringUtil.isNotEmpty((String)importPath) && !ContainerUtil.or((Iterable)importsFilters, filter -> filter.isExcluded(project, (String)importPath)) && (testFileWithTestPackage || !importPath.equals(contextImportPath))) {
                    result.addElement(GoCompletionUtil.createPackageLookupElement(importPath, contextImportPath, (PsiElement)directory, false));
                    ProgressManager.checkCanceled();
                }
                return true;
            }));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
        }
        objectArray[1] = "com/goide/completion/GoImportPathsCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

