/*
 * Decompiled with CFR 0.152.
 */
package com.goide.configuration;

import com.goide.GoConstants;
import com.goide.configuration.GoUIUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.buildTag.GoBaseBuildLexer;
import com.goide.inspections.buildTag.GoBuildCompletionContributor;
import com.goide.project.GoBuildTargetSettings;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoUtil;
import com.intellij.DynamicBundle;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoBuildTagsUI
implements Disposable {
    private final Module myModule;
    private JPanel myPanel;
    private ComboBox<String> myOSCombo;
    private ComboBox<String> myArchCombo;
    private ComboBox<String> myGoVersionCombo;
    private ComboBox<String> myCompilerCombo;
    private ComboBox<String> myCgoCombo;
    private EditorTextField myCustomTagsField;
    private JTextPane myFormatLabel;
    private JTextPane myCustomTagsHint;
    private EditorTextField myExperimentsField;
    private JTextPane myExperimentsHint;
    @NotNull
    private final MutableCollectionComboBoxModel<String> myCgoComboModel;
    @NotNull
    @Nls
    private final String myDefaultOSValue;
    @NotNull
    @Nls
    private final String myDefaultArchValue;
    @NotNull
    @Nls
    private String myDefaultCgo;
    @NotNull
    @NlsSafe
    private String myDefaultGoVersion;

    public GoBuildTagsUI(@NotNull Module module) {
        if (module == null) {
            GoBuildTagsUI.$$$reportNull$$$0(0);
        }
        this.myDefaultGoVersion = "";
        this.myModule = module;
        this.$$$setupUI$$$();
        this.myPanel.setBorder(IdeBorderFactory.createTitledBorder((String)GoBundle.message((String)"go.settings.build.tags.group.name", (Object[])new Object[0])));
        this.myDefaultOSValue = GoBundle.message((String)"go.settings.default.value", (Object[])new Object[]{GoUtil.systemOS()});
        this.myDefaultArchValue = GoBundle.message((String)"go.settings.default.value", (Object[])new Object[]{GoUtil.systemArch()});
        this.myDefaultCgo = GoBundle.message((String)"go.settings.default.value", (Object[])new Object[]{GoBuildTagsUI.cgo(GoUtil.systemCgo(this.myDefaultOSValue, this.myDefaultArchValue))});
        this.myOSCombo.setModel(GoBuildTagsUI.createModel(GoConstants.KNOWN_OS, this.myDefaultOSValue));
        this.myArchCombo.setModel(GoBuildTagsUI.createModel(GoConstants.KNOWN_ARCH, this.myDefaultArchValue));
        this.myCgoComboModel = GoBuildTagsUI.createModel(List.of(GoBundle.message((String)"go.settings.enabled", (Object[])new Object[0]), GoBundle.message((String)"go.settings.disabled", (Object[])new Object[0])), this.myDefaultCgo);
        this.myCgoCombo.setModel(this.myCgoComboModel);
        this.myCompilerCombo.setModel(GoBuildTagsUI.createModel(GoConstants.KNOWN_COMPILERS, "Any"));
        ActionListener updateCgoListener = event -> {
            @NlsSafe String selectedCgo = (String)this.myCgoComboModel.getSelected();
            String selected = StringUtil.notNullize((String)selectedCgo, (String)this.myDefaultCgo);
            String oldDefault = this.myDefaultCgo;
            String os = GoBuildTagsUI.expandDefault(GoBuildTagsUI.selected(this.myOSCombo, this.myDefaultOSValue), GoUtil.systemOS());
            String arch = GoBuildTagsUI.expandDefault(GoBuildTagsUI.selected(this.myArchCombo, this.myDefaultArchValue), GoUtil.systemArch());
            this.myDefaultCgo = GoBundle.message((String)"go.settings.default.value", (Object[])new Object[]{GoBuildTagsUI.cgo(GoUtil.systemCgo(os, arch))});
            this.myCgoComboModel.update(List.of(this.myDefaultCgo, GoBundle.message((String)"go.settings.enabled", (Object[])new Object[0]), GoBundle.message((String)"go.settings.disabled", (Object[])new Object[0])));
            this.myCgoComboModel.setSelectedItem((Object)(oldDefault.equals(selected) ? this.myDefaultCgo : selected));
        };
        this.myOSCombo.addActionListener(updateCgoListener);
        this.myArchCombo.addActionListener(updateCgoListener);
    }

    public void initPanel(final @NotNull Module module) {
        if (module == null) {
            GoBuildTagsUI.$$$reportNull$$$0(1);
        }
        if (module.isDisposed()) {
            return;
        }
        MessageBusConnection connection = module.getProject().getMessageBus().connect((Disposable)this);
        connection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                String selected = GoBuildTagsUI.selected(GoBuildTagsUI.this.myGoVersionCombo, GoBuildTagsUI.this.myDefaultGoVersion);
                GoBuildTagsUI.this.initComboValues(module);
                GoBuildTagsUI.this.myGoVersionCombo.setSelectedItem((Object)GoBuildTagsUI.expandDefault(selected, GoBuildTagsUI.this.myDefaultGoVersion));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/configuration/GoBuildTagsUI$1", "rootsChanged"));
            }
        });
        this.initComboValues(module);
    }

    private void initComboValues(@NotNull Module module) {
        if (module == null) {
            GoBuildTagsUI.$$$reportNull$$$0(2);
        }
        if (!module.isDisposed()) {
            String sdkVersion = GoSdkService.getInstance(module.getProject()).getSdk(module).getVersion();
            this.myDefaultGoVersion = GoBundle.message((String)"go.settings.project.sdk.value", (Object[])new Object[]{StringUtil.notNullize((String)sdkVersion, (String)GoBundle.message((String)"go.settings.build.tags.any.sdk.value", (Object[])new Object[0]))});
            this.myGoVersionCombo.setModel(GoBuildTagsUI.createModel(GoConstants.KNOWN_VERSIONS, VersionComparatorUtil.COMPARATOR.reversed(), this.myDefaultGoVersion));
        }
    }

    @NotNull
    private String selectedCompiler() {
        Object item = this.myCompilerCombo.getSelectedItem();
        return item instanceof String ? (String)item : "Any";
    }

    private String @NotNull [] selectedCustomTags() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)StringUtil.split((String)this.myCustomTagsField.getText(), (String)" "));
        if (stringArray == null) {
            GoBuildTagsUI.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    private String @NotNull [] selectedExperiments() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)StringUtil.split((String)this.myExperimentsField.getText(), (String)","));
        if (stringArray == null) {
            GoBuildTagsUI.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @NotNull
    private ThreeState selectedCgo() {
        String string = (String)this.myCgoComboModel.getSelected();
        if (GoBundle.message((String)"go.settings.enabled", (Object[])new Object[0]).equals(string)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                GoBuildTagsUI.$$$reportNull$$$0(5);
            }
            return threeState;
        }
        if (GoBundle.message((String)"go.settings.disabled", (Object[])new Object[0]).equals(string)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                GoBuildTagsUI.$$$reportNull$$$0(6);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            GoBuildTagsUI.$$$reportNull$$$0(7);
        }
        return threeState;
    }

    @NotNull
    @NlsSafe
    private static String selected(@NotNull ComboBox<String> comboBox, @NotNull String defaultValue) {
        Object item;
        if (comboBox == null) {
            GoBuildTagsUI.$$$reportNull$$$0(8);
        }
        if (defaultValue == null) {
            GoBuildTagsUI.$$$reportNull$$$0(9);
        }
        if ((item = comboBox.getSelectedItem()) instanceof String) {
            String string = defaultValue.equals(item) ? "default" : (String)item;
            if (string == null) {
                GoBuildTagsUI.$$$reportNull$$$0(10);
            }
            return string;
        }
        return "default";
    }

    @Contract(pure=true)
    @NotNull
    private static String expandDefault(@NotNull String value2, @NotNull String defaultValue) {
        if (value2 == null) {
            GoBuildTagsUI.$$$reportNull$$$0(11);
        }
        if (defaultValue == null) {
            GoBuildTagsUI.$$$reportNull$$$0(12);
        }
        String string = "default".equals(value2) ? defaultValue : value2;
        if (string == null) {
            GoBuildTagsUI.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static MutableCollectionComboBoxModel<String> createModel(@NotNull Collection<String> values2, @NotNull String defaultValue) {
        if (values2 == null) {
            GoBuildTagsUI.$$$reportNull$$$0(14);
        }
        if (defaultValue == null) {
            GoBuildTagsUI.$$$reportNull$$$0(15);
        }
        return GoBuildTagsUI.createModel(values2, Comparator.naturalOrder(), defaultValue);
    }

    @NotNull
    private static MutableCollectionComboBoxModel<String> createModel(@NotNull Collection<String> values2, @NotNull Comparator<String> comparator, @NotNull String defaultValue) {
        if (values2 == null) {
            GoBuildTagsUI.$$$reportNull$$$0(16);
        }
        if (comparator == null) {
            GoBuildTagsUI.$$$reportNull$$$0(17);
        }
        if (defaultValue == null) {
            GoBuildTagsUI.$$$reportNull$$$0(18);
        }
        List items = ContainerUtil.prepend((List)ContainerUtil.sorted(values2, comparator), (Object[])new String[]{defaultValue});
        return new MutableCollectionComboBoxModel(new ArrayList(items), (Object)defaultValue);
    }

    public boolean isModified(@NotNull GoBuildTargetSettings buildTargetSettings) {
        if (buildTargetSettings == null) {
            GoBuildTagsUI.$$$reportNull$$$0(19);
        }
        return !buildTargetSettings.os.equals(GoBuildTagsUI.selected(this.myOSCombo, this.myDefaultOSValue)) || !buildTargetSettings.arch.equals(GoBuildTagsUI.selected(this.myArchCombo, this.myDefaultArchValue)) || !buildTargetSettings.goVersion.equals(GoBuildTagsUI.selected(this.myGoVersionCombo, this.myDefaultGoVersion)) || buildTargetSettings.cgo != this.selectedCgo() || !buildTargetSettings.compiler.equals(this.selectedCompiler()) || !Arrays.equals(buildTargetSettings.customFlags, this.selectedCustomTags()) || !Arrays.equals(buildTargetSettings.experiments, this.selectedExperiments());
    }

    public void apply(@NotNull GoBuildTargetSettings buildTargetSettings) throws ConfigurationException {
        String[] customBuildTags;
        if (buildTargetSettings == null) {
            GoBuildTagsUI.$$$reportNull$$$0(20);
        }
        for (String tag : customBuildTags = this.selectedCustomTags()) {
            if (GoBaseBuildLexer.isValidTag(tag)) continue;
            throw new ConfigurationException(GoBundle.message((String)"go.settings.invalid.build.tag.error", (Object[])new Object[]{tag}));
        }
        buildTargetSettings.os = GoBuildTagsUI.selected(this.myOSCombo, this.myDefaultOSValue);
        buildTargetSettings.arch = GoBuildTagsUI.selected(this.myArchCombo, this.myDefaultArchValue);
        buildTargetSettings.goVersion = GoBuildTagsUI.selected(this.myGoVersionCombo, this.myDefaultGoVersion);
        buildTargetSettings.compiler = this.selectedCompiler();
        buildTargetSettings.cgo = this.selectedCgo();
        buildTargetSettings.customFlags = customBuildTags;
        buildTargetSettings.experiments = this.selectedExperiments();
    }

    public void reset(@NotNull GoBuildTargetSettings buildTargetSettings) {
        if (buildTargetSettings == null) {
            GoBuildTagsUI.$$$reportNull$$$0(21);
        }
        this.myOSCombo.setSelectedItem((Object)GoBuildTagsUI.expandDefault(buildTargetSettings.os, this.myDefaultOSValue));
        this.myArchCombo.setSelectedItem((Object)GoBuildTagsUI.expandDefault(buildTargetSettings.arch, this.myDefaultArchValue));
        this.myGoVersionCombo.setSelectedItem((Object)GoBuildTagsUI.expandDefault(buildTargetSettings.goVersion, this.myDefaultGoVersion));
        this.myCgoCombo.setSelectedItem((Object)GoBuildTagsUI.expandDefault(GoBuildTagsUI.cgo(buildTargetSettings.cgo), this.myDefaultCgo));
        this.myCompilerCombo.setSelectedItem((Object)buildTargetSettings.compiler);
        this.myCustomTagsField.setText(StringUtil.join((String[])buildTargetSettings.customFlags, (String)" "));
        this.myExperimentsField.setText(StringUtil.join((String[])buildTargetSettings.experiments, (String)","));
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            GoBuildTagsUI.$$$reportNull$$$0(22);
        }
        return jPanel;
    }

    public void dispose() {
        UIUtil.dispose((Component)this.myPanel);
        UIUtil.dispose(this.myOSCombo);
        UIUtil.dispose(this.myArchCombo);
        UIUtil.dispose(this.myGoVersionCombo);
        UIUtil.dispose(this.myCompilerCombo);
        UIUtil.dispose(this.myCgoCombo);
        UIUtil.dispose((Component)this.myCustomTagsField);
        UIUtil.dispose((Component)this.myExperimentsField);
    }

    @NotNull
    @NlsSafe
    private static String cgo(@NotNull ThreeState threeState) {
        if (threeState == null) {
            GoBuildTagsUI.$$$reportNull$$$0(23);
        }
        if (threeState == ThreeState.YES) {
            String string = GoBundle.message((String)"go.settings.enabled", (Object[])new Object[0]);
            if (string == null) {
                GoBuildTagsUI.$$$reportNull$$$0(24);
            }
            return string;
        }
        if (threeState == ThreeState.NO) {
            String string = GoBundle.message((String)"go.settings.disabled", (Object[])new Object[0]);
            if (string == null) {
                GoBuildTagsUI.$$$reportNull$$$0(25);
            }
            return string;
        }
        return "default";
    }

    private void createUIComponents() {
        this.myFormatLabel = GoUIUtil.createDescriptionPane(false);
        this.myCustomTagsHint = GoUIUtil.createDescriptionPane(false);
        this.myExperimentsHint = GoUIUtil.createDescriptionPane(false);
        this.myCustomTagsField = new CustomBuildTagsFieldProvider(this.myModule).createEditor(this.myModule.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 10, 13, 22, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/configuration/GoBuildTagsUI";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTargetSettings";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threeState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/configuration/GoBuildTagsUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedCustomTags";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedExperiments";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedCgo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "selected";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "expandDefault";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "cgo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initPanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initComboValues";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selected";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "expandDefault";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "cgo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 10, 13, 22, 24, 25 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EditorTextField editorTextField;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        ComboBox comboBox4;
        ComboBox comboBox5;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/GoBundle", GoBuildTagsUI.class).getString("go.settings.build.tags.group.name"), (int)0, (int)0, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/GoBundle", GoBuildTagsUI.class).getString("go.settings.build.tags.os.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/GoBundle", GoBuildTagsUI.class).getString("go.settings.build.tags.arch.label"));
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myOSCombo = comboBox5 = new ComboBox();
        jPanel.add((Component)comboBox5, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(250, -1), null));
        this.myArchCombo = comboBox4 = new ComboBox();
        jPanel.add((Component)comboBox4, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(250, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/GoBundle", GoBuildTagsUI.class).getString("go.settings.build.tags.cgo.support.label"));
        jPanel.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/GoBundle", GoBuildTagsUI.class).getString("go.settings.build.tags.compiler.label"));
        jPanel.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/GoBundle", GoBuildTagsUI.class).getString("go.settings.build.tags.version.label"));
        jPanel.add((Component)jBLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/GoBundle", GoBuildTagsUI.class).getString("go.settings.build.tags.custom.tags.label"));
        jPanel.add((Component)jBLabel6, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myGoVersionCombo = comboBox3 = new ComboBox();
        jPanel.add((Component)comboBox3, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(250, -1), null));
        this.myCompilerCombo = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(250, -1), null));
        this.myCgoCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(250, -1), null));
        EditorTextField editorTextField2 = this.myCustomTagsField;
        jPanel.add((Component)editorTextField2, new GridConstraints(6, 1, 1, 1, 0, 1, 3, 3, null, new Dimension(250, -1), null));
        JTextPane jTextPane = this.myFormatLabel;
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setText(DynamicBundle.getBundle((String)"messages/GoBundle", GoBuildTagsUI.class).getString("go.settings.build.tags.description"));
        jPanel.add((Component)jTextPane, new GridConstraints(0, 0, 1, 3, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        JTextPane jTextPane2 = this.myCustomTagsHint;
        jTextPane2.setContentType("text/html");
        jTextPane2.setEditable(false);
        jTextPane2.setText(DynamicBundle.getBundle((String)"messages/GoBundle", GoBuildTagsUI.class).getString("go.settings.build.tags.custom.tags.hint"));
        jPanel.add((Component)jTextPane2, new GridConstraints(7, 1, 1, 2, 0, 3, 6, 6, null, new Dimension(150, -1), null));
        this.myExperimentsField = editorTextField = new EditorTextField();
        jPanel.add((Component)editorTextField, new GridConstraints(8, 1, 1, 1, 0, 1, 3, 3, null, new Dimension(250, -1), null));
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/GoBundle", GoBuildTagsUI.class).getString("go.settings.build.tags.experiments.label"));
        jPanel.add((Component)jBLabel7, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JTextPane jTextPane3 = this.myExperimentsHint;
        jTextPane3.setContentType("text/html");
        jTextPane3.setEditable(false);
        jTextPane3.setText(DynamicBundle.getBundle((String)"messages/GoBundle", GoBuildTagsUI.class).getString("go.settings.build.tags.experiments.hint"));
        jPanel.add((Component)jTextPane3, new GridConstraints(9, 1, 1, 2, 0, 3, 6, 6, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class CustomBuildTagsFieldProvider
    extends TextFieldCompletionProvider {
        private final Module myModule;

        private CustomBuildTagsFieldProvider(@NotNull Module module) {
            if (module == null) {
                CustomBuildTagsFieldProvider.$$$reportNull$$$0(0);
            }
            this.myModule = module;
        }

        @Nullable
        public String getPrefix(@NotNull String text, int offset) {
            if (text == null) {
                CustomBuildTagsFieldProvider.$$$reportNull$$$0(1);
            }
            int start = offset;
            int i = offset - 1;
            while (i >= 0 && GoBaseBuildLexer.isValidTagChar(text.charAt(i))) {
                start = i--;
            }
            return text.substring(start, offset);
        }

        protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
            if (text == null) {
                CustomBuildTagsFieldProvider.$$$reportNull$$$0(2);
            }
            if (prefix == null) {
                CustomBuildTagsFieldProvider.$$$reportNull$$$0(3);
            }
            if (result == null) {
                CustomBuildTagsFieldProvider.$$$reportNull$$$0(4);
            }
            GoBuildCompletionContributor.addBuildTagElements(this.myModule.getProject(), this.myModule, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/goide/configuration/GoBuildTagsUI$CustomBuildTagsFieldProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPrefix";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletionVariants";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

